/*
 * JBoss, Home of Professional Open Source
 * Copyright , Red Hat, Inc. and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.richfaces.component;

import javax.annotation.Generated;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import javax.faces.context.FacesContext;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.StateHelper;
import org.richfaces.component.AbstractNotifyMessages;
import org.ajax4jsf.component.AjaxOutput;
import org.richfaces.component.ClientSideMessage;
import org.richfaces.component.NotifyAttributes;

/**
 *  <p> The &lt;rich:notifyMessages&gt; component is the same as the &lt;rich:notifyMessage&gt; component, but each of
 the available messages generates one notification. </p>

 @author <a href="http://community.jboss.org/people/lfryc">Lukas Fryc</a>
 @author <a href="http://community.jboss.org/people/bleathem">Brian Leathem</a>

 **/
@Generated({"RichFaces CDK", "4.3.0.Final"})
public class UINotifyMessages extends AbstractNotifyMessages
    implements AjaxOutput,ClientSideMessage,NotifyAttributes    {

    public static final String COMPONENT_TYPE="org.richfaces.NotifyMessages";

    public static final String COMPONENT_FAMILY="javax.faces.Messages";

    @Override
    public String getFamily() {
        return COMPONENT_FAMILY;
    }






    protected enum Properties {
        ajaxRendered,
        escape,
        keepTransient,
        nonblocking,
        nonblockingOpacity,
        showCloseButton,
        showShadow,
        stack,
        stayTime,
        sticky,
        styleClass
        
    }

 
    public boolean isAjaxRendered() {
        Boolean value = (Boolean) getStateHelper().eval(Properties.ajaxRendered, true);
        return value;
    }
    
    public void setAjaxRendered(boolean ajaxRendered) {
        getStateHelper().put(Properties.ajaxRendered, ajaxRendered);
    }

 
    public boolean isEscape() {
        Boolean value = (Boolean) getStateHelper().eval(Properties.escape, true);
        return value;
    }
    
    public void setEscape(boolean escape) {
        getStateHelper().put(Properties.escape, escape);
    }

 
    public boolean isKeepTransient() {
        Boolean value = (Boolean) getStateHelper().eval(Properties.keepTransient, false);
        return value;
    }
    
    public void setKeepTransient(boolean keepTransient) {
        getStateHelper().put(Properties.keepTransient, keepTransient);
    }

 
    public boolean isNonblocking() {
        Boolean value = (Boolean) getStateHelper().eval(Properties.nonblocking, false);
        return value;
    }
    
    public void setNonblocking(boolean nonblocking) {
        getStateHelper().put(Properties.nonblocking, nonblocking);
    }

 
    public Double getNonblockingOpacity() {
        Double value = (Double) getStateHelper().eval(Properties.nonblockingOpacity);
        return value;
    }
    
    public void setNonblockingOpacity(Double nonblockingOpacity) {
        getStateHelper().put(Properties.nonblockingOpacity, nonblockingOpacity);
    }

 
    public boolean isShowCloseButton() {
        Boolean value = (Boolean) getStateHelper().eval(Properties.showCloseButton, true);
        return value;
    }
    
    public void setShowCloseButton(boolean showCloseButton) {
        getStateHelper().put(Properties.showCloseButton, showCloseButton);
    }

 
    public boolean isShowShadow() {
        Boolean value = (Boolean) getStateHelper().eval(Properties.showShadow, false);
        return value;
    }
    
    public void setShowShadow(boolean showShadow) {
        getStateHelper().put(Properties.showShadow, showShadow);
    }

 
    public String getStack() {
        String value = (String) getStateHelper().eval(Properties.stack);
        return value;
    }
    
    public void setStack(String stack) {
        getStateHelper().put(Properties.stack, stack);
    }

 
    public Integer getStayTime() {
        Integer value = (Integer) getStateHelper().eval(Properties.stayTime);
        return value;
    }
    
    public void setStayTime(Integer stayTime) {
        getStateHelper().put(Properties.stayTime, stayTime);
    }

 
    public boolean isSticky() {
        Boolean value = (Boolean) getStateHelper().eval(Properties.sticky, false);
        return value;
    }
    
    public void setSticky(boolean sticky) {
        getStateHelper().put(Properties.sticky, sticky);
    }

 
    public String getStyleClass() {
        String value = (String) getStateHelper().eval(Properties.styleClass);
        return value;
    }
    
    public void setStyleClass(String styleClass) {
        getStateHelper().put(Properties.styleClass, styleClass);
    }

    

}