/*
 * Decompiled with CFR 0.152.
 */
package org.rnorth.testcontainers.containers;

import com.spotify.docker.client.messages.ContainerConfig;
import com.spotify.docker.client.messages.ContainerInfo;
import com.spotify.docker.client.messages.HostConfig;
import com.spotify.docker.client.messages.PortBinding;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.rnorth.testcontainers.containers.AbstractContainer;
import org.rnorth.testcontainers.containers.traits.LinkableContainer;

public class NginxContainer
extends AbstractContainer
implements LinkableContainer {
    private String nginxPort;
    private String htmlContentPath;
    private Map<String, List<PortBinding>> ports;
    private List<String> binds = new ArrayList<String>();

    protected void containerIsStarting(ContainerInfo containerInfo) {
        this.ports = containerInfo.networkSettings().ports();
        this.nginxPort = this.ports.get("80/tcp").get(0).hostPort();
    }

    protected String getLivenessCheckPort() {
        return this.nginxPort;
    }

    protected ContainerConfig getContainerConfig() {
        return ContainerConfig.builder().image(this.getDockerImageName()).exposedPorts(new String[]{"80"}).cmd(new String[]{"nginx", "-g", "daemon off;"}).build();
    }

    protected void customizeHostConfigBuilder(HostConfig.Builder hostConfigBuilder) {
        hostConfigBuilder.binds(this.binds);
    }

    protected String getDockerImageName() {
        return "nginx:1.7.11";
    }

    public URL getBaseUrl(String scheme, int port) throws MalformedURLException {
        return new URL(scheme + "://" + this.dockerHostIpAddress + ":" + this.ports.get(port + "/tcp").get(0).hostPort());
    }

    public void setCustomConfig(String htmlContentPath) {
        this.binds.add(htmlContentPath + ":/usr/share/nginx/html:ro");
    }

    public String getContainerId() {
        return this.containerId;
    }
}

