/*
 * Decompiled with CFR 0.152.
 */
package org.rnorth.testcontainers.containers;

import com.spotify.docker.client.DefaultDockerClient;
import com.spotify.docker.client.DockerCertificates;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.DockerException;
import com.spotify.docker.client.ImageNotFoundException;
import com.spotify.docker.client.ImagePullFailedException;
import com.spotify.docker.client.ProgressHandler;
import com.spotify.docker.client.messages.ContainerConfig;
import com.spotify.docker.client.messages.ContainerCreation;
import com.spotify.docker.client.messages.ContainerInfo;
import com.spotify.docker.client.messages.HostConfig;
import com.spotify.docker.client.messages.Image;
import com.spotify.docker.client.messages.ProgressMessage;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.Executors;
import org.rnorth.testcontainers.utility.CommandLine;
import org.rnorth.testcontainers.utility.PathOperations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractContainer {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"TestContainer");
    protected String dockerHostIpAddress;
    protected String containerId;
    protected DockerClient dockerClient;
    protected String tag = "latest";
    private boolean normalTermination = false;

    public void start() {
        try {
            DefaultDockerClient.Builder builder = DefaultDockerClient.builder();
            this.customizeBuilderForOs(builder);
            this.dockerClient = builder.build();
            this.pullImageIfNeeded(this.getDockerImageName());
            ContainerConfig containerConfig = this.getContainerConfig();
            HostConfig.Builder hostConfigBuilder = HostConfig.builder().publishAllPorts(Boolean.valueOf(true));
            this.customizeHostConfigBuilder(hostConfigBuilder);
            HostConfig hostConfig = hostConfigBuilder.build();
            LOGGER.info("Creating container for image: {}", (Object)this.getDockerImageName());
            ContainerCreation containerCreation = this.dockerClient.createContainer(containerConfig);
            this.containerId = containerCreation.id();
            this.dockerClient.startContainer(this.containerId, hostConfig);
            LOGGER.info("Starting container with ID: {}", (Object)this.containerId);
            ContainerInfo containerInfo = this.dockerClient.inspectContainer(this.containerId);
            this.containerIsStarting(containerInfo);
            this.waitUntilContainerStarted();
            LOGGER.info("Container started");
            Executors.newSingleThreadExecutor().submit(new Runnable(){

                @Override
                public void run() {
                    Throwable caughtException = null;
                    try {
                        AbstractContainer.this.dockerClient.waitContainer(AbstractContainer.this.containerId);
                    }
                    catch (DockerException | InterruptedException e) {
                        caughtException = e;
                    }
                    if (!AbstractContainer.this.normalTermination) {
                        throw new RuntimeException("Container exited unexpectedly", caughtException);
                    }
                }
            });
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    AbstractContainer.this.stop();
                }
            }));
        }
        catch (Exception e) {
            LOGGER.error("Could not start container", (Throwable)e);
        }
    }

    protected void customizeHostConfigBuilder(HostConfig.Builder hostConfigBuilder) {
    }

    private void pullImageIfNeeded(final String imageName) throws DockerException, InterruptedException {
        List images = this.dockerClient.listImages(new DockerClient.ListImagesParam[]{DockerClient.ListImagesParam.create((String)"name", (String)this.getDockerImageName())});
        for (Image image : images) {
            if (!image.repoTags().contains((Object)imageName)) continue;
            return;
        }
        LOGGER.info("Pulling docker image: {}. Please be patient; this may take some time but only needs to be done once.", (Object)imageName);
        this.dockerClient.pull(this.getDockerImageName(), new ProgressHandler(){

            public void progress(ProgressMessage message) throws DockerException {
                if (message.error() != null) {
                    if (message.error().contains("404") || message.error().contains("not found")) {
                        throw new ImageNotFoundException(imageName, message.toString());
                    }
                    throw new ImagePullFailedException(imageName, message.toString());
                }
            }
        });
    }

    public void stop() {
        try {
            LOGGER.info("Stopping container: {}", (Object)this.containerId);
            this.normalTermination = true;
            this.dockerClient.killContainer(this.containerId);
            this.dockerClient.removeContainer(this.containerId, true);
        }
        catch (DockerException | InterruptedException e) {
            LOGGER.debug("Error encountered shutting down container (ID: {}) - it may not have been stopped, or may already be stopped: {}", (Object)this.containerId, (Object)e.getMessage());
        }
    }

    protected Path createVolumeDirectory(boolean temporary) throws IOException {
        File file = new File(".tmp-volume");
        file.mkdirs();
        final Path directory = file.toPath();
        if (temporary) {
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    PathOperations.recursiveDeleteDir(directory);
                }
            }));
        }
        return directory;
    }

    protected abstract void containerIsStarting(ContainerInfo var1);

    protected abstract String getLivenessCheckPort();

    protected abstract ContainerConfig getContainerConfig();

    protected abstract String getDockerImageName();

    protected void waitUntilContainerStarted() {
        this.waitForListeningPort(this.dockerHostIpAddress, this.getLivenessCheckPort());
    }

    protected void waitForListeningPort(String ipAddress, String port) {
        if (port == null) {
            return;
        }
        for (int i = 0; i < 6000; ++i) {
            try {
                new Socket(ipAddress, (int)Integer.valueOf(port));
                return;
            }
            catch (IOException e) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        throw new IllegalStateException("Timed out waiting for container port to open (" + ipAddress + ":" + port + " should be listening)");
    }

    private void customizeBuilderForOs(DefaultDockerClient.Builder builder) throws Exception {
        if (System.getProperty("os.name").toLowerCase().contains("mac")) {
            CommandLine.runShellCommand("/usr/local/bin/boot2docker", "up");
            this.dockerHostIpAddress = CommandLine.runShellCommand("/usr/local/bin/boot2docker", "ip");
            builder.uri("https://" + this.dockerHostIpAddress + ":2376").dockerCertificates(new DockerCertificates(Paths.get(System.getProperty("user.home") + "/.boot2docker/certs/boot2docker-vm", new String[0])));
        } else {
            this.dockerHostIpAddress = "127.0.0.1";
        }
    }

    public void setTag(String tag) {
        this.tag = tag != null ? tag : "latest";
    }

    public String getId() {
        return this.containerId;
    }
}

