/*
 * Decompiled with CFR 0.152.
 */
package org.rnorth.testcontainers.containers;

import com.spotify.docker.client.messages.ContainerConfig;
import com.spotify.docker.client.messages.ContainerInfo;
import com.spotify.docker.client.messages.HostConfig;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.rnorth.testcontainers.containers.AbstractContainer;
import org.rnorth.testcontainers.containers.traits.LinkableContainer;
import org.rnorth.testcontainers.containers.traits.VncService;

public class VncRecordingSidekickContainer<T extends VncService & LinkableContainer>
extends AbstractContainer {
    private final T vncServiceContainer;
    private final Path tempDir;

    public VncRecordingSidekickContainer(T vncServiceContainer) {
        this.vncServiceContainer = vncServiceContainer;
        try {
            this.tempDir = this.createVolumeDirectory(true);
            Path passwordFile = this.tempDir.resolve("password");
            Files.write(passwordFile, vncServiceContainer.getPassword().getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void containerIsStarting(ContainerInfo containerInfo) {
    }

    @Override
    protected String getLivenessCheckPort() {
        return null;
    }

    @Override
    protected ContainerConfig getContainerConfig() {
        return ContainerConfig.builder().image(this.getDockerImageName()).cmd(new String[]{"-o", "/recording/screen.flv", "-P", "/recording/password", "vnchost", String.valueOf(this.vncServiceContainer.getPort())}).build();
    }

    @Override
    protected void customizeHostConfigBuilder(HostConfig.Builder hostConfigBuilder) {
        hostConfigBuilder.binds(new String[]{this.tempDir.toAbsolutePath() + ":/recording:rw"});
        hostConfigBuilder.links(new String[]{((LinkableContainer)this.vncServiceContainer).getContainerId() + ":vnchost"});
    }

    @Override
    protected String getDockerImageName() {
        return "richnorth/vnc-recorder:latest";
    }

    public Path getRecordingPath() {
        return this.tempDir.resolve("screen.flv");
    }

    public void stopAndRetainRecording(File destination) {
        super.stop();
        try {
            Files.move(this.getRecordingPath(), destination.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not move recording file from " + this.getRecordingPath() + " to " + destination, e);
        }
    }
}

