/*
 * Decompiled with CFR 0.152.
 */
package org.rnorth.testcontainers.utility;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.ProcessResult;
import org.zeroturnaround.exec.StartedProcess;

public class CommandLine {
    public static String runShellCommand(String ... command) throws IOException, InterruptedException, TimeoutException {
        ProcessResult result = new ProcessExecutor().command(command).readOutput(true).execute();
        if (result.getExitValue() != 0) {
            System.err.println(result.getOutput().getString());
            throw new IllegalStateException();
        }
        return result.outputUTF8().trim();
    }

    public static StartedProcess runShellCommandInBackground(String ... command) throws IOException {
        return new ProcessExecutor().command(command).destroyOnExit().redirectOutput((OutputStream)System.out).redirectError((OutputStream)System.err).start();
    }

    public static boolean executableExists(String executable) {
        File directFile = new File(executable);
        if (directFile.exists() && directFile.canExecute()) {
            return true;
        }
        for (String pathString : System.getenv("PATH").split(Pattern.quote(File.pathSeparator))) {
            Path path = Paths.get(pathString, new String[0]);
            if (!Files.exists(path.resolve(executable), new LinkOption[0]) || !Files.isExecutable(path.resolve(executable))) continue;
            return true;
        }
        return false;
    }
}

