/*
 * Decompiled with CFR 0.152.
 */
package jnr.netdb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jnr.netdb.Service;
import jnr.netdb.ServicesDB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class IANAServicesDB
implements ServicesDB {
    private final Map<Integer, Service> tcpPortToService;
    private final Map<Integer, Service> udpPortToService;
    private final Map<String, Service> tcpNameToService;
    private final Map<String, Service> udpNameToService;
    private final List<Service> allServices;

    private IANAServicesDB(Map<String, Service> tcpNameToService, Map<String, Service> udpNameToService, Map<Integer, Service> tcpServices, Map<Integer, Service> udpServices) {
        this.tcpNameToService = tcpNameToService;
        this.udpNameToService = udpNameToService;
        this.tcpPortToService = tcpServices;
        this.udpPortToService = udpServices;
        ArrayList<Service> services = new ArrayList<Service>(tcpNameToService.size() + udpNameToService.size());
        services.addAll(tcpNameToService.values());
        services.addAll(udpNameToService.values());
        this.allServices = Collections.unmodifiableList(services);
    }

    public static final IANAServicesDB getInstance() {
        return SingletonHolder.INSTANCE;
    }

    @Override
    public final Service getServiceByName(String name, String proto) {
        if ("tcp".equals(proto)) {
            return this.tcpNameToService.get(name);
        }
        if ("udp".equals(proto)) {
            return this.udpNameToService.get(name);
        }
        if (proto == null) {
            Service s = this.tcpNameToService.get(name);
            return s != null ? s : this.udpNameToService.get(name);
        }
        return null;
    }

    @Override
    public final Service getServiceByPort(Integer port, String proto) {
        if ("tcp".equals(proto)) {
            return this.tcpPortToService.get(port);
        }
        if ("udp".equals(proto)) {
            return this.udpPortToService.get(port);
        }
        if (proto == null) {
            Service s = this.tcpPortToService.get(port);
            return s != null ? s : this.udpPortToService.get(port);
        }
        return null;
    }

    public final List<Service> getAllServices() {
        return this.allServices;
    }

    private static final IANAServicesDB buildServices() {
        ServicesBuilder builder2 = new ServicesBuilder();
        builder2.add("spr-itunes", "tcp", 0);
        builder2.add("spl-itunes", "tcp", 0);
        builder2.add("tcpmux", "tcp", 1);
        builder2.add("tcpmux", "udp", 1);
        builder2.add("compressnet", "tcp", 2);
        builder2.add("compressnet", "udp", 2);
        builder2.add("compressnet", "tcp", 3);
        builder2.add("compressnet", "udp", 3);
        builder2.add("rje", "tcp", 5);
        builder2.add("rje", "udp", 5);
        builder2.add("echo", "tcp", 7);
        builder2.add("echo", "udp", 7);
        builder2.add("discard", "tcp", 9);
        builder2.add("discard", "udp", 9);
        builder2.add("discard/sctp", 9);
        builder2.add("discard/dccp", 9);
        builder2.add("systat", "tcp", 11);
        builder2.add("systat", "udp", 11);
        builder2.add("daytime", "tcp", 13);
        builder2.add("daytime", "udp", 13);
        builder2.add("qotd", "tcp", 17);
        builder2.add("qotd", "udp", 17);
        builder2.add("msp", "tcp", 18);
        builder2.add("msp", "udp", 18);
        builder2.add("chargen", "tcp", 19);
        builder2.add("chargen", "udp", 19);
        builder2.add("ftp-data", "tcp", 20);
        builder2.add("ftp-data", "udp", 20);
        builder2.add("ftp-data/sctp", 20);
        builder2.add("ftp", "tcp", 21);
        builder2.add("ftp", "udp", 21);
        builder2.add("ftp/sctp", 21);
        builder2.add("ssh", "tcp", 22);
        builder2.add("ssh", "udp", 22);
        builder2.add("ssh/sctp", 22);
        builder2.add("telnet", "tcp", 23);
        builder2.add("telnet", "udp", 23);
        builder2.add("smtp", "tcp", 25);
        builder2.add("smtp", "udp", 25);
        builder2.add("nsw-fe", "tcp", 27);
        builder2.add("nsw-fe", "udp", 27);
        builder2.add("msg-icp", "tcp", 29);
        builder2.add("msg-icp", "udp", 29);
        builder2.add("msg-auth", "tcp", 31);
        builder2.add("msg-auth", "udp", 31);
        builder2.add("dsp", "tcp", 33);
        builder2.add("dsp", "udp", 33);
        builder2.add("time", "tcp", 37);
        builder2.add("time", "udp", 37);
        builder2.add("rap", "tcp", 38);
        builder2.add("rap", "udp", 38);
        builder2.add("rlp", "tcp", 39);
        builder2.add("rlp", "udp", 39);
        builder2.add("graphics", "tcp", 41);
        builder2.add("graphics", "udp", 41);
        builder2.add("name", "tcp", 42);
        builder2.add("name", "udp", 42);
        builder2.add("nameserver", "tcp", 42);
        builder2.add("nameserver", "udp", 42);
        builder2.add("nicname", "tcp", 43);
        builder2.add("nicname", "udp", 43);
        builder2.add("mpm-flags", "tcp", 44);
        builder2.add("mpm-flags", "udp", 44);
        builder2.add("mpm", "tcp", 45);
        builder2.add("mpm", "udp", 45);
        builder2.add("mpm-snd", "tcp", 46);
        builder2.add("mpm-snd", "udp", 46);
        builder2.add("ni-ftp", "tcp", 47);
        builder2.add("ni-ftp", "udp", 47);
        builder2.add("auditd", "tcp", 48);
        builder2.add("auditd", "udp", 48);
        builder2.add("tacacs", "tcp", 49);
        builder2.add("tacacs", "udp", 49);
        builder2.add("re-mail-ck", "tcp", 50);
        builder2.add("re-mail-ck", "udp", 50);
        builder2.add("la-maint", "tcp", 51);
        builder2.add("la-maint", "udp", 51);
        builder2.add("xns-time", "tcp", 52);
        builder2.add("xns-time", "udp", 52);
        builder2.add("domain", "tcp", 53);
        builder2.add("domain", "udp", 53);
        builder2.add("xns-ch", "tcp", 54);
        builder2.add("xns-ch", "udp", 54);
        builder2.add("isi-gl", "tcp", 55);
        builder2.add("isi-gl", "udp", 55);
        builder2.add("xns-auth", "tcp", 56);
        builder2.add("xns-auth", "udp", 56);
        builder2.add("xns-mail", "tcp", 58);
        builder2.add("xns-mail", "udp", 58);
        builder2.add("ni-mail", "tcp", 61);
        builder2.add("ni-mail", "udp", 61);
        builder2.add("acas", "tcp", 62);
        builder2.add("acas", "udp", 62);
        builder2.add("whois++", "tcp", 63);
        builder2.add("whois++", "udp", 63);
        builder2.add("covia", "tcp", 64);
        builder2.add("covia", "udp", 64);
        builder2.add("tacacs-ds", "tcp", 65);
        builder2.add("tacacs-ds", "udp", 65);
        builder2.add("sql*net", "tcp", 66);
        builder2.add("sql*net", "udp", 66);
        builder2.add("bootps", "tcp", 67);
        builder2.add("bootps", "udp", 67);
        builder2.add("bootpc", "tcp", 68);
        builder2.add("bootpc", "udp", 68);
        builder2.add("tftp", "tcp", 69);
        builder2.add("tftp", "udp", 69);
        builder2.add("gopher", "tcp", 70);
        builder2.add("gopher", "udp", 70);
        builder2.add("netrjs-1", "tcp", 71);
        builder2.add("netrjs-1", "udp", 71);
        builder2.add("netrjs-2", "tcp", 72);
        builder2.add("netrjs-2", "udp", 72);
        builder2.add("netrjs-3", "tcp", 73);
        builder2.add("netrjs-3", "udp", 73);
        builder2.add("netrjs-4", "tcp", 74);
        builder2.add("netrjs-4", "udp", 74);
        builder2.add("deos", "tcp", 76);
        builder2.add("deos", "udp", 76);
        builder2.add("vettcp", "tcp", 78);
        builder2.add("vettcp", "udp", 78);
        builder2.add("finger", "tcp", 79);
        builder2.add("finger", "udp", 79);
        builder2.add("http", "tcp", 80);
        builder2.add("http", "udp", 80);
        builder2.add("www", "tcp", 80);
        builder2.add("www", "udp", 80);
        builder2.add("www-http", "tcp", 80);
        builder2.add("www-http", "udp", 80);
        builder2.add("http/sctp", 80);
        builder2.add("xfer", "tcp", 82);
        builder2.add("xfer", "udp", 82);
        builder2.add("mit-ml-dev", "tcp", 83);
        builder2.add("mit-ml-dev", "udp", 83);
        builder2.add("ctf", "tcp", 84);
        builder2.add("ctf", "udp", 84);
        builder2.add("mit-ml-dev", "tcp", 85);
        builder2.add("mit-ml-dev", "udp", 85);
        builder2.add("mfcobol", "tcp", 86);
        builder2.add("mfcobol", "udp", 86);
        builder2.add("kerberos", "tcp", 88);
        builder2.add("kerberos", "udp", 88);
        builder2.add("su-mit-tg", "tcp", 89);
        builder2.add("su-mit-tg", "udp", 89);
        builder2.add("dnsix", "tcp", 90);
        builder2.add("dnsix", "udp", 90);
        builder2.add("mit-dov", "tcp", 91);
        builder2.add("mit-dov", "udp", 91);
        builder2.add("npp", "tcp", 92);
        builder2.add("npp", "udp", 92);
        builder2.add("dcp", "tcp", 93);
        builder2.add("dcp", "udp", 93);
        builder2.add("objcall", "tcp", 94);
        builder2.add("objcall", "udp", 94);
        builder2.add("supdup", "tcp", 95);
        builder2.add("supdup", "udp", 95);
        builder2.add("dixie", "tcp", 96);
        builder2.add("dixie", "udp", 96);
        builder2.add("swift-rvf", "tcp", 97);
        builder2.add("swift-rvf", "udp", 97);
        builder2.add("tacnews", "tcp", 98);
        builder2.add("tacnews", "udp", 98);
        builder2.add("metagram", "tcp", 99);
        builder2.add("metagram", "udp", 99);
        builder2.add("newacct", "tcp", 100);
        builder2.add("hostname", "tcp", 101);
        builder2.add("hostname", "udp", 101);
        builder2.add("iso-tsap", "tcp", 102);
        builder2.add("iso-tsap", "udp", 102);
        builder2.add("gppitnp", "tcp", 103);
        builder2.add("gppitnp", "udp", 103);
        builder2.add("acr-nema", "tcp", 104);
        builder2.add("acr-nema", "udp", 104);
        builder2.add("cso", "tcp", 105);
        builder2.add("cso", "udp", 105);
        builder2.add("csnet-ns", "tcp", 105);
        builder2.add("csnet-ns", "udp", 105);
        builder2.add("3com-tsmux", "tcp", 106);
        builder2.add("3com-tsmux", "udp", 106);
        builder2.add("rtelnet", "tcp", 107);
        builder2.add("rtelnet", "udp", 107);
        builder2.add("snagas", "tcp", 108);
        builder2.add("snagas", "udp", 108);
        builder2.add("pop2", "tcp", 109);
        builder2.add("pop2", "udp", 109);
        builder2.add("pop3", "tcp", 110);
        builder2.add("pop3", "udp", 110);
        builder2.add("sunrpc", "tcp", 111);
        builder2.add("sunrpc", "udp", 111);
        builder2.add("mcidas", "tcp", 112);
        builder2.add("mcidas", "udp", 112);
        builder2.add("ident", "tcp", 113);
        builder2.add("auth", "tcp", 113);
        builder2.add("auth", "udp", 113);
        builder2.add("sftp", "tcp", 115);
        builder2.add("sftp", "udp", 115);
        builder2.add("ansanotify", "tcp", 116);
        builder2.add("ansanotify", "udp", 116);
        builder2.add("uucp-path", "tcp", 117);
        builder2.add("uucp-path", "udp", 117);
        builder2.add("sqlserv", "tcp", 118);
        builder2.add("sqlserv", "udp", 118);
        builder2.add("nntp", "tcp", 119);
        builder2.add("nntp", "udp", 119);
        builder2.add("cfdptkt", "tcp", 120);
        builder2.add("cfdptkt", "udp", 120);
        builder2.add("erpc", "tcp", 121);
        builder2.add("erpc", "udp", 121);
        builder2.add("smakynet", "tcp", 122);
        builder2.add("smakynet", "udp", 122);
        builder2.add("ntp", "tcp", 123);
        builder2.add("ntp", "udp", 123);
        builder2.add("ansatrader", "tcp", 124);
        builder2.add("ansatrader", "udp", 124);
        builder2.add("locus-map", "tcp", 125);
        builder2.add("locus-map", "udp", 125);
        builder2.add("nxedit", "tcp", 126);
        builder2.add("nxedit", "udp", 126);
        builder2.add("locus-con", "tcp", 127);
        builder2.add("locus-con", "udp", 127);
        builder2.add("gss-xlicen", "tcp", 128);
        builder2.add("gss-xlicen", "udp", 128);
        builder2.add("pwdgen", "tcp", 129);
        builder2.add("pwdgen", "udp", 129);
        builder2.add("cisco-fna", "tcp", 130);
        builder2.add("cisco-fna", "udp", 130);
        builder2.add("cisco-tna", "tcp", 131);
        builder2.add("cisco-tna", "udp", 131);
        builder2.add("cisco-sys", "tcp", 132);
        builder2.add("cisco-sys", "udp", 132);
        builder2.add("statsrv", "tcp", 133);
        builder2.add("statsrv", "udp", 133);
        builder2.add("ingres-net", "tcp", 134);
        builder2.add("ingres-net", "udp", 134);
        builder2.add("epmap", "tcp", 135);
        builder2.add("epmap", "udp", 135);
        builder2.add("profile", "tcp", 136);
        builder2.add("profile", "udp", 136);
        builder2.add("netbios-ns", "tcp", 137);
        builder2.add("netbios-ns", "udp", 137);
        builder2.add("netbios-dgm", "tcp", 138);
        builder2.add("netbios-dgm", "udp", 138);
        builder2.add("netbios-ssn", "tcp", 139);
        builder2.add("netbios-ssn", "udp", 139);
        builder2.add("emfis-data", "tcp", 140);
        builder2.add("emfis-data", "udp", 140);
        builder2.add("emfis-cntl", "tcp", 141);
        builder2.add("emfis-cntl", "udp", 141);
        builder2.add("bl-idm", "tcp", 142);
        builder2.add("bl-idm", "udp", 142);
        builder2.add("imap", "tcp", 143);
        builder2.add("imap", "udp", 143);
        builder2.add("uma", "tcp", 144);
        builder2.add("uma", "udp", 144);
        builder2.add("uaac", "tcp", 145);
        builder2.add("uaac", "udp", 145);
        builder2.add("iso-tp0", "tcp", 146);
        builder2.add("iso-tp0", "udp", 146);
        builder2.add("iso-ip", "tcp", 147);
        builder2.add("iso-ip", "udp", 147);
        builder2.add("jargon", "tcp", 148);
        builder2.add("jargon", "udp", 148);
        builder2.add("aed-512", "tcp", 149);
        builder2.add("aed-512", "udp", 149);
        builder2.add("sql-net", "tcp", 150);
        builder2.add("sql-net", "udp", 150);
        builder2.add("hems", "tcp", 151);
        builder2.add("hems", "udp", 151);
        builder2.add("bftp", "tcp", 152);
        builder2.add("bftp", "udp", 152);
        builder2.add("sgmp", "tcp", 153);
        builder2.add("sgmp", "udp", 153);
        builder2.add("netsc-prod", "tcp", 154);
        builder2.add("netsc-prod", "udp", 154);
        builder2.add("netsc-dev", "tcp", 155);
        builder2.add("netsc-dev", "udp", 155);
        builder2.add("sqlsrv", "tcp", 156);
        builder2.add("sqlsrv", "udp", 156);
        builder2.add("knet-cmp", "tcp", 157);
        builder2.add("knet-cmp", "udp", 157);
        builder2.add("pcmail-srv", "tcp", 158);
        builder2.add("pcmail-srv", "udp", 158);
        builder2.add("nss-routing", "tcp", 159);
        builder2.add("nss-routing", "udp", 159);
        builder2.add("sgmp-traps", "tcp", 160);
        builder2.add("sgmp-traps", "udp", 160);
        builder2.add("snmp", "tcp", 161);
        builder2.add("snmp", "udp", 161);
        builder2.add("snmptrap", "tcp", 162);
        builder2.add("snmptrap", "udp", 162);
        builder2.add("cmip-man", "tcp", 163);
        builder2.add("cmip-man", "udp", 163);
        builder2.add("cmip-agent", "tcp", 164);
        builder2.add("cmip-agent", "udp", 164);
        builder2.add("xns-courier", "tcp", 165);
        builder2.add("xns-courier", "udp", 165);
        builder2.add("s-net", "tcp", 166);
        builder2.add("s-net", "udp", 166);
        builder2.add("namp", "tcp", 167);
        builder2.add("namp", "udp", 167);
        builder2.add("rsvd", "tcp", 168);
        builder2.add("rsvd", "udp", 168);
        builder2.add("send", "tcp", 169);
        builder2.add("send", "udp", 169);
        builder2.add("print-srv", "tcp", 170);
        builder2.add("print-srv", "udp", 170);
        builder2.add("multiplex", "tcp", 171);
        builder2.add("multiplex", "udp", 171);
        builder2.add("cl/1", "tcp", 172);
        builder2.add("cl/1", "udp", 172);
        builder2.add("xyplex-mux", "tcp", 173);
        builder2.add("xyplex-mux", "udp", 173);
        builder2.add("mailq", "tcp", 174);
        builder2.add("mailq", "udp", 174);
        builder2.add("vmnet", "tcp", 175);
        builder2.add("vmnet", "udp", 175);
        builder2.add("genrad-mux", "tcp", 176);
        builder2.add("genrad-mux", "udp", 176);
        builder2.add("xdmcp", "tcp", 177);
        builder2.add("xdmcp", "udp", 177);
        builder2.add("nextstep", "tcp", 178);
        builder2.add("nextstep", "udp", 178);
        builder2.add("bgp", "tcp", 179);
        builder2.add("bgp", "udp", 179);
        builder2.add("bgp/sctp", 179);
        builder2.add("ris", "tcp", 180);
        builder2.add("ris", "udp", 180);
        builder2.add("unify", "tcp", 181);
        builder2.add("unify", "udp", 181);
        builder2.add("audit", "tcp", 182);
        builder2.add("audit", "udp", 182);
        builder2.add("ocbinder", "tcp", 183);
        builder2.add("ocbinder", "udp", 183);
        builder2.add("ocserver", "tcp", 184);
        builder2.add("ocserver", "udp", 184);
        builder2.add("remote-kis", "tcp", 185);
        builder2.add("remote-kis", "udp", 185);
        builder2.add("kis", "tcp", 186);
        builder2.add("kis", "udp", 186);
        builder2.add("aci", "tcp", 187);
        builder2.add("aci", "udp", 187);
        builder2.add("mumps", "tcp", 188);
        builder2.add("mumps", "udp", 188);
        builder2.add("qft", "tcp", 189);
        builder2.add("qft", "udp", 189);
        builder2.add("gacp", "tcp", 190);
        builder2.add("gacp", "udp", 190);
        builder2.add("prospero", "tcp", 191);
        builder2.add("prospero", "udp", 191);
        builder2.add("osu-nms", "tcp", 192);
        builder2.add("osu-nms", "udp", 192);
        builder2.add("srmp", "tcp", 193);
        builder2.add("srmp", "udp", 193);
        builder2.add("irc", "tcp", 194);
        builder2.add("irc", "udp", 194);
        builder2.add("dn6-nlm-aud", "tcp", 195);
        builder2.add("dn6-nlm-aud", "udp", 195);
        builder2.add("dn6-smm-red", "tcp", 196);
        builder2.add("dn6-smm-red", "udp", 196);
        builder2.add("dls", "tcp", 197);
        builder2.add("dls", "udp", 197);
        builder2.add("dls-mon", "tcp", 198);
        builder2.add("dls-mon", "udp", 198);
        builder2.add("smux", "tcp", 199);
        builder2.add("smux", "udp", 199);
        builder2.add("src", "tcp", 200);
        builder2.add("src", "udp", 200);
        builder2.add("at-rtmp", "tcp", 201);
        builder2.add("at-rtmp", "udp", 201);
        builder2.add("at-nbp", "tcp", 202);
        builder2.add("at-nbp", "udp", 202);
        builder2.add("at-3", "tcp", 203);
        builder2.add("at-3", "udp", 203);
        builder2.add("at-echo", "tcp", 204);
        builder2.add("at-echo", "udp", 204);
        builder2.add("at-5", "tcp", 205);
        builder2.add("at-5", "udp", 205);
        builder2.add("at-zis", "tcp", 206);
        builder2.add("at-zis", "udp", 206);
        builder2.add("at-7", "tcp", 207);
        builder2.add("at-7", "udp", 207);
        builder2.add("at-8", "tcp", 208);
        builder2.add("at-8", "udp", 208);
        builder2.add("qmtp", "tcp", 209);
        builder2.add("qmtp", "udp", 209);
        builder2.add("z39.50", "tcp", 210);
        builder2.add("z39.50", "udp", 210);
        builder2.add("914c/g", "tcp", 211);
        builder2.add("914c/g", "udp", 211);
        builder2.add("anet", "tcp", 212);
        builder2.add("anet", "udp", 212);
        builder2.add("ipx", "tcp", 213);
        builder2.add("ipx", "udp", 213);
        builder2.add("vmpwscs", "tcp", 214);
        builder2.add("vmpwscs", "udp", 214);
        builder2.add("softpc", "tcp", 215);
        builder2.add("softpc", "udp", 215);
        builder2.add("CAIlic", "tcp", 216);
        builder2.add("CAIlic", "udp", 216);
        builder2.add("dbase", "tcp", 217);
        builder2.add("dbase", "udp", 217);
        builder2.add("mpp", "tcp", 218);
        builder2.add("mpp", "udp", 218);
        builder2.add("uarps", "tcp", 219);
        builder2.add("uarps", "udp", 219);
        builder2.add("imap3", "tcp", 220);
        builder2.add("imap3", "udp", 220);
        builder2.add("fln-spx", "tcp", 221);
        builder2.add("fln-spx", "udp", 221);
        builder2.add("rsh-spx", "tcp", 222);
        builder2.add("rsh-spx", "udp", 222);
        builder2.add("cdc", "tcp", 223);
        builder2.add("cdc", "udp", 223);
        builder2.add("masqdialer", "tcp", 224);
        builder2.add("masqdialer", "udp", 224);
        builder2.add("direct", "tcp", 242);
        builder2.add("direct", "udp", 242);
        builder2.add("sur-meas", "tcp", 243);
        builder2.add("sur-meas", "udp", 243);
        builder2.add("inbusiness", "tcp", 244);
        builder2.add("inbusiness", "udp", 244);
        builder2.add("link", "tcp", 245);
        builder2.add("link", "udp", 245);
        builder2.add("dsp3270", "tcp", 246);
        builder2.add("dsp3270", "udp", 246);
        builder2.add("subntbcst_tftp", "tcp", 247);
        builder2.add("subntbcst_tftp", "udp", 247);
        builder2.add("bhfhs", "tcp", 248);
        builder2.add("bhfhs", "udp", 248);
        builder2.add("rap", "tcp", 256);
        builder2.add("rap", "udp", 256);
        builder2.add("set", "tcp", 257);
        builder2.add("set", "udp", 257);
        builder2.add("esro-gen", "tcp", 259);
        builder2.add("esro-gen", "udp", 259);
        builder2.add("openport", "tcp", 260);
        builder2.add("openport", "udp", 260);
        builder2.add("nsiiops", "tcp", 261);
        builder2.add("nsiiops", "udp", 261);
        builder2.add("arcisdms", "tcp", 262);
        builder2.add("arcisdms", "udp", 262);
        builder2.add("hdap", "tcp", 263);
        builder2.add("hdap", "udp", 263);
        builder2.add("bgmp", "tcp", 264);
        builder2.add("bgmp", "udp", 264);
        builder2.add("x-bone-ctl", "tcp", 265);
        builder2.add("x-bone-ctl", "udp", 265);
        builder2.add("sst", "tcp", 266);
        builder2.add("sst", "udp", 266);
        builder2.add("td-service", "tcp", 267);
        builder2.add("td-service", "udp", 267);
        builder2.add("td-replica", "tcp", 268);
        builder2.add("td-replica", "udp", 268);
        builder2.add("manet", "tcp", 269);
        builder2.add("manet", "udp", 269);
        builder2.add("http-mgmt", "tcp", 280);
        builder2.add("http-mgmt", "udp", 280);
        builder2.add("personal-link", "tcp", 281);
        builder2.add("personal-link", "udp", 281);
        builder2.add("cableport-ax", "tcp", 282);
        builder2.add("cableport-ax", "udp", 282);
        builder2.add("rescap", "tcp", 283);
        builder2.add("rescap", "udp", 283);
        builder2.add("corerjd", "tcp", 284);
        builder2.add("corerjd", "udp", 284);
        builder2.add("fxp", "tcp", 286);
        builder2.add("fxp", "udp", 286);
        builder2.add("k-block", "tcp", 287);
        builder2.add("k-block", "udp", 287);
        builder2.add("novastorbakcup", "tcp", 308);
        builder2.add("novastorbakcup", "udp", 308);
        builder2.add("entrusttime", "tcp", 309);
        builder2.add("entrusttime", "udp", 309);
        builder2.add("bhmds", "tcp", 310);
        builder2.add("bhmds", "udp", 310);
        builder2.add("asip-webadmin", "tcp", 311);
        builder2.add("asip-webadmin", "udp", 311);
        builder2.add("vslmp", "tcp", 312);
        builder2.add("vslmp", "udp", 312);
        builder2.add("magenta-logic", "tcp", 313);
        builder2.add("magenta-logic", "udp", 313);
        builder2.add("opalis-robot", "tcp", 314);
        builder2.add("opalis-robot", "udp", 314);
        builder2.add("dpsi", "tcp", 315);
        builder2.add("dpsi", "udp", 315);
        builder2.add("decauth", "tcp", 316);
        builder2.add("decauth", "udp", 316);
        builder2.add("zannet", "tcp", 317);
        builder2.add("zannet", "udp", 317);
        builder2.add("pkix-timestamp", "tcp", 318);
        builder2.add("pkix-timestamp", "udp", 318);
        builder2.add("ptp-event", "tcp", 319);
        builder2.add("ptp-event", "udp", 319);
        builder2.add("ptp-general", "tcp", 320);
        builder2.add("ptp-general", "udp", 320);
        builder2.add("pip", "tcp", 321);
        builder2.add("pip", "udp", 321);
        builder2.add("rtsps", "tcp", 322);
        builder2.add("rtsps", "udp", 322);
        builder2.add("texar", "tcp", 333);
        builder2.add("texar", "udp", 333);
        builder2.add("pdap", "tcp", 344);
        builder2.add("pdap", "udp", 344);
        builder2.add("pawserv", "tcp", 345);
        builder2.add("pawserv", "udp", 345);
        builder2.add("zserv", "tcp", 346);
        builder2.add("zserv", "udp", 346);
        builder2.add("fatserv", "tcp", 347);
        builder2.add("fatserv", "udp", 347);
        builder2.add("csi-sgwp", "tcp", 348);
        builder2.add("csi-sgwp", "udp", 348);
        builder2.add("mftp", "tcp", 349);
        builder2.add("mftp", "udp", 349);
        builder2.add("matip-type-a", "tcp", 350);
        builder2.add("matip-type-a", "udp", 350);
        builder2.add("matip-type-b", "tcp", 351);
        builder2.add("matip-type-b", "udp", 351);
        builder2.add("bhoetty", "tcp", 351);
        builder2.add("bhoetty", "udp", 351);
        builder2.add("dtag-ste-sb", "tcp", 352);
        builder2.add("dtag-ste-sb", "udp", 352);
        builder2.add("bhoedap4", "tcp", 352);
        builder2.add("bhoedap4", "udp", 352);
        builder2.add("ndsauth", "tcp", 353);
        builder2.add("ndsauth", "udp", 353);
        builder2.add("bh611", "tcp", 354);
        builder2.add("bh611", "udp", 354);
        builder2.add("datex-asn", "tcp", 355);
        builder2.add("datex-asn", "udp", 355);
        builder2.add("cloanto-net-1", "tcp", 356);
        builder2.add("cloanto-net-1", "udp", 356);
        builder2.add("bhevent", "tcp", 357);
        builder2.add("bhevent", "udp", 357);
        builder2.add("shrinkwrap", "tcp", 358);
        builder2.add("shrinkwrap", "udp", 358);
        builder2.add("nsrmp", "tcp", 359);
        builder2.add("nsrmp", "udp", 359);
        builder2.add("scoi2odialog", "tcp", 360);
        builder2.add("scoi2odialog", "udp", 360);
        builder2.add("semantix", "tcp", 361);
        builder2.add("semantix", "udp", 361);
        builder2.add("srssend", "tcp", 362);
        builder2.add("srssend", "udp", 362);
        builder2.add("rsvp_tunnel", "tcp", 363);
        builder2.add("rsvp_tunnel", "udp", 363);
        builder2.add("aurora-cmgr", "tcp", 364);
        builder2.add("aurora-cmgr", "udp", 364);
        builder2.add("dtk", "tcp", 365);
        builder2.add("dtk", "udp", 365);
        builder2.add("odmr", "tcp", 366);
        builder2.add("odmr", "udp", 366);
        builder2.add("mortgageware", "tcp", 367);
        builder2.add("mortgageware", "udp", 367);
        builder2.add("qbikgdp", "tcp", 368);
        builder2.add("qbikgdp", "udp", 368);
        builder2.add("rpc2portmap", "tcp", 369);
        builder2.add("rpc2portmap", "udp", 369);
        builder2.add("codaauth2", "tcp", 370);
        builder2.add("codaauth2", "udp", 370);
        builder2.add("clearcase", "tcp", 371);
        builder2.add("clearcase", "udp", 371);
        builder2.add("ulistproc", "tcp", 372);
        builder2.add("ulistproc", "udp", 372);
        builder2.add("legent-1", "tcp", 373);
        builder2.add("legent-1", "udp", 373);
        builder2.add("legent-2", "tcp", 374);
        builder2.add("legent-2", "udp", 374);
        builder2.add("hassle", "tcp", 375);
        builder2.add("hassle", "udp", 375);
        builder2.add("nip", "tcp", 376);
        builder2.add("nip", "udp", 376);
        builder2.add("tnETOS", "tcp", 377);
        builder2.add("tnETOS", "udp", 377);
        builder2.add("dsETOS", "tcp", 378);
        builder2.add("dsETOS", "udp", 378);
        builder2.add("is99c", "tcp", 379);
        builder2.add("is99c", "udp", 379);
        builder2.add("is99s", "tcp", 380);
        builder2.add("is99s", "udp", 380);
        builder2.add("hp-collector", "tcp", 381);
        builder2.add("hp-collector", "udp", 381);
        builder2.add("hp-managed-node", "tcp", 382);
        builder2.add("hp-managed-node", "udp", 382);
        builder2.add("hp-alarm-mgr", "tcp", 383);
        builder2.add("hp-alarm-mgr", "udp", 383);
        builder2.add("arns", "tcp", 384);
        builder2.add("arns", "udp", 384);
        builder2.add("ibm-app", "tcp", 385);
        builder2.add("ibm-app", "udp", 385);
        builder2.add("asa", "tcp", 386);
        builder2.add("asa", "udp", 386);
        builder2.add("aurp", "tcp", 387);
        builder2.add("aurp", "udp", 387);
        builder2.add("unidata-ldm", "tcp", 388);
        builder2.add("unidata-ldm", "udp", 388);
        builder2.add("ldap", "tcp", 389);
        builder2.add("ldap", "udp", 389);
        builder2.add("uis", "tcp", 390);
        builder2.add("uis", "udp", 390);
        builder2.add("synotics-relay", "tcp", 391);
        builder2.add("synotics-relay", "udp", 391);
        builder2.add("synotics-broker", "tcp", 392);
        builder2.add("synotics-broker", "udp", 392);
        builder2.add("meta5", "tcp", 393);
        builder2.add("meta5", "udp", 393);
        builder2.add("embl-ndt", "tcp", 394);
        builder2.add("embl-ndt", "udp", 394);
        builder2.add("netcp", "tcp", 395);
        builder2.add("netcp", "udp", 395);
        builder2.add("netware-ip", "tcp", 396);
        builder2.add("netware-ip", "udp", 396);
        builder2.add("mptn", "tcp", 397);
        builder2.add("mptn", "udp", 397);
        builder2.add("kryptolan", "tcp", 398);
        builder2.add("kryptolan", "udp", 398);
        builder2.add("iso-tsap-c2", "tcp", 399);
        builder2.add("iso-tsap-c2", "udp", 399);
        builder2.add("work-sol", "tcp", 400);
        builder2.add("work-sol", "udp", 400);
        builder2.add("ups", "tcp", 401);
        builder2.add("ups", "udp", 401);
        builder2.add("genie", "tcp", 402);
        builder2.add("genie", "udp", 402);
        builder2.add("decap", "tcp", 403);
        builder2.add("decap", "udp", 403);
        builder2.add("nced", "tcp", 404);
        builder2.add("nced", "udp", 404);
        builder2.add("ncld", "tcp", 405);
        builder2.add("ncld", "udp", 405);
        builder2.add("imsp", "tcp", 406);
        builder2.add("imsp", "udp", 406);
        builder2.add("timbuktu", "tcp", 407);
        builder2.add("timbuktu", "udp", 407);
        builder2.add("prm-sm", "tcp", 408);
        builder2.add("prm-sm", "udp", 408);
        builder2.add("prm-nm", "tcp", 409);
        builder2.add("prm-nm", "udp", 409);
        builder2.add("decladebug", "tcp", 410);
        builder2.add("decladebug", "udp", 410);
        builder2.add("rmt", "tcp", 411);
        builder2.add("rmt", "udp", 411);
        builder2.add("synoptics-trap", "tcp", 412);
        builder2.add("synoptics-trap", "udp", 412);
        builder2.add("smsp", "tcp", 413);
        builder2.add("smsp", "udp", 413);
        builder2.add("infoseek", "tcp", 414);
        builder2.add("infoseek", "udp", 414);
        builder2.add("bnet", "tcp", 415);
        builder2.add("bnet", "udp", 415);
        builder2.add("silverplatter", "tcp", 416);
        builder2.add("silverplatter", "udp", 416);
        builder2.add("onmux", "tcp", 417);
        builder2.add("onmux", "udp", 417);
        builder2.add("hyper-g", "tcp", 418);
        builder2.add("hyper-g", "udp", 418);
        builder2.add("ariel1", "tcp", 419);
        builder2.add("ariel1", "udp", 419);
        builder2.add("smpte", "tcp", 420);
        builder2.add("smpte", "udp", 420);
        builder2.add("ariel2", "tcp", 421);
        builder2.add("ariel2", "udp", 421);
        builder2.add("ariel3", "tcp", 422);
        builder2.add("ariel3", "udp", 422);
        builder2.add("opc-job-start", "tcp", 423);
        builder2.add("opc-job-start", "udp", 423);
        builder2.add("opc-job-track", "tcp", 424);
        builder2.add("opc-job-track", "udp", 424);
        builder2.add("icad-el", "tcp", 425);
        builder2.add("icad-el", "udp", 425);
        builder2.add("smartsdp", "tcp", 426);
        builder2.add("smartsdp", "udp", 426);
        builder2.add("svrloc", "tcp", 427);
        builder2.add("svrloc", "udp", 427);
        builder2.add("ocs_cmu", "tcp", 428);
        builder2.add("ocs_cmu", "udp", 428);
        builder2.add("ocs_amu", "tcp", 429);
        builder2.add("ocs_amu", "udp", 429);
        builder2.add("utmpsd", "tcp", 430);
        builder2.add("utmpsd", "udp", 430);
        builder2.add("utmpcd", "tcp", 431);
        builder2.add("utmpcd", "udp", 431);
        builder2.add("iasd", "tcp", 432);
        builder2.add("iasd", "udp", 432);
        builder2.add("nnsp", "tcp", 433);
        builder2.add("nnsp", "udp", 433);
        builder2.add("mobileip-agent", "tcp", 434);
        builder2.add("mobileip-agent", "udp", 434);
        builder2.add("mobilip-mn", "tcp", 435);
        builder2.add("mobilip-mn", "udp", 435);
        builder2.add("dna-cml", "tcp", 436);
        builder2.add("dna-cml", "udp", 436);
        builder2.add("comscm", "tcp", 437);
        builder2.add("comscm", "udp", 437);
        builder2.add("dsfgw", "tcp", 438);
        builder2.add("dsfgw", "udp", 438);
        builder2.add("dasp", "tcp", 439);
        builder2.add("dasp", "udp", 439);
        builder2.add("sgcp", "tcp", 440);
        builder2.add("sgcp", "udp", 440);
        builder2.add("decvms-sysmgt", "tcp", 441);
        builder2.add("decvms-sysmgt", "udp", 441);
        builder2.add("cvc_hostd", "tcp", 442);
        builder2.add("cvc_hostd", "udp", 442);
        builder2.add("https", "tcp", 443);
        builder2.add("https", "udp", 443);
        builder2.add("https/sctp", 443);
        builder2.add("snpp", "tcp", 444);
        builder2.add("snpp", "udp", 444);
        builder2.add("microsoft-ds", "tcp", 445);
        builder2.add("microsoft-ds", "udp", 445);
        builder2.add("ddm-rdb", "tcp", 446);
        builder2.add("ddm-rdb", "udp", 446);
        builder2.add("ddm-dfm", "tcp", 447);
        builder2.add("ddm-dfm", "udp", 447);
        builder2.add("ddm-ssl", "tcp", 448);
        builder2.add("ddm-ssl", "udp", 448);
        builder2.add("as-servermap", "tcp", 449);
        builder2.add("as-servermap", "udp", 449);
        builder2.add("tserver", "tcp", 450);
        builder2.add("tserver", "udp", 450);
        builder2.add("sfs-smp-net", "tcp", 451);
        builder2.add("sfs-smp-net", "udp", 451);
        builder2.add("sfs-config", "tcp", 452);
        builder2.add("sfs-config", "udp", 452);
        builder2.add("creativeserver", "tcp", 453);
        builder2.add("creativeserver", "udp", 453);
        builder2.add("contentserver", "tcp", 454);
        builder2.add("contentserver", "udp", 454);
        builder2.add("creativepartnr", "tcp", 455);
        builder2.add("creativepartnr", "udp", 455);
        builder2.add("macon-tcp", "tcp", 456);
        builder2.add("macon-udp", "udp", 456);
        builder2.add("scohelp", "tcp", 457);
        builder2.add("scohelp", "udp", 457);
        builder2.add("appleqtc", "tcp", 458);
        builder2.add("appleqtc", "udp", 458);
        builder2.add("ampr-rcmd", "tcp", 459);
        builder2.add("ampr-rcmd", "udp", 459);
        builder2.add("skronk", "tcp", 460);
        builder2.add("skronk", "udp", 460);
        builder2.add("datasurfsrv", "tcp", 461);
        builder2.add("datasurfsrv", "udp", 461);
        builder2.add("datasurfsrvsec", "tcp", 462);
        builder2.add("datasurfsrvsec", "udp", 462);
        builder2.add("alpes", "tcp", 463);
        builder2.add("alpes", "udp", 463);
        builder2.add("kpasswd", "tcp", 464);
        builder2.add("kpasswd", "udp", 464);
        builder2.add("urd", "tcp", 465);
        builder2.add("igmpv3lite", "udp", 465);
        builder2.add("digital-vrc", "tcp", 466);
        builder2.add("digital-vrc", "udp", 466);
        builder2.add("mylex-mapd", "tcp", 467);
        builder2.add("mylex-mapd", "udp", 467);
        builder2.add("photuris", "tcp", 468);
        builder2.add("photuris", "udp", 468);
        builder2.add("rcp", "tcp", 469);
        builder2.add("rcp", "udp", 469);
        builder2.add("scx-proxy", "tcp", 470);
        builder2.add("scx-proxy", "udp", 470);
        builder2.add("mondex", "tcp", 471);
        builder2.add("mondex", "udp", 471);
        builder2.add("ljk-login", "tcp", 472);
        builder2.add("ljk-login", "udp", 472);
        builder2.add("hybrid-pop", "tcp", 473);
        builder2.add("hybrid-pop", "udp", 473);
        builder2.add("tn-tl-w1", "tcp", 474);
        builder2.add("tn-tl-w2", "udp", 474);
        builder2.add("tcpnethaspsrv", "tcp", 475);
        builder2.add("tcpnethaspsrv", "udp", 475);
        builder2.add("tn-tl-fd1", "tcp", 476);
        builder2.add("tn-tl-fd1", "udp", 476);
        builder2.add("ss7ns", "tcp", 477);
        builder2.add("ss7ns", "udp", 477);
        builder2.add("spsc", "tcp", 478);
        builder2.add("spsc", "udp", 478);
        builder2.add("iafserver", "tcp", 479);
        builder2.add("iafserver", "udp", 479);
        builder2.add("iafdbase", "tcp", 480);
        builder2.add("iafdbase", "udp", 480);
        builder2.add("ph", "tcp", 481);
        builder2.add("ph", "udp", 481);
        builder2.add("bgs-nsi", "tcp", 482);
        builder2.add("bgs-nsi", "udp", 482);
        builder2.add("ulpnet", "tcp", 483);
        builder2.add("ulpnet", "udp", 483);
        builder2.add("integra-sme", "tcp", 484);
        builder2.add("integra-sme", "udp", 484);
        builder2.add("powerburst", "tcp", 485);
        builder2.add("powerburst", "udp", 485);
        builder2.add("avian", "tcp", 486);
        builder2.add("avian", "udp", 486);
        builder2.add("saft", "tcp", 487);
        builder2.add("saft", "udp", 487);
        builder2.add("gss-http", "tcp", 488);
        builder2.add("gss-http", "udp", 488);
        builder2.add("nest-protocol", "tcp", 489);
        builder2.add("nest-protocol", "udp", 489);
        builder2.add("micom-pfs", "tcp", 490);
        builder2.add("micom-pfs", "udp", 490);
        builder2.add("go-login", "tcp", 491);
        builder2.add("go-login", "udp", 491);
        builder2.add("ticf-1", "tcp", 492);
        builder2.add("ticf-1", "udp", 492);
        builder2.add("ticf-2", "tcp", 493);
        builder2.add("ticf-2", "udp", 493);
        builder2.add("pov-ray", "tcp", 494);
        builder2.add("pov-ray", "udp", 494);
        builder2.add("intecourier", "tcp", 495);
        builder2.add("intecourier", "udp", 495);
        builder2.add("pim-rp-disc", "tcp", 496);
        builder2.add("pim-rp-disc", "udp", 496);
        builder2.add("dantz", "tcp", 497);
        builder2.add("dantz", "udp", 497);
        builder2.add("siam", "tcp", 498);
        builder2.add("siam", "udp", 498);
        builder2.add("iso-ill", "tcp", 499);
        builder2.add("iso-ill", "udp", 499);
        builder2.add("isakmp", "tcp", 500);
        builder2.add("isakmp", "udp", 500);
        builder2.add("stmf", "tcp", 501);
        builder2.add("stmf", "udp", 501);
        builder2.add("asa-appl-proto", "tcp", 502);
        builder2.add("asa-appl-proto", "udp", 502);
        builder2.add("intrinsa", "tcp", 503);
        builder2.add("intrinsa", "udp", 503);
        builder2.add("citadel", "tcp", 504);
        builder2.add("citadel", "udp", 504);
        builder2.add("mailbox-lm", "tcp", 505);
        builder2.add("mailbox-lm", "udp", 505);
        builder2.add("ohimsrv", "tcp", 506);
        builder2.add("ohimsrv", "udp", 506);
        builder2.add("crs", "tcp", 507);
        builder2.add("crs", "udp", 507);
        builder2.add("xvttp", "tcp", 508);
        builder2.add("xvttp", "udp", 508);
        builder2.add("snare", "tcp", 509);
        builder2.add("snare", "udp", 509);
        builder2.add("fcp", "tcp", 510);
        builder2.add("fcp", "udp", 510);
        builder2.add("passgo", "tcp", 511);
        builder2.add("passgo", "udp", 511);
        builder2.add("exec", "tcp", 512);
        builder2.add("comsat", "udp", 512);
        builder2.add("biff", "udp", 512);
        builder2.add("login", "tcp", 513);
        builder2.add("who", "udp", 513);
        builder2.add("shell", "tcp", 514);
        builder2.add("syslog", "udp", 514);
        builder2.add("printer", "tcp", 515);
        builder2.add("printer", "udp", 515);
        builder2.add("videotex", "tcp", 516);
        builder2.add("videotex", "udp", 516);
        builder2.add("talk", "tcp", 517);
        builder2.add("talk", "udp", 517);
        builder2.add("ntalk", "tcp", 518);
        builder2.add("ntalk", "udp", 518);
        builder2.add("utime", "tcp", 519);
        builder2.add("utime", "udp", 519);
        builder2.add("efs", "tcp", 520);
        builder2.add("router", "udp", 520);
        builder2.add("ripng", "tcp", 521);
        builder2.add("ripng", "udp", 521);
        builder2.add("ulp", "tcp", 522);
        builder2.add("ulp", "udp", 522);
        builder2.add("ibm-db2", "tcp", 523);
        builder2.add("ibm-db2", "udp", 523);
        builder2.add("ncp", "tcp", 524);
        builder2.add("ncp", "udp", 524);
        builder2.add("timed", "tcp", 525);
        builder2.add("timed", "udp", 525);
        builder2.add("tempo", "tcp", 526);
        builder2.add("tempo", "udp", 526);
        builder2.add("stx", "tcp", 527);
        builder2.add("stx", "udp", 527);
        builder2.add("custix", "tcp", 528);
        builder2.add("custix", "udp", 528);
        builder2.add("irc-serv", "tcp", 529);
        builder2.add("irc-serv", "udp", 529);
        builder2.add("courier", "tcp", 530);
        builder2.add("courier", "udp", 530);
        builder2.add("conference", "tcp", 531);
        builder2.add("conference", "udp", 531);
        builder2.add("netnews", "tcp", 532);
        builder2.add("netnews", "udp", 532);
        builder2.add("netwall", "tcp", 533);
        builder2.add("netwall", "udp", 533);
        builder2.add("windream", "tcp", 534);
        builder2.add("windream", "udp", 534);
        builder2.add("iiop", "tcp", 535);
        builder2.add("iiop", "udp", 535);
        builder2.add("opalis-rdv", "tcp", 536);
        builder2.add("opalis-rdv", "udp", 536);
        builder2.add("nmsp", "tcp", 537);
        builder2.add("nmsp", "udp", 537);
        builder2.add("gdomap", "tcp", 538);
        builder2.add("gdomap", "udp", 538);
        builder2.add("apertus-ldp", "tcp", 539);
        builder2.add("apertus-ldp", "udp", 539);
        builder2.add("uucp", "tcp", 540);
        builder2.add("uucp", "udp", 540);
        builder2.add("uucp-rlogin", "tcp", 541);
        builder2.add("uucp-rlogin", "udp", 541);
        builder2.add("commerce", "tcp", 542);
        builder2.add("commerce", "udp", 542);
        builder2.add("klogin", "tcp", 543);
        builder2.add("klogin", "udp", 543);
        builder2.add("kshell", "tcp", 544);
        builder2.add("kshell", "udp", 544);
        builder2.add("appleqtcsrvr", "tcp", 545);
        builder2.add("appleqtcsrvr", "udp", 545);
        builder2.add("dhcpv6-client", "tcp", 546);
        builder2.add("dhcpv6-client", "udp", 546);
        builder2.add("dhcpv6-server", "tcp", 547);
        builder2.add("dhcpv6-server", "udp", 547);
        builder2.add("afpovertcp", "tcp", 548);
        builder2.add("afpovertcp", "udp", 548);
        builder2.add("idfp", "tcp", 549);
        builder2.add("idfp", "udp", 549);
        builder2.add("new-rwho", "tcp", 550);
        builder2.add("new-rwho", "udp", 550);
        builder2.add("cybercash", "tcp", 551);
        builder2.add("cybercash", "udp", 551);
        builder2.add("devshr-nts", "tcp", 552);
        builder2.add("devshr-nts", "udp", 552);
        builder2.add("pirp", "tcp", 553);
        builder2.add("pirp", "udp", 553);
        builder2.add("rtsp", "tcp", 554);
        builder2.add("rtsp", "udp", 554);
        builder2.add("dsf", "tcp", 555);
        builder2.add("dsf", "udp", 555);
        builder2.add("remotefs", "tcp", 556);
        builder2.add("remotefs", "udp", 556);
        builder2.add("openvms-sysipc", "tcp", 557);
        builder2.add("openvms-sysipc", "udp", 557);
        builder2.add("sdnskmp", "tcp", 558);
        builder2.add("sdnskmp", "udp", 558);
        builder2.add("teedtap", "tcp", 559);
        builder2.add("teedtap", "udp", 559);
        builder2.add("rmonitor", "tcp", 560);
        builder2.add("rmonitor", "udp", 560);
        builder2.add("monitor", "tcp", 561);
        builder2.add("monitor", "udp", 561);
        builder2.add("chshell", "tcp", 562);
        builder2.add("chshell", "udp", 562);
        builder2.add("nntps", "tcp", 563);
        builder2.add("nntps", "udp", 563);
        builder2.add("9pfs", "tcp", 564);
        builder2.add("9pfs", "udp", 564);
        builder2.add("whoami", "tcp", 565);
        builder2.add("whoami", "udp", 565);
        builder2.add("streettalk", "tcp", 566);
        builder2.add("streettalk", "udp", 566);
        builder2.add("banyan-rpc", "tcp", 567);
        builder2.add("banyan-rpc", "udp", 567);
        builder2.add("ms-shuttle", "tcp", 568);
        builder2.add("ms-shuttle", "udp", 568);
        builder2.add("ms-rome", "tcp", 569);
        builder2.add("ms-rome", "udp", 569);
        builder2.add("meter", "tcp", 570);
        builder2.add("meter", "udp", 570);
        builder2.add("meter", "tcp", 571);
        builder2.add("meter", "udp", 571);
        builder2.add("sonar", "tcp", 572);
        builder2.add("sonar", "udp", 572);
        builder2.add("banyan-vip", "tcp", 573);
        builder2.add("banyan-vip", "udp", 573);
        builder2.add("ftp-agent", "tcp", 574);
        builder2.add("ftp-agent", "udp", 574);
        builder2.add("vemmi", "tcp", 575);
        builder2.add("vemmi", "udp", 575);
        builder2.add("ipcd", "tcp", 576);
        builder2.add("ipcd", "udp", 576);
        builder2.add("vnas", "tcp", 577);
        builder2.add("vnas", "udp", 577);
        builder2.add("ipdd", "tcp", 578);
        builder2.add("ipdd", "udp", 578);
        builder2.add("decbsrv", "tcp", 579);
        builder2.add("decbsrv", "udp", 579);
        builder2.add("sntp-heartbeat", "tcp", 580);
        builder2.add("sntp-heartbeat", "udp", 580);
        builder2.add("bdp", "tcp", 581);
        builder2.add("bdp", "udp", 581);
        builder2.add("scc-security", "tcp", 582);
        builder2.add("scc-security", "udp", 582);
        builder2.add("philips-vc", "tcp", 583);
        builder2.add("philips-vc", "udp", 583);
        builder2.add("keyserver", "tcp", 584);
        builder2.add("keyserver", "udp", 584);
        builder2.add("password-chg", "tcp", 586);
        builder2.add("password-chg", "udp", 586);
        builder2.add("submission", "tcp", 587);
        builder2.add("submission", "udp", 587);
        builder2.add("cal", "tcp", 588);
        builder2.add("cal", "udp", 588);
        builder2.add("eyelink", "tcp", 589);
        builder2.add("eyelink", "udp", 589);
        builder2.add("tns-cml", "tcp", 590);
        builder2.add("tns-cml", "udp", 590);
        builder2.add("http-alt", "tcp", 591);
        builder2.add("http-alt", "udp", 591);
        builder2.add("eudora-set", "tcp", 592);
        builder2.add("eudora-set", "udp", 592);
        builder2.add("http-rpc-epmap", "tcp", 593);
        builder2.add("http-rpc-epmap", "udp", 593);
        builder2.add("tpip", "tcp", 594);
        builder2.add("tpip", "udp", 594);
        builder2.add("cab-protocol", "tcp", 595);
        builder2.add("cab-protocol", "udp", 595);
        builder2.add("smsd", "tcp", 596);
        builder2.add("smsd", "udp", 596);
        builder2.add("ptcnameservice", "tcp", 597);
        builder2.add("ptcnameservice", "udp", 597);
        builder2.add("sco-websrvrmg3", "tcp", 598);
        builder2.add("sco-websrvrmg3", "udp", 598);
        builder2.add("acp", "tcp", 599);
        builder2.add("acp", "udp", 599);
        builder2.add("ipcserver", "tcp", 600);
        builder2.add("ipcserver", "udp", 600);
        builder2.add("syslog-conn", "tcp", 601);
        builder2.add("syslog-conn", "udp", 601);
        builder2.add("xmlrpc-beep", "tcp", 602);
        builder2.add("xmlrpc-beep", "udp", 602);
        builder2.add("idxp", "tcp", 603);
        builder2.add("idxp", "udp", 603);
        builder2.add("tunnel", "tcp", 604);
        builder2.add("tunnel", "udp", 604);
        builder2.add("soap-beep", "tcp", 605);
        builder2.add("soap-beep", "udp", 605);
        builder2.add("urm", "tcp", 606);
        builder2.add("urm", "udp", 606);
        builder2.add("nqs", "tcp", 607);
        builder2.add("nqs", "udp", 607);
        builder2.add("sift-uft", "tcp", 608);
        builder2.add("sift-uft", "udp", 608);
        builder2.add("npmp-trap", "tcp", 609);
        builder2.add("npmp-trap", "udp", 609);
        builder2.add("npmp-local", "tcp", 610);
        builder2.add("npmp-local", "udp", 610);
        builder2.add("npmp-gui", "tcp", 611);
        builder2.add("npmp-gui", "udp", 611);
        builder2.add("hmmp-ind", "tcp", 612);
        builder2.add("hmmp-ind", "udp", 612);
        builder2.add("hmmp-op", "tcp", 613);
        builder2.add("hmmp-op", "udp", 613);
        builder2.add("sshell", "tcp", 614);
        builder2.add("sshell", "udp", 614);
        builder2.add("sco-inetmgr", "tcp", 615);
        builder2.add("sco-inetmgr", "udp", 615);
        builder2.add("sco-sysmgr", "tcp", 616);
        builder2.add("sco-sysmgr", "udp", 616);
        builder2.add("sco-dtmgr", "tcp", 617);
        builder2.add("sco-dtmgr", "udp", 617);
        builder2.add("dei-icda", "tcp", 618);
        builder2.add("dei-icda", "udp", 618);
        builder2.add("compaq-evm", "tcp", 619);
        builder2.add("compaq-evm", "udp", 619);
        builder2.add("sco-websrvrmgr", "tcp", 620);
        builder2.add("sco-websrvrmgr", "udp", 620);
        builder2.add("escp-ip", "tcp", 621);
        builder2.add("escp-ip", "udp", 621);
        builder2.add("collaborator", "tcp", 622);
        builder2.add("collaborator", "udp", 622);
        builder2.add("oob-ws-http", "tcp", 623);
        builder2.add("asf-rmcp", "udp", 623);
        builder2.add("cryptoadmin", "tcp", 624);
        builder2.add("cryptoadmin", "udp", 624);
        builder2.add("dec_dlm", "tcp", 625);
        builder2.add("dec_dlm", "udp", 625);
        builder2.add("asia", "tcp", 626);
        builder2.add("asia", "udp", 626);
        builder2.add("passgo-tivoli", "tcp", 627);
        builder2.add("passgo-tivoli", "udp", 627);
        builder2.add("qmqp", "tcp", 628);
        builder2.add("qmqp", "udp", 628);
        builder2.add("3com-amp3", "tcp", 629);
        builder2.add("3com-amp3", "udp", 629);
        builder2.add("rda", "tcp", 630);
        builder2.add("rda", "udp", 630);
        builder2.add("ipp", "tcp", 631);
        builder2.add("ipp", "udp", 631);
        builder2.add("bmpp", "tcp", 632);
        builder2.add("bmpp", "udp", 632);
        builder2.add("servstat", "tcp", 633);
        builder2.add("servstat", "udp", 633);
        builder2.add("ginad", "tcp", 634);
        builder2.add("ginad", "udp", 634);
        builder2.add("rlzdbase", "tcp", 635);
        builder2.add("rlzdbase", "udp", 635);
        builder2.add("ldaps", "tcp", 636);
        builder2.add("ldaps", "udp", 636);
        builder2.add("lanserver", "tcp", 637);
        builder2.add("lanserver", "udp", 637);
        builder2.add("mcns-sec", "tcp", 638);
        builder2.add("mcns-sec", "udp", 638);
        builder2.add("msdp", "tcp", 639);
        builder2.add("msdp", "udp", 639);
        builder2.add("entrust-sps", "tcp", 640);
        builder2.add("entrust-sps", "udp", 640);
        builder2.add("repcmd", "tcp", 641);
        builder2.add("repcmd", "udp", 641);
        builder2.add("esro-emsdp", "tcp", 642);
        builder2.add("esro-emsdp", "udp", 642);
        builder2.add("sanity", "tcp", 643);
        builder2.add("sanity", "udp", 643);
        builder2.add("dwr", "tcp", 644);
        builder2.add("dwr", "udp", 644);
        builder2.add("pssc", "tcp", 645);
        builder2.add("pssc", "udp", 645);
        builder2.add("ldp", "tcp", 646);
        builder2.add("ldp", "udp", 646);
        builder2.add("dhcp-failover", "tcp", 647);
        builder2.add("dhcp-failover", "udp", 647);
        builder2.add("rrp", "tcp", 648);
        builder2.add("rrp", "udp", 648);
        builder2.add("cadview-3d", "tcp", 649);
        builder2.add("cadview-3d", "udp", 649);
        builder2.add("obex", "tcp", 650);
        builder2.add("obex", "udp", 650);
        builder2.add("ieee-mms", "tcp", 651);
        builder2.add("ieee-mms", "udp", 651);
        builder2.add("hello-port", "tcp", 652);
        builder2.add("hello-port", "udp", 652);
        builder2.add("repscmd", "tcp", 653);
        builder2.add("repscmd", "udp", 653);
        builder2.add("aodv", "tcp", 654);
        builder2.add("aodv", "udp", 654);
        builder2.add("tinc", "tcp", 655);
        builder2.add("tinc", "udp", 655);
        builder2.add("spmp", "tcp", 656);
        builder2.add("spmp", "udp", 656);
        builder2.add("rmc", "tcp", 657);
        builder2.add("rmc", "udp", 657);
        builder2.add("tenfold", "tcp", 658);
        builder2.add("tenfold", "udp", 658);
        builder2.add("mac-srvr-admin", "tcp", 660);
        builder2.add("mac-srvr-admin", "udp", 660);
        builder2.add("hap", "tcp", 661);
        builder2.add("hap", "udp", 661);
        builder2.add("pftp", "tcp", 662);
        builder2.add("pftp", "udp", 662);
        builder2.add("purenoise", "tcp", 663);
        builder2.add("purenoise", "udp", 663);
        builder2.add("oob-ws-https", "tcp", 664);
        builder2.add("asf-secure-rmcp", "udp", 664);
        builder2.add("sun-dr", "tcp", 665);
        builder2.add("sun-dr", "udp", 665);
        builder2.add("mdqs", "tcp", 666);
        builder2.add("mdqs", "udp", 666);
        builder2.add("doom", "tcp", 666);
        builder2.add("doom", "udp", 666);
        builder2.add("disclose", "tcp", 667);
        builder2.add("disclose", "udp", 667);
        builder2.add("mecomm", "tcp", 668);
        builder2.add("mecomm", "udp", 668);
        builder2.add("meregister", "tcp", 669);
        builder2.add("meregister", "udp", 669);
        builder2.add("vacdsm-sws", "tcp", 670);
        builder2.add("vacdsm-sws", "udp", 670);
        builder2.add("vacdsm-app", "tcp", 671);
        builder2.add("vacdsm-app", "udp", 671);
        builder2.add("vpps-qua", "tcp", 672);
        builder2.add("vpps-qua", "udp", 672);
        builder2.add("cimplex", "tcp", 673);
        builder2.add("cimplex", "udp", 673);
        builder2.add("acap", "tcp", 674);
        builder2.add("acap", "udp", 674);
        builder2.add("dctp", "tcp", 675);
        builder2.add("dctp", "udp", 675);
        builder2.add("vpps-via", "tcp", 676);
        builder2.add("vpps-via", "udp", 676);
        builder2.add("vpp", "tcp", 677);
        builder2.add("vpp", "udp", 677);
        builder2.add("ggf-ncp", "tcp", 678);
        builder2.add("ggf-ncp", "udp", 678);
        builder2.add("mrm", "tcp", 679);
        builder2.add("mrm", "udp", 679);
        builder2.add("entrust-aaas", "tcp", 680);
        builder2.add("entrust-aaas", "udp", 680);
        builder2.add("entrust-aams", "tcp", 681);
        builder2.add("entrust-aams", "udp", 681);
        builder2.add("xfr", "tcp", 682);
        builder2.add("xfr", "udp", 682);
        builder2.add("corba-iiop", "tcp", 683);
        builder2.add("corba-iiop", "udp", 683);
        builder2.add("corba-iiop-ssl", "tcp", 684);
        builder2.add("corba-iiop-ssl", "udp", 684);
        builder2.add("mdc-portmapper", "tcp", 685);
        builder2.add("mdc-portmapper", "udp", 685);
        builder2.add("hcp-wismar", "tcp", 686);
        builder2.add("hcp-wismar", "udp", 686);
        builder2.add("asipregistry", "tcp", 687);
        builder2.add("asipregistry", "udp", 687);
        builder2.add("realm-rusd", "tcp", 688);
        builder2.add("realm-rusd", "udp", 688);
        builder2.add("nmap", "tcp", 689);
        builder2.add("nmap", "udp", 689);
        builder2.add("vatp", "tcp", 690);
        builder2.add("vatp", "udp", 690);
        builder2.add("msexch-routing", "tcp", 691);
        builder2.add("msexch-routing", "udp", 691);
        builder2.add("hyperwave-isp", "tcp", 692);
        builder2.add("hyperwave-isp", "udp", 692);
        builder2.add("connendp", "tcp", 693);
        builder2.add("connendp", "udp", 693);
        builder2.add("ha-cluster", "tcp", 694);
        builder2.add("ha-cluster", "udp", 694);
        builder2.add("ieee-mms-ssl", "tcp", 695);
        builder2.add("ieee-mms-ssl", "udp", 695);
        builder2.add("rushd", "tcp", 696);
        builder2.add("rushd", "udp", 696);
        builder2.add("uuidgen", "tcp", 697);
        builder2.add("uuidgen", "udp", 697);
        builder2.add("olsr", "tcp", 698);
        builder2.add("olsr", "udp", 698);
        builder2.add("accessnetwork", "tcp", 699);
        builder2.add("accessnetwork", "udp", 699);
        builder2.add("epp", "tcp", 700);
        builder2.add("epp", "udp", 700);
        builder2.add("lmp", "tcp", 701);
        builder2.add("lmp", "udp", 701);
        builder2.add("iris-beep", "tcp", 702);
        builder2.add("iris-beep", "udp", 702);
        builder2.add("elcsd", "tcp", 704);
        builder2.add("elcsd", "udp", 704);
        builder2.add("agentx", "tcp", 705);
        builder2.add("agentx", "udp", 705);
        builder2.add("silc", "tcp", 706);
        builder2.add("silc", "udp", 706);
        builder2.add("borland-dsj", "tcp", 707);
        builder2.add("borland-dsj", "udp", 707);
        builder2.add("entrust-kmsh", "tcp", 709);
        builder2.add("entrust-kmsh", "udp", 709);
        builder2.add("entrust-ash", "tcp", 710);
        builder2.add("entrust-ash", "udp", 710);
        builder2.add("cisco-tdp", "tcp", 711);
        builder2.add("cisco-tdp", "udp", 711);
        builder2.add("tbrpf", "tcp", 712);
        builder2.add("tbrpf", "udp", 712);
        builder2.add("iris-xpc", "tcp", 713);
        builder2.add("iris-xpc", "udp", 713);
        builder2.add("iris-xpcs", "tcp", 714);
        builder2.add("iris-xpcs", "udp", 714);
        builder2.add("iris-lwz", "tcp", 715);
        builder2.add("iris-lwz", "udp", 715);
        builder2.add("pana", "udp", 716);
        builder2.add("netviewdm1", "tcp", 729);
        builder2.add("netviewdm1", "udp", 729);
        builder2.add("netviewdm2", "tcp", 730);
        builder2.add("netviewdm2", "udp", 730);
        builder2.add("netviewdm3", "tcp", 731);
        builder2.add("netviewdm3", "udp", 731);
        builder2.add("netgw", "tcp", 741);
        builder2.add("netgw", "udp", 741);
        builder2.add("netrcs", "tcp", 742);
        builder2.add("netrcs", "udp", 742);
        builder2.add("flexlm", "tcp", 744);
        builder2.add("flexlm", "udp", 744);
        builder2.add("fujitsu-dev", "tcp", 747);
        builder2.add("fujitsu-dev", "udp", 747);
        builder2.add("ris-cm", "tcp", 748);
        builder2.add("ris-cm", "udp", 748);
        builder2.add("kerberos-adm", "tcp", 749);
        builder2.add("kerberos-adm", "udp", 749);
        builder2.add("rfile", "tcp", 750);
        builder2.add("loadav", "udp", 750);
        builder2.add("kerberos-iv", "udp", 750);
        builder2.add("pump", "tcp", 751);
        builder2.add("pump", "udp", 751);
        builder2.add("qrh", "tcp", 752);
        builder2.add("qrh", "udp", 752);
        builder2.add("rrh", "tcp", 753);
        builder2.add("rrh", "udp", 753);
        builder2.add("tell", "tcp", 754);
        builder2.add("tell", "udp", 754);
        builder2.add("nlogin", "tcp", 758);
        builder2.add("nlogin", "udp", 758);
        builder2.add("con", "tcp", 759);
        builder2.add("con", "udp", 759);
        builder2.add("ns", "tcp", 760);
        builder2.add("ns", "udp", 760);
        builder2.add("rxe", "tcp", 761);
        builder2.add("rxe", "udp", 761);
        builder2.add("quotad", "tcp", 762);
        builder2.add("quotad", "udp", 762);
        builder2.add("cycleserv", "tcp", 763);
        builder2.add("cycleserv", "udp", 763);
        builder2.add("omserv", "tcp", 764);
        builder2.add("omserv", "udp", 764);
        builder2.add("webster", "tcp", 765);
        builder2.add("webster", "udp", 765);
        builder2.add("phonebook", "tcp", 767);
        builder2.add("phonebook", "udp", 767);
        builder2.add("vid", "tcp", 769);
        builder2.add("vid", "udp", 769);
        builder2.add("cadlock", "tcp", 770);
        builder2.add("cadlock", "udp", 770);
        builder2.add("rtip", "tcp", 771);
        builder2.add("rtip", "udp", 771);
        builder2.add("cycleserv2", "tcp", 772);
        builder2.add("cycleserv2", "udp", 772);
        builder2.add("submit", "tcp", 773);
        builder2.add("notify", "udp", 773);
        builder2.add("rpasswd", "tcp", 774);
        builder2.add("acmaint_dbd", "udp", 774);
        builder2.add("entomb", "tcp", 775);
        builder2.add("acmaint_transd", "udp", 775);
        builder2.add("wpages", "tcp", 776);
        builder2.add("wpages", "udp", 776);
        builder2.add("multiling-http", "tcp", 777);
        builder2.add("multiling-http", "udp", 777);
        builder2.add("wpgs", "tcp", 780);
        builder2.add("wpgs", "udp", 780);
        builder2.add("mdbs_daemon", "tcp", 800);
        builder2.add("mdbs_daemon", "udp", 800);
        builder2.add("device", "tcp", 801);
        builder2.add("device", "udp", 801);
        builder2.add("fcp-udp", "tcp", 810);
        builder2.add("fcp-udp", "udp", 810);
        builder2.add("itm-mcell-s", "tcp", 828);
        builder2.add("itm-mcell-s", "udp", 828);
        builder2.add("pkix-3-ca-ra", "tcp", 829);
        builder2.add("pkix-3-ca-ra", "udp", 829);
        builder2.add("netconf-ssh", "tcp", 830);
        builder2.add("netconf-ssh", "udp", 830);
        builder2.add("netconf-beep", "tcp", 831);
        builder2.add("netconf-beep", "udp", 831);
        builder2.add("netconfsoaphttp", "tcp", 832);
        builder2.add("netconfsoaphttp", "udp", 832);
        builder2.add("netconfsoapbeep", "tcp", 833);
        builder2.add("netconfsoapbeep", "udp", 833);
        builder2.add("dhcp-failover2", "tcp", 847);
        builder2.add("dhcp-failover2", "udp", 847);
        builder2.add("gdoi", "tcp", 848);
        builder2.add("gdoi", "udp", 848);
        builder2.add("iscsi", "tcp", 860);
        builder2.add("iscsi", "udp", 860);
        builder2.add("owamp-control", "tcp", 861);
        builder2.add("owamp-control", "udp", 861);
        builder2.add("rsync", "tcp", 873);
        builder2.add("rsync", "udp", 873);
        builder2.add("iclcnet-locate", "tcp", 886);
        builder2.add("iclcnet-locate", "udp", 886);
        builder2.add("iclcnet_svinfo", "tcp", 887);
        builder2.add("iclcnet_svinfo", "udp", 887);
        builder2.add("accessbuilder", "tcp", 888);
        builder2.add("accessbuilder", "udp", 888);
        builder2.add("cddbp", "tcp", 888);
        builder2.add("omginitialrefs", "tcp", 900);
        builder2.add("omginitialrefs", "udp", 900);
        builder2.add("smpnameres", "tcp", 901);
        builder2.add("smpnameres", "udp", 901);
        builder2.add("ideafarm-door", "tcp", 902);
        builder2.add("ideafarm-door", "udp", 902);
        builder2.add("ideafarm-panic", "tcp", 903);
        builder2.add("ideafarm-panic", "udp", 903);
        builder2.add("kink", "tcp", 910);
        builder2.add("kink", "udp", 910);
        builder2.add("xact-backup", "tcp", 911);
        builder2.add("xact-backup", "udp", 911);
        builder2.add("apex-mesh", "tcp", 912);
        builder2.add("apex-mesh", "udp", 912);
        builder2.add("apex-edge", "tcp", 913);
        builder2.add("apex-edge", "udp", 913);
        builder2.add("ftps-data", "tcp", 989);
        builder2.add("ftps-data", "udp", 989);
        builder2.add("ftps", "tcp", 990);
        builder2.add("ftps", "udp", 990);
        builder2.add("nas", "tcp", 991);
        builder2.add("nas", "udp", 991);
        builder2.add("telnets", "tcp", 992);
        builder2.add("telnets", "udp", 992);
        builder2.add("imaps", "tcp", 993);
        builder2.add("imaps", "udp", 993);
        builder2.add("ircs", "tcp", 994);
        builder2.add("ircs", "udp", 994);
        builder2.add("pop3s", "tcp", 995);
        builder2.add("pop3s", "udp", 995);
        builder2.add("vsinet", "tcp", 996);
        builder2.add("vsinet", "udp", 996);
        builder2.add("maitrd", "tcp", 997);
        builder2.add("maitrd", "udp", 997);
        builder2.add("busboy", "tcp", 998);
        builder2.add("puparp", "udp", 998);
        builder2.add("garcon", "tcp", 999);
        builder2.add("applix", "udp", 999);
        builder2.add("puprouter", "tcp", 999);
        builder2.add("puprouter", "udp", 999);
        builder2.add("cadlock2", "tcp", 1000);
        builder2.add("cadlock2", "udp", 1000);
        builder2.add("surf", "tcp", 1010);
        builder2.add("surf", "udp", 1010);
        builder2.add("exp1", "tcp", 1021);
        builder2.add("exp1", "udp", 1021);
        builder2.add("exp2", "tcp", 1022);
        builder2.add("exp2", "udp", 1022);
        return builder2.build();
    }

    static /* synthetic */ IANAServicesDB access$000() {
        return IANAServicesDB.buildServices();
    }

    private static final class ServicesBuilder {
        private static final List<String> emptyAliases = Collections.emptyList();
        final Map<String, Service> tcpNameToService = new HashMap<String, Service>();
        final Map<String, Service> udpNameToService = new HashMap<String, Service>();
        final Map<Integer, Service> tcpPortToService = new HashMap<Integer, Service>();
        final Map<Integer, Service> udpPortToService = new HashMap<Integer, Service>();

        private ServicesBuilder() {
        }

        public final void add(String service, int port) {
            String[] descr = service.split("/");
            this.add(descr[0], descr[1], port);
        }

        public final void add(String service, String proto, int port) {
            Service s = new Service(service, port, proto, emptyAliases);
            if ("tcp".equals(proto)) {
                this.tcpNameToService.put(service, s);
                this.tcpPortToService.put(port, s);
            } else if ("udp".equals(proto)) {
                this.udpNameToService.put(service, s);
                this.udpPortToService.put(port, s);
            }
        }

        IANAServicesDB build() {
            return new IANAServicesDB(this.tcpNameToService, this.udpNameToService, this.tcpPortToService, this.udpPortToService);
        }
    }

    private static final class SingletonHolder {
        public static final IANAServicesDB INSTANCE = IANAServicesDB.access$000();

        private SingletonHolder() {
        }
    }
}

