/*
 * Decompiled with CFR 0.152.
 */
package org.python.antlr.runtime;

import org.python.antlr.runtime.CharStream;
import org.python.antlr.runtime.CommonToken;
import org.python.antlr.runtime.IntStream;
import org.python.antlr.runtime.Token;
import org.python.antlr.runtime.TokenStream;
import org.python.antlr.runtime.tree.CommonTree;
import org.python.antlr.runtime.tree.Tree;
import org.python.antlr.runtime.tree.TreeAdaptor;
import org.python.antlr.runtime.tree.TreeNodeStream;

public class RecognitionException
extends Exception {
    public transient IntStream input;
    public int index;
    public Token token;
    public Object node;
    public int c;
    public int line;
    public int charPositionInLine;
    public boolean approximateLineInfo;

    public RecognitionException() {
    }

    public RecognitionException(IntStream input) {
        this.input = input;
        this.index = input.index();
        if (input instanceof TokenStream) {
            this.token = ((TokenStream)input).LT(1);
            this.line = this.token.getLine();
            this.charPositionInLine = this.token.getCharPositionInLine();
        }
        if (input instanceof TreeNodeStream) {
            this.extractInformationFromTreeNodeStream(input);
        } else if (input instanceof CharStream) {
            this.c = input.LA(1);
            this.line = ((CharStream)input).getLine();
            this.charPositionInLine = ((CharStream)input).getCharPositionInLine();
        } else {
            this.c = input.LA(1);
        }
    }

    protected void extractInformationFromTreeNodeStream(IntStream input) {
        TreeNodeStream nodes2 = (TreeNodeStream)input;
        this.node = nodes2.LT(1);
        TreeAdaptor adaptor = nodes2.getTreeAdaptor();
        Token payload = adaptor.getToken(this.node);
        if (payload != null) {
            this.token = payload;
            if (payload.getLine() <= 0) {
                int i = -1;
                Object priorNode = nodes2.LT(i);
                while (priorNode != null) {
                    Token priorPayload = adaptor.getToken(priorNode);
                    if (priorPayload != null && priorPayload.getLine() > 0) {
                        this.line = priorPayload.getLine();
                        this.charPositionInLine = priorPayload.getCharPositionInLine();
                        this.approximateLineInfo = true;
                        break;
                    }
                    priorNode = nodes2.LT(--i);
                }
            } else {
                this.line = payload.getLine();
                this.charPositionInLine = payload.getCharPositionInLine();
            }
        } else if (this.node instanceof Tree) {
            this.line = ((Tree)this.node).getLine();
            this.charPositionInLine = ((Tree)this.node).getCharPositionInLine();
            if (this.node instanceof CommonTree) {
                this.token = ((CommonTree)this.node).token;
            }
        } else {
            int type = adaptor.getType(this.node);
            String text2 = adaptor.getText(this.node);
            this.token = new CommonToken(type, text2);
        }
    }

    public int getUnexpectedType() {
        if (this.input instanceof TokenStream) {
            return this.token.getType();
        }
        if (this.input instanceof TreeNodeStream) {
            TreeNodeStream nodes2 = (TreeNodeStream)this.input;
            TreeAdaptor adaptor = nodes2.getTreeAdaptor();
            return adaptor.getType(this.node);
        }
        return this.c;
    }
}

