/*
 * Decompiled with CFR 0.152.
 */
package org.python.bouncycastle.cms;

import java.util.ArrayList;
import java.util.List;
import org.python.bouncycastle.asn1.cms.OriginatorInfo;
import org.python.bouncycastle.cert.X509CertificateHolder;
import org.python.bouncycastle.cms.CMSException;
import org.python.bouncycastle.cms.CMSUtils;
import org.python.bouncycastle.cms.OriginatorInformation;
import org.python.bouncycastle.util.Store;

public class OriginatorInfoGenerator {
    private final List origCerts;
    private final List origCRLs;

    public OriginatorInfoGenerator(X509CertificateHolder x509CertificateHolder) {
        this.origCerts = new ArrayList(1);
        this.origCRLs = null;
        this.origCerts.add(x509CertificateHolder.toASN1Structure());
    }

    public OriginatorInfoGenerator(Store store2) throws CMSException {
        this(store2, null);
    }

    public OriginatorInfoGenerator(Store store2, Store store3) throws CMSException {
        this.origCerts = CMSUtils.getCertificatesFromStore(store2);
        this.origCRLs = store3 != null ? CMSUtils.getCRLsFromStore(store3) : null;
    }

    public OriginatorInformation generate() {
        if (this.origCRLs != null) {
            return new OriginatorInformation(new OriginatorInfo(CMSUtils.createDerSetFromList(this.origCerts), CMSUtils.createDerSetFromList(this.origCRLs)));
        }
        return new OriginatorInformation(new OriginatorInfo(CMSUtils.createDerSetFromList(this.origCerts), null));
    }
}

