/*
 * Decompiled with CFR 0.152.
 */
package org.python.icu.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import org.python.icu.impl.ICUCache;
import org.python.icu.impl.ICUResourceBundle;
import org.python.icu.impl.SimpleCache;
import org.python.icu.impl.SimplePatternFormatter;
import org.python.icu.util.ULocale;
import org.python.icu.util.UResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ListFormatter {
    private final SimplePatternFormatter two;
    private final SimplePatternFormatter start;
    private final SimplePatternFormatter middle;
    private final SimplePatternFormatter end;
    private final ULocale locale;
    static Map<ULocale, ListFormatter> localeToData = new HashMap<ULocale, ListFormatter>();
    static Cache cache = new Cache();

    @Deprecated
    public ListFormatter(String two, String start, String middle, String end) {
        this(SimplePatternFormatter.compile(two), SimplePatternFormatter.compile(start), SimplePatternFormatter.compile(middle), SimplePatternFormatter.compile(end), null);
    }

    private ListFormatter(SimplePatternFormatter two, SimplePatternFormatter start, SimplePatternFormatter middle, SimplePatternFormatter end, ULocale locale2) {
        this.two = two;
        this.start = start;
        this.middle = middle;
        this.end = end;
        this.locale = locale2;
    }

    public static ListFormatter getInstance(ULocale locale2) {
        return ListFormatter.getInstance(locale2, Style.STANDARD);
    }

    public static ListFormatter getInstance(Locale locale2) {
        return ListFormatter.getInstance(ULocale.forLocale(locale2), Style.STANDARD);
    }

    @Deprecated
    public static ListFormatter getInstance(ULocale locale2, Style style) {
        return cache.get(locale2, style.getName());
    }

    public static ListFormatter getInstance() {
        return ListFormatter.getInstance(ULocale.getDefault(ULocale.Category.FORMAT));
    }

    public String format(Object ... items) {
        return this.format(Arrays.asList(items));
    }

    public String format(Collection<?> items) {
        return this.format(items, -1).toString();
    }

    FormattedListBuilder format(Collection<?> items, int index) {
        Iterator<?> it = items.iterator();
        int count2 = items.size();
        switch (count2) {
            case 0: {
                return new FormattedListBuilder("", false);
            }
            case 1: {
                return new FormattedListBuilder(it.next(), index == 0);
            }
            case 2: {
                return new FormattedListBuilder(it.next(), index == 0).append(this.two, it.next(), index == 1);
            }
        }
        FormattedListBuilder builder2 = new FormattedListBuilder(it.next(), index == 0);
        builder2.append(this.start, it.next(), index == 1);
        for (int idx = 2; idx < count2 - 1; ++idx) {
            builder2.append(this.middle, it.next(), index == idx);
        }
        return builder2.append(this.end, it.next(), index == count2 - 1);
    }

    public String getPatternForNumItems(int count2) {
        if (count2 <= 0) {
            throw new IllegalArgumentException("count must be > 0");
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < count2; ++i) {
            list.add(String.format("{%d}", i));
        }
        return this.format(list);
    }

    @Deprecated
    public ULocale getLocale() {
        return this.locale;
    }

    static void add(String locale2, String ... data) {
        localeToData.put(new ULocale(locale2), new ListFormatter(data[0], data[1], data[2], data[3]));
    }

    private static class Cache {
        private final ICUCache<String, ListFormatter> cache = new SimpleCache<String, ListFormatter>();

        private Cache() {
        }

        public ListFormatter get(ULocale locale2, String style) {
            String key = String.format("%s:%s", locale2.toString(), style);
            ListFormatter result2 = this.cache.get(key);
            if (result2 == null) {
                result2 = Cache.load(locale2, style);
                this.cache.put(key, result2);
            }
            return result2;
        }

        private static ListFormatter load(ULocale ulocale, String style) {
            ICUResourceBundle r = (ICUResourceBundle)UResourceBundle.getBundleInstance("org/python/icu/impl/data/icudt54b", ulocale);
            try {
                return new ListFormatter(SimplePatternFormatter.compile(r.getWithFallback("listPattern/" + style + "/2").getString()), SimplePatternFormatter.compile(r.getWithFallback("listPattern/" + style + "/start").getString()), SimplePatternFormatter.compile(r.getWithFallback("listPattern/" + style + "/middle").getString()), SimplePatternFormatter.compile(r.getWithFallback("listPattern/" + style + "/end").getString()), ulocale);
            }
            catch (MissingResourceException e) {
                return new ListFormatter(SimplePatternFormatter.compile(r.getWithFallback("listPattern/standard/2").getString()), SimplePatternFormatter.compile(r.getWithFallback("listPattern/standard/start").getString()), SimplePatternFormatter.compile(r.getWithFallback("listPattern/standard/middle").getString()), SimplePatternFormatter.compile(r.getWithFallback("listPattern/standard/end").getString()), ulocale);
            }
        }
    }

    static class FormattedListBuilder {
        private StringBuilder current;
        private int offset;

        public FormattedListBuilder(Object start, boolean recordOffset) {
            this.current = new StringBuilder(start.toString());
            this.offset = recordOffset ? 0 : -1;
        }

        public FormattedListBuilder append(SimplePatternFormatter pattern, Object next, boolean recordOffset) {
            if (pattern.getPlaceholderCount() != 2) {
                throw new IllegalArgumentException("Need {0} and {1} only in pattern " + pattern);
            }
            int[] offsets = (int[])(recordOffset || this.offsetRecorded() ? new int[2] : null);
            StringBuilder nextBuilder = pattern.startsWithPlaceholder(0) ? this.current : new StringBuilder();
            this.current = pattern.format(nextBuilder, offsets, this.current, next.toString());
            if (offsets != null) {
                if (offsets[0] == -1 || offsets[1] == -1) {
                    throw new IllegalArgumentException("{0} or {1} missing from pattern " + pattern);
                }
                this.offset = recordOffset ? offsets[1] : (this.offset += offsets[0]);
            }
            return this;
        }

        public String toString() {
            return this.current.toString();
        }

        public int getOffset() {
            return this.offset;
        }

        private boolean offsetRecorded() {
            return this.offset >= 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Deprecated
    public static enum Style {
        STANDARD("standard"),
        DURATION("unit"),
        DURATION_SHORT("unit-short"),
        DURATION_NARROW("unit-narrow");

        private final String name;

        private Style(String name) {
            this.name = name;
        }

        @Deprecated
        public String getName() {
            return this.name;
        }
    }
}

