/*
 * Decompiled with CFR 0.152.
 */
package org.python.util;

import java.util.concurrent.CountDownLatch;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.python.core.Console;
import org.python.core.PlainConsole;
import org.python.core.Py;
import org.python.core.PyDictionary;
import org.python.core.PyInteger;
import org.python.core.PyObject;
import org.python.core.PyUnicode;
import org.python.util.PythonInterpreter;

public class InterpreterTest
extends TestCase {
    public void testBasicEval() throws Exception {
        PyDictionary test2 = new PyDictionary();
        test2.__setitem__(new PyUnicode("one"), (PyObject)new PyUnicode("two"));
        PythonInterpreter.initialize(System.getProperties(), null, new String[0]);
        PythonInterpreter interp = new PythonInterpreter();
        PyObject pyo = interp.eval("{u'one': u'two'}");
        InterpreterTest.assertEquals((Object)test2, (Object)pyo);
    }

    public void testMultipleThreads() {
        final CountDownLatch doneSignal = new CountDownLatch(10);
        for (int i = 0; i < 10; ++i) {
            new Thread(){

                @Override
                public void run() {
                    PythonInterpreter interp = new PythonInterpreter();
                    interp.exec("import sys");
                    interp.set("a", new PyInteger(41));
                    int set = Py.tojava(interp.get("a"), Integer.class);
                    Assert.assertEquals((int)41, (int)set);
                    interp.exec("x = 'hello ' + 'goodbye'");
                    Assert.assertEquals((String)"hello goodbye", (String)Py.tojava(interp.get("x"), String.class));
                    doneSignal.countDown();
                }
            }.start();
        }
        try {
            doneSignal.await();
        }
        catch (InterruptedException e) {
            System.err.println("Interpreters in multiple threads test interrupted, bailing");
        }
    }

    public void testCallInstancesFromJava() {
        PythonInterpreter interp = new PythonInterpreter();
        interp.exec("class Blah(object):\n    def __init__(self, val):\n        self.val = val\n    def incval(self):\n        self.val += 1\n        return self.val");
        PyObject blahClass = interp.get("Blah");
        int base2 = 42;
        PyObject blahInstance = blahClass.__call__(new PyInteger(base2));
        for (int i = 0; i < 4; ++i) {
            InterpreterTest.assertEquals((Object)(++base2), (Object)blahInstance.invoke("incval").__tojava__(Integer.class));
        }
    }

    public void testConsoleIsPlain() throws Exception {
        PythonInterpreter interp = new PythonInterpreter();
        interp.exec("import sys");
        Console console2 = Py.tojava(interp.eval("sys._jy_console"), Console.class);
        InterpreterTest.assertEquals(PlainConsole.class, console2.getClass());
        Console console22 = Py.getConsole();
        InterpreterTest.assertEquals(PlainConsole.class, console22.getClass());
    }
}

