/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.Callable;
import org.python.core.ArgParser;
import org.python.core.BufferProtocol;
import org.python.core.Py;
import org.python.core.PyArray;
import org.python.core.PyBuffer;
import org.python.core.PyFile$PyExposer;
import org.python.core.PyJavaType;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PySystemState;
import org.python.core.PyType;
import org.python.core.PyUnicode;
import org.python.core.Traverseproc;
import org.python.core.Visitproc;
import org.python.core.finalization.FinalizableBuiltin;
import org.python.core.finalization.FinalizeTrigger;
import org.python.core.io.BinaryIOWrapper;
import org.python.core.io.BufferedIOBase;
import org.python.core.io.BufferedIOMixin;
import org.python.core.io.BufferedRandom;
import org.python.core.io.BufferedReader;
import org.python.core.io.BufferedWriter;
import org.python.core.io.FileIO;
import org.python.core.io.LineBufferedRandom;
import org.python.core.io.LineBufferedWriter;
import org.python.core.io.RawIOBase;
import org.python.core.io.StreamIO;
import org.python.core.io.TextIOBase;
import org.python.core.io.TextIOWrapper;
import org.python.core.io.UniversalIOWrapper;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;

@ExposedType(name="file", doc="file(name[, mode[, buffering]]) -> file object\n\nOpen a file.  The mode can be 'r', 'w' or 'a' for reading (default),\nwriting or appending.  The file will be created if it doesn't exist\nwhen opened for writing or appending; it will be truncated when\nopened for writing.  Add a 'b' to the mode for binary files.\nAdd a '+' to the mode to allow simultaneous reading and writing.\nIf the buffering argument is given, 0 means unbuffered, 1 means line\nbuffered, and larger numbers specify the buffer size.  The preferred way\nto open a file is with the builtin open() function.\nAdd a 'U' to mode to open the file for input with universal newline\nsupport.  Any line ending in the input file will be seen as a '\\n'\nin Python.  Also, a file so opened gains the attribute 'newlines';\nthe value for this attribute is one of None (no newline read yet),\n'\\r', '\\n', '\\r\\n' or a tuple containing all the newline types seen.\n\n'U' cannot be combined with 'w' or '+' mode.\n")
public class PyFile
extends PyObject
implements FinalizableBuiltin,
Traverseproc {
    public static final PyType TYPE;
    public PyObject name;
    public String mode;
    public String encoding;
    public String errors;
    public boolean softspace = false;
    private boolean reading = false;
    private boolean writing = false;
    private boolean appending = false;
    private boolean updating = false;
    private boolean binary = false;
    private boolean universal = false;
    private TextIOBase file;
    private Closer closer;

    public PyFile() {
        FinalizeTrigger.ensureFinalizer(this);
    }

    public PyFile(PyType subType) {
        super(subType);
        FinalizeTrigger.ensureFinalizer(this);
    }

    public PyFile(RawIOBase raw, String name, String mode, int bufsize) {
        this.parseMode(mode);
        this.file___init__(raw, name, mode, bufsize);
        FinalizeTrigger.ensureFinalizer(this);
    }

    public PyFile(InputStream istream, String name, String mode, int bufsize, boolean closefd) {
        this.parseMode(mode);
        this.file___init__((RawIOBase)new StreamIO(istream, closefd), name, mode, bufsize);
        FinalizeTrigger.ensureFinalizer(this);
    }

    public PyFile(InputStream istream, String mode, int bufsize) {
        this(istream, "<Java InputStream '" + istream + "' as file>", mode, bufsize, true);
    }

    public PyFile(InputStream istream, String mode) {
        this(istream, mode, -1);
    }

    public PyFile(InputStream istream, int bufsize) {
        this(istream, "r", bufsize);
    }

    public PyFile(InputStream istream) {
        this(istream, -1);
    }

    public PyFile(OutputStream ostream, String name, String mode, int bufsize, boolean closefd) {
        this.parseMode(mode);
        this.file___init__((RawIOBase)new StreamIO(ostream, closefd), name, mode, bufsize);
        FinalizeTrigger.ensureFinalizer(this);
    }

    public PyFile(OutputStream ostream, String mode, int bufsize) {
        this(ostream, "<Java OutputStream '" + ostream + "' as file>", mode, bufsize, true);
    }

    public PyFile(OutputStream ostream, int bufsize) {
        this(ostream, "w", bufsize);
    }

    public PyFile(OutputStream ostream) {
        this(ostream, -1);
    }

    public PyFile(String name, String mode, int bufsize) {
        this.file___init__((RawIOBase)new FileIO(name, this.parseMode(mode)), name, mode, bufsize);
        FinalizeTrigger.ensureFinalizer(this);
    }

    @ExposedNew
    final void file___init__(PyObject[] args, String[] kwds) {
        ArgParser ap = new ArgParser("file", args, kwds, new String[]{"name", "mode", "buffering"}, 1);
        PyObject name = ap.getPyObject(0);
        if (!(name instanceof PyString)) {
            throw Py.TypeError("coercing to Unicode: need string, '" + name.getType().fastGetName() + "' type found");
        }
        String mode = ap.getString(1, "r");
        int bufsize = ap.getInt(2, -1);
        this.file___init__((RawIOBase)new FileIO((PyString)name, this.parseMode(mode)), name, mode, bufsize);
        this.closer = new Closer(this.file, Py.getSystemState());
    }

    private void file___init__(RawIOBase raw, String name, String mode, int bufsize) {
        this.file___init__(raw, new PyString(name), mode, bufsize);
    }

    private void file___init__(RawIOBase raw, PyObject name, String mode, int bufsize) {
        this.name = name;
        this.mode = mode;
        BufferedIOBase buffer = this.createBuffer(raw, bufsize);
        this.file = this.universal ? new UniversalIOWrapper(buffer) : (!this.binary ? new TextIOWrapper(buffer) : new BinaryIOWrapper(buffer));
    }

    void setEncoding(String encoding2, String errors2) {
        this.encoding = encoding2;
        this.errors = errors2;
    }

    private BufferedIOBase createBuffer(RawIOBase raw, int bufsize) {
        BufferedIOMixin buffer;
        boolean lineBuffered;
        if (bufsize < 0) {
            bufsize = 8192;
        }
        boolean bl = lineBuffered = bufsize == 1;
        if (this.updating) {
            buffer = lineBuffered ? new LineBufferedRandom(raw) : new BufferedRandom(raw, bufsize);
        } else if (this.writing || this.appending) {
            buffer = lineBuffered ? new LineBufferedWriter(raw) : new BufferedWriter(raw, bufsize);
        } else if (this.reading) {
            buffer = new BufferedReader(raw, lineBuffered ? 8192 : bufsize);
        } else {
            throw Py.ValueError("unknown mode: '" + this.mode + "'");
        }
        return buffer;
    }

    private String parseMode(String mode) {
        String message2 = null;
        boolean duplicate = false;
        boolean invalid = false;
        boolean text_intent = false;
        int n = mode.length();
        for (int i = 0; i < n; ++i) {
            char c = mode.charAt(i);
            switch (c) {
                case 'r': {
                    duplicate = this.reading;
                    this.reading = true;
                    break;
                }
                case 'w': {
                    duplicate = this.writing;
                    this.writing = true;
                    break;
                }
                case 'a': {
                    duplicate = this.appending;
                    this.appending = true;
                    break;
                }
                case '+': {
                    duplicate = this.updating;
                    this.updating = true;
                    break;
                }
                case 'b': {
                    duplicate = this.binary;
                    this.binary = true;
                    break;
                }
                case 't': {
                    duplicate = text_intent;
                    text_intent = true;
                    this.binary = false;
                    break;
                }
                case 'U': {
                    duplicate = this.universal;
                    this.universal = true;
                    break;
                }
                default: {
                    invalid = true;
                }
            }
            if (!duplicate) continue;
            invalid = true;
            break;
        }
        this.reading |= this.universal;
        this.binary |= this.universal;
        StringBuilder fileioMode = new StringBuilder();
        if (!invalid) {
            if (this.universal && (this.writing || this.appending)) {
                message2 = "universal newline mode can only be used with modes starting with 'r'";
            } else {
                if (this.reading) {
                    fileioMode.append('r');
                }
                if (this.writing) {
                    fileioMode.append('w');
                }
                if (this.appending) {
                    fileioMode.append('a');
                }
                if (fileioMode.length() != 1) {
                    message2 = "mode string must begin with one of 'r', 'w', 'a' or 'U', not '" + mode + "'";
                }
                if (this.updating) {
                    fileioMode.append('+');
                }
            }
            invalid |= message2 != null;
        }
        if (invalid) {
            if (message2 == null) {
                message2 = String.format("invalid mode: '%.20s'", mode);
            }
            throw Py.ValueError(message2);
        }
        return fileioMode.toString();
    }

    final synchronized PyString file_read(int size) {
        this.checkClosed();
        return new PyString(this.file.read(size));
    }

    public PyString read(int size) {
        return this.file_read(size);
    }

    public PyString read() {
        return this.file_read(-1);
    }

    final synchronized int file_readinto(PyObject buf) {
        this.checkClosed();
        return this.file.readinto(buf);
    }

    public int readinto(PyObject buf) {
        return this.file_readinto(buf);
    }

    final synchronized PyString file_readline(int max) {
        this.checkClosed();
        return new PyString(this.file.readline(max));
    }

    public PyString readline(int max) {
        return this.file_readline(max);
    }

    public PyString readline() {
        return this.file_readline(-1);
    }

    final synchronized PyObject file_readlines(int sizehint) {
        String line;
        int len;
        this.checkClosed();
        PyList list = new PyList();
        int count2 = 0;
        while ((len = (line = this.file.readline(-1)).length()) != 0) {
            list.append(new PyString(line));
            if (sizehint <= 0 || (count2 += len) < sizehint) continue;
        }
        return list;
    }

    public PyObject readlines(int sizehint) {
        return this.file_readlines(sizehint);
    }

    public PyObject readlines() {
        return this.file_readlines(0);
    }

    @Override
    public PyObject __iternext__() {
        return this.file___iternext__();
    }

    final synchronized PyObject file___iternext__() {
        this.checkClosed();
        String next = this.file.readline(-1);
        if (next.length() == 0) {
            return null;
        }
        return new PyString(next);
    }

    final PyObject file_next() {
        PyObject ret = this.file___iternext__();
        if (ret == null) {
            throw Py.StopIteration("");
        }
        return ret;
    }

    public PyObject next() {
        return this.file_next();
    }

    final PyObject file_self() {
        this.checkClosed();
        return this;
    }

    public PyObject __enter__() {
        return this.file_self();
    }

    @Override
    public PyObject __iter__() {
        return this.file_self();
    }

    public PyObject xreadlines() {
        return this.file_self();
    }

    final void file_write(PyObject obj) {
        this.file_write(this.asWritable(obj, null));
    }

    final synchronized void file_write(String string2) {
        this.checkClosed();
        this.softspace = false;
        this.file.write(string2);
    }

    public void write(String string2) {
        this.file_write(string2);
    }

    final synchronized void file_writelines(PyObject lines) {
        this.checkClosed();
        PyObject iter = Py.iter(lines, "writelines() requires an iterable argument");
        PyObject item = null;
        while ((item = iter.__iternext__()) != null) {
            this.checkClosed();
            this.softspace = false;
            this.file.write(this.asWritable(item, "writelines() argument must be a sequence of strings"));
        }
    }

    public void writelines(PyObject lines) {
        this.file_writelines(lines);
    }

    private String asWritable(PyObject obj, String message2) {
        if (obj instanceof PyUnicode) {
            return ((PyUnicode)obj).encode(this.encoding, this.errors);
        }
        if (obj instanceof PyString) {
            return ((PyString)obj).getString();
        }
        if ((!(obj instanceof PyArray) || this.binary) && obj instanceof BufferProtocol) {
            try (PyBuffer buf = ((BufferProtocol)((Object)obj)).getBuffer(284);){
                String string2 = buf.toString();
                return string2;
            }
        }
        if (message2 == null) {
            String.format("%s buffer, not %.200s", this.binary ? "must be string or" : "expected a character", obj.getType().fastGetName());
        }
        throw Py.TypeError(message2);
    }

    final synchronized long file_tell() {
        this.checkClosed();
        return this.file.tell();
    }

    public long tell() {
        return this.file_tell();
    }

    final synchronized void file_seek(long pos, int how) {
        this.checkClosed();
        this.file.seek(pos, how);
    }

    public void seek(long pos, int how) {
        this.file_seek(pos, how);
    }

    public void seek(long pos) {
        this.file_seek(pos, 0);
    }

    final synchronized void file_flush() {
        this.checkClosed();
        this.file.flush();
    }

    public void flush() {
        this.file_flush();
    }

    final synchronized void file_close() {
        if (this.closer != null) {
            this.closer.close();
            this.closer = null;
        } else {
            this.file.close();
        }
    }

    public void close() {
        this.file_close();
    }

    final void file___exit__(PyObject type, PyObject value, PyObject traceback2) {
        this.close();
    }

    public void __exit__(PyObject type, PyObject value, PyObject traceback2) {
        this.file___exit__(type, value, traceback2);
    }

    final void file_truncate(PyObject position) {
        if (position == null) {
            this.file_truncate();
            return;
        }
        this.file_truncate(position.asLong());
    }

    final synchronized void file_truncate(long position) {
        this.file.truncate(position);
    }

    public void truncate(long position) {
        this.file_truncate(position);
    }

    final synchronized void file_truncate() {
        this.file.truncate(this.file.tell());
    }

    public void truncate() {
        this.file_truncate();
    }

    public boolean isatty() {
        return this.file_isatty();
    }

    final boolean file_isatty() {
        return this.file.isatty();
    }

    public PyObject fileno() {
        return this.file_fileno();
    }

    final PyObject file_fileno() {
        return PyJavaType.wrapJavaObject(this.file.fileno());
    }

    final String file_toString() {
        String state = this.file.closed() ? "closed" : "open";
        String id = Py.idstr(this);
        String escapedName = this.name instanceof PyUnicode ? "u'" + PyString.encode_UnicodeEscape(this.name.toString(), false) + "'" : this.name.__repr__().getString();
        return String.format("<%s file %s, mode '%s' at %s>", state, escapedName, this.mode, id);
    }

    @Override
    public String toString() {
        return this.file_toString();
    }

    private void checkClosed() {
        this.file.checkClosed();
    }

    public boolean getClosed() {
        return this.file.closed();
    }

    public PyObject getNewlines() {
        return this.file.getNewlines();
    }

    public PyObject getSoftspace() {
        return this.softspace ? Py.One : Py.Zero;
    }

    public void setSoftspace(PyObject obj) {
        this.softspace = obj.__nonzero__();
    }

    public void delSoftspace() {
        throw Py.TypeError("can't delete numeric/char attribute");
    }

    @Override
    public Object __tojava__(Class<?> cls) {
        Object obj = null;
        if (InputStream.class.isAssignableFrom(cls)) {
            obj = this.file.asInputStream();
        } else if (OutputStream.class.isAssignableFrom(cls)) {
            obj = this.file.asOutputStream();
        }
        if (obj == null) {
            obj = super.__tojava__(cls);
        }
        return obj;
    }

    @Override
    public void __del_builtin__() {
        if (this.closer != null) {
            this.closer.close();
        }
    }

    @Override
    public int traverse(Visitproc visit, Object arg) {
        return this.name == null ? 0 : visit.visit(this.name, arg);
    }

    @Override
    public boolean refersDirectlyTo(PyObject ob) {
        return ob != null && ob == this.name;
    }

    static {
        PyType.addBuilder(PyFile.class, new PyFile$PyExposer());
        TYPE = PyType.fromClass(PyFile.class);
    }

    private static class Closer
    implements Callable<Void> {
        private final TextIOBase file;
        private PySystemState sys;

        public Closer(TextIOBase file, PySystemState sys) {
            this.file = file;
            this.sys = sys;
            sys.registerCloser(this);
        }

        public void close() {
            this.sys.unregisterCloser(this);
            this.file.close();
            this.sys = null;
        }

        @Override
        public Void call() {
            this.file.close();
            this.sys = null;
            return null;
        }
    }
}

