/*
 * Decompiled with CFR 0.152.
 */
package org.python.netty.handler.ssl;

import java.io.File;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.python.apache.tomcat.jni.CertificateVerifier;
import org.python.apache.tomcat.jni.SSL;
import org.python.apache.tomcat.jni.SSLContext;
import org.python.netty.buffer.ByteBuf;
import org.python.netty.buffer.ByteBufInputStream;
import org.python.netty.handler.ssl.ApplicationProtocolConfig;
import org.python.netty.handler.ssl.OpenSsl;
import org.python.netty.handler.ssl.OpenSslApplicationProtocolNegotiator;
import org.python.netty.handler.ssl.OpenSslContext;
import org.python.netty.handler.ssl.OpenSslDefaultApplicationProtocolNegotiator;
import org.python.netty.handler.ssl.OpenSslServerSessionContext;
import org.python.netty.handler.ssl.PemReader;
import org.python.netty.util.internal.ObjectUtil;
import org.python.netty.util.internal.logging.InternalLogger;
import org.python.netty.util.internal.logging.InternalLoggerFactory;

public final class OpenSslServerContext
extends OpenSslContext {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(OpenSslServerContext.class);
    private final OpenSslServerSessionContext sessionContext;

    public OpenSslServerContext(File certChainFile, File keyFile) throws SSLException {
        this(certChainFile, keyFile, null);
    }

    public OpenSslServerContext(File certChainFile, File keyFile, String keyPassword) throws SSLException {
        this(certChainFile, keyFile, keyPassword, null, null, OpenSslDefaultApplicationProtocolNegotiator.INSTANCE, 0L, 0L);
    }

    public OpenSslServerContext(File certChainFile, File keyFile, String keyPassword, Iterable<String> ciphers, ApplicationProtocolConfig apn, long sessionCacheSize, long sessionTimeout) throws SSLException {
        this(certChainFile, keyFile, keyPassword, null, ciphers, OpenSslServerContext.toNegotiator(apn, false), sessionCacheSize, sessionTimeout);
    }

    @Deprecated
    public OpenSslServerContext(File certChainFile, File keyFile, String keyPassword, Iterable<String> ciphers, Iterable<String> nextProtocols, long sessionCacheSize, long sessionTimeout) throws SSLException {
        this(certChainFile, keyFile, keyPassword, ciphers, OpenSslServerContext.toApplicationProtocolConfig(nextProtocols), sessionCacheSize, sessionTimeout);
    }

    public OpenSslServerContext(File certChainFile, File keyFile, String keyPassword, TrustManagerFactory trustManagerFactory, Iterable<String> ciphers, ApplicationProtocolConfig config2, long sessionCacheSize, long sessionTimeout) throws SSLException {
        this(certChainFile, keyFile, keyPassword, trustManagerFactory, ciphers, OpenSslServerContext.toNegotiator(config2, true), sessionCacheSize, sessionTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenSslServerContext(File certChainFile, File keyFile, String keyPassword, TrustManagerFactory trustManagerFactory, Iterable<String> ciphers, OpenSslApplicationProtocolNegotiator apn, long sessionCacheSize, long sessionTimeout) throws SSLException {
        super(ciphers, apn, sessionCacheSize, sessionTimeout, 1);
        OpenSsl.ensureAvailability();
        ObjectUtil.checkNotNull(certChainFile, "certChainFile");
        if (!certChainFile.isFile()) {
            throw new IllegalArgumentException("certChainFile is not a file: " + certChainFile);
        }
        ObjectUtil.checkNotNull(keyFile, "keyFile");
        if (!keyFile.isFile()) {
            throw new IllegalArgumentException("keyPath is not a file: " + keyFile);
        }
        if (keyPassword == null) {
            keyPassword = "";
        }
        boolean success = false;
        try {
            Class<OpenSslContext> clazz = OpenSslContext.class;
            synchronized (OpenSslContext.class) {
                long error2;
                SSLContext.setVerify((long)this.ctx, (int)0, (int)10);
                if (!SSLContext.setCertificateChainFile((long)this.ctx, (String)certChainFile.getPath(), (boolean)true) && OpenSsl.isError(error2 = (long)SSL.getLastErrorNumber())) {
                    String err = SSL.getErrorString((long)error2);
                    throw new SSLException("failed to set certificate chain: " + certChainFile + " (" + err + ')');
                }
                try {
                    if (!SSLContext.setCertificate((long)this.ctx, (String)certChainFile.getPath(), (String)keyFile.getPath(), (String)keyPassword, (int)0) && OpenSsl.isError(error2 = (long)SSL.getLastErrorNumber())) {
                        String err = SSL.getErrorString((long)error2);
                        throw new SSLException("failed to set certificate: " + certChainFile + " and " + keyFile + " (" + err + ')');
                    }
                }
                catch (SSLException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new SSLException("failed to set certificate: " + certChainFile + " and " + keyFile, e);
                }
                try {
                    PrivateKey key;
                    KeyStore ks = KeyStore.getInstance("JKS");
                    ks.load(null, null);
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    KeyFactory rsaKF = KeyFactory.getInstance("RSA");
                    KeyFactory dsaKF = KeyFactory.getInstance("DSA");
                    ByteBuf encodedKeyBuf = PemReader.readPrivateKey(keyFile);
                    byte[] encodedKey = new byte[encodedKeyBuf.readableBytes()];
                    encodedKeyBuf.readBytes(encodedKey).release();
                    char[] keyPasswordChars = keyPassword.toCharArray();
                    PKCS8EncodedKeySpec encodedKeySpec = OpenSslServerContext.generateKeySpec(keyPasswordChars, encodedKey);
                    try {
                        key = rsaKF.generatePrivate(encodedKeySpec);
                    }
                    catch (InvalidKeySpecException ignore) {
                        key = dsaKF.generatePrivate(encodedKeySpec);
                    }
                    ArrayList<Certificate> certChain = new ArrayList<Certificate>();
                    ByteBuf[] certs = PemReader.readCertificates(certChainFile);
                    try {
                        for (ByteBuf buf : certs) {
                            certChain.add(cf.generateCertificate(new ByteBufInputStream(buf)));
                        }
                    }
                    finally {
                        for (ByteBuf buf : certs) {
                            buf.release();
                        }
                    }
                    ks.setKeyEntry("key", key, keyPasswordChars, certChain.toArray(new Certificate[certChain.size()]));
                    if (trustManagerFactory == null) {
                        trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                        trustManagerFactory.init((KeyStore)null);
                    } else {
                        trustManagerFactory.init(ks);
                    }
                    final X509TrustManager manager = OpenSslServerContext.chooseTrustManager(trustManagerFactory.getTrustManagers());
                    SSLContext.setCertVerifyCallback((long)this.ctx, (CertificateVerifier)new CertificateVerifier(){

                        public boolean verify(long ssl2, byte[][] chain2, String auth) {
                            X509Certificate[] peerCerts = OpenSslContext.certificates(chain2);
                            try {
                                manager.checkClientTrusted(peerCerts, auth);
                                return true;
                            }
                            catch (Exception e) {
                                logger.debug("verification of certificate failed", e);
                                return false;
                            }
                        }
                    });
                }
                catch (Exception e) {
                    throw new SSLException("unable to setup trustmanager", e);
                }
                this.sessionContext = new OpenSslServerSessionContext(this.ctx);
                success = true;
            }
        }
        finally {
            if (!success) {
                this.destroyPools();
            }
        }
        {
            return;
        }
    }

    @Override
    public OpenSslServerSessionContext sessionContext() {
        return this.sessionContext;
    }
}

