/*
 * Decompiled with CFR 0.152.
 */
package robot.libraries;

import java.util.Arrays;
import org.python.compiler.APIVersion;
import org.python.compiler.Filename;
import org.python.compiler.MTime;
import org.python.core.CodeBootstrap;
import org.python.core.CodeLoader;
import org.python.core.Py;
import org.python.core.PyCode;
import org.python.core.PyException;
import org.python.core.PyFrame;
import org.python.core.PyFunction;
import org.python.core.PyFunctionTable;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyRunnable;
import org.python.core.PyRunnableBootstrap;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.ThreadState;
import org.python.core.imp;

@APIVersion(value=36)
@MTime(value=1487348830000L)
@Filename(value="/Users/jmalinen/Documents/workspace/robotframework/build/Lib/robot/libraries/DateTime.py")
public class DateTime$py
extends PyFunctionTable
implements PyRunnable {
    static DateTime$py self;
    static final PyCode f$0;
    static final PyCode get_current_date$1;
    static final PyCode convert_date$2;
    static final PyCode convert_time$3;
    static final PyCode subtract_date_from_date$4;
    static final PyCode add_time_to_date$5;
    static final PyCode subtract_time_from_date$6;
    static final PyCode add_time_to_time$7;
    static final PyCode subtract_time_from_time$8;
    static final PyCode Date$9;
    static final PyCode __init__$10;
    static final PyCode seconds$11;
    static final PyCode _convert_to_datetime$12;
    static final PyCode _seconds_to_datetime$13;
    static final PyCode _string_to_datetime$14;
    static final PyCode _normalize_timestamp$15;
    static final PyCode f$16;
    static final PyCode _need_to_handle_f_directive$17;
    static final PyCode _handle_un_supported_f_directive$18;
    static final PyCode _remove_f_from_format$19;
    static final PyCode convert$20;
    static final PyCode _convert_to_custom_timestamp$21;
    static final PyCode _convert_to_timestamp$22;
    static final PyCode _convert_to_epoch$23;
    static final PyCode __add__$24;
    static final PyCode __sub__$25;
    static final PyCode Time$26;
    static final PyCode __init__$27;
    static final PyCode _convert_time_to_seconds$28;
    static final PyCode timedelta$29;
    static final PyCode convert$30;
    static final PyCode _convert_to_number$31;
    static final PyCode _convert_to_verbose$32;
    static final PyCode _convert_to_compact$33;
    static final PyCode _convert_to_timer$34;
    static final PyCode _convert_to_timedelta$35;
    static final PyCode __add__$36;
    static final PyCode __sub__$37;

    public PyObject f$0(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setglobal("__doc__", PyString.fromInterned("A test library for handling date and time values.\n\n``DateTime`` is a Robot Framework standard library that supports creating and\nconverting date and time values (e.g. `Get Current Date`, `Convert Time`),\nas well as doing simple calculations with them (e.g. `Subtract Time From Date`,\n`Add Time To Time`). It supports dates and times in various formats, and can\nalso be used by other libraries programmatically.\n\nThis library is new in Robot Framework 2.8.5.\n\n= Table of Contents =\n\n- `Terminology`\n- `Date formats`\n- `Time formats`\n- `Millisecond handling`\n- `Programmatic usage`\n- `Shortcuts`\n- `Keywords`\n\n= Terminology =\n\nIn the context of this library, ``date`` and ``time`` generally have following\nmeanings:\n\n- ``date``: An entity with both date and time components but without any\n   timezone information. For example, ``2014-06-11 10:07:42``.\n- ``time``: A time interval. For example, ``1 hour 20 minutes`` or ``01:20:00``.\n\nThis terminology differs from what Python's standard\n[https://docs.python.org/2/library/datetime.html|datetime] module uses.\nBasically its\n[https://docs.python.org/2/library/datetime.html#datetime-objects|datetime] and\n[https://docs.python.org/2/library/datetime.html#timedelta-objects|timedelta]\nobjects match ``date`` and ``time`` as defined by this library.\n\n= Date formats =\n\nDates can given to and received from keywords in `timestamp`, `custom\ntimestamp`, `Python datetime` and `epoch time` formats. These formats are\ndiscussed thoroughly in subsequent sections.\n\nInput format is determined automatically based on the given date except when\nusing custom timestamps, in which case it needs to be given using\n``date_format`` argument. Default result format is timestamp, but it can\nbe overridden using ``result_format`` argument.\n\n== Timestamp ==\n\nIf a date is given as a string, it is always considered to be a timestamp.\nIf no custom formatting is given using ``date_format`` argument, the timestamp\nis expected to be in [http://en.wikipedia.org/wiki/ISO_8601|ISO 8601] like\nformat ``YYYY-MM-DD hh:mm:ss.mil``, where any non-digit character can be used\nas a separator or separators can be omitted altogether. Additionally,\nonly the date part is mandatory, all possibly missing time components are\nconsidered to be zeros.\n\nDates can also be returned in the same ``YYYY-MM-DD hh:mm:ss.mil`` format by\nusing ``timestamp`` value with ``result_format`` argument. This is also the\ndefault format that keywords returning dates use. Milliseconds can be excluded\nusing ``exclude_millis`` as explained in `Millisecond handling` section.\n\nExamples:\n| ${date1} =      | Convert Date | 2014-06-11 10:07:42.000 |\n| ${date2} =      | Convert Date | 20140611 100742         | result_format=timestamp |\n| Should Be Equal | ${date1}     | ${date2}                |\n| ${date} =       | Convert Date | 20140612 12:57          | exclude_millis=yes |\n| Should Be Equal | ${date}      | 2014-06-12 12:57:00     |\n\n== Custom timestamp ==\n\nIt is possible to use custom timestamps in both input and output.\nThe custom format is same as accepted by Python's\n[https://docs.python.org/2/library/datetime.html#strftime-strptime-behavior|\ndatatime.strptime] function. For example, the default timestamp discussed\nin the previous section would match ``%Y-%m-%d %H:%M:%S.%f``.\n\nWhen using a custom timestamp in input, it must be specified using\n``date_format`` argument. The actual input value must be a string that matches\nthe specified format exactly. When using a custom timestamp in output, it must\nbe given using ``result_format`` argument.\n\nExamples:\n| ${date} =       | Convert Date | 28.05.2014 12:05        | date_format=%d.%m.%Y %H:%M |\n| Should Be Equal | ${date}      | 2014-05-28 12:05:00.000 |\n| ${date} =       | Convert Date | ${date}                 | result_format=%d.%m.%Y |\n| Should Be Equal | ${date}      | 28.05.2014              |\n\nNotice that locale aware directives like ``%b``  do not work correctly with\nJython on non-English locales: http://bugs.jython.org/issue2285\n\n== Python datetime ==\n\nPython's standard\n[https://docs.python.org/2/library/datetime.html#datetime.datetime|datetime]\nobjects can be used both in input and output. In input they are recognized\nautomatically, and in output it is possible to get them by giving ``datetime``\nvalue to ``result_format`` argument.\n\nOne nice benefit with datetime objects is that they have different time\ncomponents available as attributes that can be easily accessed using the\nextended variable syntax.\n\nExamples:\n| ${datetime} = | Convert Date | 2014-06-11 10:07:42.123 | datetime |\n| Should Be Equal As Integers | ${datetime.year}        | 2014   |\n| Should Be Equal As Integers | ${datetime.month}       | 6      |\n| Should Be Equal As Integers | ${datetime.day}         | 11     |\n| Should Be Equal As Integers | ${datetime.hour}        | 10     |\n| Should Be Equal As Integers | ${datetime.minute}      | 7      |\n| Should Be Equal As Integers | ${datetime.second}      | 42     |\n| Should Be Equal As Integers | ${datetime.microsecond} | 123000 |\n\n== Epoch time ==\n\nEpoch time is the time in seconds since the\n[http://en.wikipedia.org/wiki/Unix_time|UNIX epoch] i.e. 00:00:00.000 (UTC)\n1 January 1970. To give a date in epoch time, it must be given as a number\n(integer or float), not as a string. To return a date in epoch time,\nit is possible to use ``epoch`` value with ``result_format`` argument.\nEpoch time is returned as a floating point number.\n\nNotice that epoch time itself is independent on timezones and thus same\naround the world at a certain time. What local time a certain epoch time\nmatches obviously then depends on the timezone. For example, examples below\nwere tested in Finland but verifications would fail on other timezones.\n\nExamples:\n| ${date} =       | Convert Date | ${1000000000}           |\n| Should Be Equal | ${date}      | 2001-09-09 04:46:40.000 |\n| ${date} =       | Convert Date | 2014-06-12 13:27:59.279 | epoch |\n| Should Be Equal | ${date}      | ${1402568879.279}       |\n\n== Earliest supported date ==\n\nThe earliest date that is supported depends on the date format and to some\nextend on the platform:\n\n- Timestamps support year 1900 and above.\n- Python datetime objects support year 1 and above.\n- Epoch time supports 1970 and above on Windows with Python and IronPython.\n- On other platforms epoch time supports 1900 and above or even earlier.\n\nPrior to Robot Framework 2.9.2, all formats had same limitation as epoch time\nhas nowadays.\n\n= Time formats =\n\nSimilarly as dates, times can be given to and received from keywords in\nvarious different formats. Supported formats are `number`, `time string`\n(verbose and compact), `timer string` and `Python timedelta`.\n\nInput format for time is always determined automatically based on the input.\nResult format is number by default, but it can be customised using\n``result_format`` argument.\n\n== Number ==\n\nTime given as a number is interpreted to be seconds. It can be given\neither as an integer or a float, or it can be a string that can be converted\nto a number.\n\nTo return a time as a number, ``result_format`` argument must have value\n``number``, which is also the default. Returned number is always a float.\n\nExamples:\n| ${time} =       | Convert Time | 3.14    |\n| Should Be Equal | ${time}      | ${3.14} |\n| ${time} =       | Convert Time | ${time} | result_format=number |\n| Should Be Equal | ${time}      | ${3.14} |\n\n== Time string ==\n\nTime strings are strings in format like ``1 minute 42 seconds`` or ``1min 42s``.\nThe basic idea of this format is having first a number and then a text\nspecifying what time that number represents. Numbers can be either\nintegers or floating point numbers, the whole format is case and space\ninsensitive, and it is possible to add a minus prefix to specify negative\ntimes. The available time specifiers are:\n\n- ``days``, ``day``, ``d``\n- ``hours``, ``hour``, ``h``\n- ``minutes``, ``minute``, ``mins``, ``min``, ``m``\n- ``seconds``, ``second``, ``secs``, ``sec``, ``s``\n- ``milliseconds``, ``millisecond``, ``millis``, ``ms``\n\nWhen returning a time string, it is possible to select between ``verbose``\nand ``compact`` representations using ``result_format`` argument. The verbose\nformat uses long specifiers ``day``, ``hour``, ``minute``, ``second`` and\n``millisecond``, and adds ``s`` at the end when needed. The compact format uses\nshorter specifiers ``d``, ``h``, ``min``, ``s`` and ``ms``, and even drops\nthe space between the number and the specifier.\n\nExamples:\n| ${time} =       | Convert Time | 1 minute 42 seconds |\n| Should Be Equal | ${time}      | ${102}              |\n| ${time} =       | Convert Time | 4200                | verbose |\n| Should Be Equal | ${time}      | 1 hour 10 minutes   |\n| ${time} =       | Convert Time | - 1.5 hours         | compact |\n| Should Be Equal | ${time}      | - 1h 30min          |\n\n== Timer string ==\n\nTimer string is a string given in timer like format ``hh:mm:ss.mil``. In this\nformat both hour and millisecond parts are optional, leading and trailing\nzeros can be left out when they are not meaningful, and negative times can\nbe represented by adding a minus prefix.\n\nTo return a time as timer string, ``result_format`` argument must be given\nvalue ``timer``. Timer strings are by default returned in full ``hh:mm:ss.mil``\nformat, but milliseconds can be excluded using ``exclude_millis`` as explained\nin `Millisecond handling` section.\n\nExamples:\n| ${time} =       | Convert Time | 01:42        |\n| Should Be Equal | ${time}      | ${102}       |\n| ${time} =       | Convert Time | 01:10:00.123 |\n| Should Be Equal | ${time}      | ${4200.123}  |\n| ${time} =       | Convert Time | 102          | timer |\n| Should Be Equal | ${time}      | 00:01:42.000 |\n| ${time} =       | Convert Time | -101.567     | timer | exclude_millis=yes |\n| Should Be Equal | ${time}      | -00:01:42    |\n\n== Python timedelta ==\n\nPython's standard\n[https://docs.python.org/2/library/datetime.html#datetime.timedelta|timedelta]\nobjects are also supported both in input and in output. In input they are\nrecognized automatically, and in output it is possible to receive them by\ngiving ``timedelta`` value to ``result_format`` argument.\n\nExamples:\n| ${timedelta} =  | Convert Time                 | 01:10:02.123 | timedelta |\n| Should Be Equal | ${timedelta.total_seconds()} | ${4202.123}  |\n\n= Millisecond handling =\n\nThis library handles dates and times internally using the precision of the\ngiven input. With `timestamp`, `time string`, and `timer string` result\nformats seconds are, however, rounded to millisecond accuracy. Milliseconds\nmay also be included even if there would be none.\n\nAll keywords returning dates or times have an option to leave milliseconds out\nby giving a true value to ``exclude_millis`` argument. If the argument is given\nas a string, it is considered true unless it is empty or case-insensitively\nequal to ``false`` or ``no``. Other argument types are tested using same\n[http://docs.python.org/2/library/stdtypes.html#truth-value-testing|rules as in\nPython]. Notice that prior to Robot Framework 2.9, all strings except the empty\nstring were considered true.\n\nWhen milliseconds are excluded, seconds in returned dates and times are\nrounded to the nearest full second. With `timestamp` and `timer string`\nresult formats, milliseconds will also be removed from the returned string\naltogether.\n\nExamples:\n| ${date} =       | Convert Date | 2014-06-11 10:07:42     |\n| Should Be Equal | ${date}      | 2014-06-11 10:07:42.000 |\n| ${date} =       | Convert Date | 2014-06-11 10:07:42.500 | exclude_millis=yes |\n| Should Be Equal | ${date}      | 2014-06-11 10:07:43     |\n| ${dt} =         | Convert Date | 2014-06-11 10:07:42.500 | datetime | exclude_millis=yes |\n| Should Be Equal | ${dt.second} | ${43}        |\n| Should Be Equal | ${dt.microsecond} | ${0}    |\n| ${time} =       | Convert Time | 102          | timer | exclude_millis=false |\n| Should Be Equal | ${time}      | 00:01:42.000 |       |\n| ${time} =       | Convert Time | 102.567      | timer | exclude_millis=true |\n| Should Be Equal | ${time}      | 00:01:43     |       |\n\n= Programmatic usage =\n\nIn addition to be used as normal library, this library is intended to\nprovide a stable API for other libraries to use if they want to support\nsame date and time formats as this library. All the provided keywords\nare available as functions that can be easily imported:\n\n| from robot.libraries.DateTime import convert_time\n|\n| def example_keyword(timeout):\n|     seconds = convert_time(timeout)\n|     # ...\n\nAdditionally helper classes ``Date`` and ``Time`` can be used directly:\n\n| from robot.libraries.DateTime import Date, Time\n|\n| def example_keyword(date, interval):\n|     date = Date(date).convert('datetime')\n|     interval = Time(interval).convert('number')\n|     # ...\n"));
        pyFrame.setline(305);
        PyString.fromInterned("A test library for handling date and time values.\n\n``DateTime`` is a Robot Framework standard library that supports creating and\nconverting date and time values (e.g. `Get Current Date`, `Convert Time`),\nas well as doing simple calculations with them (e.g. `Subtract Time From Date`,\n`Add Time To Time`). It supports dates and times in various formats, and can\nalso be used by other libraries programmatically.\n\nThis library is new in Robot Framework 2.8.5.\n\n= Table of Contents =\n\n- `Terminology`\n- `Date formats`\n- `Time formats`\n- `Millisecond handling`\n- `Programmatic usage`\n- `Shortcuts`\n- `Keywords`\n\n= Terminology =\n\nIn the context of this library, ``date`` and ``time`` generally have following\nmeanings:\n\n- ``date``: An entity with both date and time components but without any\n   timezone information. For example, ``2014-06-11 10:07:42``.\n- ``time``: A time interval. For example, ``1 hour 20 minutes`` or ``01:20:00``.\n\nThis terminology differs from what Python's standard\n[https://docs.python.org/2/library/datetime.html|datetime] module uses.\nBasically its\n[https://docs.python.org/2/library/datetime.html#datetime-objects|datetime] and\n[https://docs.python.org/2/library/datetime.html#timedelta-objects|timedelta]\nobjects match ``date`` and ``time`` as defined by this library.\n\n= Date formats =\n\nDates can given to and received from keywords in `timestamp`, `custom\ntimestamp`, `Python datetime` and `epoch time` formats. These formats are\ndiscussed thoroughly in subsequent sections.\n\nInput format is determined automatically based on the given date except when\nusing custom timestamps, in which case it needs to be given using\n``date_format`` argument. Default result format is timestamp, but it can\nbe overridden using ``result_format`` argument.\n\n== Timestamp ==\n\nIf a date is given as a string, it is always considered to be a timestamp.\nIf no custom formatting is given using ``date_format`` argument, the timestamp\nis expected to be in [http://en.wikipedia.org/wiki/ISO_8601|ISO 8601] like\nformat ``YYYY-MM-DD hh:mm:ss.mil``, where any non-digit character can be used\nas a separator or separators can be omitted altogether. Additionally,\nonly the date part is mandatory, all possibly missing time components are\nconsidered to be zeros.\n\nDates can also be returned in the same ``YYYY-MM-DD hh:mm:ss.mil`` format by\nusing ``timestamp`` value with ``result_format`` argument. This is also the\ndefault format that keywords returning dates use. Milliseconds can be excluded\nusing ``exclude_millis`` as explained in `Millisecond handling` section.\n\nExamples:\n| ${date1} =      | Convert Date | 2014-06-11 10:07:42.000 |\n| ${date2} =      | Convert Date | 20140611 100742         | result_format=timestamp |\n| Should Be Equal | ${date1}     | ${date2}                |\n| ${date} =       | Convert Date | 20140612 12:57          | exclude_millis=yes |\n| Should Be Equal | ${date}      | 2014-06-12 12:57:00     |\n\n== Custom timestamp ==\n\nIt is possible to use custom timestamps in both input and output.\nThe custom format is same as accepted by Python's\n[https://docs.python.org/2/library/datetime.html#strftime-strptime-behavior|\ndatatime.strptime] function. For example, the default timestamp discussed\nin the previous section would match ``%Y-%m-%d %H:%M:%S.%f``.\n\nWhen using a custom timestamp in input, it must be specified using\n``date_format`` argument. The actual input value must be a string that matches\nthe specified format exactly. When using a custom timestamp in output, it must\nbe given using ``result_format`` argument.\n\nExamples:\n| ${date} =       | Convert Date | 28.05.2014 12:05        | date_format=%d.%m.%Y %H:%M |\n| Should Be Equal | ${date}      | 2014-05-28 12:05:00.000 |\n| ${date} =       | Convert Date | ${date}                 | result_format=%d.%m.%Y |\n| Should Be Equal | ${date}      | 28.05.2014              |\n\nNotice that locale aware directives like ``%b``  do not work correctly with\nJython on non-English locales: http://bugs.jython.org/issue2285\n\n== Python datetime ==\n\nPython's standard\n[https://docs.python.org/2/library/datetime.html#datetime.datetime|datetime]\nobjects can be used both in input and output. In input they are recognized\nautomatically, and in output it is possible to get them by giving ``datetime``\nvalue to ``result_format`` argument.\n\nOne nice benefit with datetime objects is that they have different time\ncomponents available as attributes that can be easily accessed using the\nextended variable syntax.\n\nExamples:\n| ${datetime} = | Convert Date | 2014-06-11 10:07:42.123 | datetime |\n| Should Be Equal As Integers | ${datetime.year}        | 2014   |\n| Should Be Equal As Integers | ${datetime.month}       | 6      |\n| Should Be Equal As Integers | ${datetime.day}         | 11     |\n| Should Be Equal As Integers | ${datetime.hour}        | 10     |\n| Should Be Equal As Integers | ${datetime.minute}      | 7      |\n| Should Be Equal As Integers | ${datetime.second}      | 42     |\n| Should Be Equal As Integers | ${datetime.microsecond} | 123000 |\n\n== Epoch time ==\n\nEpoch time is the time in seconds since the\n[http://en.wikipedia.org/wiki/Unix_time|UNIX epoch] i.e. 00:00:00.000 (UTC)\n1 January 1970. To give a date in epoch time, it must be given as a number\n(integer or float), not as a string. To return a date in epoch time,\nit is possible to use ``epoch`` value with ``result_format`` argument.\nEpoch time is returned as a floating point number.\n\nNotice that epoch time itself is independent on timezones and thus same\naround the world at a certain time. What local time a certain epoch time\nmatches obviously then depends on the timezone. For example, examples below\nwere tested in Finland but verifications would fail on other timezones.\n\nExamples:\n| ${date} =       | Convert Date | ${1000000000}           |\n| Should Be Equal | ${date}      | 2001-09-09 04:46:40.000 |\n| ${date} =       | Convert Date | 2014-06-12 13:27:59.279 | epoch |\n| Should Be Equal | ${date}      | ${1402568879.279}       |\n\n== Earliest supported date ==\n\nThe earliest date that is supported depends on the date format and to some\nextend on the platform:\n\n- Timestamps support year 1900 and above.\n- Python datetime objects support year 1 and above.\n- Epoch time supports 1970 and above on Windows with Python and IronPython.\n- On other platforms epoch time supports 1900 and above or even earlier.\n\nPrior to Robot Framework 2.9.2, all formats had same limitation as epoch time\nhas nowadays.\n\n= Time formats =\n\nSimilarly as dates, times can be given to and received from keywords in\nvarious different formats. Supported formats are `number`, `time string`\n(verbose and compact), `timer string` and `Python timedelta`.\n\nInput format for time is always determined automatically based on the input.\nResult format is number by default, but it can be customised using\n``result_format`` argument.\n\n== Number ==\n\nTime given as a number is interpreted to be seconds. It can be given\neither as an integer or a float, or it can be a string that can be converted\nto a number.\n\nTo return a time as a number, ``result_format`` argument must have value\n``number``, which is also the default. Returned number is always a float.\n\nExamples:\n| ${time} =       | Convert Time | 3.14    |\n| Should Be Equal | ${time}      | ${3.14} |\n| ${time} =       | Convert Time | ${time} | result_format=number |\n| Should Be Equal | ${time}      | ${3.14} |\n\n== Time string ==\n\nTime strings are strings in format like ``1 minute 42 seconds`` or ``1min 42s``.\nThe basic idea of this format is having first a number and then a text\nspecifying what time that number represents. Numbers can be either\nintegers or floating point numbers, the whole format is case and space\ninsensitive, and it is possible to add a minus prefix to specify negative\ntimes. The available time specifiers are:\n\n- ``days``, ``day``, ``d``\n- ``hours``, ``hour``, ``h``\n- ``minutes``, ``minute``, ``mins``, ``min``, ``m``\n- ``seconds``, ``second``, ``secs``, ``sec``, ``s``\n- ``milliseconds``, ``millisecond``, ``millis``, ``ms``\n\nWhen returning a time string, it is possible to select between ``verbose``\nand ``compact`` representations using ``result_format`` argument. The verbose\nformat uses long specifiers ``day``, ``hour``, ``minute``, ``second`` and\n``millisecond``, and adds ``s`` at the end when needed. The compact format uses\nshorter specifiers ``d``, ``h``, ``min``, ``s`` and ``ms``, and even drops\nthe space between the number and the specifier.\n\nExamples:\n| ${time} =       | Convert Time | 1 minute 42 seconds |\n| Should Be Equal | ${time}      | ${102}              |\n| ${time} =       | Convert Time | 4200                | verbose |\n| Should Be Equal | ${time}      | 1 hour 10 minutes   |\n| ${time} =       | Convert Time | - 1.5 hours         | compact |\n| Should Be Equal | ${time}      | - 1h 30min          |\n\n== Timer string ==\n\nTimer string is a string given in timer like format ``hh:mm:ss.mil``. In this\nformat both hour and millisecond parts are optional, leading and trailing\nzeros can be left out when they are not meaningful, and negative times can\nbe represented by adding a minus prefix.\n\nTo return a time as timer string, ``result_format`` argument must be given\nvalue ``timer``. Timer strings are by default returned in full ``hh:mm:ss.mil``\nformat, but milliseconds can be excluded using ``exclude_millis`` as explained\nin `Millisecond handling` section.\n\nExamples:\n| ${time} =       | Convert Time | 01:42        |\n| Should Be Equal | ${time}      | ${102}       |\n| ${time} =       | Convert Time | 01:10:00.123 |\n| Should Be Equal | ${time}      | ${4200.123}  |\n| ${time} =       | Convert Time | 102          | timer |\n| Should Be Equal | ${time}      | 00:01:42.000 |\n| ${time} =       | Convert Time | -101.567     | timer | exclude_millis=yes |\n| Should Be Equal | ${time}      | -00:01:42    |\n\n== Python timedelta ==\n\nPython's standard\n[https://docs.python.org/2/library/datetime.html#datetime.timedelta|timedelta]\nobjects are also supported both in input and in output. In input they are\nrecognized automatically, and in output it is possible to receive them by\ngiving ``timedelta`` value to ``result_format`` argument.\n\nExamples:\n| ${timedelta} =  | Convert Time                 | 01:10:02.123 | timedelta |\n| Should Be Equal | ${timedelta.total_seconds()} | ${4202.123}  |\n\n= Millisecond handling =\n\nThis library handles dates and times internally using the precision of the\ngiven input. With `timestamp`, `time string`, and `timer string` result\nformats seconds are, however, rounded to millisecond accuracy. Milliseconds\nmay also be included even if there would be none.\n\nAll keywords returning dates or times have an option to leave milliseconds out\nby giving a true value to ``exclude_millis`` argument. If the argument is given\nas a string, it is considered true unless it is empty or case-insensitively\nequal to ``false`` or ``no``. Other argument types are tested using same\n[http://docs.python.org/2/library/stdtypes.html#truth-value-testing|rules as in\nPython]. Notice that prior to Robot Framework 2.9, all strings except the empty\nstring were considered true.\n\nWhen milliseconds are excluded, seconds in returned dates and times are\nrounded to the nearest full second. With `timestamp` and `timer string`\nresult formats, milliseconds will also be removed from the returned string\naltogether.\n\nExamples:\n| ${date} =       | Convert Date | 2014-06-11 10:07:42     |\n| Should Be Equal | ${date}      | 2014-06-11 10:07:42.000 |\n| ${date} =       | Convert Date | 2014-06-11 10:07:42.500 | exclude_millis=yes |\n| Should Be Equal | ${date}      | 2014-06-11 10:07:43     |\n| ${dt} =         | Convert Date | 2014-06-11 10:07:42.500 | datetime | exclude_millis=yes |\n| Should Be Equal | ${dt.second} | ${43}        |\n| Should Be Equal | ${dt.microsecond} | ${0}    |\n| ${time} =       | Convert Time | 102          | timer | exclude_millis=false |\n| Should Be Equal | ${time}      | 00:01:42.000 |       |\n| ${time} =       | Convert Time | 102.567      | timer | exclude_millis=true |\n| Should Be Equal | ${time}      | 00:01:43     |       |\n\n= Programmatic usage =\n\nIn addition to be used as normal library, this library is intended to\nprovide a stable API for other libraries to use if they want to support\nsame date and time formats as this library. All the provided keywords\nare available as functions that can be easily imported:\n\n| from robot.libraries.DateTime import convert_time\n|\n| def example_keyword(timeout):\n|     seconds = convert_time(timeout)\n|     # ...\n\nAdditionally helper classes ``Date`` and ``Time`` can be used directly:\n\n| from robot.libraries.DateTime import Date, Time\n|\n| def example_keyword(date, interval):\n|     date = Date(date).convert('datetime')\n|     interval = Time(interval).convert('number')\n|     # ...\n");
        pyFrame.setline(307);
        Object[] objectArray = new String[]{"datetime", "timedelta"};
        objectArray = imp.importFrom("datetime", (String[])objectArray, pyFrame, -1);
        Object object = objectArray[0];
        pyFrame.setlocal("datetime", (PyObject)object);
        object = null;
        object = objectArray[1];
        pyFrame.setlocal("timedelta", (PyObject)object);
        object = null;
        pyFrame.setline(308);
        objectArray = imp.importOne("time", pyFrame, -1);
        pyFrame.setlocal("time", (PyObject)objectArray);
        objectArray = null;
        pyFrame.setline(309);
        objectArray = imp.importOne("re", pyFrame, -1);
        pyFrame.setlocal("re", (PyObject)objectArray);
        objectArray = null;
        pyFrame.setline(311);
        objectArray = new String[]{"get_version"};
        objectArray = imp.importFrom("robot.version", (String[])objectArray, pyFrame, -1);
        object = objectArray[0];
        pyFrame.setlocal("get_version", (PyObject)object);
        object = null;
        pyFrame.setline(312);
        objectArray = new String[]{"elapsed_time_to_string", "is_falsy", "is_number", "is_string", "roundup", "secs_to_timestr", "timestr_to_secs", "type_name", "IRONPYTHON"};
        objectArray = imp.importFrom("robot.utils", (String[])objectArray, pyFrame, -1);
        object = objectArray[0];
        pyFrame.setlocal("elapsed_time_to_string", (PyObject)object);
        object = null;
        object = objectArray[1];
        pyFrame.setlocal("is_falsy", (PyObject)object);
        object = null;
        object = objectArray[2];
        pyFrame.setlocal("is_number", (PyObject)object);
        object = null;
        object = objectArray[3];
        pyFrame.setlocal("is_string", (PyObject)object);
        object = null;
        object = objectArray[4];
        pyFrame.setlocal("roundup", (PyObject)object);
        object = null;
        object = objectArray[5];
        pyFrame.setlocal("secs_to_timestr", (PyObject)object);
        object = null;
        object = objectArray[6];
        pyFrame.setlocal("timestr_to_secs", (PyObject)object);
        object = null;
        object = objectArray[7];
        pyFrame.setlocal("type_name", (PyObject)object);
        object = null;
        object = objectArray[8];
        pyFrame.setlocal("IRONPYTHON", (PyObject)object);
        object = null;
        pyFrame.setline(316);
        objectArray = pyFrame.getname("get_version").__call__(threadState);
        pyFrame.setlocal("__version__", (PyObject)objectArray);
        objectArray = null;
        pyFrame.setline(317);
        objectArray = new PyList(new PyObject[]{PyString.fromInterned("convert_time"), PyString.fromInterned("convert_date"), PyString.fromInterned("subtract_date_from_date"), PyString.fromInterned("subtract_time_from_date"), PyString.fromInterned("subtract_time_from_time"), PyString.fromInterned("add_time_to_time"), PyString.fromInterned("add_time_to_date"), PyString.fromInterned("get_current_date")});
        pyFrame.setlocal("__all__", (PyObject)objectArray);
        objectArray = null;
        pyFrame.setline(322);
        objectArray = new PyObject[]{PyString.fromInterned("local"), Py.newInteger(0), PyString.fromInterned("timestamp"), pyFrame.getname("False")};
        objectArray = new PyFunction(pyFrame.f_globals, (PyObject[])objectArray, get_current_date$1, PyString.fromInterned("Returns current local or UTC time with an optional increment.\n\n    Arguments:\n    - ``time_zone:``      Get the current time on this time zone. Currently only\n                          ``local`` (default) and ``UTC`` are supported.\n    - ``increment:``      Optional time increment to add to the returned date in\n                          one of the supported `time formats`. Can be negative.\n    - ``result_format:``  Format of the returned date (see `date formats`).\n    - ``exclude_millis:`` When set to any true value, rounds and drops\n                          milliseconds as explained in `millisecond handling`.\n\n    Examples:\n    | ${date} =       | Get Current Date |\n    | Should Be Equal | ${date}          | 2014-06-12 20:00:58.946 |\n    | ${date} =       | Get Current Date | UTC                     |\n    | Should Be Equal | ${date}          | 2014-06-12 17:00:58.946 |\n    | ${date} =       | Get Current Date | increment=02:30:00      |\n    | Should Be Equal | ${date}          | 2014-06-12 22:30:58.946 |\n    | ${date} =       | Get Current Date | UTC                     | - 5 hours |\n    | Should Be Equal | ${date}          | 2014-06-12 12:00:58.946 |\n    | ${date} =       | Get Current Date | result_format=datetime  |\n    | Should Be Equal | ${date.year}     | ${2014}                 |\n    | Should Be Equal | ${date.month}    | ${6}                    |\n    "));
        pyFrame.setlocal("get_current_date", (PyObject)objectArray);
        objectArray = null;
        pyFrame.setline(358);
        objectArray = new PyObject[]{PyString.fromInterned("timestamp"), pyFrame.getname("False"), pyFrame.getname("None")};
        objectArray = new PyFunction(pyFrame.f_globals, (PyObject[])objectArray, convert_date$2, PyString.fromInterned("Converts between supported `date formats`.\n\n    Arguments:\n    - ``date:``           Date in one of the supported `date formats`.\n    - ``result_format:``  Format of the returned date.\n    - ``exclude_millis:`` When set to any true value, rounds and drops\n                          milliseconds as explained in `millisecond handling`.\n    - ``date_format:``    Specifies possible `custom timestamp` format.\n\n    Examples:\n    | ${date} =       | Convert Date | 20140528 12:05:03.111   |\n    | Should Be Equal | ${date}      | 2014-05-28 12:05:03.111 |\n    | ${date} =       | Convert Date | ${date}                 | epoch |\n    | Should Be Equal | ${date}      | ${1401267903.111}       |\n    | ${date} =       | Convert Date | 5.28.2014 12:05         | exclude_millis=yes | date_format=%m.%d.%Y %H:%M |\n    | Should Be Equal | ${date}      | 2014-05-28 12:05:00     |\n    "));
        pyFrame.setlocal("convert_date", (PyObject)objectArray);
        objectArray = null;
        pyFrame.setline(381);
        objectArray = new PyObject[]{PyString.fromInterned("number"), pyFrame.getname("False")};
        objectArray = new PyFunction(pyFrame.f_globals, (PyObject[])objectArray, convert_time$3, PyString.fromInterned("Converts between supported `time formats`.\n\n    Arguments:\n    - ``time:``           Time in one of the supported `time formats`.\n    - ``result_format:``  Format of the returned time.\n    - ``exclude_millis:`` When set to any true value, rounds and drops\n                          milliseconds as explained in `millisecond handling`.\n\n    Examples:\n    | ${time} =       | Convert Time  | 10 seconds        |\n    | Should Be Equal | ${time}       | ${10}             |\n    | ${time} =       | Convert Time  | 1:00:01           | verbose |\n    | Should Be Equal | ${time}       | 1 hour 1 second   |\n    | ${time} =       | Convert Time  | ${3661.5} | timer | exclude_milles=yes |\n    | Should Be Equal | ${time}       | 01:01:02          |\n    "));
        pyFrame.setlocal("convert_time", (PyObject)objectArray);
        objectArray = null;
        pyFrame.setline(401);
        objectArray = new PyObject[]{PyString.fromInterned("number"), pyFrame.getname("False"), pyFrame.getname("None"), pyFrame.getname("None")};
        objectArray = new PyFunction(pyFrame.f_globals, (PyObject[])objectArray, subtract_date_from_date$4, PyString.fromInterned("Subtracts date from another date and returns time between.\n\n    Arguments:\n    - ``date1:``          Date to subtract another date from in one of the\n                          supported `date formats`.\n    - ``date2:``          Date that is subtracted in one of the supported\n                          `date formats`.\n    - ``result_format:``  Format of the returned time (see `time formats`).\n    - ``exclude_millis:`` When set to any true value, rounds and drops\n                          milliseconds as explained in `millisecond handling`.\n    - ``date1_format:``   Possible `custom timestamp` format of ``date1``.\n    - ``date2_format:``   Possible `custom timestamp` format of ``date2``.\n\n     Examples:\n    | ${time} =       | Subtract Date From Date | 2014-05-28 12:05:52     | 2014-05-28 12:05:10 |\n    | Should Be Equal | ${time}                 | ${42}                   |\n    | ${time} =       | Subtract Date From Date | 2014-05-28 12:05:52     | 2014-05-27 12:05:10 | verbose |\n    | Should Be Equal | ${time}                 | 1 day 42 seconds        |\n    "));
        pyFrame.setlocal("subtract_date_from_date", (PyObject)objectArray);
        objectArray = null;
        pyFrame.setline(427);
        objectArray = new PyObject[]{PyString.fromInterned("timestamp"), pyFrame.getname("False"), pyFrame.getname("None")};
        objectArray = new PyFunction(pyFrame.f_globals, (PyObject[])objectArray, add_time_to_date$5, PyString.fromInterned("Adds time to date and returns the resulting date.\n\n    Arguments:\n    - ``date:``           Date to add time to in one of the supported\n                          `date formats`.\n    - ``time:``           Time that is added in one of the supported\n                          `time formats`.\n    - ``result_format:``  Format of the returned date.\n    - ``exclude_millis:`` When set to any true value, rounds and drops\n                          milliseconds as explained in `millisecond handling`.\n    - ``date_format:``    Possible `custom timestamp` format of ``date``.\n\n    Examples:\n    | ${date} =       | Add Time To Date | 2014-05-28 12:05:03.111 | 7 days       |\n    | Should Be Equal | ${date}          | 2014-06-04 12:05:03.111 |              |\n    | ${date} =       | Add Time To Date | 2014-05-28 12:05:03.111 | 01:02:03:004 |\n    | Should Be Equal | ${date}          | 2014-05-28 13:07:06.115 |\n    "));
        pyFrame.setlocal("add_time_to_date", (PyObject)objectArray);
        objectArray = null;
        pyFrame.setline(451);
        objectArray = new PyObject[]{PyString.fromInterned("timestamp"), pyFrame.getname("False"), pyFrame.getname("None")};
        objectArray = new PyFunction(pyFrame.f_globals, (PyObject[])objectArray, subtract_time_from_date$6, PyString.fromInterned("Subtracts time from date and returns the resulting date.\n\n    Arguments:\n    - ``date:``           Date to subtract time from in one of the supported\n                          `date formats`.\n    - ``time:``           Time that is subtracted in one of the supported\n                         `time formats`.\n    - ``result_format:``  Format of the returned date.\n    - ``exclude_millis:`` When set to any true value, rounds and drops\n                          milliseconds as explained in `millisecond handling`.\n    - ``date_format:``    Possible `custom timestamp` format of ``date``.\n\n    Examples:\n    | ${date} =       | Subtract Time From Date | 2014-06-04 12:05:03.111 | 7 days |\n    | Should Be Equal | ${date}                 | 2014-05-28 12:05:03.111 |\n    | ${date} =       | Subtract Time From Date | 2014-05-28 13:07:06.115 | 01:02:03:004 |\n    | Should Be Equal | ${date}                 | 2014-05-28 12:05:03.111 |\n    "));
        pyFrame.setlocal("subtract_time_from_date", (PyObject)objectArray);
        objectArray = null;
        pyFrame.setline(475);
        objectArray = new PyObject[]{PyString.fromInterned("number"), pyFrame.getname("False")};
        objectArray = new PyFunction(pyFrame.f_globals, (PyObject[])objectArray, add_time_to_time$7, PyString.fromInterned("Adds time to another time and returns the resulting time.\n\n    Arguments:\n    - ``time1:``          First time in one of the supported `time formats`.\n    - ``time2:``          Second time in one of the supported `time formats`.\n    - ``result_format:``  Format of the returned time.\n    - ``exclude_millis:`` When set to any true value, rounds and drops\n                          milliseconds as explained in `millisecond handling`.\n\n    Examples:\n    | ${time} =       | Add Time To Time | 1 minute          | 42       |\n    | Should Be Equal | ${time}          | ${102}            |\n    | ${time} =       | Add Time To Time | 3 hours 5 minutes | 01:02:03 | timer | exclude_millis=yes |\n    | Should Be Equal | ${time}          | 04:07:03          |\n    "));
        pyFrame.setlocal("add_time_to_time", (PyObject)objectArray);
        objectArray = null;
        pyFrame.setline(496);
        objectArray = new PyObject[]{PyString.fromInterned("number"), pyFrame.getname("False")};
        objectArray = new PyFunction(pyFrame.f_globals, (PyObject[])objectArray, subtract_time_from_time$8, PyString.fromInterned("Subtracts time from another time and returns the resulting time.\n\n    Arguments:\n    - ``time1:``          Time to subtract another time from in one of\n                          the supported `time formats`.\n    - ``time2:``          Time to subtract in one of the supported `time formats`.\n    - ``result_format:``  Format of the returned time.\n    - ``exclude_millis:`` When set to any true value, rounds and drops\n                          milliseconds as explained in `millisecond handling`.\n\n    Examples:\n    | ${time} =       | Subtract Time From Time | 00:02:30 | 100      |\n    | Should Be Equal | ${time}                 | ${50}    |\n    | ${time} =       | Subtract Time From Time | ${time}  | 1 minute | compact |\n    | Should Be Equal | ${time}                 | - 10s    |\n    "));
        pyFrame.setlocal("subtract_time_from_time", (PyObject)objectArray);
        objectArray = null;
        pyFrame.setline(518);
        objectArray = new PyObject[]{pyFrame.getname("object")};
        object = Py.makeClass("Date", (PyObject[])objectArray, Date$9);
        pyFrame.setlocal("Date", (PyObject)object);
        object = null;
        Arrays.fill(objectArray, null);
        pyFrame.setline(629);
        objectArray = new PyObject[]{pyFrame.getname("object")};
        object = Py.makeClass("Time", (PyObject[])objectArray, Time$26);
        pyFrame.setlocal("Time", (PyObject)object);
        object = null;
        Arrays.fill(objectArray, null);
        pyFrame.f_lasti = -1;
        return Py.None;
    }

    public PyObject get_current_date$1(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(347);
        PyString.fromInterned("Returns current local or UTC time with an optional increment.\n\n    Arguments:\n    - ``time_zone:``      Get the current time on this time zone. Currently only\n                          ``local`` (default) and ``UTC`` are supported.\n    - ``increment:``      Optional time increment to add to the returned date in\n                          one of the supported `time formats`. Can be negative.\n    - ``result_format:``  Format of the returned date (see `date formats`).\n    - ``exclude_millis:`` When set to any true value, rounds and drops\n                          milliseconds as explained in `millisecond handling`.\n\n    Examples:\n    | ${date} =       | Get Current Date |\n    | Should Be Equal | ${date}          | 2014-06-12 20:00:58.946 |\n    | ${date} =       | Get Current Date | UTC                     |\n    | Should Be Equal | ${date}          | 2014-06-12 17:00:58.946 |\n    | ${date} =       | Get Current Date | increment=02:30:00      |\n    | Should Be Equal | ${date}          | 2014-06-12 22:30:58.946 |\n    | ${date} =       | Get Current Date | UTC                     | - 5 hours |\n    | Should Be Equal | ${date}          | 2014-06-12 12:00:58.946 |\n    | ${date} =       | Get Current Date | result_format=datetime  |\n    | Should Be Equal | ${date.year}     | ${2014}                 |\n    | Should Be Equal | ${date.month}    | ${6}                    |\n    ");
        pyFrame.setline(348);
        Object object = pyFrame.getlocal(0).__getattr__("upper").__call__(threadState);
        PyObject pyObject = object._eq(PyString.fromInterned("LOCAL"));
        object = null;
        if (pyObject.__nonzero__()) {
            pyFrame.setline(349);
            object = pyFrame.getglobal("datetime").__getattr__("now").__call__(threadState);
            pyFrame.setlocal(4, (PyObject)object);
            object = null;
        } else {
            pyFrame.setline(350);
            object = pyFrame.getlocal(0).__getattr__("upper").__call__(threadState);
            PyObject pyObject2 = object._eq(PyString.fromInterned("UTC"));
            object = null;
            if (pyObject2.__nonzero__()) {
                pyFrame.setline(351);
                object = pyFrame.getglobal("datetime").__getattr__("utcnow").__call__(threadState);
                pyFrame.setlocal(4, (PyObject)object);
                object = null;
            } else {
                pyFrame.setline(353);
                throw Py.makeException(pyFrame.getglobal("ValueError").__call__(threadState, PyString.fromInterned("Unsupported timezone '%s'.")._mod(pyFrame.getlocal(0))));
            }
        }
        pyFrame.setline(354);
        object = pyFrame.getglobal("Date").__call__(threadState, pyFrame.getlocal(4))._add(pyFrame.getglobal("Time").__call__(threadState, pyFrame.getlocal(1)));
        pyFrame.setlocal(5, (PyObject)object);
        object = null;
        pyFrame.setline(355);
        object = new PyObject[]{pyFrame.getlocal(2), pyFrame.getglobal("is_falsy").__call__(threadState, pyFrame.getlocal(3))};
        String[] stringArray = new String[]{"millis"};
        PyObject pyObject3 = pyFrame.getlocal(5).__getattr__("convert").__call__(threadState, (PyObject[])object, stringArray);
        object = null;
        object = pyObject3;
        pyFrame.f_lasti = -1;
        return object;
    }

    public PyObject convert_date$2(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(376);
        PyString.fromInterned("Converts between supported `date formats`.\n\n    Arguments:\n    - ``date:``           Date in one of the supported `date formats`.\n    - ``result_format:``  Format of the returned date.\n    - ``exclude_millis:`` When set to any true value, rounds and drops\n                          milliseconds as explained in `millisecond handling`.\n    - ``date_format:``    Specifies possible `custom timestamp` format.\n\n    Examples:\n    | ${date} =       | Convert Date | 20140528 12:05:03.111   |\n    | Should Be Equal | ${date}      | 2014-05-28 12:05:03.111 |\n    | ${date} =       | Convert Date | ${date}                 | epoch |\n    | Should Be Equal | ${date}      | ${1401267903.111}       |\n    | ${date} =       | Convert Date | 5.28.2014 12:05         | exclude_millis=yes | date_format=%m.%d.%Y %H:%M |\n    | Should Be Equal | ${date}      | 2014-05-28 12:05:00     |\n    ");
        pyFrame.setline(377);
        Object object = new PyObject[]{pyFrame.getlocal(1), pyFrame.getglobal("is_falsy").__call__(threadState, pyFrame.getlocal(2))};
        String[] stringArray = new String[]{"millis"};
        PyObject pyObject = pyFrame.getglobal("Date").__call__(threadState, pyFrame.getlocal(0), pyFrame.getlocal(3)).__getattr__("convert").__call__(threadState, (PyObject[])object, stringArray);
        object = null;
        object = pyObject;
        pyFrame.f_lasti = -1;
        return object;
    }

    public PyObject convert_time$3(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(397);
        PyString.fromInterned("Converts between supported `time formats`.\n\n    Arguments:\n    - ``time:``           Time in one of the supported `time formats`.\n    - ``result_format:``  Format of the returned time.\n    - ``exclude_millis:`` When set to any true value, rounds and drops\n                          milliseconds as explained in `millisecond handling`.\n\n    Examples:\n    | ${time} =       | Convert Time  | 10 seconds        |\n    | Should Be Equal | ${time}       | ${10}             |\n    | ${time} =       | Convert Time  | 1:00:01           | verbose |\n    | Should Be Equal | ${time}       | 1 hour 1 second   |\n    | ${time} =       | Convert Time  | ${3661.5} | timer | exclude_milles=yes |\n    | Should Be Equal | ${time}       | 01:01:02          |\n    ");
        pyFrame.setline(398);
        Object object = new PyObject[]{pyFrame.getlocal(1), pyFrame.getglobal("is_falsy").__call__(threadState, pyFrame.getlocal(2))};
        String[] stringArray = new String[]{"millis"};
        PyObject pyObject = pyFrame.getglobal("Time").__call__(threadState, pyFrame.getlocal(0)).__getattr__("convert").__call__(threadState, (PyObject[])object, stringArray);
        object = null;
        object = pyObject;
        pyFrame.f_lasti = -1;
        return object;
    }

    public PyObject subtract_date_from_date$4(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(422);
        PyString.fromInterned("Subtracts date from another date and returns time between.\n\n    Arguments:\n    - ``date1:``          Date to subtract another date from in one of the\n                          supported `date formats`.\n    - ``date2:``          Date that is subtracted in one of the supported\n                          `date formats`.\n    - ``result_format:``  Format of the returned time (see `time formats`).\n    - ``exclude_millis:`` When set to any true value, rounds and drops\n                          milliseconds as explained in `millisecond handling`.\n    - ``date1_format:``   Possible `custom timestamp` format of ``date1``.\n    - ``date2_format:``   Possible `custom timestamp` format of ``date2``.\n\n     Examples:\n    | ${time} =       | Subtract Date From Date | 2014-05-28 12:05:52     | 2014-05-28 12:05:10 |\n    | Should Be Equal | ${time}                 | ${42}                   |\n    | ${time} =       | Subtract Date From Date | 2014-05-28 12:05:52     | 2014-05-27 12:05:10 | verbose |\n    | Should Be Equal | ${time}                 | 1 day 42 seconds        |\n    ");
        pyFrame.setline(423);
        Object object = pyFrame.getglobal("Date").__call__(threadState, pyFrame.getlocal(0), pyFrame.getlocal(4))._sub(pyFrame.getglobal("Date").__call__(threadState, pyFrame.getlocal(1), pyFrame.getlocal(5)));
        pyFrame.setlocal(6, (PyObject)object);
        object = null;
        pyFrame.setline(424);
        object = new PyObject[]{pyFrame.getlocal(2), pyFrame.getglobal("is_falsy").__call__(threadState, pyFrame.getlocal(3))};
        String[] stringArray = new String[]{"millis"};
        PyObject pyObject = pyFrame.getlocal(6).__getattr__("convert").__call__(threadState, (PyObject[])object, stringArray);
        object = null;
        object = pyObject;
        pyFrame.f_lasti = -1;
        return object;
    }

    public PyObject add_time_to_date$5(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(446);
        PyString.fromInterned("Adds time to date and returns the resulting date.\n\n    Arguments:\n    - ``date:``           Date to add time to in one of the supported\n                          `date formats`.\n    - ``time:``           Time that is added in one of the supported\n                          `time formats`.\n    - ``result_format:``  Format of the returned date.\n    - ``exclude_millis:`` When set to any true value, rounds and drops\n                          milliseconds as explained in `millisecond handling`.\n    - ``date_format:``    Possible `custom timestamp` format of ``date``.\n\n    Examples:\n    | ${date} =       | Add Time To Date | 2014-05-28 12:05:03.111 | 7 days       |\n    | Should Be Equal | ${date}          | 2014-06-04 12:05:03.111 |              |\n    | ${date} =       | Add Time To Date | 2014-05-28 12:05:03.111 | 01:02:03:004 |\n    | Should Be Equal | ${date}          | 2014-05-28 13:07:06.115 |\n    ");
        pyFrame.setline(447);
        Object object = pyFrame.getglobal("Date").__call__(threadState, pyFrame.getlocal(0), pyFrame.getlocal(4))._add(pyFrame.getglobal("Time").__call__(threadState, pyFrame.getlocal(1)));
        pyFrame.setlocal(0, (PyObject)object);
        object = null;
        pyFrame.setline(448);
        object = new PyObject[]{pyFrame.getlocal(2), pyFrame.getglobal("is_falsy").__call__(threadState, pyFrame.getlocal(3))};
        String[] stringArray = new String[]{"millis"};
        PyObject pyObject = pyFrame.getlocal(0).__getattr__("convert").__call__(threadState, (PyObject[])object, stringArray);
        object = null;
        object = pyObject;
        pyFrame.f_lasti = -1;
        return object;
    }

    public PyObject subtract_time_from_date$6(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(470);
        PyString.fromInterned("Subtracts time from date and returns the resulting date.\n\n    Arguments:\n    - ``date:``           Date to subtract time from in one of the supported\n                          `date formats`.\n    - ``time:``           Time that is subtracted in one of the supported\n                         `time formats`.\n    - ``result_format:``  Format of the returned date.\n    - ``exclude_millis:`` When set to any true value, rounds and drops\n                          milliseconds as explained in `millisecond handling`.\n    - ``date_format:``    Possible `custom timestamp` format of ``date``.\n\n    Examples:\n    | ${date} =       | Subtract Time From Date | 2014-06-04 12:05:03.111 | 7 days |\n    | Should Be Equal | ${date}                 | 2014-05-28 12:05:03.111 |\n    | ${date} =       | Subtract Time From Date | 2014-05-28 13:07:06.115 | 01:02:03:004 |\n    | Should Be Equal | ${date}                 | 2014-05-28 12:05:03.111 |\n    ");
        pyFrame.setline(471);
        Object object = pyFrame.getglobal("Date").__call__(threadState, pyFrame.getlocal(0), pyFrame.getlocal(4))._sub(pyFrame.getglobal("Time").__call__(threadState, pyFrame.getlocal(1)));
        pyFrame.setlocal(0, (PyObject)object);
        object = null;
        pyFrame.setline(472);
        object = new PyObject[]{pyFrame.getlocal(2), pyFrame.getglobal("is_falsy").__call__(threadState, pyFrame.getlocal(3))};
        String[] stringArray = new String[]{"millis"};
        PyObject pyObject = pyFrame.getlocal(0).__getattr__("convert").__call__(threadState, (PyObject[])object, stringArray);
        object = null;
        object = pyObject;
        pyFrame.f_lasti = -1;
        return object;
    }

    public PyObject add_time_to_time$7(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(491);
        PyString.fromInterned("Adds time to another time and returns the resulting time.\n\n    Arguments:\n    - ``time1:``          First time in one of the supported `time formats`.\n    - ``time2:``          Second time in one of the supported `time formats`.\n    - ``result_format:``  Format of the returned time.\n    - ``exclude_millis:`` When set to any true value, rounds and drops\n                          milliseconds as explained in `millisecond handling`.\n\n    Examples:\n    | ${time} =       | Add Time To Time | 1 minute          | 42       |\n    | Should Be Equal | ${time}          | ${102}            |\n    | ${time} =       | Add Time To Time | 3 hours 5 minutes | 01:02:03 | timer | exclude_millis=yes |\n    | Should Be Equal | ${time}          | 04:07:03          |\n    ");
        pyFrame.setline(492);
        Object object = pyFrame.getglobal("Time").__call__(threadState, pyFrame.getlocal(0))._add(pyFrame.getglobal("Time").__call__(threadState, pyFrame.getlocal(1)));
        pyFrame.setlocal(4, (PyObject)object);
        object = null;
        pyFrame.setline(493);
        object = new PyObject[]{pyFrame.getlocal(2), pyFrame.getglobal("is_falsy").__call__(threadState, pyFrame.getlocal(3))};
        String[] stringArray = new String[]{"millis"};
        PyObject pyObject = pyFrame.getlocal(4).__getattr__("convert").__call__(threadState, (PyObject[])object, stringArray);
        object = null;
        object = pyObject;
        pyFrame.f_lasti = -1;
        return object;
    }

    public PyObject subtract_time_from_time$8(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(513);
        PyString.fromInterned("Subtracts time from another time and returns the resulting time.\n\n    Arguments:\n    - ``time1:``          Time to subtract another time from in one of\n                          the supported `time formats`.\n    - ``time2:``          Time to subtract in one of the supported `time formats`.\n    - ``result_format:``  Format of the returned time.\n    - ``exclude_millis:`` When set to any true value, rounds and drops\n                          milliseconds as explained in `millisecond handling`.\n\n    Examples:\n    | ${time} =       | Subtract Time From Time | 00:02:30 | 100      |\n    | Should Be Equal | ${time}                 | ${50}    |\n    | ${time} =       | Subtract Time From Time | ${time}  | 1 minute | compact |\n    | Should Be Equal | ${time}                 | - 10s    |\n    ");
        pyFrame.setline(514);
        Object object = pyFrame.getglobal("Time").__call__(threadState, pyFrame.getlocal(0))._sub(pyFrame.getglobal("Time").__call__(threadState, pyFrame.getlocal(1)));
        pyFrame.setlocal(4, (PyObject)object);
        object = null;
        pyFrame.setline(515);
        object = new PyObject[]{pyFrame.getlocal(2), pyFrame.getglobal("is_falsy").__call__(threadState, pyFrame.getlocal(3))};
        String[] stringArray = new String[]{"millis"};
        PyObject pyObject = pyFrame.getlocal(4).__getattr__("convert").__call__(threadState, (PyObject[])object, stringArray);
        object = null;
        object = pyObject;
        pyFrame.f_lasti = -1;
        return object;
    }

    public PyObject Date$9(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setlocal("__module__", pyFrame.getname("__name__"));
        pyFrame.setline(520);
        Object object = new PyObject[]{pyFrame.getname("None")};
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, __init__$10, null);
        pyFrame.setlocal("__init__", (PyObject)object);
        object = null;
        pyFrame.setline(523);
        object = Py.EmptyObjects;
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, seconds$11, null);
        object = pyFrame.getname("property").__call__(threadState, (PyObject)object);
        pyFrame.setlocal("seconds", (PyObject)object);
        object = null;
        pyFrame.setline(528);
        object = Py.EmptyObjects;
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, _convert_to_datetime$12, null);
        pyFrame.setlocal("_convert_to_datetime", (PyObject)object);
        object = null;
        pyFrame.setline(537);
        object = Py.EmptyObjects;
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, _seconds_to_datetime$13, null);
        pyFrame.setlocal("_seconds_to_datetime", (PyObject)object);
        object = null;
        pyFrame.setline(544);
        object = Py.EmptyObjects;
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, _string_to_datetime$14, null);
        pyFrame.setlocal("_string_to_datetime", (PyObject)object);
        object = null;
        pyFrame.setline(552);
        object = Py.EmptyObjects;
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, _normalize_timestamp$15, null);
        pyFrame.setlocal("_normalize_timestamp", (PyObject)object);
        object = null;
        pyFrame.setline(560);
        object = Py.EmptyObjects;
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, _need_to_handle_f_directive$17, null);
        pyFrame.setlocal("_need_to_handle_f_directive", (PyObject)object);
        object = null;
        pyFrame.setline(564);
        object = Py.EmptyObjects;
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, _handle_un_supported_f_directive$18, null);
        pyFrame.setlocal("_handle_un_supported_f_directive", (PyObject)object);
        object = null;
        pyFrame.setline(575);
        object = Py.EmptyObjects;
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, _remove_f_from_format$19, null);
        pyFrame.setlocal("_remove_f_from_format", (PyObject)object);
        object = null;
        pyFrame.setline(581);
        object = new PyObject[]{pyFrame.getname("True")};
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, convert$20, null);
        pyFrame.setlocal("convert", (PyObject)object);
        object = null;
        pyFrame.setline(597);
        object = Py.EmptyObjects;
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, _convert_to_custom_timestamp$21, null);
        pyFrame.setlocal("_convert_to_custom_timestamp", (PyObject)object);
        object = null;
        pyFrame.setline(603);
        object = new PyObject[]{pyFrame.getname("True")};
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, _convert_to_timestamp$22, null);
        pyFrame.setlocal("_convert_to_timestamp", (PyObject)object);
        object = null;
        pyFrame.setline(612);
        object = Py.EmptyObjects;
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, _convert_to_epoch$23, null);
        pyFrame.setlocal("_convert_to_epoch", (PyObject)object);
        object = null;
        pyFrame.setline(615);
        object = Py.EmptyObjects;
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, __add__$24, null);
        pyFrame.setlocal("__add__", (PyObject)object);
        object = null;
        pyFrame.setline(620);
        object = Py.EmptyObjects;
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, __sub__$25, null);
        pyFrame.setlocal("__sub__", (PyObject)object);
        object = null;
        return pyFrame.getf_locals();
    }

    public PyObject __init__$10(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(521);
        PyObject pyObject = pyFrame.getlocal(0).__getattr__("_convert_to_datetime").__call__(threadState, pyFrame.getlocal(1), pyFrame.getlocal(2));
        pyFrame.getlocal(0).__setattr__("datetime", pyObject);
        pyObject = null;
        pyFrame.f_lasti = -1;
        return Py.None;
    }

    public PyObject seconds$11(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(526);
        PyObject pyObject = pyFrame.getlocal(0).__getattr__("_convert_to_epoch").__call__(threadState, pyFrame.getlocal(0).__getattr__("datetime"));
        pyFrame.f_lasti = -1;
        return pyObject;
    }

    public PyObject _convert_to_datetime$12(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(529);
        if (pyFrame.getglobal("isinstance").__call__(threadState, pyFrame.getlocal(1), pyFrame.getglobal("datetime")).__nonzero__()) {
            pyFrame.setline(530);
            PyObject pyObject = pyFrame.getlocal(1);
            pyFrame.f_lasti = -1;
            return pyObject;
        }
        pyFrame.setline(531);
        if (pyFrame.getglobal("is_number").__call__(threadState, pyFrame.getlocal(1)).__nonzero__()) {
            pyFrame.setline(532);
            PyObject pyObject = pyFrame.getlocal(0).__getattr__("_seconds_to_datetime").__call__(threadState, pyFrame.getlocal(1));
            pyFrame.f_lasti = -1;
            return pyObject;
        }
        pyFrame.setline(533);
        if (pyFrame.getglobal("is_string").__call__(threadState, pyFrame.getlocal(1)).__nonzero__()) {
            pyFrame.setline(534);
            PyObject pyObject = pyFrame.getlocal(0).__getattr__("_string_to_datetime").__call__(threadState, pyFrame.getlocal(1), pyFrame.getlocal(2));
            pyFrame.f_lasti = -1;
            return pyObject;
        }
        pyFrame.setline(535);
        throw Py.makeException(pyFrame.getglobal("ValueError").__call__(threadState, PyString.fromInterned("Unsupported input '%s'.")._mod(pyFrame.getlocal(1))));
    }

    public PyObject _seconds_to_datetime$13(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(541);
        Object object = pyFrame.getglobal("datetime").__getattr__("fromtimestamp").__call__(threadState, pyFrame.getlocal(1));
        pyFrame.setlocal(2, (PyObject)object);
        object = null;
        pyFrame.setline(542);
        object = new PyObject[]{pyFrame.getglobal("roundup").__call__(threadState, pyFrame.getlocal(1)._mod(Py.newInteger(1))._mul(Py.newFloat(1000000.0)))};
        String[] stringArray = new String[]{"microsecond"};
        PyObject pyObject = pyFrame.getlocal(2).__getattr__("replace").__call__(threadState, (PyObject[])object, stringArray);
        object = null;
        object = pyObject;
        pyFrame.f_lasti = -1;
        return object;
    }

    public PyObject _string_to_datetime$14(PyFrame pyFrame, ThreadState threadState) {
        PyObject pyObject;
        pyFrame.setline(545);
        if (pyFrame.getlocal(2).__not__().__nonzero__()) {
            pyFrame.setline(546);
            pyObject = pyFrame.getlocal(0).__getattr__("_normalize_timestamp").__call__(threadState, pyFrame.getlocal(1));
            pyFrame.setlocal(1, pyObject);
            pyObject = null;
            pyFrame.setline(547);
            pyObject = PyString.fromInterned("%Y-%m-%d %H:%M:%S.%f");
            pyFrame.setlocal(2, pyObject);
            pyObject = null;
        }
        pyFrame.setline(548);
        if (pyFrame.getlocal(0).__getattr__("_need_to_handle_f_directive").__call__(threadState, pyFrame.getlocal(2)).__nonzero__()) {
            pyFrame.setline(549);
            pyObject = pyFrame.getlocal(0).__getattr__("_handle_un_supported_f_directive").__call__(threadState, pyFrame.getlocal(1), pyFrame.getlocal(2));
            pyFrame.f_lasti = -1;
            return pyObject;
        }
        pyFrame.setline(550);
        pyObject = pyFrame.getglobal("datetime").__getattr__("strptime").__call__(threadState, pyFrame.getlocal(1), pyFrame.getlocal(2));
        pyFrame.f_lasti = -1;
        return pyObject;
    }

    public PyObject _normalize_timestamp$15(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(553);
        PyObject pyObject = PyString.fromInterned("").__getattr__("join");
        pyFrame.setline(553);
        Object object = Py.EmptyObjects;
        PyFunction pyFunction = new PyFunction(pyFrame.f_globals, (PyObject[])object, f$16, null);
        PyObject pyObject2 = ((PyObject)pyFunction).__call__(threadState, pyFrame.getlocal(1).__iter__());
        Arrays.fill((Object[])object, null);
        object = pyObject.__call__(threadState, pyObject2);
        pyFrame.setlocal(2, (PyObject)object);
        object = null;
        pyFrame.setline(554);
        object = pyFrame.getglobal("len").__call__(threadState, pyFrame.getlocal(2));
        PyObject pyObject3 = ((PyObject)object)._lt(Py.newInteger(8));
        object = null;
        if (pyObject3.__nonzero__()) {
            pyFrame.setline(555);
            throw Py.makeException(pyFrame.getglobal("ValueError").__call__(threadState, PyString.fromInterned("Invalid timestamp '%s'.")._mod(pyFrame.getlocal(1))));
        }
        pyFrame.setline(556);
        object = pyFrame.getlocal(2).__getattr__("ljust").__call__(threadState, (PyObject)Py.newInteger(20), (PyObject)PyString.fromInterned("0"));
        pyFrame.setlocal(2, (PyObject)object);
        object = null;
        pyFrame.setline(557);
        object = PyString.fromInterned("%s-%s-%s %s:%s:%s.%s")._mod(new PyTuple(pyFrame.getlocal(2).__getslice__(null, Py.newInteger(4), null), pyFrame.getlocal(2).__getslice__(Py.newInteger(4), Py.newInteger(6), null), pyFrame.getlocal(2).__getslice__(Py.newInteger(6), Py.newInteger(8), null), pyFrame.getlocal(2).__getslice__(Py.newInteger(8), Py.newInteger(10), null), pyFrame.getlocal(2).__getslice__(Py.newInteger(10), Py.newInteger(12), null), pyFrame.getlocal(2).__getslice__(Py.newInteger(12), Py.newInteger(14), null), pyFrame.getlocal(2).__getslice__(Py.newInteger(14), null, null)));
        pyFrame.f_lasti = -1;
        return object;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    public PyObject f$16(PyFrame pyFrame, ThreadState threadState) {
        block8: {
            PyObject pyObject;
            Object[] objectArray;
            PyObject pyObject2;
            block7: {
                switch (pyFrame.f_lasti) {
                    default: {
                        pyFrame.setline(553);
                        pyObject2 = pyFrame.getlocal(0).__iter__();
                        break;
                    }
                    case 1: {
                        objectArray = pyFrame.f_savedlocals;
                        pyObject2 = (PyObject)objectArray[3];
                        pyObject = (PyObject)objectArray[4];
                        Object object = pyFrame.getGeneratorInput();
                        if (object instanceof PyException) {
                            throw (Throwable)object;
                        }
                        PyObject cfr_ignored_0 = (PyObject)object;
                        break;
                    }
                }
                if (!true) break block7;
                pyFrame.setline(553);
                if ((pyObject = pyObject2.__iternext__()) == null) break block8;
            }
            do {
                pyFrame.setlocal(1, pyObject);
                pyFrame.setline(553);
                if (pyFrame.getlocal(1).__getattr__("isdigit").__call__(threadState).__nonzero__()) {
                    pyFrame.setline(553);
                    pyFrame.setline(553);
                    pyFrame.f_lasti = 1;
                    objectArray = new Object[5];
                    objectArray[3] = pyObject2;
                    objectArray[4] = pyObject;
                    pyFrame.f_savedlocals = objectArray;
                    return pyFrame.getlocal(1);
                }
                pyFrame.setline(553);
            } while ((pyObject = pyObject2.__iternext__()) != null);
        }
        pyFrame.f_lasti = -1;
        return Py.None;
    }

    public PyObject _need_to_handle_f_directive$17(PyFrame pyFrame, ThreadState threadState) {
        PyObject pyObject;
        pyFrame.setline(562);
        PyObject pyObject2 = pyFrame.getglobal("IRONPYTHON");
        if (pyObject2.__nonzero__()) {
            pyObject = PyString.fromInterned("%f");
            pyObject2 = pyObject._in(pyFrame.getlocal(1));
            pyObject = null;
        }
        pyObject = pyObject2;
        pyFrame.f_lasti = -1;
        return pyObject;
    }

    public PyObject _handle_un_supported_f_directive$18(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(565);
        Object object = pyFrame.getlocal(0).__getattr__("_remove_f_from_format").__call__(threadState, pyFrame.getlocal(2));
        pyFrame.setlocal(2, (PyObject)object);
        object = null;
        pyFrame.setline(566);
        object = pyFrame.getglobal("re").__getattr__("search").__call__(threadState, (PyObject)PyString.fromInterned("\\d+$"), pyFrame.getlocal(1));
        pyFrame.setlocal(3, (PyObject)object);
        object = null;
        pyFrame.setline(567);
        if (pyFrame.getlocal(3).__not__().__nonzero__()) {
            pyFrame.setline(568);
            throw Py.makeException(pyFrame.getglobal("ValueError").__call__(threadState, PyString.fromInterned("time data '%s' does not match format '%s%%f'.")._mod(new PyTuple(pyFrame.getlocal(1), pyFrame.getlocal(2)))));
        }
        pyFrame.setline(570);
        object = pyFrame.getlocal(3).__getattr__("group").__call__(threadState, (PyObject)Py.newInteger(0));
        pyFrame.setlocal(4, (PyObject)object);
        object = null;
        pyFrame.setline(571);
        object = pyFrame.getglobal("int").__call__(threadState, pyFrame.getlocal(4).__getattr__("ljust").__call__(threadState, (PyObject)Py.newInteger(6), (PyObject)PyString.fromInterned("0")));
        pyFrame.setlocal(5, (PyObject)object);
        object = null;
        pyFrame.setline(572);
        object = pyFrame.getglobal("datetime").__getattr__("strptime").__call__(threadState, pyFrame.getlocal(1).__getslice__(null, pyFrame.getglobal("len").__call__(threadState, pyFrame.getlocal(4)).__neg__(), null), pyFrame.getlocal(2));
        pyFrame.setlocal(6, (PyObject)object);
        object = null;
        pyFrame.setline(573);
        object = new PyObject[]{pyFrame.getlocal(5)};
        String[] stringArray = new String[]{"microsecond"};
        PyObject pyObject = pyFrame.getlocal(6).__getattr__("replace").__call__(threadState, (PyObject[])object, stringArray);
        object = null;
        object = pyObject;
        pyFrame.f_lasti = -1;
        return object;
    }

    public PyObject _remove_f_from_format$19(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(576);
        if (pyFrame.getlocal(1).__getattr__("endswith").__call__(threadState, (PyObject)PyString.fromInterned("%f")).__not__().__nonzero__()) {
            pyFrame.setline(577);
            throw Py.makeException(pyFrame.getglobal("ValueError").__call__(threadState, (PyObject)PyString.fromInterned("%f directive is supported only at the end of the format string on this Python interpreter.")));
        }
        pyFrame.setline(579);
        PyObject pyObject = pyFrame.getlocal(1).__getslice__(null, Py.newInteger(-2), null);
        pyFrame.f_lasti = -1;
        return pyObject;
    }

    public PyObject convert$20(PyFrame pyFrame, ThreadState threadState) {
        Object object;
        pyFrame.setline(582);
        Object object2 = pyFrame.getlocal(0).__getattr__("datetime");
        pyFrame.setlocal(3, (PyObject)object2);
        object2 = null;
        pyFrame.setline(583);
        if (pyFrame.getlocal(2).__not__().__nonzero__()) {
            pyFrame.setline(584);
            pyFrame.setline(584);
            object2 = pyFrame.getlocal(3).__getattr__("microsecond");
            PyObject pyObject = object2._ge(Py.newFloat(500000.0));
            object2 = null;
            object2 = pyObject.__nonzero__() ? Py.newInteger(1) : Py.newInteger(0);
            pyFrame.setlocal(4, (PyObject)object2);
            object2 = null;
            pyFrame.setline(585);
            object2 = new PyObject[]{Py.newInteger(0)};
            object = new String[]{"microsecond"};
            PyObject pyObject2 = pyFrame.getlocal(3).__getattr__("replace").__call__(threadState, (PyObject[])object2, (String[])object);
            object2 = null;
            object2 = new PyObject[]{pyFrame.getlocal(4)};
            object = new String[]{"seconds"};
            PyObject pyObject3 = pyFrame.getglobal("timedelta").__call__(threadState, (PyObject[])object2, (String[])object);
            object2 = null;
            object2 = pyObject2._add(pyObject3);
            pyFrame.setlocal(3, (PyObject)object2);
            object2 = null;
        }
        pyFrame.setline(586);
        object2 = PyString.fromInterned("%");
        PyObject pyObject = object2._in(pyFrame.getlocal(1));
        object2 = null;
        if (pyObject.__nonzero__()) {
            pyFrame.setline(587);
            object2 = pyFrame.getlocal(0).__getattr__("_convert_to_custom_timestamp").__call__(threadState, pyFrame.getlocal(3), pyFrame.getlocal(1));
            pyFrame.f_lasti = -1;
            return object2;
        }
        pyFrame.setline(588);
        object = pyFrame.getlocal(1).__getattr__("lower").__call__(threadState);
        pyFrame.setlocal(1, (PyObject)object);
        object = null;
        pyFrame.setline(589);
        object = pyFrame.getlocal(1);
        PyObject pyObject4 = ((PyObject)object)._eq(PyString.fromInterned("timestamp"));
        object = null;
        if (pyObject4.__nonzero__()) {
            pyFrame.setline(590);
            object2 = pyFrame.getlocal(0).__getattr__("_convert_to_timestamp").__call__(threadState, pyFrame.getlocal(3), pyFrame.getlocal(2));
            pyFrame.f_lasti = -1;
            return object2;
        }
        pyFrame.setline(591);
        object = pyFrame.getlocal(1);
        PyObject pyObject5 = ((PyObject)object)._eq(PyString.fromInterned("datetime"));
        object = null;
        if (pyObject5.__nonzero__()) {
            pyFrame.setline(592);
            object2 = pyFrame.getlocal(3);
            pyFrame.f_lasti = -1;
            return object2;
        }
        pyFrame.setline(593);
        object = pyFrame.getlocal(1);
        PyObject pyObject6 = ((PyObject)object)._eq(PyString.fromInterned("epoch"));
        object = null;
        if (pyObject6.__nonzero__()) {
            pyFrame.setline(594);
            object2 = pyFrame.getlocal(0).__getattr__("_convert_to_epoch").__call__(threadState, pyFrame.getlocal(3));
            pyFrame.f_lasti = -1;
            return object2;
        }
        pyFrame.setline(595);
        throw Py.makeException(pyFrame.getglobal("ValueError").__call__(threadState, PyString.fromInterned("Unknown format '%s'.")._mod(pyFrame.getlocal(1))));
    }

    public PyObject _convert_to_custom_timestamp$21(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(598);
        if (pyFrame.getlocal(0).__getattr__("_need_to_handle_f_directive").__call__(threadState, pyFrame.getlocal(2)).__not__().__nonzero__()) {
            pyFrame.setline(599);
            PyObject pyObject = pyFrame.getlocal(1).__getattr__("strftime").__call__(threadState, pyFrame.getlocal(2));
            pyFrame.f_lasti = -1;
            return pyObject;
        }
        pyFrame.setline(600);
        PyObject pyObject = pyFrame.getlocal(0).__getattr__("_remove_f_from_format").__call__(threadState, pyFrame.getlocal(2));
        pyFrame.setlocal(2, pyObject);
        pyObject = null;
        pyFrame.setline(601);
        PyObject pyObject2 = pyFrame.getlocal(1).__getattr__("strftime").__call__(threadState, pyFrame.getlocal(2))._add(PyString.fromInterned("%06d")._mod(pyFrame.getlocal(1).__getattr__("microsecond")));
        pyFrame.f_lasti = -1;
        return pyObject2;
    }

    public PyObject _convert_to_timestamp$22(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(604);
        if (pyFrame.getlocal(2).__not__().__nonzero__()) {
            pyFrame.setline(605);
            PyObject pyObject = pyFrame.getlocal(1).__getattr__("strftime").__call__(threadState, (PyObject)PyString.fromInterned("%Y-%m-%d %H:%M:%S"));
            pyFrame.f_lasti = -1;
            return pyObject;
        }
        pyFrame.setline(606);
        PyObject pyObject = pyFrame.getglobal("roundup").__call__(threadState, pyFrame.getlocal(1).__getattr__("microsecond")._div(Py.newFloat(1000.0)));
        pyFrame.setlocal(3, pyObject);
        pyObject = null;
        pyFrame.setline(607);
        pyObject = pyFrame.getlocal(3);
        PyObject pyObject2 = pyObject._eq(Py.newInteger(1000));
        pyObject = null;
        if (pyObject2.__nonzero__()) {
            pyFrame.setline(608);
            pyObject = pyFrame.getlocal(1);
            PyObject[] pyObjectArray = new PyObject[]{Py.newInteger(1)};
            String[] stringArray = new String[]{"seconds"};
            PyObject pyObject3 = pyFrame.getglobal("timedelta").__call__(threadState, pyObjectArray, stringArray);
            pyObjectArray = null;
            pyObject = pyObject._iadd(pyObject3);
            pyFrame.setlocal(1, pyObject);
            pyFrame.setline(609);
            pyObject = Py.newInteger(0);
            pyFrame.setlocal(3, pyObject);
            pyObject = null;
        }
        pyFrame.setline(610);
        PyObject pyObject4 = pyFrame.getlocal(1).__getattr__("strftime").__call__(threadState, (PyObject)PyString.fromInterned("%Y-%m-%d %H:%M:%S"))._add(PyString.fromInterned(".%03d")._mod(pyFrame.getlocal(3)));
        pyFrame.f_lasti = -1;
        return pyObject4;
    }

    public PyObject _convert_to_epoch$23(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(613);
        PyObject pyObject = pyFrame.getglobal("time").__getattr__("mktime").__call__(threadState, pyFrame.getlocal(1).__getattr__("timetuple").__call__(threadState))._add(pyFrame.getlocal(1).__getattr__("microsecond")._div(Py.newFloat(1000000.0)));
        pyFrame.f_lasti = -1;
        return pyObject;
    }

    public PyObject __add__$24(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(616);
        if (pyFrame.getglobal("isinstance").__call__(threadState, pyFrame.getlocal(1), pyFrame.getglobal("Time")).__nonzero__()) {
            pyFrame.setline(617);
            PyObject pyObject = pyFrame.getglobal("Date").__call__(threadState, pyFrame.getlocal(0).__getattr__("datetime")._add(pyFrame.getlocal(1).__getattr__("timedelta")));
            pyFrame.f_lasti = -1;
            return pyObject;
        }
        pyFrame.setline(618);
        throw Py.makeException(pyFrame.getglobal("TypeError").__call__(threadState, PyString.fromInterned("Can only add Time to Date, got %s.")._mod(pyFrame.getglobal("type_name").__call__(threadState, pyFrame.getlocal(1)))));
    }

    public PyObject __sub__$25(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(621);
        if (pyFrame.getglobal("isinstance").__call__(threadState, pyFrame.getlocal(1), pyFrame.getglobal("Date")).__nonzero__()) {
            pyFrame.setline(622);
            PyObject pyObject = pyFrame.getglobal("Time").__call__(threadState, pyFrame.getlocal(0).__getattr__("datetime")._sub(pyFrame.getlocal(1).__getattr__("datetime")));
            pyFrame.f_lasti = -1;
            return pyObject;
        }
        pyFrame.setline(623);
        if (pyFrame.getglobal("isinstance").__call__(threadState, pyFrame.getlocal(1), pyFrame.getglobal("Time")).__nonzero__()) {
            pyFrame.setline(624);
            PyObject pyObject = pyFrame.getglobal("Date").__call__(threadState, pyFrame.getlocal(0).__getattr__("datetime")._sub(pyFrame.getlocal(1).__getattr__("timedelta")));
            pyFrame.f_lasti = -1;
            return pyObject;
        }
        pyFrame.setline(625);
        throw Py.makeException(pyFrame.getglobal("TypeError").__call__(threadState, PyString.fromInterned("Can only subtract Date or Time from Date, got %s.")._mod(pyFrame.getglobal("type_name").__call__(threadState, pyFrame.getlocal(1)))));
    }

    public PyObject Time$26(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setlocal("__module__", pyFrame.getname("__name__"));
        pyFrame.setline(631);
        Object object = Py.EmptyObjects;
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, __init__$27, null);
        pyFrame.setlocal("__init__", (PyObject)object);
        object = null;
        pyFrame.setline(634);
        object = Py.EmptyObjects;
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, _convert_time_to_seconds$28, null);
        pyFrame.setlocal("_convert_time_to_seconds", (PyObject)object);
        object = null;
        pyFrame.setline(642);
        object = Py.EmptyObjects;
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, timedelta$29, null);
        object = pyFrame.getname("property").__call__(threadState, (PyObject)object);
        pyFrame.setlocal("timedelta", (PyObject)object);
        object = null;
        pyFrame.setline(646);
        object = new PyObject[]{pyFrame.getname("True")};
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, convert$30, null);
        pyFrame.setlocal("convert", (PyObject)object);
        object = null;
        pyFrame.setline(654);
        object = new PyObject[]{pyFrame.getname("True")};
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, _convert_to_number$31, null);
        pyFrame.setlocal("_convert_to_number", (PyObject)object);
        object = null;
        pyFrame.setline(657);
        object = new PyObject[]{pyFrame.getname("True")};
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, _convert_to_verbose$32, null);
        pyFrame.setlocal("_convert_to_verbose", (PyObject)object);
        object = null;
        pyFrame.setline(660);
        object = new PyObject[]{pyFrame.getname("True")};
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, _convert_to_compact$33, null);
        pyFrame.setlocal("_convert_to_compact", (PyObject)object);
        object = null;
        pyFrame.setline(663);
        object = new PyObject[]{pyFrame.getname("True")};
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, _convert_to_timer$34, null);
        pyFrame.setlocal("_convert_to_timer", (PyObject)object);
        object = null;
        pyFrame.setline(666);
        object = new PyObject[]{pyFrame.getname("True")};
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, _convert_to_timedelta$35, null);
        pyFrame.setlocal("_convert_to_timedelta", (PyObject)object);
        object = null;
        pyFrame.setline(669);
        object = Py.EmptyObjects;
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, __add__$36, null);
        pyFrame.setlocal("__add__", (PyObject)object);
        object = null;
        pyFrame.setline(674);
        object = Py.EmptyObjects;
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, __sub__$37, null);
        pyFrame.setlocal("__sub__", (PyObject)object);
        object = null;
        return pyFrame.getf_locals();
    }

    public PyObject __init__$27(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(632);
        PyObject pyObject = pyFrame.getglobal("float").__call__(threadState, pyFrame.getlocal(0).__getattr__("_convert_time_to_seconds").__call__(threadState, pyFrame.getlocal(1)));
        pyFrame.getlocal(0).__setattr__("seconds", pyObject);
        pyObject = null;
        pyFrame.f_lasti = -1;
        return Py.None;
    }

    public PyObject _convert_time_to_seconds$28(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(635);
        if (pyFrame.getglobal("isinstance").__call__(threadState, pyFrame.getlocal(1), pyFrame.getglobal("timedelta")).__nonzero__()) {
            pyFrame.setline(637);
            PyObject pyObject = pyFrame.getlocal(1).__getattr__("days")._mul(Py.newInteger(24))._mul(Py.newInteger(60))._mul(Py.newInteger(60))._add(pyFrame.getlocal(1).__getattr__("seconds"))._add(pyFrame.getlocal(1).__getattr__("microseconds")._div(Py.newFloat(1000000.0)));
            pyFrame.f_lasti = -1;
            return pyObject;
        }
        pyFrame.setline(640);
        PyObject[] pyObjectArray = new PyObject[]{pyFrame.getlocal(1), pyFrame.getglobal("None")};
        String[] stringArray = new String[]{"round_to"};
        PyObject pyObject = pyFrame.getglobal("timestr_to_secs").__call__(threadState, pyObjectArray, stringArray);
        pyObjectArray = null;
        PyObject pyObject2 = pyObject;
        pyFrame.f_lasti = -1;
        return pyObject2;
    }

    public PyObject timedelta$29(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(644);
        Object object = new PyObject[]{pyFrame.getlocal(0).__getattr__("seconds")};
        String[] stringArray = new String[]{"seconds"};
        PyObject pyObject = pyFrame.getglobal("timedelta").__call__(threadState, (PyObject[])object, stringArray);
        object = null;
        object = pyObject;
        pyFrame.f_lasti = -1;
        return object;
    }

    public PyObject convert$30(PyFrame pyFrame, ThreadState threadState) {
        PyObject pyObject;
        try {
            pyFrame.setline(648);
            pyObject = pyFrame.getglobal("getattr").__call__(threadState, pyFrame.getlocal(0), PyString.fromInterned("_convert_to_%s")._mod(pyFrame.getlocal(1).__getattr__("lower").__call__(threadState)));
            pyFrame.setlocal(3, pyObject);
            pyObject = null;
        }
        catch (Throwable throwable) {
            PyException pyException = Py.setException(throwable, pyFrame);
            if (pyException.match(pyFrame.getglobal("AttributeError"))) {
                pyFrame.setline(650);
                throw Py.makeException(pyFrame.getglobal("ValueError").__call__(threadState, PyString.fromInterned("Unknown format '%s'.")._mod(pyFrame.getlocal(1))));
            }
            throw pyException;
        }
        pyFrame.setline(651);
        pyFrame.setline(651);
        pyObject = pyFrame.getlocal(2).__nonzero__() ? pyFrame.getlocal(0).__getattr__("seconds") : pyFrame.getglobal("float").__call__(threadState, pyFrame.getglobal("roundup").__call__(threadState, pyFrame.getlocal(0).__getattr__("seconds")));
        pyFrame.setlocal(4, pyObject);
        pyObject = null;
        pyFrame.setline(652);
        pyObject = pyFrame.getlocal(3).__call__(threadState, pyFrame.getlocal(4), pyFrame.getlocal(2));
        pyFrame.f_lasti = -1;
        return pyObject;
    }

    public PyObject _convert_to_number$31(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(655);
        PyObject pyObject = pyFrame.getlocal(1);
        pyFrame.f_lasti = -1;
        return pyObject;
    }

    public PyObject _convert_to_verbose$32(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(658);
        PyObject pyObject = pyFrame.getglobal("secs_to_timestr").__call__(threadState, pyFrame.getlocal(1));
        pyFrame.f_lasti = -1;
        return pyObject;
    }

    public PyObject _convert_to_compact$33(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(661);
        Object object = new PyObject[]{pyFrame.getlocal(1), pyFrame.getglobal("True")};
        String[] stringArray = new String[]{"compact"};
        PyObject pyObject = pyFrame.getglobal("secs_to_timestr").__call__(threadState, (PyObject[])object, stringArray);
        object = null;
        object = pyObject;
        pyFrame.f_lasti = -1;
        return object;
    }

    public PyObject _convert_to_timer$34(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(664);
        Object object = new PyObject[]{pyFrame.getlocal(1)._mul(Py.newInteger(1000)), pyFrame.getlocal(2)};
        String[] stringArray = new String[]{"include_millis"};
        PyObject pyObject = pyFrame.getglobal("elapsed_time_to_string").__call__(threadState, (PyObject[])object, stringArray);
        object = null;
        object = pyObject;
        pyFrame.f_lasti = -1;
        return object;
    }

    public PyObject _convert_to_timedelta$35(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(667);
        Object object = new PyObject[]{pyFrame.getlocal(1)};
        String[] stringArray = new String[]{"seconds"};
        PyObject pyObject = pyFrame.getglobal("timedelta").__call__(threadState, (PyObject[])object, stringArray);
        object = null;
        object = pyObject;
        pyFrame.f_lasti = -1;
        return object;
    }

    public PyObject __add__$36(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(670);
        if (pyFrame.getglobal("isinstance").__call__(threadState, pyFrame.getlocal(1), pyFrame.getglobal("Time")).__nonzero__()) {
            pyFrame.setline(671);
            PyObject pyObject = pyFrame.getglobal("Time").__call__(threadState, pyFrame.getlocal(0).__getattr__("seconds")._add(pyFrame.getlocal(1).__getattr__("seconds")));
            pyFrame.f_lasti = -1;
            return pyObject;
        }
        pyFrame.setline(672);
        throw Py.makeException(pyFrame.getglobal("TypeError").__call__(threadState, PyString.fromInterned("Can only add Time to Time, got %s.")._mod(pyFrame.getglobal("type_name").__call__(threadState, pyFrame.getlocal(1)))));
    }

    public PyObject __sub__$37(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(675);
        if (pyFrame.getglobal("isinstance").__call__(threadState, pyFrame.getlocal(1), pyFrame.getglobal("Time")).__nonzero__()) {
            pyFrame.setline(676);
            PyObject pyObject = pyFrame.getglobal("Time").__call__(threadState, pyFrame.getlocal(0).__getattr__("seconds")._sub(pyFrame.getlocal(1).__getattr__("seconds")));
            pyFrame.f_lasti = -1;
            return pyObject;
        }
        pyFrame.setline(677);
        throw Py.makeException(pyFrame.getglobal("TypeError").__call__(threadState, PyString.fromInterned("Can only subtract Time from Time, got %s.")._mod(pyFrame.getglobal("type_name").__call__(threadState, pyFrame.getlocal(1)))));
    }

    public DateTime$py(String string2) {
        self = this;
        String[] stringArray = new String[]{};
        f$0 = Py.newCode(0, stringArray, string2, "<module>", 0, false, false, (PyFunctionTable)self, 0, null, null, 0, 4096);
        stringArray = new String[]{"time_zone", "increment", "result_format", "exclude_millis", "dt", "date"};
        get_current_date$1 = Py.newCode(4, stringArray, string2, "get_current_date", 322, false, false, (PyFunctionTable)self, 1, null, null, 0, 4097);
        stringArray = new String[]{"date", "result_format", "exclude_millis", "date_format"};
        convert_date$2 = Py.newCode(4, stringArray, string2, "convert_date", 358, false, false, (PyFunctionTable)self, 2, null, null, 0, 4097);
        stringArray = new String[]{"time", "result_format", "exclude_millis"};
        convert_time$3 = Py.newCode(3, stringArray, string2, "convert_time", 381, false, false, (PyFunctionTable)self, 3, null, null, 0, 4097);
        stringArray = new String[]{"date1", "date2", "result_format", "exclude_millis", "date1_format", "date2_format", "time"};
        subtract_date_from_date$4 = Py.newCode(6, stringArray, string2, "subtract_date_from_date", 401, false, false, (PyFunctionTable)self, 4, null, null, 0, 4097);
        stringArray = new String[]{"date", "time", "result_format", "exclude_millis", "date_format"};
        add_time_to_date$5 = Py.newCode(5, stringArray, string2, "add_time_to_date", 427, false, false, (PyFunctionTable)self, 5, null, null, 0, 4097);
        stringArray = new String[]{"date", "time", "result_format", "exclude_millis", "date_format"};
        subtract_time_from_date$6 = Py.newCode(5, stringArray, string2, "subtract_time_from_date", 451, false, false, (PyFunctionTable)self, 6, null, null, 0, 4097);
        stringArray = new String[]{"time1", "time2", "result_format", "exclude_millis", "time"};
        add_time_to_time$7 = Py.newCode(4, stringArray, string2, "add_time_to_time", 475, false, false, (PyFunctionTable)self, 7, null, null, 0, 4097);
        stringArray = new String[]{"time1", "time2", "result_format", "exclude_millis", "time"};
        subtract_time_from_time$8 = Py.newCode(4, stringArray, string2, "subtract_time_from_time", 496, false, false, (PyFunctionTable)self, 8, null, null, 0, 4097);
        stringArray = new String[]{};
        Date$9 = Py.newCode(0, stringArray, string2, "Date", 518, false, false, (PyFunctionTable)self, 9, null, null, 0, 4096);
        stringArray = new String[]{"self", "date", "input_format"};
        __init__$10 = Py.newCode(3, stringArray, string2, "__init__", 520, false, false, (PyFunctionTable)self, 10, null, null, 0, 4097);
        stringArray = new String[]{"self"};
        seconds$11 = Py.newCode(1, stringArray, string2, "seconds", 523, false, false, (PyFunctionTable)self, 11, null, null, 0, 4097);
        stringArray = new String[]{"self", "date", "input_format"};
        _convert_to_datetime$12 = Py.newCode(3, stringArray, string2, "_convert_to_datetime", 528, false, false, (PyFunctionTable)self, 12, null, null, 0, 4097);
        stringArray = new String[]{"self", "secs", "dt"};
        _seconds_to_datetime$13 = Py.newCode(2, stringArray, string2, "_seconds_to_datetime", 537, false, false, (PyFunctionTable)self, 13, null, null, 0, 4097);
        stringArray = new String[]{"self", "ts", "input_format"};
        _string_to_datetime$14 = Py.newCode(3, stringArray, string2, "_string_to_datetime", 544, false, false, (PyFunctionTable)self, 14, null, null, 0, 4097);
        stringArray = new String[]{"self", "date", "ts", "_(553_21)"};
        _normalize_timestamp$15 = Py.newCode(2, stringArray, string2, "_normalize_timestamp", 552, false, false, (PyFunctionTable)self, 15, null, null, 0, 4097);
        stringArray = new String[]{"_(x)", "d"};
        f$16 = Py.newCode(1, stringArray, string2, "<genexpr>", 553, false, false, (PyFunctionTable)self, 16, null, null, 0, 4129);
        stringArray = new String[]{"self", "format"};
        _need_to_handle_f_directive$17 = Py.newCode(2, stringArray, string2, "_need_to_handle_f_directive", 560, false, false, (PyFunctionTable)self, 17, null, null, 0, 4097);
        stringArray = new String[]{"self", "ts", "input_format", "match", "end_digits", "micro", "dt"};
        _handle_un_supported_f_directive$18 = Py.newCode(3, stringArray, string2, "_handle_un_supported_f_directive", 564, false, false, (PyFunctionTable)self, 18, null, null, 0, 4097);
        stringArray = new String[]{"self", "format"};
        _remove_f_from_format$19 = Py.newCode(2, stringArray, string2, "_remove_f_from_format", 575, false, false, (PyFunctionTable)self, 19, null, null, 0, 4097);
        stringArray = new String[]{"self", "format", "millis", "dt", "secs"};
        convert$20 = Py.newCode(3, stringArray, string2, "convert", 581, false, false, (PyFunctionTable)self, 20, null, null, 0, 4097);
        stringArray = new String[]{"self", "dt", "format"};
        _convert_to_custom_timestamp$21 = Py.newCode(3, stringArray, string2, "_convert_to_custom_timestamp", 597, false, false, (PyFunctionTable)self, 21, null, null, 0, 4097);
        stringArray = new String[]{"self", "dt", "millis", "ms"};
        _convert_to_timestamp$22 = Py.newCode(3, stringArray, string2, "_convert_to_timestamp", 603, false, false, (PyFunctionTable)self, 22, null, null, 0, 4097);
        stringArray = new String[]{"self", "dt"};
        _convert_to_epoch$23 = Py.newCode(2, stringArray, string2, "_convert_to_epoch", 612, false, false, (PyFunctionTable)self, 23, null, null, 0, 4097);
        stringArray = new String[]{"self", "other"};
        __add__$24 = Py.newCode(2, stringArray, string2, "__add__", 615, false, false, (PyFunctionTable)self, 24, null, null, 0, 4097);
        stringArray = new String[]{"self", "other"};
        __sub__$25 = Py.newCode(2, stringArray, string2, "__sub__", 620, false, false, (PyFunctionTable)self, 25, null, null, 0, 4097);
        stringArray = new String[]{};
        Time$26 = Py.newCode(0, stringArray, string2, "Time", 629, false, false, (PyFunctionTable)self, 26, null, null, 0, 4096);
        stringArray = new String[]{"self", "time"};
        __init__$27 = Py.newCode(2, stringArray, string2, "__init__", 631, false, false, (PyFunctionTable)self, 27, null, null, 0, 4097);
        stringArray = new String[]{"self", "time"};
        _convert_time_to_seconds$28 = Py.newCode(2, stringArray, string2, "_convert_time_to_seconds", 634, false, false, (PyFunctionTable)self, 28, null, null, 0, 4097);
        stringArray = new String[]{"self"};
        timedelta$29 = Py.newCode(1, stringArray, string2, "timedelta", 642, false, false, (PyFunctionTable)self, 29, null, null, 0, 4097);
        stringArray = new String[]{"self", "format", "millis", "result_converter", "seconds"};
        convert$30 = Py.newCode(3, stringArray, string2, "convert", 646, false, false, (PyFunctionTable)self, 30, null, null, 0, 4097);
        stringArray = new String[]{"self", "seconds", "millis"};
        _convert_to_number$31 = Py.newCode(3, stringArray, string2, "_convert_to_number", 654, false, false, (PyFunctionTable)self, 31, null, null, 0, 4097);
        stringArray = new String[]{"self", "seconds", "millis"};
        _convert_to_verbose$32 = Py.newCode(3, stringArray, string2, "_convert_to_verbose", 657, false, false, (PyFunctionTable)self, 32, null, null, 0, 4097);
        stringArray = new String[]{"self", "seconds", "millis"};
        _convert_to_compact$33 = Py.newCode(3, stringArray, string2, "_convert_to_compact", 660, false, false, (PyFunctionTable)self, 33, null, null, 0, 4097);
        stringArray = new String[]{"self", "seconds", "millis"};
        _convert_to_timer$34 = Py.newCode(3, stringArray, string2, "_convert_to_timer", 663, false, false, (PyFunctionTable)self, 34, null, null, 0, 4097);
        stringArray = new String[]{"self", "seconds", "millis"};
        _convert_to_timedelta$35 = Py.newCode(3, stringArray, string2, "_convert_to_timedelta", 666, false, false, (PyFunctionTable)self, 35, null, null, 0, 4097);
        stringArray = new String[]{"self", "other"};
        __add__$36 = Py.newCode(2, stringArray, string2, "__add__", 669, false, false, (PyFunctionTable)self, 36, null, null, 0, 4097);
        stringArray = new String[]{"self", "other"};
        __sub__$37 = Py.newCode(2, stringArray, string2, "__sub__", 674, false, false, (PyFunctionTable)self, 37, null, null, 0, 4097);
    }

    public PyCode getMain() {
        return f$0;
    }

    public static void main(String[] stringArray) {
        Py.runMain(CodeLoader.createSimpleBootstrap(new DateTime$py("robot/libraries/DateTime$py").getMain()), stringArray);
    }

    public static CodeBootstrap getCodeBootstrap() {
        return PyRunnableBootstrap.getFilenameConstructorReflectionBootstrap(DateTime$py.class);
    }

    public PyObject call_function(int n, PyFrame pyFrame, ThreadState threadState) {
        DateTime$py dateTime$py = this;
        PyFrame pyFrame2 = pyFrame;
        ThreadState threadState2 = threadState;
        switch (n) {
            case 0: {
                return dateTime$py.f$0(pyFrame2, threadState2);
            }
            case 1: {
                return dateTime$py.get_current_date$1(pyFrame2, threadState2);
            }
            case 2: {
                return dateTime$py.convert_date$2(pyFrame2, threadState2);
            }
            case 3: {
                return dateTime$py.convert_time$3(pyFrame2, threadState2);
            }
            case 4: {
                return dateTime$py.subtract_date_from_date$4(pyFrame2, threadState2);
            }
            case 5: {
                return dateTime$py.add_time_to_date$5(pyFrame2, threadState2);
            }
            case 6: {
                return dateTime$py.subtract_time_from_date$6(pyFrame2, threadState2);
            }
            case 7: {
                return dateTime$py.add_time_to_time$7(pyFrame2, threadState2);
            }
            case 8: {
                return dateTime$py.subtract_time_from_time$8(pyFrame2, threadState2);
            }
            case 9: {
                return dateTime$py.Date$9(pyFrame2, threadState2);
            }
            case 10: {
                return dateTime$py.__init__$10(pyFrame2, threadState2);
            }
            case 11: {
                return dateTime$py.seconds$11(pyFrame2, threadState2);
            }
            case 12: {
                return dateTime$py._convert_to_datetime$12(pyFrame2, threadState2);
            }
            case 13: {
                return dateTime$py._seconds_to_datetime$13(pyFrame2, threadState2);
            }
            case 14: {
                return dateTime$py._string_to_datetime$14(pyFrame2, threadState2);
            }
            case 15: {
                return dateTime$py._normalize_timestamp$15(pyFrame2, threadState2);
            }
            case 16: {
                return dateTime$py.f$16(pyFrame2, threadState2);
            }
            case 17: {
                return dateTime$py._need_to_handle_f_directive$17(pyFrame2, threadState2);
            }
            case 18: {
                return dateTime$py._handle_un_supported_f_directive$18(pyFrame2, threadState2);
            }
            case 19: {
                return dateTime$py._remove_f_from_format$19(pyFrame2, threadState2);
            }
            case 20: {
                return dateTime$py.convert$20(pyFrame2, threadState2);
            }
            case 21: {
                return dateTime$py._convert_to_custom_timestamp$21(pyFrame2, threadState2);
            }
            case 22: {
                return dateTime$py._convert_to_timestamp$22(pyFrame2, threadState2);
            }
            case 23: {
                return dateTime$py._convert_to_epoch$23(pyFrame2, threadState2);
            }
            case 24: {
                return dateTime$py.__add__$24(pyFrame2, threadState2);
            }
            case 25: {
                return dateTime$py.__sub__$25(pyFrame2, threadState2);
            }
            case 26: {
                return dateTime$py.Time$26(pyFrame2, threadState2);
            }
            case 27: {
                return dateTime$py.__init__$27(pyFrame2, threadState2);
            }
            case 28: {
                return dateTime$py._convert_time_to_seconds$28(pyFrame2, threadState2);
            }
            case 29: {
                return dateTime$py.timedelta$29(pyFrame2, threadState2);
            }
            case 30: {
                return dateTime$py.convert$30(pyFrame2, threadState2);
            }
            case 31: {
                return dateTime$py._convert_to_number$31(pyFrame2, threadState2);
            }
            case 32: {
                return dateTime$py._convert_to_verbose$32(pyFrame2, threadState2);
            }
            case 33: {
                return dateTime$py._convert_to_compact$33(pyFrame2, threadState2);
            }
            case 34: {
                return dateTime$py._convert_to_timer$34(pyFrame2, threadState2);
            }
            case 35: {
                return dateTime$py._convert_to_timedelta$35(pyFrame2, threadState2);
            }
            case 36: {
                return dateTime$py.__add__$36(pyFrame2, threadState2);
            }
            case 37: {
                return dateTime$py.__sub__$37(pyFrame2, threadState2);
            }
        }
        return null;
    }
}

