/*
 * Decompiled with CFR 0.152.
 */
package robot.libraries;

import java.util.Arrays;
import org.python.compiler.APIVersion;
import org.python.compiler.Filename;
import org.python.compiler.MTime;
import org.python.core.CodeBootstrap;
import org.python.core.CodeLoader;
import org.python.core.Py;
import org.python.core.PyCode;
import org.python.core.PyDictionary;
import org.python.core.PyException;
import org.python.core.PyFrame;
import org.python.core.PyFunction;
import org.python.core.PyFunctionTable;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyRunnable;
import org.python.core.PyRunnableBootstrap;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.ThreadState;
import org.python.core.imp;

@APIVersion(value=36)
@MTime(value=1487348830000L)
@Filename(value="/Users/jmalinen/Documents/workspace/robotframework/build/Lib/robot/libraries/String.py")
public class String$py
extends PyFunctionTable
implements PyRunnable {
    static String$py self;
    static final PyCode f$0;
    static final PyCode String$1;
    static final PyCode convert_to_lowercase$2;
    static final PyCode convert_to_uppercase$3;
    static final PyCode encode_string_to_bytes$4;
    static final PyCode decode_bytes_to_string$5;
    static final PyCode get_line_count$6;
    static final PyCode split_to_lines$7;
    static final PyCode get_line$8;
    static final PyCode get_lines_containing_string$9;
    static final PyCode f$10;
    static final PyCode f$11;
    static final PyCode get_lines_matching_pattern$12;
    static final PyCode f$13;
    static final PyCode f$14;
    static final PyCode get_lines_matching_regexp$15;
    static final PyCode _get_matching_lines$16;
    static final PyCode get_regexp_matches$17;
    static final PyCode _parse_group$18;
    static final PyCode replace_string$19;
    static final PyCode replace_string_using_regexp$20;
    static final PyCode remove_string$21;
    static final PyCode remove_string_using_regexp$22;
    static final PyCode split_string$23;
    static final PyCode split_string_from_right$24;
    static final PyCode split_string_to_characters$25;
    static final PyCode fetch_from_left$26;
    static final PyCode fetch_from_right$27;
    static final PyCode generate_random_string$28;
    static final PyCode f$29;
    static final PyCode get_substring$30;
    static final PyCode strip_string$31;
    static final PyCode f$32;
    static final PyCode should_be_string$33;
    static final PyCode should_not_be_string$34;
    static final PyCode should_be_unicode_string$35;
    static final PyCode should_be_byte_string$36;
    static final PyCode should_be_lowercase$37;
    static final PyCode should_be_uppercase$38;
    static final PyCode should_be_titlecase$39;
    static final PyCode _convert_to_index$40;
    static final PyCode _convert_to_integer$41;
    static final PyCode _fail$42;
    static final PyCode f$43;

    public PyObject f$0(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(16);
        Object[] objectArray = imp.importOne("re", pyFrame, -1);
        pyFrame.setlocal("re", (PyObject)objectArray);
        objectArray = null;
        pyFrame.setline(17);
        objectArray = new String[]{"fnmatchcase"};
        objectArray = imp.importFrom("fnmatch", (String[])objectArray, pyFrame, -1);
        Object object = objectArray[0];
        pyFrame.setlocal("fnmatchcase", (PyObject)object);
        object = null;
        pyFrame.setline(18);
        objectArray = new String[]{"randint"};
        objectArray = imp.importFrom("random", (String[])objectArray, pyFrame, -1);
        object = objectArray[0];
        pyFrame.setlocal("randint", (PyObject)object);
        object = null;
        pyFrame.setline(19);
        objectArray = new String[]{"ascii_lowercase", "ascii_uppercase", "digits"};
        objectArray = imp.importFrom("string", (String[])objectArray, pyFrame, -1);
        object = objectArray[0];
        pyFrame.setlocal("ascii_lowercase", (PyObject)object);
        object = null;
        object = objectArray[1];
        pyFrame.setlocal("ascii_uppercase", (PyObject)object);
        object = null;
        object = objectArray[2];
        pyFrame.setlocal("digits", (PyObject)object);
        object = null;
        pyFrame.setline(21);
        objectArray = new String[]{"logger"};
        objectArray = imp.importFrom("robot.api", (String[])objectArray, pyFrame, -1);
        object = objectArray[0];
        pyFrame.setlocal("logger", (PyObject)object);
        object = null;
        pyFrame.setline(22);
        objectArray = new String[]{"is_bytes", "is_string", "is_truthy", "is_unicode", "lower", "unic", "PY3"};
        objectArray = imp.importFrom("robot.utils", (String[])objectArray, pyFrame, -1);
        object = objectArray[0];
        pyFrame.setlocal("is_bytes", (PyObject)object);
        object = null;
        object = objectArray[1];
        pyFrame.setlocal("is_string", (PyObject)object);
        object = null;
        object = objectArray[2];
        pyFrame.setlocal("is_truthy", (PyObject)object);
        object = null;
        object = objectArray[3];
        pyFrame.setlocal("is_unicode", (PyObject)object);
        object = null;
        object = objectArray[4];
        pyFrame.setlocal("lower", (PyObject)object);
        object = null;
        object = objectArray[5];
        pyFrame.setlocal("unic", (PyObject)object);
        object = null;
        object = objectArray[6];
        pyFrame.setlocal("PY3", (PyObject)object);
        object = null;
        pyFrame.setline(24);
        objectArray = new String[]{"get_version"};
        objectArray = imp.importFrom("robot.version", (String[])objectArray, pyFrame, -1);
        object = objectArray[0];
        pyFrame.setlocal("get_version", (PyObject)object);
        object = null;
        pyFrame.setline(27);
        objectArray = new PyObject[]{pyFrame.getname("object")};
        object = Py.makeClass("String", (PyObject[])objectArray, String$1);
        pyFrame.setlocal("String", (PyObject)object);
        object = null;
        Arrays.fill(objectArray, null);
        pyFrame.f_lasti = -1;
        return Py.None;
    }

    public PyObject String$1(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setlocal("__module__", pyFrame.getname("__name__"));
        pyFrame.setlocal("__doc__", (PyObject)PyString.fromInterned("A test library for string manipulation and verification.\n\n    ``String`` is Robot Framework's standard library for manipulating\n    strings (e.g. `Replace String Using Regexp`, `Split To Lines`) and\n    verifying their contents (e.g. `Should Be String`).\n\n    Following keywords from ``BuiltIn`` library can also be used with strings:\n\n    - `Catenate`\n    - `Get Length`\n    - `Length Should Be`\n    - `Should (Not) Be Empty`\n    - `Should (Not) Be Equal (As Strings/Integers/Numbers)`\n    - `Should (Not) Match (Regexp)`\n    - `Should (Not) Contain`\n    - `Should (Not) Start With`\n    - `Should (Not) End With`\n    - `Convert To String`\n    - `Convert To Bytes`\n    "));
        pyFrame.setline(47);
        PyString.fromInterned("A test library for string manipulation and verification.\n\n    ``String`` is Robot Framework's standard library for manipulating\n    strings (e.g. `Replace String Using Regexp`, `Split To Lines`) and\n    verifying their contents (e.g. `Should Be String`).\n\n    Following keywords from ``BuiltIn`` library can also be used with strings:\n\n    - `Catenate`\n    - `Get Length`\n    - `Length Should Be`\n    - `Should (Not) Be Empty`\n    - `Should (Not) Be Equal (As Strings/Integers/Numbers)`\n    - `Should (Not) Match (Regexp)`\n    - `Should (Not) Contain`\n    - `Should (Not) Start With`\n    - `Should (Not) End With`\n    - `Convert To String`\n    - `Convert To Bytes`\n    ");
        pyFrame.setline(48);
        Object object = PyString.fromInterned("GLOBAL");
        pyFrame.setlocal("ROBOT_LIBRARY_SCOPE", (PyObject)object);
        object = null;
        pyFrame.setline(49);
        object = pyFrame.getname("get_version").__call__(threadState);
        pyFrame.setlocal("ROBOT_LIBRARY_VERSION", (PyObject)object);
        object = null;
        pyFrame.setline(51);
        object = Py.EmptyObjects;
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, convert_to_lowercase$2, PyString.fromInterned("Converts string to lowercase.\n\n        Examples:\n        | ${str1} = | Convert To Lowercase | ABC |\n        | ${str2} = | Convert To Lowercase | 1A2c3D |\n        | Should Be Equal | ${str1} | abc |\n        | Should Be Equal | ${str2} | 1a2c3d |\n\n        New in Robot Framework 2.8.6.\n        "));
        pyFrame.setlocal("convert_to_lowercase", (PyObject)object);
        object = null;
        pyFrame.setline(66);
        object = Py.EmptyObjects;
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, convert_to_uppercase$3, PyString.fromInterned("Converts string to uppercase.\n\n        Examples:\n        | ${str1} = | Convert To Uppercase | abc |\n        | ${str2} = | Convert To Uppercase | 1a2C3d |\n        | Should Be Equal | ${str1} | ABC |\n        | Should Be Equal | ${str2} | 1A2C3D |\n\n        New in Robot Framework 2.8.6.\n        "));
        pyFrame.setlocal("convert_to_uppercase", (PyObject)object);
        object = null;
        pyFrame.setline(79);
        object = new PyObject[]{PyString.fromInterned("strict")};
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, encode_string_to_bytes$4, PyString.fromInterned("Encodes the given Unicode ``string`` to bytes using the given ``encoding``.\n\n        ``errors`` argument controls what to do if encoding some characters fails.\n        All values accepted by ``encode`` method in Python are valid, but in\n        practice the following values are most useful:\n\n        - ``strict``: fail if characters cannot be encoded (default)\n        - ``ignore``: ignore characters that cannot be encoded\n        - ``replace``: replace characters that cannot be encoded with\n          a replacement character\n\n        Examples:\n        | ${bytes} = | Encode String To Bytes | ${string} | UTF-8 |\n        | ${bytes} = | Encode String To Bytes | ${string} | ASCII | errors=ignore |\n\n        Use `Convert To Bytes` in ``BuiltIn`` if you want to create bytes based\n        on character or integer sequences. Use `Decode Bytes To String` if you\n        need to convert byte strings to Unicode strings and `Convert To String`\n        in ``BuiltIn`` if you need to convert arbitrary objects to Unicode.\n        "));
        pyFrame.setlocal("encode_string_to_bytes", (PyObject)object);
        object = null;
        pyFrame.setline(102);
        object = new PyObject[]{PyString.fromInterned("strict")};
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, decode_bytes_to_string$5, PyString.fromInterned("Decodes the given ``bytes`` to a Unicode string using the given ``encoding``.\n\n        ``errors`` argument controls what to do if decoding some bytes fails.\n        All values accepted by ``decode`` method in Python are valid, but in\n        practice the following values are most useful:\n\n        - ``strict``: fail if characters cannot be decoded (default)\n        - ``ignore``: ignore characters that cannot be decoded\n        - ``replace``: replace characters that cannot be decoded with\n          a replacement character\n\n        Examples:\n        | ${string} = | Decode Bytes To String | ${bytes} | UTF-8 |\n        | ${string} = | Decode Bytes To String | ${bytes} | ASCII | errors=ignore |\n\n        Use `Encode String To Bytes` if you need to convert Unicode strings to\n        byte strings, and `Convert To String` in ``BuiltIn`` if you need to\n        convert arbitrary objects to Unicode strings.\n        "));
        pyFrame.setlocal("decode_bytes_to_string", (PyObject)object);
        object = null;
        pyFrame.setline(126);
        object = Py.EmptyObjects;
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, get_line_count$6, PyString.fromInterned("Returns and logs the number of lines in the given string."));
        pyFrame.setlocal("get_line_count", (PyObject)object);
        object = null;
        pyFrame.setline(132);
        object = new PyObject[]{Py.newInteger(0), pyFrame.getname("None")};
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, split_to_lines$7, PyString.fromInterned("Splits the given string to lines.\n\n        It is possible to get only a selection of lines from ``start``\n        to ``end`` so that ``start`` index is inclusive and ``end`` is\n        exclusive. Line numbering starts from 0, and it is possible to\n        use negative indices to refer to lines from the end.\n\n        Lines are returned without the newlines. The number of\n        returned lines is automatically logged.\n\n        Examples:\n        | @{lines} =        | Split To Lines | ${manylines} |    |    |\n        | @{ignore first} = | Split To Lines | ${manylines} | 1  |    |\n        | @{ignore last} =  | Split To Lines | ${manylines} |    | -1 |\n        | @{5th to 10th} =  | Split To Lines | ${manylines} | 4  | 10 |\n        | @{first two} =    | Split To Lines | ${manylines} |    | 1  |\n        | @{last two} =     | Split To Lines | ${manylines} | -2 |    |\n\n        Use `Get Line` if you only need to get a single line.\n        "));
        pyFrame.setlocal("split_to_lines", (PyObject)object);
        object = null;
        pyFrame.setline(159);
        object = Py.EmptyObjects;
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, get_line$8, PyString.fromInterned("Returns the specified line from the given ``string``.\n\n        Line numbering starts from 0 and it is possible to use\n        negative indices to refer to lines from the end. The line is\n        returned without the newline character.\n\n        Examples:\n        | ${first} =    | Get Line | ${string} | 0  |\n        | ${2nd last} = | Get Line | ${string} | -2 |\n\n        Use `Split To Lines` if all lines are needed.\n        "));
        pyFrame.setlocal("get_line", (PyObject)object);
        object = null;
        pyFrame.setline(175);
        object = new PyObject[]{pyFrame.getname("False")};
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, get_lines_containing_string$9, PyString.fromInterned("Returns lines of the given ``string`` that contain the ``pattern``.\n\n        The ``pattern`` is always considered to be a normal string, not a glob\n        or regexp pattern. A line matches if the ``pattern`` is found anywhere\n        on it.\n\n        The match is case-sensitive by default, but giving ``case_insensitive``\n        a true value makes it case-insensitive. The value is considered true\n        if it is a non-empty string that is not equal to ``false`` or ``no``.\n        If the value is not a string, its truth value is got directly in Python.\n\n        Lines are returned as one string catenated back together with\n        newlines. Possible trailing newline is never returned. The\n        number of matching lines is automatically logged.\n\n        Examples:\n        | ${lines} = | Get Lines Containing String | ${result} | An example |\n        | ${ret} =   | Get Lines Containing String | ${ret} | FAIL | case-insensitive |\n\n        See `Get Lines Matching Pattern` and `Get Lines Matching Regexp`\n        if you need more complex pattern matching.\n        "));
        pyFrame.setlocal("get_lines_containing_string", (PyObject)object);
        object = null;
        pyFrame.setline(205);
        object = new PyObject[]{pyFrame.getname("False")};
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, get_lines_matching_pattern$12, PyString.fromInterned("Returns lines of the given ``string`` that match the ``pattern``.\n\n        The ``pattern`` is a _glob pattern_ where:\n        | ``*``        | matches everything |\n        | ``?``        | matches any single character |\n        | ``[chars]``  | matches any character inside square brackets (e.g. ``[abc]`` matches either ``a``, ``b`` or ``c``) |\n        | ``[!chars]`` | matches any character not inside square brackets |\n\n        A line matches only if it matches the ``pattern`` fully.\n\n        The match is case-sensitive by default, but giving ``case_insensitive``\n        a true value makes it case-insensitive. The value is considered true\n        if it is a non-empty string that is not equal to ``false`` or ``no``.\n        If the value is not a string, its truth value is got directly in Python.\n\n        Lines are returned as one string catenated back together with\n        newlines. Possible trailing newline is never returned. The\n        number of matching lines is automatically logged.\n\n        Examples:\n        | ${lines} = | Get Lines Matching Pattern | ${result} | Wild???? example |\n        | ${ret} = | Get Lines Matching Pattern | ${ret} | FAIL: * | case_insensitive=true |\n\n        See `Get Lines Matching Regexp` if you need more complex\n        patterns and `Get Lines Containing String` if searching\n        literal strings is enough.\n        "));
        pyFrame.setlocal("get_lines_matching_pattern", (PyObject)object);
        object = null;
        pyFrame.setline(240);
        object = new PyObject[]{pyFrame.getname("False")};
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, get_lines_matching_regexp$15, PyString.fromInterned("Returns lines of the given ``string`` that match the regexp ``pattern``.\n\n        See `BuiltIn.Should Match Regexp` for more information about\n        Python regular expression syntax in general and how to use it\n        in Robot Framework test data in particular.\n\n        By default lines match only if they match the pattern fully, but\n        partial matching can be enabled by giving the ``partial_match``\n        argument a true value. The value is considered true if it is a\n        non-empty string that is not equal to ``false`` or ``no``. If the\n        value is not a string, its truth value is got directly in Python.\n\n        If the pattern is empty, it matches only empty lines by default.\n        When partial matching is enabled, empty pattern matches all lines.\n\n        Notice that to make the match case-insensitive, you need to prefix\n        the pattern with case-insensitive flag ``(?i)``.\n\n        Lines are returned as one string concatenated back together with\n        newlines. Possible trailing newline is never returned. The\n        number of matching lines is automatically logged.\n\n        Examples:\n        | ${lines} = | Get Lines Matching Regexp | ${result} | Reg\\\\w{3} example |\n        | ${lines} = | Get Lines Matching Regexp | ${result} | Reg\\\\w{3} example | partial_match=true |\n        | ${ret} =   | Get Lines Matching Regexp | ${ret}    | (?i)FAIL: .* |\n\n        See `Get Lines Matching Pattern` and `Get Lines Containing\n        String` if you do not need full regular expression powers (and\n        complexity).\n\n        ``partial_match`` argument is new in Robot Framework 2.9. In earlier\n         versions exact match was always required.\n        "));
        pyFrame.setlocal("get_lines_matching_regexp", (PyObject)object);
        object = null;
        pyFrame.setline(279);
        object = Py.EmptyObjects;
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, _get_matching_lines$16, null);
        pyFrame.setlocal("_get_matching_lines", (PyObject)object);
        object = null;
        pyFrame.setline(285);
        object = Py.EmptyObjects;
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, get_regexp_matches$17, PyString.fromInterned("Returns a list of all non-overlapping matches in the given string.\n\n        ``string`` is the string to find matches from and ``pattern`` is the\n        regular expression. See `BuiltIn.Should Match Regexp` for more\n        information about Python regular expression syntax in general and how\n        to use it in Robot Framework test data in particular.\n\n        If no groups are used, the returned list contains full matches. If one\n        group is used, the list contains only contents of that group. If\n        multiple groups are used, the list contains tuples that contain\n        individual group contents. All groups can be given as indexes (starting\n        from 1) and named groups also as names.\n\n        Examples:\n        | ${no match} =    | Get Regexp Matches | the string | xxx     |\n        | ${matches} =     | Get Regexp Matches | the string | t..     |\n        | ${one group} =   | Get Regexp Matches | the string | t(..)   | 1 |\n        | ${named group} = | Get Regexp Matches | the string | t(?P<name>..) | name |\n        | ${two groups} =  | Get Regexp Matches | the string | t(.)(.) | 1 | 2 |\n        =>\n        | ${no match} = []\n        | ${matches} = ['the', 'tri']\n        | ${one group} = ['he', 'ri']\n        | ${named group} = ['he', 'ri']\n        | ${two groups} = [('h', 'e'), ('r', 'i')]\n\n        New in Robot Framework 2.9.\n        "));
        pyFrame.setlocal("get_regexp_matches", (PyObject)object);
        object = null;
        pyFrame.setline(318);
        object = Py.EmptyObjects;
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, _parse_group$18, null);
        pyFrame.setlocal("_parse_group", (PyObject)object);
        object = null;
        pyFrame.setline(324);
        object = new PyObject[]{Py.newInteger(-1)};
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, replace_string$19, PyString.fromInterned("Replaces ``search_for`` in the given ``string`` with ``replace_with``.\n\n        ``search_for`` is used as a literal string. See `Replace String\n        Using Regexp` if more powerful pattern matching is needed.\n        If you need to just remove a string see `Remove String`.\n\n        If the optional argument ``count`` is given, only that many\n        occurrences from left are replaced. Negative ``count`` means\n        that all occurrences are replaced (default behaviour) and zero\n        means that nothing is done.\n\n        A modified version of the string is returned and the original\n        string is not altered.\n\n        Examples:\n        | ${str} =        | Replace String | Hello, world!  | world | tellus   |\n        | Should Be Equal | ${str}         | Hello, tellus! |       |          |\n        | ${str} =        | Replace String | Hello, world!  | l     | ${EMPTY} | count=1 |\n        | Should Be Equal | ${str}         | Helo, world!   |       |          |\n        "));
        pyFrame.setlocal("replace_string", (PyObject)object);
        object = null;
        pyFrame.setline(348);
        object = new PyObject[]{Py.newInteger(-1)};
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, replace_string_using_regexp$20, PyString.fromInterned("Replaces ``pattern`` in the given ``string`` with ``replace_with``.\n\n        This keyword is otherwise identical to `Replace String`, but\n        the ``pattern`` to search for is considered to be a regular\n        expression.  See `BuiltIn.Should Match Regexp` for more\n        information about Python regular expression syntax in general\n        and how to use it in Robot Framework test data in particular.\n\n        If you need to just remove a string see `Remove String Using Regexp`.\n\n        Examples:\n        | ${str} = | Replace String Using Regexp | ${str} | 20\\\\d\\\\d-\\\\d\\\\d-\\\\d\\\\d | <DATE> |\n        | ${str} = | Replace String Using Regexp | ${str} | (Hello|Hi) | ${EMPTY} | count=1 |\n        "));
        pyFrame.setlocal("replace_string_using_regexp", (PyObject)object);
        object = null;
        pyFrame.setline(369);
        object = Py.EmptyObjects;
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, remove_string$21, PyString.fromInterned("Removes all ``removables`` from the given ``string``.\n\n        ``removables`` are used as literal strings. Each removable will be\n        matched to a temporary string from which preceding removables have\n        been already removed. See second example below.\n\n        Use `Remove String Using Regexp` if more powerful pattern matching is\n        needed. If only a certain number of matches should be removed,\n        `Replace String` or `Replace String Using Regexp` can be used.\n\n        A modified version of the string is returned and the original\n        string is not altered.\n\n        Examples:\n        | ${str} =        | Remove String | Robot Framework | work   |\n        | Should Be Equal | ${str}        | Robot Frame     |\n        | ${str} =        | Remove String | Robot Framework | o | bt |\n        | Should Be Equal | ${str}        | R Framewrk      |\n\n        New in Robot Framework 2.8.2.\n        "));
        pyFrame.setlocal("remove_string", (PyObject)object);
        object = null;
        pyFrame.setline(395);
        object = Py.EmptyObjects;
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, remove_string_using_regexp$22, PyString.fromInterned("Removes ``patterns`` from the given ``string``.\n\n        This keyword is otherwise identical to `Remove String`, but\n        the ``patterns`` to search for are considered to be a regular\n        expression. See `Replace String Using Regexp` for more information\n        about the regular expression syntax. That keyword can also be\n        used if there is a need to remove only a certain number of\n        occurrences.\n\n        New in Robot Framework 2.8.2.\n        "));
        pyFrame.setlocal("remove_string_using_regexp", (PyObject)object);
        object = null;
        pyFrame.setline(411);
        object = new PyObject[]{pyFrame.getname("None"), Py.newInteger(-1)};
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, split_string$23, PyString.fromInterned("Splits the ``string`` using ``separator`` as a delimiter string.\n\n        If a ``separator`` is not given, any whitespace string is a\n        separator. In that case also possible consecutive whitespace\n        as well as leading and trailing whitespace is ignored.\n\n        Split words are returned as a list. If the optional\n        ``max_split`` is given, at most ``max_split`` splits are done, and\n        the returned list will have maximum ``max_split + 1`` elements.\n\n        Examples:\n        | @{words} =         | Split String | ${string} |\n        | @{words} =         | Split String | ${string} | ,${SPACE} |\n        | ${pre} | ${post} = | Split String | ${string} | ::    | 1 |\n\n        See `Split String From Right` if you want to start splitting\n        from right, and `Fetch From Left` and `Fetch From Right` if\n        you only want to get first/last part of the string.\n        "));
        pyFrame.setlocal("split_string", (PyObject)object);
        object = null;
        pyFrame.setline(436);
        object = new PyObject[]{pyFrame.getname("None"), Py.newInteger(-1)};
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, split_string_from_right$24, PyString.fromInterned("Splits the ``string`` using ``separator`` starting from right.\n\n        Same as `Split String`, but splitting is started from right. This has\n        an effect only when ``max_split`` is given.\n\n        Examples:\n        | ${first} | ${rest} = | Split String            | ${string} | - | 1 |\n        | ${rest}  | ${last} = | Split String From Right | ${string} | - | 1 |\n        "));
        pyFrame.setlocal("split_string_from_right", (PyObject)object);
        object = null;
        pyFrame.setline(451);
        object = Py.EmptyObjects;
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, split_string_to_characters$25, PyString.fromInterned("Splits the given ``string`` to characters.\n\n        Example:\n        | @{characters} = | Split String To Characters | ${string} |\n        "));
        pyFrame.setlocal("split_string_to_characters", (PyObject)object);
        object = null;
        pyFrame.setline(459);
        object = Py.EmptyObjects;
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, fetch_from_left$26, PyString.fromInterned("Returns contents of the ``string`` before the first occurrence of ``marker``.\n\n        If the ``marker`` is not found, whole string is returned.\n\n        See also `Fetch From Right`, `Split String` and `Split String\n        From Right`.\n        "));
        pyFrame.setlocal("fetch_from_left", (PyObject)object);
        object = null;
        pyFrame.setline(469);
        object = Py.EmptyObjects;
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, fetch_from_right$27, PyString.fromInterned("Returns contents of the ``string`` after the last occurrence of ``marker``.\n\n        If the ``marker`` is not found, whole string is returned.\n\n        See also `Fetch From Left`, `Split String` and `Split String\n        From Right`.\n        "));
        pyFrame.setlocal("fetch_from_right", (PyObject)object);
        object = null;
        pyFrame.setline(479);
        object = new PyObject[]{Py.newInteger(8), PyString.fromInterned("[LETTERS][NUMBERS]")};
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, generate_random_string$28, PyString.fromInterned("Generates a string with a desired ``length`` from the given ``chars``.\n\n        The population sequence ``chars`` contains the characters to use\n        when generating the random string. It can contain any\n        characters, and it is possible to use special markers\n        explained in the table below:\n\n        |  = Marker =   |               = Explanation =                   |\n        | ``[LOWER]``   | Lowercase ASCII characters from ``a`` to ``z``. |\n        | ``[UPPER]``   | Uppercase ASCII characters from ``A`` to ``Z``. |\n        | ``[LETTERS]`` | Lowercase and uppercase ASCII characters.       |\n        | ``[NUMBERS]`` | Numbers from 0 to 9.                            |\n\n        Examples:\n        | ${ret} = | Generate Random String |\n        | ${low} = | Generate Random String | 12 | [LOWER]         |\n        | ${bin} = | Generate Random String | 8  | 01              |\n        | ${hex} = | Generate Random String | 4  | [NUMBERS]abcdef |\n        "));
        pyFrame.setlocal("generate_random_string", (PyObject)object);
        object = null;
        pyFrame.setline(510);
        object = new PyObject[]{pyFrame.getname("None")};
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, get_substring$30, PyString.fromInterned("Returns a substring from ``start`` index to ``end`` index.\n\n        The ``start`` index is inclusive and ``end`` is exclusive.\n        Indexing starts from 0, and it is possible to use\n        negative indices to refer to characters from the end.\n\n        Examples:\n        | ${ignore first} = | Get Substring | ${string} | 1  |    |\n        | ${ignore last} =  | Get Substring | ${string} |    | -1 |\n        | ${5th to 10th} =  | Get Substring | ${string} | 4  | 10 |\n        | ${first two} =    | Get Substring | ${string} |    | 1  |\n        | ${last two} =     | Get Substring | ${string} | -2 |    |\n        "));
        pyFrame.setlocal("get_substring", (PyObject)object);
        object = null;
        pyFrame.setline(528);
        object = new PyObject[]{PyString.fromInterned("both"), pyFrame.getname("None")};
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, strip_string$31, PyString.fromInterned("Remove leading and/or trailing whitespaces from the given string.\n\n        ``mode`` is either ``left`` to remove leading characters, ``right`` to\n        remove trailing characters, ``both`` (default) to remove the\n        characters from both sides of the string or ``none`` to return the\n        unmodified string.\n\n        If the optional ``characters`` is given, it must be a string and the\n        characters in the string will be stripped in the string. Please note,\n        that this is not a substring to be removed but a list of characters,\n        see the example below.\n\n        Examples:\n        | ${stripped}=  | Strip String | ${SPACE}Hello${SPACE} | |\n        | Should Be Equal | ${stripped} | Hello | |\n        | ${stripped}=  | Strip String | ${SPACE}Hello${SPACE} | mode=left |\n        | Should Be Equal | ${stripped} | Hello${SPACE} | |\n        | ${stripped}=  | Strip String | aabaHelloeee | characters=abe |\n        | Should Be Equal | ${stripped} | Hello | |\n\n        New in Robot Framework 3.0.\n        "));
        pyFrame.setlocal("strip_string", (PyObject)object);
        object = null;
        pyFrame.setline(560);
        object = new PyObject[]{pyFrame.getname("None")};
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, should_be_string$33, PyString.fromInterned("Fails if the given ``item`` is not a string.\n\n        With Python 2, except with IronPython, this keyword passes regardless\n        is the ``item`` a Unicode string or a byte string. Use `Should Be\n        Unicode String` or `Should Be Byte String` if you want to restrict\n        the string type. Notice that with Python 2, except with IronPython,\n        ``'string'`` creates a byte string and ``u'unicode'`` must be used to\n        create a Unicode string.\n\n        With Python 3 and IronPython, this keyword passes if the string is\n        a Unicode string but fails if it is bytes. Notice that with both\n        Python 3 and IronPython, ``'string'`` creates a Unicode string, and\n        ``b'bytes'`` must be used to create a byte string.\n\n        The default error message can be overridden with the optional\n        ``msg`` argument.\n        "));
        pyFrame.setlocal("should_be_string", (PyObject)object);
        object = null;
        pyFrame.setline(581);
        object = new PyObject[]{pyFrame.getname("None")};
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, should_not_be_string$34, PyString.fromInterned("Fails if the given ``item`` is a string.\n\n        See `Should Be String` for more details about Unicode strings and byte\n        strings.\n\n        The default error message can be overridden with the optional\n        ``msg`` argument.\n        "));
        pyFrame.setlocal("should_not_be_string", (PyObject)object);
        object = null;
        pyFrame.setline(593);
        object = new PyObject[]{pyFrame.getname("None")};
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, should_be_unicode_string$35, PyString.fromInterned("Fails if the given ``item`` is not a Unicode string.\n\n        Use `Should Be Byte String` if you want to verify the ``item`` is a\n        byte string, or `Should Be String` if both Unicode and byte strings\n        are fine. See `Should Be String` for more details about Unicode\n        strings and byte strings.\n\n        The default error message can be overridden with the optional\n        ``msg`` argument.\n        "));
        pyFrame.setlocal("should_be_unicode_string", (PyObject)object);
        object = null;
        pyFrame.setline(607);
        object = new PyObject[]{pyFrame.getname("None")};
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, should_be_byte_string$36, PyString.fromInterned("Fails if the given ``item`` is not a byte string.\n\n        Use `Should Be Unicode String` if you want to verify the ``item`` is a\n        Unicode string, or `Should Be String` if both Unicode and byte strings\n        are fine. See `Should Be String` for more details about Unicode strings\n        and byte strings.\n\n        The default error message can be overridden with the optional\n        ``msg`` argument.\n        "));
        pyFrame.setlocal("should_be_byte_string", (PyObject)object);
        object = null;
        pyFrame.setline(621);
        object = new PyObject[]{pyFrame.getname("None")};
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, should_be_lowercase$37, PyString.fromInterned("Fails if the given ``string`` is not in lowercase.\n\n        For example, ``'string'`` and ``'with specials!'`` would pass, and\n        ``'String'``, ``''`` and ``' '`` would fail.\n\n        The default error message can be overridden with the optional\n        ``msg`` argument.\n\n        See also `Should Be Uppercase` and `Should Be Titlecase`.\n        "));
        pyFrame.setlocal("should_be_lowercase", (PyObject)object);
        object = null;
        pyFrame.setline(635);
        object = new PyObject[]{pyFrame.getname("None")};
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, should_be_uppercase$38, PyString.fromInterned("Fails if the given ``string`` is not in uppercase.\n\n        For example, ``'STRING'`` and ``'WITH SPECIALS!'`` would pass, and\n        ``'String'``, ``''`` and ``' '`` would fail.\n\n        The default error message can be overridden with the optional\n        ``msg`` argument.\n\n        See also `Should Be Titlecase` and `Should Be Lowercase`.\n        "));
        pyFrame.setlocal("should_be_uppercase", (PyObject)object);
        object = null;
        pyFrame.setline(649);
        object = new PyObject[]{pyFrame.getname("None")};
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, should_be_titlecase$39, PyString.fromInterned("Fails if given ``string`` is not title.\n\n        ``string`` is a titlecased string if there is at least one\n        character in it, uppercase characters only follow uncased\n        characters and lowercase characters only cased ones.\n\n        For example, ``'This Is Title'`` would pass, and ``'Word In UPPER'``,\n        ``'Word In lower'``, ``''`` and ``' '`` would fail.\n\n        The default error message can be overridden with the optional\n        ``msg`` argument.\n\n        See also `Should Be Uppercase` and `Should Be Lowercase`.\n        "));
        pyFrame.setlocal("should_be_titlecase", (PyObject)object);
        object = null;
        pyFrame.setline(667);
        object = Py.EmptyObjects;
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, _convert_to_index$40, null);
        pyFrame.setlocal("_convert_to_index", (PyObject)object);
        object = null;
        pyFrame.setline(674);
        object = Py.EmptyObjects;
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, _convert_to_integer$41, null);
        pyFrame.setlocal("_convert_to_integer", (PyObject)object);
        object = null;
        pyFrame.setline(681);
        object = Py.EmptyObjects;
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, _fail$42, null);
        pyFrame.setlocal("_fail", (PyObject)object);
        object = null;
        return pyFrame.getf_locals();
    }

    public PyObject convert_to_lowercase$2(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(61);
        PyString.fromInterned("Converts string to lowercase.\n\n        Examples:\n        | ${str1} = | Convert To Lowercase | ABC |\n        | ${str2} = | Convert To Lowercase | 1A2c3D |\n        | Should Be Equal | ${str1} | abc |\n        | Should Be Equal | ${str2} | 1a2c3d |\n\n        New in Robot Framework 2.8.6.\n        ");
        pyFrame.setline(64);
        PyObject pyObject = pyFrame.getglobal("lower").__call__(threadState, pyFrame.getlocal(1));
        pyFrame.f_lasti = -1;
        return pyObject;
    }

    public PyObject convert_to_uppercase$3(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(76);
        PyString.fromInterned("Converts string to uppercase.\n\n        Examples:\n        | ${str1} = | Convert To Uppercase | abc |\n        | ${str2} = | Convert To Uppercase | 1a2C3d |\n        | Should Be Equal | ${str1} | ABC |\n        | Should Be Equal | ${str2} | 1A2C3D |\n\n        New in Robot Framework 2.8.6.\n        ");
        pyFrame.setline(77);
        PyObject pyObject = pyFrame.getlocal(1).__getattr__("upper").__call__(threadState);
        pyFrame.f_lasti = -1;
        return pyObject;
    }

    public PyObject encode_string_to_bytes$4(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(99);
        PyString.fromInterned("Encodes the given Unicode ``string`` to bytes using the given ``encoding``.\n\n        ``errors`` argument controls what to do if encoding some characters fails.\n        All values accepted by ``encode`` method in Python are valid, but in\n        practice the following values are most useful:\n\n        - ``strict``: fail if characters cannot be encoded (default)\n        - ``ignore``: ignore characters that cannot be encoded\n        - ``replace``: replace characters that cannot be encoded with\n          a replacement character\n\n        Examples:\n        | ${bytes} = | Encode String To Bytes | ${string} | UTF-8 |\n        | ${bytes} = | Encode String To Bytes | ${string} | ASCII | errors=ignore |\n\n        Use `Convert To Bytes` in ``BuiltIn`` if you want to create bytes based\n        on character or integer sequences. Use `Decode Bytes To String` if you\n        need to convert byte strings to Unicode strings and `Convert To String`\n        in ``BuiltIn`` if you need to convert arbitrary objects to Unicode.\n        ");
        pyFrame.setline(100);
        PyObject pyObject = pyFrame.getglobal("bytes").__call__(threadState, pyFrame.getlocal(1).__getattr__("encode").__call__(threadState, pyFrame.getlocal(2), pyFrame.getlocal(3)));
        pyFrame.f_lasti = -1;
        return pyObject;
    }

    public PyObject decode_bytes_to_string$5(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(121);
        PyString.fromInterned("Decodes the given ``bytes`` to a Unicode string using the given ``encoding``.\n\n        ``errors`` argument controls what to do if decoding some bytes fails.\n        All values accepted by ``decode`` method in Python are valid, but in\n        practice the following values are most useful:\n\n        - ``strict``: fail if characters cannot be decoded (default)\n        - ``ignore``: ignore characters that cannot be decoded\n        - ``replace``: replace characters that cannot be decoded with\n          a replacement character\n\n        Examples:\n        | ${string} = | Decode Bytes To String | ${bytes} | UTF-8 |\n        | ${string} = | Decode Bytes To String | ${bytes} | ASCII | errors=ignore |\n\n        Use `Encode String To Bytes` if you need to convert Unicode strings to\n        byte strings, and `Convert To String` in ``BuiltIn`` if you need to\n        convert arbitrary objects to Unicode strings.\n        ");
        pyFrame.setline(122);
        PyObject pyObject = pyFrame.getglobal("PY3");
        if (pyObject.__nonzero__()) {
            pyObject = pyFrame.getglobal("is_unicode").__call__(threadState, pyFrame.getlocal(1));
        }
        if (pyObject.__nonzero__()) {
            pyFrame.setline(123);
            throw Py.makeException(pyFrame.getglobal("TypeError").__call__(threadState, (PyObject)PyString.fromInterned("Can not decode strings on Python 3.")));
        }
        pyFrame.setline(124);
        PyObject pyObject2 = pyFrame.getlocal(1).__getattr__("decode").__call__(threadState, pyFrame.getlocal(2), pyFrame.getlocal(3));
        pyFrame.f_lasti = -1;
        return pyObject2;
    }

    public PyObject get_line_count$6(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(127);
        PyString.fromInterned("Returns and logs the number of lines in the given string.");
        pyFrame.setline(128);
        PyObject pyObject = pyFrame.getglobal("len").__call__(threadState, pyFrame.getlocal(1).__getattr__("splitlines").__call__(threadState));
        pyFrame.setlocal(2, pyObject);
        pyObject = null;
        pyFrame.setline(129);
        pyFrame.getglobal("logger").__getattr__("info").__call__(threadState, PyString.fromInterned("%d lines")._mod(pyFrame.getlocal(2)));
        pyFrame.setline(130);
        pyObject = pyFrame.getlocal(2);
        pyFrame.f_lasti = -1;
        return pyObject;
    }

    public PyObject split_to_lines$7(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(152);
        PyString.fromInterned("Splits the given string to lines.\n\n        It is possible to get only a selection of lines from ``start``\n        to ``end`` so that ``start`` index is inclusive and ``end`` is\n        exclusive. Line numbering starts from 0, and it is possible to\n        use negative indices to refer to lines from the end.\n\n        Lines are returned without the newlines. The number of\n        returned lines is automatically logged.\n\n        Examples:\n        | @{lines} =        | Split To Lines | ${manylines} |    |    |\n        | @{ignore first} = | Split To Lines | ${manylines} | 1  |    |\n        | @{ignore last} =  | Split To Lines | ${manylines} |    | -1 |\n        | @{5th to 10th} =  | Split To Lines | ${manylines} | 4  | 10 |\n        | @{first two} =    | Split To Lines | ${manylines} |    | 1  |\n        | @{last two} =     | Split To Lines | ${manylines} | -2 |    |\n\n        Use `Get Line` if you only need to get a single line.\n        ");
        pyFrame.setline(153);
        PyObject pyObject = pyFrame.getlocal(0).__getattr__("_convert_to_index").__call__(threadState, pyFrame.getlocal(2), (PyObject)PyString.fromInterned("start"));
        pyFrame.setlocal(2, pyObject);
        pyObject = null;
        pyFrame.setline(154);
        pyObject = pyFrame.getlocal(0).__getattr__("_convert_to_index").__call__(threadState, pyFrame.getlocal(3), (PyObject)PyString.fromInterned("end"));
        pyFrame.setlocal(3, pyObject);
        pyObject = null;
        pyFrame.setline(155);
        pyObject = pyFrame.getlocal(1).__getattr__("splitlines").__call__(threadState).__getslice__(pyFrame.getlocal(2), pyFrame.getlocal(3), null);
        pyFrame.setlocal(4, pyObject);
        pyObject = null;
        pyFrame.setline(156);
        pyFrame.getglobal("logger").__getattr__("info").__call__(threadState, PyString.fromInterned("%d lines returned")._mod(pyFrame.getglobal("len").__call__(threadState, pyFrame.getlocal(4))));
        pyFrame.setline(157);
        pyObject = pyFrame.getlocal(4);
        pyFrame.f_lasti = -1;
        return pyObject;
    }

    public PyObject get_line$8(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(171);
        PyString.fromInterned("Returns the specified line from the given ``string``.\n\n        Line numbering starts from 0 and it is possible to use\n        negative indices to refer to lines from the end. The line is\n        returned without the newline character.\n\n        Examples:\n        | ${first} =    | Get Line | ${string} | 0  |\n        | ${2nd last} = | Get Line | ${string} | -2 |\n\n        Use `Split To Lines` if all lines are needed.\n        ");
        pyFrame.setline(172);
        PyObject pyObject = pyFrame.getlocal(0).__getattr__("_convert_to_integer").__call__(threadState, pyFrame.getlocal(2), (PyObject)PyString.fromInterned("line_number"));
        pyFrame.setlocal(2, pyObject);
        pyObject = null;
        pyFrame.setline(173);
        pyObject = pyFrame.getlocal(1).__getattr__("splitlines").__call__(threadState).__getitem__(pyFrame.getlocal(2));
        pyFrame.f_lasti = -1;
        return pyObject;
    }

    public PyObject get_lines_containing_string$9(PyFrame pyFrame, ThreadState threadState) {
        Object object;
        pyFrame.to_cell(2, 0);
        pyFrame.setline(197);
        PyString.fromInterned("Returns lines of the given ``string`` that contain the ``pattern``.\n\n        The ``pattern`` is always considered to be a normal string, not a glob\n        or regexp pattern. A line matches if the ``pattern`` is found anywhere\n        on it.\n\n        The match is case-sensitive by default, but giving ``case_insensitive``\n        a true value makes it case-insensitive. The value is considered true\n        if it is a non-empty string that is not equal to ``false`` or ``no``.\n        If the value is not a string, its truth value is got directly in Python.\n\n        Lines are returned as one string catenated back together with\n        newlines. Possible trailing newline is never returned. The\n        number of matching lines is automatically logged.\n\n        Examples:\n        | ${lines} = | Get Lines Containing String | ${result} | An example |\n        | ${ret} =   | Get Lines Containing String | ${ret} | FAIL | case-insensitive |\n\n        See `Get Lines Matching Pattern` and `Get Lines Matching Regexp`\n        if you need more complex pattern matching.\n        ");
        pyFrame.setline(198);
        if (pyFrame.getglobal("is_truthy").__call__(threadState, pyFrame.getlocal(3)).__nonzero__()) {
            pyFrame.setline(199);
            object = pyFrame.getderef(0).__getattr__("lower").__call__(threadState);
            pyFrame.setderef(0, (PyObject)object);
            object = null;
            pyFrame.setline(200);
            pyFrame.setline(200);
            object = Py.EmptyObjects;
            object = new PyObject[]{pyFrame.getclosure(0)};
            object = new PyFunction(pyFrame.f_globals, (PyObject[])object, f$10, (PyObject[])object);
            pyFrame.setlocal(4, (PyObject)object);
            object = null;
        } else {
            pyFrame.setline(202);
            pyFrame.setline(202);
            object = Py.EmptyObjects;
            object = new PyObject[]{pyFrame.getclosure(0)};
            object = new PyFunction(pyFrame.f_globals, (PyObject[])object, f$11, (PyObject[])object);
            pyFrame.setlocal(4, (PyObject)object);
            object = null;
        }
        pyFrame.setline(203);
        object = pyFrame.getlocal(0).__getattr__("_get_matching_lines").__call__(threadState, pyFrame.getlocal(1), pyFrame.getlocal(4));
        pyFrame.f_lasti = -1;
        return object;
    }

    public PyObject f$10(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(200);
        PyObject pyObject = pyFrame.getderef(0);
        PyObject pyObject2 = pyObject._in(pyFrame.getlocal(0).__getattr__("lower").__call__(threadState));
        pyObject = null;
        pyObject = pyObject2;
        pyFrame.f_lasti = -1;
        return pyObject;
    }

    public PyObject f$11(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(202);
        PyObject pyObject = pyFrame.getderef(0);
        PyObject pyObject2 = pyObject._in(pyFrame.getlocal(0));
        pyObject = null;
        pyObject = pyObject2;
        pyFrame.f_lasti = -1;
        return pyObject;
    }

    public PyObject get_lines_matching_pattern$12(PyFrame pyFrame, ThreadState threadState) {
        Object object;
        pyFrame.to_cell(2, 0);
        pyFrame.setline(232);
        PyString.fromInterned("Returns lines of the given ``string`` that match the ``pattern``.\n\n        The ``pattern`` is a _glob pattern_ where:\n        | ``*``        | matches everything |\n        | ``?``        | matches any single character |\n        | ``[chars]``  | matches any character inside square brackets (e.g. ``[abc]`` matches either ``a``, ``b`` or ``c``) |\n        | ``[!chars]`` | matches any character not inside square brackets |\n\n        A line matches only if it matches the ``pattern`` fully.\n\n        The match is case-sensitive by default, but giving ``case_insensitive``\n        a true value makes it case-insensitive. The value is considered true\n        if it is a non-empty string that is not equal to ``false`` or ``no``.\n        If the value is not a string, its truth value is got directly in Python.\n\n        Lines are returned as one string catenated back together with\n        newlines. Possible trailing newline is never returned. The\n        number of matching lines is automatically logged.\n\n        Examples:\n        | ${lines} = | Get Lines Matching Pattern | ${result} | Wild???? example |\n        | ${ret} = | Get Lines Matching Pattern | ${ret} | FAIL: * | case_insensitive=true |\n\n        See `Get Lines Matching Regexp` if you need more complex\n        patterns and `Get Lines Containing String` if searching\n        literal strings is enough.\n        ");
        pyFrame.setline(233);
        if (pyFrame.getglobal("is_truthy").__call__(threadState, pyFrame.getlocal(3)).__nonzero__()) {
            pyFrame.setline(234);
            object = pyFrame.getderef(0).__getattr__("lower").__call__(threadState);
            pyFrame.setderef(0, (PyObject)object);
            object = null;
            pyFrame.setline(235);
            pyFrame.setline(235);
            object = Py.EmptyObjects;
            object = new PyObject[]{pyFrame.getclosure(0)};
            object = new PyFunction(pyFrame.f_globals, (PyObject[])object, f$13, (PyObject[])object);
            pyFrame.setlocal(4, (PyObject)object);
            object = null;
        } else {
            pyFrame.setline(237);
            pyFrame.setline(237);
            object = Py.EmptyObjects;
            object = new PyObject[]{pyFrame.getclosure(0)};
            object = new PyFunction(pyFrame.f_globals, (PyObject[])object, f$14, (PyObject[])object);
            pyFrame.setlocal(4, (PyObject)object);
            object = null;
        }
        pyFrame.setline(238);
        object = pyFrame.getlocal(0).__getattr__("_get_matching_lines").__call__(threadState, pyFrame.getlocal(1), pyFrame.getlocal(4));
        pyFrame.f_lasti = -1;
        return object;
    }

    public PyObject f$13(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(235);
        PyObject pyObject = pyFrame.getglobal("fnmatchcase").__call__(threadState, pyFrame.getlocal(0).__getattr__("lower").__call__(threadState), pyFrame.getderef(0));
        pyFrame.f_lasti = -1;
        return pyObject;
    }

    public PyObject f$14(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(237);
        PyObject pyObject = pyFrame.getglobal("fnmatchcase").__call__(threadState, pyFrame.getlocal(0), pyFrame.getderef(0));
        pyFrame.f_lasti = -1;
        return pyObject;
    }

    public PyObject get_lines_matching_regexp$15(PyFrame pyFrame, ThreadState threadState) {
        PyObject pyObject;
        pyFrame.setline(274);
        PyString.fromInterned("Returns lines of the given ``string`` that match the regexp ``pattern``.\n\n        See `BuiltIn.Should Match Regexp` for more information about\n        Python regular expression syntax in general and how to use it\n        in Robot Framework test data in particular.\n\n        By default lines match only if they match the pattern fully, but\n        partial matching can be enabled by giving the ``partial_match``\n        argument a true value. The value is considered true if it is a\n        non-empty string that is not equal to ``false`` or ``no``. If the\n        value is not a string, its truth value is got directly in Python.\n\n        If the pattern is empty, it matches only empty lines by default.\n        When partial matching is enabled, empty pattern matches all lines.\n\n        Notice that to make the match case-insensitive, you need to prefix\n        the pattern with case-insensitive flag ``(?i)``.\n\n        Lines are returned as one string concatenated back together with\n        newlines. Possible trailing newline is never returned. The\n        number of matching lines is automatically logged.\n\n        Examples:\n        | ${lines} = | Get Lines Matching Regexp | ${result} | Reg\\\\w{3} example |\n        | ${lines} = | Get Lines Matching Regexp | ${result} | Reg\\\\w{3} example | partial_match=true |\n        | ${ret} =   | Get Lines Matching Regexp | ${ret}    | (?i)FAIL: .* |\n\n        See `Get Lines Matching Pattern` and `Get Lines Containing\n        String` if you do not need full regular expression powers (and\n        complexity).\n\n        ``partial_match`` argument is new in Robot Framework 2.9. In earlier\n         versions exact match was always required.\n        ");
        pyFrame.setline(275);
        if (pyFrame.getglobal("is_truthy").__call__(threadState, pyFrame.getlocal(3)).__not__().__nonzero__()) {
            pyFrame.setline(276);
            pyObject = PyString.fromInterned("^%s$")._mod(pyFrame.getlocal(2));
            pyFrame.setlocal(2, pyObject);
            pyObject = null;
        }
        pyFrame.setline(277);
        pyObject = pyFrame.getlocal(0).__getattr__("_get_matching_lines").__call__(threadState, pyFrame.getlocal(1), pyFrame.getglobal("re").__getattr__("compile").__call__(threadState, pyFrame.getlocal(2)).__getattr__("search"));
        pyFrame.f_lasti = -1;
        return pyObject;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    public PyObject _get_matching_lines$16(PyFrame pyFrame, ThreadState threadState) {
        PyList pyList;
        PyObject pyObject;
        block4: {
            PyObject pyObject2;
            block3: {
                pyFrame.setline(280);
                pyObject = pyFrame.getlocal(1).__getattr__("splitlines").__call__(threadState);
                pyFrame.setlocal(3, pyObject);
                pyObject = null;
                pyFrame.setline(281);
                pyList = new PyList();
                pyObject = pyList.__getattr__("append");
                pyFrame.setlocal(5, pyObject);
                pyObject = null;
                pyFrame.setline(281);
                pyObject = pyFrame.getlocal(3).__iter__();
                if (!true) break block3;
                pyFrame.setline(281);
                if ((pyObject2 = pyObject.__iternext__()) == null) break block4;
            }
            do {
                pyFrame.setlocal(6, pyObject2);
                pyFrame.setline(281);
                if (pyFrame.getlocal(2).__call__(threadState, pyFrame.getlocal(6)).__nonzero__()) {
                    pyFrame.setline(281);
                    pyFrame.getlocal(5).__call__(threadState, pyFrame.getlocal(6));
                }
                pyFrame.setline(281);
            } while ((pyObject2 = pyObject.__iternext__()) != null);
        }
        pyFrame.setline(281);
        pyFrame.dellocal(5);
        pyObject = pyList;
        pyFrame.setlocal(4, pyObject);
        pyObject = null;
        pyFrame.setline(282);
        pyFrame.getglobal("logger").__getattr__("info").__call__(threadState, PyString.fromInterned("%d out of %d lines matched")._mod(new PyTuple(pyFrame.getglobal("len").__call__(threadState, pyFrame.getlocal(4)), pyFrame.getglobal("len").__call__(threadState, pyFrame.getlocal(3)))));
        pyFrame.setline(283);
        pyObject = PyString.fromInterned("\n").__getattr__("join").__call__(threadState, pyFrame.getlocal(4));
        pyFrame.f_lasti = -1;
        return pyObject;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    public PyObject get_regexp_matches$17(PyFrame pyFrame, ThreadState threadState) {
        PyList pyList;
        PyObject pyObject;
        block7: {
            PyObject pyObject2;
            block6: {
                PyList pyList2;
                block5: {
                    block4: {
                        pyFrame.setline(313);
                        PyString.fromInterned("Returns a list of all non-overlapping matches in the given string.\n\n        ``string`` is the string to find matches from and ``pattern`` is the\n        regular expression. See `BuiltIn.Should Match Regexp` for more\n        information about Python regular expression syntax in general and how\n        to use it in Robot Framework test data in particular.\n\n        If no groups are used, the returned list contains full matches. If one\n        group is used, the list contains only contents of that group. If\n        multiple groups are used, the list contains tuples that contain\n        individual group contents. All groups can be given as indexes (starting\n        from 1) and named groups also as names.\n\n        Examples:\n        | ${no match} =    | Get Regexp Matches | the string | xxx     |\n        | ${matches} =     | Get Regexp Matches | the string | t..     |\n        | ${one group} =   | Get Regexp Matches | the string | t(..)   | 1 |\n        | ${named group} = | Get Regexp Matches | the string | t(?P<name>..) | name |\n        | ${two groups} =  | Get Regexp Matches | the string | t(.)(.) | 1 | 2 |\n        =>\n        | ${no match} = []\n        | ${matches} = ['the', 'tri']\n        | ${one group} = ['he', 'ri']\n        | ${named group} = ['he', 'ri']\n        | ${two groups} = [('h', 'e'), ('r', 'i')]\n\n        New in Robot Framework 2.9.\n        ");
                        pyFrame.setline(314);
                        pyObject = pyFrame.getglobal("re").__getattr__("compile").__call__(threadState, pyFrame.getlocal(2));
                        pyFrame.setlocal(4, pyObject);
                        pyObject = null;
                        pyFrame.setline(315);
                        pyList2 = new PyList();
                        pyObject = pyList2.__getattr__("append");
                        pyFrame.setlocal(5, pyObject);
                        pyObject = null;
                        pyFrame.setline(315);
                        pyObject = pyFrame.getlocal(3).__iter__();
                        if (!true) break block4;
                        pyFrame.setline(315);
                        if ((pyObject2 = pyObject.__iternext__()) == null) break block5;
                    }
                    do {
                        pyFrame.setlocal(6, pyObject2);
                        pyFrame.setline(315);
                        pyFrame.getlocal(5).__call__(threadState, pyFrame.getlocal(0).__getattr__("_parse_group").__call__(threadState, pyFrame.getlocal(6)));
                        pyFrame.setline(315);
                    } while ((pyObject2 = pyObject.__iternext__()) != null);
                }
                pyFrame.setline(315);
                pyFrame.dellocal(5);
                pyObject = pyList2;
                pyFrame.setlocal(3, pyObject);
                pyObject = null;
                pyFrame.setline(316);
                pyList = new PyList();
                pyObject = pyList.__getattr__("append");
                pyFrame.setlocal(7, pyObject);
                pyObject = null;
                pyFrame.setline(316);
                pyObject = pyFrame.getlocal(4).__getattr__("finditer").__call__(threadState, pyFrame.getlocal(1)).__iter__();
                if (!true) break block6;
                pyFrame.setline(316);
                if ((pyObject2 = pyObject.__iternext__()) == null) break block7;
            }
            do {
                pyFrame.setlocal(8, pyObject2);
                pyFrame.setline(316);
                PyObject[] pyObjectArray = Py.EmptyObjects;
                String[] stringArray = new String[]{};
                PyObject pyObject3 = pyFrame.getlocal(8).__getattr__("group")._callextra(pyObjectArray, stringArray, pyFrame.getlocal(3), null);
                pyObjectArray = null;
                pyFrame.getlocal(7).__call__(threadState, pyObject3);
                pyFrame.setline(316);
            } while ((pyObject2 = pyObject.__iternext__()) != null);
        }
        pyFrame.setline(316);
        pyFrame.dellocal(7);
        pyObject = pyList;
        pyFrame.f_lasti = -1;
        return pyObject;
    }

    public PyObject _parse_group$18(PyFrame pyFrame, ThreadState threadState) {
        try {
            pyFrame.setline(320);
            PyObject pyObject = pyFrame.getglobal("int").__call__(threadState, pyFrame.getlocal(1));
            pyFrame.f_lasti = -1;
            return pyObject;
        }
        catch (Throwable throwable) {
            PyException pyException = Py.setException(throwable, pyFrame);
            if (pyException.match(pyFrame.getglobal("ValueError"))) {
                pyFrame.setline(322);
                PyObject pyObject = pyFrame.getlocal(1);
                pyFrame.f_lasti = -1;
                return pyObject;
            }
            throw pyException;
        }
    }

    public PyObject replace_string$19(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(344);
        PyString.fromInterned("Replaces ``search_for`` in the given ``string`` with ``replace_with``.\n\n        ``search_for`` is used as a literal string. See `Replace String\n        Using Regexp` if more powerful pattern matching is needed.\n        If you need to just remove a string see `Remove String`.\n\n        If the optional argument ``count`` is given, only that many\n        occurrences from left are replaced. Negative ``count`` means\n        that all occurrences are replaced (default behaviour) and zero\n        means that nothing is done.\n\n        A modified version of the string is returned and the original\n        string is not altered.\n\n        Examples:\n        | ${str} =        | Replace String | Hello, world!  | world | tellus   |\n        | Should Be Equal | ${str}         | Hello, tellus! |       |          |\n        | ${str} =        | Replace String | Hello, world!  | l     | ${EMPTY} | count=1 |\n        | Should Be Equal | ${str}         | Helo, world!   |       |          |\n        ");
        pyFrame.setline(345);
        PyObject pyObject = pyFrame.getlocal(0).__getattr__("_convert_to_integer").__call__(threadState, pyFrame.getlocal(4), (PyObject)PyString.fromInterned("count"));
        pyFrame.setlocal(4, pyObject);
        pyObject = null;
        pyFrame.setline(346);
        pyObject = pyFrame.getlocal(1).__getattr__("replace").__call__(threadState, pyFrame.getlocal(2), pyFrame.getlocal(3), pyFrame.getlocal(4));
        pyFrame.f_lasti = -1;
        return pyObject;
    }

    public PyObject replace_string_using_regexp$20(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(362);
        PyString.fromInterned("Replaces ``pattern`` in the given ``string`` with ``replace_with``.\n\n        This keyword is otherwise identical to `Replace String`, but\n        the ``pattern`` to search for is considered to be a regular\n        expression.  See `BuiltIn.Should Match Regexp` for more\n        information about Python regular expression syntax in general\n        and how to use it in Robot Framework test data in particular.\n\n        If you need to just remove a string see `Remove String Using Regexp`.\n\n        Examples:\n        | ${str} = | Replace String Using Regexp | ${str} | 20\\\\d\\\\d-\\\\d\\\\d-\\\\d\\\\d | <DATE> |\n        | ${str} = | Replace String Using Regexp | ${str} | (Hello|Hi) | ${EMPTY} | count=1 |\n        ");
        pyFrame.setline(363);
        PyObject pyObject = pyFrame.getlocal(0).__getattr__("_convert_to_integer").__call__(threadState, pyFrame.getlocal(4), (PyObject)PyString.fromInterned("count"));
        pyFrame.setlocal(4, pyObject);
        pyObject = null;
        pyFrame.setline(365);
        pyObject = pyFrame.getlocal(4);
        PyObject pyObject2 = pyObject._eq(Py.newInteger(0));
        pyObject = null;
        if (pyObject2.__nonzero__()) {
            pyFrame.setline(366);
            pyObject = pyFrame.getlocal(1);
            pyFrame.f_lasti = -1;
            return pyObject;
        }
        pyFrame.setline(367);
        pyObject = pyFrame.getglobal("re").__getattr__("sub").__call__(threadState, pyFrame.getlocal(2), pyFrame.getlocal(3), pyFrame.getlocal(1), pyFrame.getglobal("max").__call__(threadState, pyFrame.getlocal(4), (PyObject)Py.newInteger(0)));
        pyFrame.f_lasti = -1;
        return pyObject;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    public PyObject remove_string$21(PyFrame pyFrame, ThreadState threadState) {
        PyObject pyObject;
        block3: {
            PyObject pyObject2;
            block2: {
                pyFrame.setline(390);
                PyString.fromInterned("Removes all ``removables`` from the given ``string``.\n\n        ``removables`` are used as literal strings. Each removable will be\n        matched to a temporary string from which preceding removables have\n        been already removed. See second example below.\n\n        Use `Remove String Using Regexp` if more powerful pattern matching is\n        needed. If only a certain number of matches should be removed,\n        `Replace String` or `Replace String Using Regexp` can be used.\n\n        A modified version of the string is returned and the original\n        string is not altered.\n\n        Examples:\n        | ${str} =        | Remove String | Robot Framework | work   |\n        | Should Be Equal | ${str}        | Robot Frame     |\n        | ${str} =        | Remove String | Robot Framework | o | bt |\n        | Should Be Equal | ${str}        | R Framewrk      |\n\n        New in Robot Framework 2.8.2.\n        ");
                pyFrame.setline(391);
                pyObject = pyFrame.getlocal(2).__iter__();
                if (!true) break block2;
                pyFrame.setline(391);
                if ((pyObject2 = pyObject.__iternext__()) == null) break block3;
            }
            do {
                pyFrame.setlocal(3, pyObject2);
                pyFrame.setline(392);
                PyObject pyObject3 = pyFrame.getlocal(0).__getattr__("replace_string").__call__(threadState, pyFrame.getlocal(1), pyFrame.getlocal(3), (PyObject)PyString.fromInterned(""));
                pyFrame.setlocal(1, pyObject3);
                pyObject3 = null;
                pyFrame.setline(391);
            } while ((pyObject2 = pyObject.__iternext__()) != null);
        }
        pyFrame.setline(393);
        pyObject = pyFrame.getlocal(1);
        pyFrame.f_lasti = -1;
        return pyObject;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    public PyObject remove_string_using_regexp$22(PyFrame pyFrame, ThreadState threadState) {
        PyObject pyObject;
        block3: {
            PyObject pyObject2;
            block2: {
                pyFrame.setline(406);
                PyString.fromInterned("Removes ``patterns`` from the given ``string``.\n\n        This keyword is otherwise identical to `Remove String`, but\n        the ``patterns`` to search for are considered to be a regular\n        expression. See `Replace String Using Regexp` for more information\n        about the regular expression syntax. That keyword can also be\n        used if there is a need to remove only a certain number of\n        occurrences.\n\n        New in Robot Framework 2.8.2.\n        ");
                pyFrame.setline(407);
                pyObject = pyFrame.getlocal(2).__iter__();
                if (!true) break block2;
                pyFrame.setline(407);
                if ((pyObject2 = pyObject.__iternext__()) == null) break block3;
            }
            do {
                pyFrame.setlocal(3, pyObject2);
                pyFrame.setline(408);
                PyObject pyObject3 = pyFrame.getlocal(0).__getattr__("replace_string_using_regexp").__call__(threadState, pyFrame.getlocal(1), pyFrame.getlocal(3), (PyObject)PyString.fromInterned(""));
                pyFrame.setlocal(1, pyObject3);
                pyObject3 = null;
                pyFrame.setline(407);
            } while ((pyObject2 = pyObject.__iternext__()) != null);
        }
        pyFrame.setline(409);
        pyObject = pyFrame.getlocal(1);
        pyFrame.f_lasti = -1;
        return pyObject;
    }

    public PyObject split_string$23(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(430);
        PyString.fromInterned("Splits the ``string`` using ``separator`` as a delimiter string.\n\n        If a ``separator`` is not given, any whitespace string is a\n        separator. In that case also possible consecutive whitespace\n        as well as leading and trailing whitespace is ignored.\n\n        Split words are returned as a list. If the optional\n        ``max_split`` is given, at most ``max_split`` splits are done, and\n        the returned list will have maximum ``max_split + 1`` elements.\n\n        Examples:\n        | @{words} =         | Split String | ${string} |\n        | @{words} =         | Split String | ${string} | ,${SPACE} |\n        | ${pre} | ${post} = | Split String | ${string} | ::    | 1 |\n\n        See `Split String From Right` if you want to start splitting\n        from right, and `Fetch From Left` and `Fetch From Right` if\n        you only want to get first/last part of the string.\n        ");
        pyFrame.setline(431);
        PyObject pyObject = pyFrame.getlocal(2);
        PyObject pyObject2 = pyObject._eq(PyString.fromInterned(""));
        pyObject = null;
        if (pyObject2.__nonzero__()) {
            pyFrame.setline(432);
            pyObject = pyFrame.getglobal("None");
            pyFrame.setlocal(2, pyObject);
            pyObject = null;
        }
        pyFrame.setline(433);
        pyObject = pyFrame.getlocal(0).__getattr__("_convert_to_integer").__call__(threadState, pyFrame.getlocal(3), (PyObject)PyString.fromInterned("max_split"));
        pyFrame.setlocal(3, pyObject);
        pyObject = null;
        pyFrame.setline(434);
        pyObject = pyFrame.getlocal(1).__getattr__("split").__call__(threadState, pyFrame.getlocal(2), pyFrame.getlocal(3));
        pyFrame.f_lasti = -1;
        return pyObject;
    }

    public PyObject split_string_from_right$24(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(445);
        PyString.fromInterned("Splits the ``string`` using ``separator`` starting from right.\n\n        Same as `Split String`, but splitting is started from right. This has\n        an effect only when ``max_split`` is given.\n\n        Examples:\n        | ${first} | ${rest} = | Split String            | ${string} | - | 1 |\n        | ${rest}  | ${last} = | Split String From Right | ${string} | - | 1 |\n        ");
        pyFrame.setline(446);
        PyObject pyObject = pyFrame.getlocal(2);
        PyObject pyObject2 = pyObject._eq(PyString.fromInterned(""));
        pyObject = null;
        if (pyObject2.__nonzero__()) {
            pyFrame.setline(447);
            pyObject = pyFrame.getglobal("None");
            pyFrame.setlocal(2, pyObject);
            pyObject = null;
        }
        pyFrame.setline(448);
        pyObject = pyFrame.getlocal(0).__getattr__("_convert_to_integer").__call__(threadState, pyFrame.getlocal(3), (PyObject)PyString.fromInterned("max_split"));
        pyFrame.setlocal(3, pyObject);
        pyObject = null;
        pyFrame.setline(449);
        pyObject = pyFrame.getlocal(1).__getattr__("rsplit").__call__(threadState, pyFrame.getlocal(2), pyFrame.getlocal(3));
        pyFrame.f_lasti = -1;
        return pyObject;
    }

    public PyObject split_string_to_characters$25(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(456);
        PyString.fromInterned("Splits the given ``string`` to characters.\n\n        Example:\n        | @{characters} = | Split String To Characters | ${string} |\n        ");
        pyFrame.setline(457);
        PyObject pyObject = pyFrame.getglobal("list").__call__(threadState, pyFrame.getlocal(1));
        pyFrame.f_lasti = -1;
        return pyObject;
    }

    public PyObject fetch_from_left$26(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(466);
        PyString.fromInterned("Returns contents of the ``string`` before the first occurrence of ``marker``.\n\n        If the ``marker`` is not found, whole string is returned.\n\n        See also `Fetch From Right`, `Split String` and `Split String\n        From Right`.\n        ");
        pyFrame.setline(467);
        PyObject pyObject = pyFrame.getlocal(1).__getattr__("split").__call__(threadState, pyFrame.getlocal(2)).__getitem__(Py.newInteger(0));
        pyFrame.f_lasti = -1;
        return pyObject;
    }

    public PyObject fetch_from_right$27(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(476);
        PyString.fromInterned("Returns contents of the ``string`` after the last occurrence of ``marker``.\n\n        If the ``marker`` is not found, whole string is returned.\n\n        See also `Fetch From Left`, `Split String` and `Split String\n        From Right`.\n        ");
        pyFrame.setline(477);
        PyObject pyObject = pyFrame.getlocal(1).__getattr__("split").__call__(threadState, pyFrame.getlocal(2)).__getitem__(Py.newInteger(-1));
        pyFrame.f_lasti = -1;
        return pyObject;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    public PyObject generate_random_string$28(PyFrame pyFrame, ThreadState threadState) {
        Object object;
        block4: {
            PyObject pyObject;
            block3: {
                pyFrame.to_cell(2, 1);
                pyFrame.setline(498);
                PyString.fromInterned("Generates a string with a desired ``length`` from the given ``chars``.\n\n        The population sequence ``chars`` contains the characters to use\n        when generating the random string. It can contain any\n        characters, and it is possible to use special markers\n        explained in the table below:\n\n        |  = Marker =   |               = Explanation =                   |\n        | ``[LOWER]``   | Lowercase ASCII characters from ``a`` to ``z``. |\n        | ``[UPPER]``   | Uppercase ASCII characters from ``A`` to ``Z``. |\n        | ``[LETTERS]`` | Lowercase and uppercase ASCII characters.       |\n        | ``[NUMBERS]`` | Numbers from 0 to 9.                            |\n\n        Examples:\n        | ${ret} = | Generate Random String |\n        | ${low} = | Generate Random String | 12 | [LOWER]         |\n        | ${bin} = | Generate Random String | 8  | 01              |\n        | ${hex} = | Generate Random String | 4  | [NUMBERS]abcdef |\n        ");
                pyFrame.setline(499);
                PyObject pyObject2 = pyFrame.getlocal(1);
                Object var3_4 = null;
                if (pyObject2._eq(PyString.fromInterned("")).__nonzero__()) {
                    pyFrame.setline(500);
                    PyInteger pyInteger = Py.newInteger(8);
                    pyFrame.setlocal(1, (PyObject)pyInteger);
                    Object var3_6 = null;
                }
                pyFrame.setline(501);
                PyObject pyObject3 = pyFrame.getlocal(0).__getattr__("_convert_to_integer").__call__(threadState, pyFrame.getlocal(1), (PyObject)PyString.fromInterned("length"));
                pyFrame.setlocal(1, pyObject3);
                Object var3_9 = null;
                pyFrame.setline(502);
                pyObject = ((PyObject)new PyList(new PyObject[]{new PyTuple(PyString.fromInterned("[LOWER]"), pyFrame.getglobal("ascii_lowercase")), new PyTuple(PyString.fromInterned("[UPPER]"), pyFrame.getglobal("ascii_uppercase")), new PyTuple(PyString.fromInterned("[LETTERS]"), pyFrame.getglobal("ascii_lowercase")._add(pyFrame.getglobal("ascii_uppercase"))), new PyTuple(PyString.fromInterned("[NUMBERS]"), pyFrame.getglobal("digits"))})).__iter__();
                if (!true) break block3;
                pyFrame.setline(502);
                if ((object = pyObject.__iternext__()) == null) break block4;
            }
            do {
                PyObject[] pyObjectArray = Py.unpackSequence((PyObject)object, 2);
                PyObject pyObject4 = pyObjectArray[0];
                pyFrame.setlocal(3, pyObject4);
                pyObject4 = null;
                pyObject4 = pyObjectArray[1];
                pyFrame.setlocal(4, pyObject4);
                pyObject4 = null;
                pyFrame.setline(506);
                PyObject pyObject5 = pyFrame.getderef(1).__getattr__("replace").__call__(threadState, pyFrame.getlocal(3), pyFrame.getlocal(4));
                pyFrame.setderef(1, pyObject5);
                Object var5_16 = null;
                pyFrame.setline(502);
            } while ((object = pyObject.__iternext__()) != null);
        }
        pyFrame.setline(507);
        PyObject pyObject = pyFrame.getglobal("len").__call__(threadState, pyFrame.getderef(1))._sub(Py.newInteger(1));
        pyFrame.setderef(0, pyObject);
        Object var3_12 = null;
        pyFrame.setline(508);
        PyObject pyObject6 = PyString.fromInterned("").__getattr__("join");
        pyFrame.setline(508);
        Object[] objectArray = Py.EmptyObjects;
        object = new PyObject[]{pyFrame.getclosure(1), pyFrame.getclosure(0)};
        object = new PyFunction(pyFrame.f_globals, (PyObject[])objectArray, f$29, null, (PyObject[])object);
        PyObject pyObject7 = ((PyObject)object).__call__(threadState, pyFrame.getglobal("range").__call__(threadState, pyFrame.getlocal(1)).__iter__());
        Arrays.fill(objectArray, null);
        PyObject pyObject8 = pyObject6.__call__(threadState, pyObject7);
        pyFrame.f_lasti = -1;
        return pyObject8;
    }

    /*
     * Enabled aggressive block sorting
     */
    public PyObject f$29(PyFrame pyFrame, ThreadState threadState) {
        PyObject pyObject;
        Object[] objectArray;
        PyObject pyObject2;
        switch (pyFrame.f_lasti) {
            default: {
                pyFrame.setline(508);
                pyObject2 = pyFrame.getlocal(0).__iter__();
                break;
            }
            case 1: {
                objectArray = pyFrame.f_savedlocals;
                pyObject2 = (PyObject)objectArray[3];
                pyObject = (PyObject)objectArray[4];
                Object object = pyFrame.getGeneratorInput();
                if (object instanceof PyException) {
                    throw (Throwable)object;
                }
                PyObject cfr_ignored_0 = (PyObject)object;
            }
        }
        pyFrame.setline(508);
        pyObject = pyObject2.__iternext__();
        if (pyObject != null) {
            pyFrame.setlocal(1, pyObject);
            pyFrame.setline(508);
            pyFrame.setline(508);
            pyFrame.f_lasti = 1;
            objectArray = new Object[5];
            objectArray[3] = pyObject2;
            objectArray[4] = pyObject;
            pyFrame.f_savedlocals = objectArray;
            return pyFrame.getderef(0).__getitem__(pyFrame.getglobal("randint").__call__(threadState, (PyObject)Py.newInteger(0), pyFrame.getderef(1)));
        }
        pyFrame.f_lasti = -1;
        return Py.None;
    }

    public PyObject get_substring$30(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(523);
        PyString.fromInterned("Returns a substring from ``start`` index to ``end`` index.\n\n        The ``start`` index is inclusive and ``end`` is exclusive.\n        Indexing starts from 0, and it is possible to use\n        negative indices to refer to characters from the end.\n\n        Examples:\n        | ${ignore first} = | Get Substring | ${string} | 1  |    |\n        | ${ignore last} =  | Get Substring | ${string} |    | -1 |\n        | ${5th to 10th} =  | Get Substring | ${string} | 4  | 10 |\n        | ${first two} =    | Get Substring | ${string} |    | 1  |\n        | ${last two} =     | Get Substring | ${string} | -2 |    |\n        ");
        pyFrame.setline(524);
        PyObject pyObject = pyFrame.getlocal(0).__getattr__("_convert_to_index").__call__(threadState, pyFrame.getlocal(2), (PyObject)PyString.fromInterned("start"));
        pyFrame.setlocal(2, pyObject);
        pyObject = null;
        pyFrame.setline(525);
        pyObject = pyFrame.getlocal(0).__getattr__("_convert_to_index").__call__(threadState, pyFrame.getlocal(3), (PyObject)PyString.fromInterned("end"));
        pyFrame.setlocal(3, pyObject);
        pyObject = null;
        pyFrame.setline(526);
        pyObject = pyFrame.getlocal(1).__getslice__(pyFrame.getlocal(2), pyFrame.getlocal(3), null);
        pyFrame.f_lasti = -1;
        return pyObject;
    }

    public PyObject strip_string$31(PyFrame pyFrame, ThreadState threadState) {
        Object object;
        pyFrame.to_cell(1, 0);
        pyFrame.setline(550);
        PyString.fromInterned("Remove leading and/or trailing whitespaces from the given string.\n\n        ``mode`` is either ``left`` to remove leading characters, ``right`` to\n        remove trailing characters, ``both`` (default) to remove the\n        characters from both sides of the string or ``none`` to return the\n        unmodified string.\n\n        If the optional ``characters`` is given, it must be a string and the\n        characters in the string will be stripped in the string. Please note,\n        that this is not a substring to be removed but a list of characters,\n        see the example below.\n\n        Examples:\n        | ${stripped}=  | Strip String | ${SPACE}Hello${SPACE} | |\n        | Should Be Equal | ${stripped} | Hello | |\n        | ${stripped}=  | Strip String | ${SPACE}Hello${SPACE} | mode=left |\n        | Should Be Equal | ${stripped} | Hello${SPACE} | |\n        | ${stripped}=  | Strip String | aabaHelloeee | characters=abe |\n        | Should Be Equal | ${stripped} | Hello | |\n\n        New in Robot Framework 3.0.\n        ");
        try {
            pyFrame.setline(552);
            PyObject[] pyObjectArray = new PyObject[8];
            pyObjectArray[0] = PyString.fromInterned("BOTH");
            pyObjectArray[1] = pyFrame.getderef(0).__getattr__("strip");
            pyObjectArray[2] = PyString.fromInterned("LEFT");
            pyObjectArray[3] = pyFrame.getderef(0).__getattr__("lstrip");
            pyObjectArray[4] = PyString.fromInterned("RIGHT");
            pyObjectArray[5] = pyFrame.getderef(0).__getattr__("rstrip");
            pyObjectArray[6] = PyString.fromInterned("NONE");
            pyFrame.setline(555);
            object = Py.EmptyObjects;
            object = new PyObject[]{pyFrame.getclosure(0)};
            pyObjectArray[7] = new PyFunction(pyFrame.f_globals, (PyObject[])object, f$32, (PyObject[])object);
            object = new PyDictionary(pyObjectArray).__getitem__(pyFrame.getlocal(2).__getattr__("upper").__call__(threadState));
            pyFrame.setlocal(4, (PyObject)object);
            object = null;
        }
        catch (Throwable throwable) {
            PyException pyException = Py.setException(throwable, pyFrame);
            if (pyException.match(pyFrame.getglobal("KeyError"))) {
                pyFrame.setline(557);
                throw Py.makeException(pyFrame.getglobal("ValueError").__call__(threadState, PyString.fromInterned("Invalid mode '%s'.")._mod(pyFrame.getlocal(2))));
            }
            throw pyException;
        }
        pyFrame.setline(558);
        object = pyFrame.getlocal(4).__call__(threadState, pyFrame.getlocal(3));
        pyFrame.f_lasti = -1;
        return object;
    }

    public PyObject f$32(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(555);
        PyObject pyObject = pyFrame.getderef(0);
        pyFrame.f_lasti = -1;
        return pyObject;
    }

    public PyObject should_be_string$33(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(577);
        PyString.fromInterned("Fails if the given ``item`` is not a string.\n\n        With Python 2, except with IronPython, this keyword passes regardless\n        is the ``item`` a Unicode string or a byte string. Use `Should Be\n        Unicode String` or `Should Be Byte String` if you want to restrict\n        the string type. Notice that with Python 2, except with IronPython,\n        ``'string'`` creates a byte string and ``u'unicode'`` must be used to\n        create a Unicode string.\n\n        With Python 3 and IronPython, this keyword passes if the string is\n        a Unicode string but fails if it is bytes. Notice that with both\n        Python 3 and IronPython, ``'string'`` creates a Unicode string, and\n        ``b'bytes'`` must be used to create a byte string.\n\n        The default error message can be overridden with the optional\n        ``msg`` argument.\n        ");
        pyFrame.setline(578);
        if (pyFrame.getglobal("is_string").__call__(threadState, pyFrame.getlocal(1)).__not__().__nonzero__()) {
            pyFrame.setline(579);
            pyFrame.getlocal(0).__getattr__("_fail").__call__(threadState, pyFrame.getlocal(2), (PyObject)PyString.fromInterned("'%s' is not a string."), pyFrame.getlocal(1));
        }
        pyFrame.f_lasti = -1;
        return Py.None;
    }

    public PyObject should_not_be_string$34(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(589);
        PyString.fromInterned("Fails if the given ``item`` is a string.\n\n        See `Should Be String` for more details about Unicode strings and byte\n        strings.\n\n        The default error message can be overridden with the optional\n        ``msg`` argument.\n        ");
        pyFrame.setline(590);
        if (pyFrame.getglobal("is_string").__call__(threadState, pyFrame.getlocal(1)).__nonzero__()) {
            pyFrame.setline(591);
            pyFrame.getlocal(0).__getattr__("_fail").__call__(threadState, pyFrame.getlocal(2), (PyObject)PyString.fromInterned("'%s' is a string."), pyFrame.getlocal(1));
        }
        pyFrame.f_lasti = -1;
        return Py.None;
    }

    public PyObject should_be_unicode_string$35(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(603);
        PyString.fromInterned("Fails if the given ``item`` is not a Unicode string.\n\n        Use `Should Be Byte String` if you want to verify the ``item`` is a\n        byte string, or `Should Be String` if both Unicode and byte strings\n        are fine. See `Should Be String` for more details about Unicode\n        strings and byte strings.\n\n        The default error message can be overridden with the optional\n        ``msg`` argument.\n        ");
        pyFrame.setline(604);
        if (pyFrame.getglobal("is_unicode").__call__(threadState, pyFrame.getlocal(1)).__not__().__nonzero__()) {
            pyFrame.setline(605);
            pyFrame.getlocal(0).__getattr__("_fail").__call__(threadState, pyFrame.getlocal(2), (PyObject)PyString.fromInterned("'%s' is not a Unicode string."), pyFrame.getlocal(1));
        }
        pyFrame.f_lasti = -1;
        return Py.None;
    }

    public PyObject should_be_byte_string$36(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(617);
        PyString.fromInterned("Fails if the given ``item`` is not a byte string.\n\n        Use `Should Be Unicode String` if you want to verify the ``item`` is a\n        Unicode string, or `Should Be String` if both Unicode and byte strings\n        are fine. See `Should Be String` for more details about Unicode strings\n        and byte strings.\n\n        The default error message can be overridden with the optional\n        ``msg`` argument.\n        ");
        pyFrame.setline(618);
        if (pyFrame.getglobal("is_bytes").__call__(threadState, pyFrame.getlocal(1)).__not__().__nonzero__()) {
            pyFrame.setline(619);
            pyFrame.getlocal(0).__getattr__("_fail").__call__(threadState, pyFrame.getlocal(2), (PyObject)PyString.fromInterned("'%s' is not a byte string."), pyFrame.getlocal(1));
        }
        pyFrame.f_lasti = -1;
        return Py.None;
    }

    public PyObject should_be_lowercase$37(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(631);
        PyString.fromInterned("Fails if the given ``string`` is not in lowercase.\n\n        For example, ``'string'`` and ``'with specials!'`` would pass, and\n        ``'String'``, ``''`` and ``' '`` would fail.\n\n        The default error message can be overridden with the optional\n        ``msg`` argument.\n\n        See also `Should Be Uppercase` and `Should Be Titlecase`.\n        ");
        pyFrame.setline(632);
        if (pyFrame.getlocal(1).__getattr__("islower").__call__(threadState).__not__().__nonzero__()) {
            pyFrame.setline(633);
            pyFrame.getlocal(0).__getattr__("_fail").__call__(threadState, pyFrame.getlocal(2), (PyObject)PyString.fromInterned("'%s' is not lowercase."), pyFrame.getlocal(1));
        }
        pyFrame.f_lasti = -1;
        return Py.None;
    }

    public PyObject should_be_uppercase$38(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(645);
        PyString.fromInterned("Fails if the given ``string`` is not in uppercase.\n\n        For example, ``'STRING'`` and ``'WITH SPECIALS!'`` would pass, and\n        ``'String'``, ``''`` and ``' '`` would fail.\n\n        The default error message can be overridden with the optional\n        ``msg`` argument.\n\n        See also `Should Be Titlecase` and `Should Be Lowercase`.\n        ");
        pyFrame.setline(646);
        if (pyFrame.getlocal(1).__getattr__("isupper").__call__(threadState).__not__().__nonzero__()) {
            pyFrame.setline(647);
            pyFrame.getlocal(0).__getattr__("_fail").__call__(threadState, pyFrame.getlocal(2), (PyObject)PyString.fromInterned("'%s' is not uppercase."), pyFrame.getlocal(1));
        }
        pyFrame.f_lasti = -1;
        return Py.None;
    }

    public PyObject should_be_titlecase$39(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(663);
        PyString.fromInterned("Fails if given ``string`` is not title.\n\n        ``string`` is a titlecased string if there is at least one\n        character in it, uppercase characters only follow uncased\n        characters and lowercase characters only cased ones.\n\n        For example, ``'This Is Title'`` would pass, and ``'Word In UPPER'``,\n        ``'Word In lower'``, ``''`` and ``' '`` would fail.\n\n        The default error message can be overridden with the optional\n        ``msg`` argument.\n\n        See also `Should Be Uppercase` and `Should Be Lowercase`.\n        ");
        pyFrame.setline(664);
        if (pyFrame.getlocal(1).__getattr__("istitle").__call__(threadState).__not__().__nonzero__()) {
            pyFrame.setline(665);
            pyFrame.getlocal(0).__getattr__("_fail").__call__(threadState, pyFrame.getlocal(2), (PyObject)PyString.fromInterned("'%s' is not titlecase."), pyFrame.getlocal(1));
        }
        pyFrame.f_lasti = -1;
        return Py.None;
    }

    public PyObject _convert_to_index$40(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(668);
        PyObject pyObject = pyFrame.getlocal(1);
        PyObject pyObject2 = pyObject._eq(PyString.fromInterned(""));
        pyObject = null;
        if (pyObject2.__nonzero__()) {
            pyFrame.setline(669);
            pyObject = Py.newInteger(0);
            pyFrame.f_lasti = -1;
            return pyObject;
        }
        pyFrame.setline(670);
        PyObject pyObject3 = pyFrame.getlocal(1);
        PyObject pyObject4 = pyObject3._is(pyFrame.getglobal("None"));
        pyObject3 = null;
        if (pyObject4.__nonzero__()) {
            pyFrame.setline(671);
            pyObject = pyFrame.getglobal("None");
            pyFrame.f_lasti = -1;
            return pyObject;
        }
        pyFrame.setline(672);
        pyObject = pyFrame.getlocal(0).__getattr__("_convert_to_integer").__call__(threadState, pyFrame.getlocal(1), pyFrame.getlocal(2));
        pyFrame.f_lasti = -1;
        return pyObject;
    }

    public PyObject _convert_to_integer$41(PyFrame pyFrame, ThreadState threadState) {
        try {
            pyFrame.setline(676);
            PyObject pyObject = pyFrame.getglobal("int").__call__(threadState, pyFrame.getlocal(1));
            pyFrame.f_lasti = -1;
            return pyObject;
        }
        catch (Throwable throwable) {
            PyException pyException = Py.setException(throwable, pyFrame);
            if (pyException.match(pyFrame.getglobal("ValueError"))) {
                pyFrame.setline(678);
                throw Py.makeException(pyFrame.getglobal("ValueError").__call__(threadState, PyString.fromInterned("Cannot convert '%s' argument '%s' to an integer.")._mod(new PyTuple(pyFrame.getlocal(2), pyFrame.getlocal(1)))));
            }
            throw pyException;
        }
    }

    public PyObject _fail$42(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(682);
        if (pyFrame.getlocal(1).__not__().__nonzero__()) {
            pyFrame.setline(683);
            PyObject pyObject = pyFrame.getlocal(2);
            PyObject pyObject2 = pyFrame.getglobal("tuple");
            pyFrame.setline(683);
            Object object = Py.EmptyObjects;
            PyFunction pyFunction = new PyFunction(pyFrame.f_globals, (PyObject[])object, f$43, null);
            PyObject pyObject3 = ((PyObject)pyFunction).__call__(threadState, pyFrame.getlocal(3).__iter__());
            Arrays.fill(object, null);
            object = pyObject._mod(pyObject2.__call__(threadState, pyObject3));
            pyFrame.setlocal(1, (PyObject)object);
            object = null;
        }
        pyFrame.setline(684);
        throw Py.makeException(pyFrame.getglobal("AssertionError").__call__(threadState, pyFrame.getlocal(1)));
    }

    /*
     * Enabled aggressive block sorting
     */
    public PyObject f$43(PyFrame pyFrame, ThreadState threadState) {
        PyObject pyObject;
        Object[] objectArray;
        PyObject pyObject2;
        switch (pyFrame.f_lasti) {
            default: {
                pyFrame.setline(683);
                pyObject2 = pyFrame.getlocal(0).__iter__();
                break;
            }
            case 1: {
                objectArray = pyFrame.f_savedlocals;
                pyObject2 = (PyObject)objectArray[3];
                pyObject = (PyObject)objectArray[4];
                Object object = pyFrame.getGeneratorInput();
                if (object instanceof PyException) {
                    throw (Throwable)object;
                }
                PyObject cfr_ignored_0 = (PyObject)object;
            }
        }
        pyFrame.setline(683);
        pyObject = pyObject2.__iternext__();
        if (pyObject != null) {
            pyFrame.setlocal(1, pyObject);
            pyFrame.setline(683);
            pyFrame.setline(683);
            pyFrame.f_lasti = 1;
            objectArray = new Object[5];
            objectArray[3] = pyObject2;
            objectArray[4] = pyObject;
            pyFrame.f_savedlocals = objectArray;
            return pyFrame.getglobal("unic").__call__(threadState, pyFrame.getlocal(1));
        }
        pyFrame.f_lasti = -1;
        return Py.None;
    }

    public String$py(String string2) {
        self = this;
        String[] stringArray = new String[]{};
        f$0 = Py.newCode(0, stringArray, string2, "<module>", 0, false, false, (PyFunctionTable)self, 0, null, null, 0, 4096);
        stringArray = new String[]{};
        String$1 = Py.newCode(0, stringArray, string2, "String", 27, false, false, (PyFunctionTable)self, 1, null, null, 0, 4096);
        stringArray = new String[]{"self", "string"};
        convert_to_lowercase$2 = Py.newCode(2, stringArray, string2, "convert_to_lowercase", 51, false, false, (PyFunctionTable)self, 2, null, null, 0, 4097);
        stringArray = new String[]{"self", "string"};
        convert_to_uppercase$3 = Py.newCode(2, stringArray, string2, "convert_to_uppercase", 66, false, false, (PyFunctionTable)self, 3, null, null, 0, 4097);
        stringArray = new String[]{"self", "string", "encoding", "errors"};
        encode_string_to_bytes$4 = Py.newCode(4, stringArray, string2, "encode_string_to_bytes", 79, false, false, (PyFunctionTable)self, 4, null, null, 0, 4097);
        stringArray = new String[]{"self", "bytes", "encoding", "errors"};
        decode_bytes_to_string$5 = Py.newCode(4, stringArray, string2, "decode_bytes_to_string", 102, false, false, (PyFunctionTable)self, 5, null, null, 0, 4097);
        stringArray = new String[]{"self", "string", "count"};
        get_line_count$6 = Py.newCode(2, stringArray, string2, "get_line_count", 126, false, false, (PyFunctionTable)self, 6, null, null, 0, 4097);
        stringArray = new String[]{"self", "string", "start", "end", "lines"};
        split_to_lines$7 = Py.newCode(4, stringArray, string2, "split_to_lines", 132, false, false, (PyFunctionTable)self, 7, null, null, 0, 4097);
        stringArray = new String[]{"self", "string", "line_number"};
        get_line$8 = Py.newCode(3, stringArray, string2, "get_line", 159, false, false, (PyFunctionTable)self, 8, null, null, 0, 4097);
        stringArray = new String[]{"self", "string", "pattern", "case_insensitive", "contains"};
        String[] stringArray2 = stringArray;
        stringArray = new String[]{"pattern"};
        get_lines_containing_string$9 = Py.newCode(4, stringArray2, string2, "get_lines_containing_string", 175, false, false, (PyFunctionTable)self, 9, stringArray, null, 0, 4097);
        stringArray = new String[]{"line"};
        String[] stringArray3 = stringArray;
        stringArray = new String[]{"pattern"};
        f$10 = Py.newCode(1, stringArray3, string2, "<lambda>", 200, false, false, (PyFunctionTable)self, 10, null, stringArray, 0, 4097);
        stringArray = new String[]{"line"};
        String[] stringArray4 = stringArray;
        stringArray = new String[]{"pattern"};
        f$11 = Py.newCode(1, stringArray4, string2, "<lambda>", 202, false, false, (PyFunctionTable)self, 11, null, stringArray, 0, 4097);
        stringArray = new String[]{"self", "string", "pattern", "case_insensitive", "matches"};
        String[] stringArray5 = stringArray;
        stringArray = new String[]{"pattern"};
        get_lines_matching_pattern$12 = Py.newCode(4, stringArray5, string2, "get_lines_matching_pattern", 205, false, false, (PyFunctionTable)self, 12, stringArray, null, 0, 4097);
        stringArray = new String[]{"line"};
        String[] stringArray6 = stringArray;
        stringArray = new String[]{"pattern"};
        f$13 = Py.newCode(1, stringArray6, string2, "<lambda>", 235, false, false, (PyFunctionTable)self, 13, null, stringArray, 0, 4097);
        stringArray = new String[]{"line"};
        String[] stringArray7 = stringArray;
        stringArray = new String[]{"pattern"};
        f$14 = Py.newCode(1, stringArray7, string2, "<lambda>", 237, false, false, (PyFunctionTable)self, 14, null, stringArray, 0, 4097);
        stringArray = new String[]{"self", "string", "pattern", "partial_match"};
        get_lines_matching_regexp$15 = Py.newCode(4, stringArray, string2, "get_lines_matching_regexp", 240, false, false, (PyFunctionTable)self, 15, null, null, 0, 4097);
        stringArray = new String[]{"self", "string", "matches", "lines", "matching", "_[281_20]", "line"};
        _get_matching_lines$16 = Py.newCode(3, stringArray, string2, "_get_matching_lines", 279, false, false, (PyFunctionTable)self, 16, null, null, 0, 4097);
        stringArray = new String[]{"self", "string", "pattern", "groups", "regexp", "_[315_18]", "g", "_[316_16]", "m"};
        get_regexp_matches$17 = Py.newCode(4, stringArray, string2, "get_regexp_matches", 285, true, false, (PyFunctionTable)self, 17, null, null, 0, 4097);
        stringArray = new String[]{"self", "group"};
        _parse_group$18 = Py.newCode(2, stringArray, string2, "_parse_group", 318, false, false, (PyFunctionTable)self, 18, null, null, 0, 4097);
        stringArray = new String[]{"self", "string", "search_for", "replace_with", "count"};
        replace_string$19 = Py.newCode(5, stringArray, string2, "replace_string", 324, false, false, (PyFunctionTable)self, 19, null, null, 0, 4097);
        stringArray = new String[]{"self", "string", "pattern", "replace_with", "count"};
        replace_string_using_regexp$20 = Py.newCode(5, stringArray, string2, "replace_string_using_regexp", 348, false, false, (PyFunctionTable)self, 20, null, null, 0, 4097);
        stringArray = new String[]{"self", "string", "removables", "removable"};
        remove_string$21 = Py.newCode(3, stringArray, string2, "remove_string", 369, true, false, (PyFunctionTable)self, 21, null, null, 0, 4097);
        stringArray = new String[]{"self", "string", "patterns", "pattern"};
        remove_string_using_regexp$22 = Py.newCode(3, stringArray, string2, "remove_string_using_regexp", 395, true, false, (PyFunctionTable)self, 22, null, null, 0, 4097);
        stringArray = new String[]{"self", "string", "separator", "max_split"};
        split_string$23 = Py.newCode(4, stringArray, string2, "split_string", 411, false, false, (PyFunctionTable)self, 23, null, null, 0, 4097);
        stringArray = new String[]{"self", "string", "separator", "max_split"};
        split_string_from_right$24 = Py.newCode(4, stringArray, string2, "split_string_from_right", 436, false, false, (PyFunctionTable)self, 24, null, null, 0, 4097);
        stringArray = new String[]{"self", "string"};
        split_string_to_characters$25 = Py.newCode(2, stringArray, string2, "split_string_to_characters", 451, false, false, (PyFunctionTable)self, 25, null, null, 0, 4097);
        stringArray = new String[]{"self", "string", "marker"};
        fetch_from_left$26 = Py.newCode(3, stringArray, string2, "fetch_from_left", 459, false, false, (PyFunctionTable)self, 26, null, null, 0, 4097);
        stringArray = new String[]{"self", "string", "marker"};
        fetch_from_right$27 = Py.newCode(3, stringArray, string2, "fetch_from_right", 469, false, false, (PyFunctionTable)self, 27, null, null, 0, 4097);
        stringArray = new String[]{"self", "length", "chars", "name", "value", "_(508_23)", "maxi"};
        String[] stringArray8 = stringArray;
        stringArray = new String[]{"maxi", "chars"};
        generate_random_string$28 = Py.newCode(3, stringArray8, string2, "generate_random_string", 479, false, false, (PyFunctionTable)self, 28, stringArray, null, 1, 4097);
        stringArray = new String[]{"_(x)", "_"};
        String[] stringArray9 = stringArray;
        stringArray = new String[]{"chars", "maxi"};
        f$29 = Py.newCode(1, stringArray9, string2, "<genexpr>", 508, false, false, (PyFunctionTable)self, 29, null, stringArray, 0, 4129);
        stringArray = new String[]{"self", "string", "start", "end"};
        get_substring$30 = Py.newCode(4, stringArray, string2, "get_substring", 510, false, false, (PyFunctionTable)self, 30, null, null, 0, 4097);
        stringArray = new String[]{"self", "string", "mode", "characters", "method"};
        String[] stringArray10 = stringArray;
        stringArray = new String[]{"string"};
        strip_string$31 = Py.newCode(4, stringArray10, string2, "strip_string", 528, false, false, (PyFunctionTable)self, 31, stringArray, null, 0, 4097);
        stringArray = new String[]{"characters"};
        String[] stringArray11 = stringArray;
        stringArray = new String[]{"string"};
        f$32 = Py.newCode(1, stringArray11, string2, "<lambda>", 555, false, false, (PyFunctionTable)self, 32, null, stringArray, 0, 4097);
        stringArray = new String[]{"self", "item", "msg"};
        should_be_string$33 = Py.newCode(3, stringArray, string2, "should_be_string", 560, false, false, (PyFunctionTable)self, 33, null, null, 0, 4097);
        stringArray = new String[]{"self", "item", "msg"};
        should_not_be_string$34 = Py.newCode(3, stringArray, string2, "should_not_be_string", 581, false, false, (PyFunctionTable)self, 34, null, null, 0, 4097);
        stringArray = new String[]{"self", "item", "msg"};
        should_be_unicode_string$35 = Py.newCode(3, stringArray, string2, "should_be_unicode_string", 593, false, false, (PyFunctionTable)self, 35, null, null, 0, 4097);
        stringArray = new String[]{"self", "item", "msg"};
        should_be_byte_string$36 = Py.newCode(3, stringArray, string2, "should_be_byte_string", 607, false, false, (PyFunctionTable)self, 36, null, null, 0, 4097);
        stringArray = new String[]{"self", "string", "msg"};
        should_be_lowercase$37 = Py.newCode(3, stringArray, string2, "should_be_lowercase", 621, false, false, (PyFunctionTable)self, 37, null, null, 0, 4097);
        stringArray = new String[]{"self", "string", "msg"};
        should_be_uppercase$38 = Py.newCode(3, stringArray, string2, "should_be_uppercase", 635, false, false, (PyFunctionTable)self, 38, null, null, 0, 4097);
        stringArray = new String[]{"self", "string", "msg"};
        should_be_titlecase$39 = Py.newCode(3, stringArray, string2, "should_be_titlecase", 649, false, false, (PyFunctionTable)self, 39, null, null, 0, 4097);
        stringArray = new String[]{"self", "value", "name"};
        _convert_to_index$40 = Py.newCode(3, stringArray, string2, "_convert_to_index", 667, false, false, (PyFunctionTable)self, 40, null, null, 0, 4097);
        stringArray = new String[]{"self", "value", "name"};
        _convert_to_integer$41 = Py.newCode(3, stringArray, string2, "_convert_to_integer", 674, false, false, (PyFunctionTable)self, 41, null, null, 0, 4097);
        stringArray = new String[]{"self", "message", "default_template", "items", "_(683_47)"};
        _fail$42 = Py.newCode(4, stringArray, string2, "_fail", 681, true, false, (PyFunctionTable)self, 42, null, null, 0, 4097);
        stringArray = new String[]{"_(x)", "item"};
        f$43 = Py.newCode(1, stringArray, string2, "<genexpr>", 683, false, false, (PyFunctionTable)self, 43, null, null, 0, 4129);
    }

    public PyCode getMain() {
        return f$0;
    }

    public static void main(String[] stringArray) {
        Py.runMain(CodeLoader.createSimpleBootstrap(new String$py("robot/libraries/String$py").getMain()), stringArray);
    }

    public static CodeBootstrap getCodeBootstrap() {
        return PyRunnableBootstrap.getFilenameConstructorReflectionBootstrap(String$py.class);
    }

    public PyObject call_function(int n, PyFrame pyFrame, ThreadState threadState) {
        String$py string$py = this;
        PyFrame pyFrame2 = pyFrame;
        ThreadState threadState2 = threadState;
        switch (n) {
            case 0: {
                return string$py.f$0(pyFrame2, threadState2);
            }
            case 1: {
                return string$py.String$1(pyFrame2, threadState2);
            }
            case 2: {
                return string$py.convert_to_lowercase$2(pyFrame2, threadState2);
            }
            case 3: {
                return string$py.convert_to_uppercase$3(pyFrame2, threadState2);
            }
            case 4: {
                return string$py.encode_string_to_bytes$4(pyFrame2, threadState2);
            }
            case 5: {
                return string$py.decode_bytes_to_string$5(pyFrame2, threadState2);
            }
            case 6: {
                return string$py.get_line_count$6(pyFrame2, threadState2);
            }
            case 7: {
                return string$py.split_to_lines$7(pyFrame2, threadState2);
            }
            case 8: {
                return string$py.get_line$8(pyFrame2, threadState2);
            }
            case 9: {
                return string$py.get_lines_containing_string$9(pyFrame2, threadState2);
            }
            case 10: {
                return string$py.f$10(pyFrame2, threadState2);
            }
            case 11: {
                return string$py.f$11(pyFrame2, threadState2);
            }
            case 12: {
                return string$py.get_lines_matching_pattern$12(pyFrame2, threadState2);
            }
            case 13: {
                return string$py.f$13(pyFrame2, threadState2);
            }
            case 14: {
                return string$py.f$14(pyFrame2, threadState2);
            }
            case 15: {
                return string$py.get_lines_matching_regexp$15(pyFrame2, threadState2);
            }
            case 16: {
                return string$py._get_matching_lines$16(pyFrame2, threadState2);
            }
            case 17: {
                return string$py.get_regexp_matches$17(pyFrame2, threadState2);
            }
            case 18: {
                return string$py._parse_group$18(pyFrame2, threadState2);
            }
            case 19: {
                return string$py.replace_string$19(pyFrame2, threadState2);
            }
            case 20: {
                return string$py.replace_string_using_regexp$20(pyFrame2, threadState2);
            }
            case 21: {
                return string$py.remove_string$21(pyFrame2, threadState2);
            }
            case 22: {
                return string$py.remove_string_using_regexp$22(pyFrame2, threadState2);
            }
            case 23: {
                return string$py.split_string$23(pyFrame2, threadState2);
            }
            case 24: {
                return string$py.split_string_from_right$24(pyFrame2, threadState2);
            }
            case 25: {
                return string$py.split_string_to_characters$25(pyFrame2, threadState2);
            }
            case 26: {
                return string$py.fetch_from_left$26(pyFrame2, threadState2);
            }
            case 27: {
                return string$py.fetch_from_right$27(pyFrame2, threadState2);
            }
            case 28: {
                return string$py.generate_random_string$28(pyFrame2, threadState2);
            }
            case 29: {
                return string$py.f$29(pyFrame2, threadState2);
            }
            case 30: {
                return string$py.get_substring$30(pyFrame2, threadState2);
            }
            case 31: {
                return string$py.strip_string$31(pyFrame2, threadState2);
            }
            case 32: {
                return string$py.f$32(pyFrame2, threadState2);
            }
            case 33: {
                return string$py.should_be_string$33(pyFrame2, threadState2);
            }
            case 34: {
                return string$py.should_not_be_string$34(pyFrame2, threadState2);
            }
            case 35: {
                return string$py.should_be_unicode_string$35(pyFrame2, threadState2);
            }
            case 36: {
                return string$py.should_be_byte_string$36(pyFrame2, threadState2);
            }
            case 37: {
                return string$py.should_be_lowercase$37(pyFrame2, threadState2);
            }
            case 38: {
                return string$py.should_be_uppercase$38(pyFrame2, threadState2);
            }
            case 39: {
                return string$py.should_be_titlecase$39(pyFrame2, threadState2);
            }
            case 40: {
                return string$py._convert_to_index$40(pyFrame2, threadState2);
            }
            case 41: {
                return string$py._convert_to_integer$41(pyFrame2, threadState2);
            }
            case 42: {
                return string$py._fail$42(pyFrame2, threadState2);
            }
            case 43: {
                return string$py.f$43(pyFrame2, threadState2);
            }
        }
        return null;
    }
}

