/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.python.core.BaseBytes;
import org.python.core.BaseBytesTest;
import org.python.core.Py;
import org.python.core.PyByteArray;
import org.python.core.PyException;
import org.python.core.PyInteger;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyType;
import org.python.util.PythonInterpreter;

public class PyByteArrayTest
extends BaseBytesTest {
    public PyByteArrayTest(String name) {
        super(name);
    }

    public static int[] patternInts(int na, int nd, int nb, String c) {
        int i;
        int[] r = new int[na + nd + nb];
        int p = 0;
        for (i = 0; i < na; ++i) {
            r[p++] = c.charAt(0);
        }
        for (i = 0; i < nd; ++i) {
            r[p++] = c.charAt(1);
        }
        for (i = 0; i < nb; ++i) {
            r[p++] = c.charAt(2);
        }
        return r;
    }

    public static int[] adbInts(int na, int nd, int nb) {
        return PyByteArrayTest.patternInts(na, nd, nb, "aDb");
    }

    public static int[] aebInts(int na, int ne, int nb) {
        return PyByteArrayTest.patternInts(na, ne, nb, "aEb");
    }

    public static int[][] randomSliceProblem(Random random2, int na, int nd, int nb, int ne) {
        int i;
        int[] adb = new int[na + nd + nb];
        int[] aeb = new int[na + ne + nb];
        int[] e = new int[ne];
        int[][] ret = new int[][]{adb, aeb, e};
        int p = 0;
        int q = 0;
        for (i = 0; i < na; ++i) {
            int a = random2.nextInt(256);
            adb[p++] = a;
            aeb[q++] = a;
        }
        for (i = 0; i < nd; ++i) {
            int d = random2.nextInt(256);
            adb[p++] = d;
        }
        for (i = 0; i < ne; ++i) {
            int x = random2.nextInt(256);
            e[p++] = x;
            aeb[q++] = x;
        }
        for (i = 0; i < nb; ++i) {
            int b = random2.nextInt(256);
            adb[p++] = b;
            aeb[q++] = b;
        }
        return ret;
    }

    public static void checkSlice(int na, int nd, int nb, int ne, int[] x, int[] y, BaseBytes result2) {
        PyByteArrayTest.assertEquals((String)"size", (int)(na + ne + nb), (int)result2.size());
        PyByteArrayTest.checkInts(x, 0, result2, 0, na);
        PyByteArrayTest.checkInts(y, 0, result2, na, ne);
        PyByteArrayTest.checkInts(x, na + nd, result2, na + ne, nb);
    }

    public static void checkSlice(int start, int step, int n, int[] x, int[] y, BaseBytes u) {
        PyByteArrayTest.assertEquals((String)"size", (int)x.length, (int)u.size());
        if (step > 0) {
            int px;
            int py2 = 0;
            for (px = 0; px < start; ++px) {
                PyByteArrayTest.assertEquals((String)"before slice", (int)x[px], (int)u.intAt(px));
            }
            if (n > 0) {
                PyByteArrayTest.assertEquals((String)"first affected", (int)y[py2++], (int)u.intAt(px++));
            }
            for (int i = 1; i < n; ++i) {
                int j = 1;
                while (j < step) {
                    PyByteArrayTest.assertEquals((String)"in gap", (int)x[px], (int)u.intAt(px));
                    ++j;
                    ++px;
                }
                PyByteArrayTest.assertEquals((String)"next affected", (int)y[py2++], (int)u.intAt(px++));
            }
            while (px < x.length) {
                PyByteArrayTest.assertEquals((String)"after slice", (int)x[px], (int)u.intAt(px));
                ++px;
            }
        } else {
            int px;
            step = -step;
            int py3 = 0;
            for (px = x.length - 1; px > start; --px) {
                PyByteArrayTest.assertEquals((String)"after slice", (int)x[px], (int)u.intAt(px));
            }
            if (n > 0) {
                PyByteArrayTest.assertEquals((String)"first affected", (int)y[py3++], (int)u.intAt(px--));
            }
            for (int i = 1; i < n; ++i) {
                int j = 1;
                while (j < step) {
                    PyByteArrayTest.assertEquals((String)"in gap", (int)x[px], (int)u.intAt(px));
                    ++j;
                    --px;
                }
                PyByteArrayTest.assertEquals((String)"next affected", (int)y[py3++], (int)u.intAt(px--));
            }
            while (px >= 0) {
                PyByteArrayTest.assertEquals((String)"before slice", (int)x[px], (int)u.intAt(px));
                --px;
            }
        }
    }

    public static void checkDelSlice(int start, int step, int n, int[] x, BaseBytes u) {
        PyByteArrayTest.assertEquals((String)"size", (int)(x.length - n), (int)u.size());
        if (step > 0) {
            int px;
            int pu = 0;
            for (px = 0; px < start; ++px) {
                PyByteArrayTest.assertEquals((String)"before slice", (int)x[px], (int)u.intAt(pu++));
            }
            ++px;
            for (int i = 1; i < n; ++i) {
                int j = 1;
                while (j < step) {
                    PyByteArrayTest.assertEquals((String)"in gap", (int)x[px], (int)u.intAt(pu++));
                    ++j;
                    ++px;
                }
                ++px;
            }
            while (px < x.length) {
                PyByteArrayTest.assertEquals((String)"after slice", (int)x[px], (int)u.intAt(pu++));
                ++px;
            }
        } else {
            int px;
            step = -step;
            int pu = u.size - 1;
            for (px = x.length - 1; px > start; --px) {
                PyByteArrayTest.assertEquals((String)"after slice", (int)x[px], (int)u.intAt(pu--));
            }
            --px;
            for (int i = 1; i < n; ++i) {
                int j = 1;
                while (j < step) {
                    PyByteArrayTest.assertEquals((String)"in gap", (int)x[px], (int)u.intAt(pu--));
                    ++j;
                    --px;
                }
                --px;
            }
            while (px >= 0) {
                PyByteArrayTest.assertEquals((String)"before slice", (int)x[px], (int)u.intAt(pu--));
                --px;
            }
        }
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void test__getslice__2() {
        int[] posStart;
        int verbose2 = 0;
        String ver = "L'un a la pourpre de nos \u00e2mes";
        int L = ver.length();
        int[] aRef = PyByteArrayTest.toInts(ver);
        PyByteArray a = this.getInstance(aRef);
        ArrayList<PyInteger> bList = new ArrayList<PyInteger>(L);
        this.interp = new PythonInterpreter();
        for (int start : posStart = new int[]{0, 8, 16, L - 5, L - 1}) {
            PyInteger pyStart = new PyInteger(start);
            PyObject pyStart_L = start > 0 ? new PyInteger(start - L) : Py.None;
            for (int stop = start; stop <= L; ++stop) {
                bList.clear();
                for (int i = start; i < stop; ++i) {
                    if (verbose2 >= 5) {
                        System.out.printf("    (%d,%d) i=%d\n", start, stop, i);
                    }
                    bList.add(new PyInteger(aRef[i]));
                }
                PyObject pyStop_L = stop < L ? new PyInteger(stop - L) : Py.None;
                PyInteger pyStop = new PyInteger(stop);
                this.doTest__getslice__2(a, pyStart, pyStop, bList, verbose2 + 2);
                this.doTest__getslice__2(a, pyStart_L, pyStop, bList, verbose2);
                this.doTest__getslice__2(a, pyStart, pyStop_L, bList, verbose2);
                this.doTest__getslice__2(a, pyStart_L, pyStop_L, bList, verbose2);
            }
        }
    }

    private void doTest__getslice__2(BaseBytes a, PyObject pyStart, PyObject pyStop, List<PyInteger> bList, int verbose2) {
        if (verbose2 >= 4) {
            System.out.printf("    __getslice__(%s,%s)\n", pyStart, pyStop);
        }
        PyObject b = a.__getslice__(pyStart, pyStop);
        if (verbose2 >= 3) {
            System.out.println(this.toString((BaseBytes)b));
        }
        PyByteArrayTest.checkInts(bList, b);
    }

    public void test__getslice__3() {
        int verbose2 = 0;
        String ver = "Quand je br\u00fble et que tu t'enflammes ;";
        int L = ver.length();
        int[] aRef = PyByteArrayTest.toInts(ver);
        PyByteArray a = this.getInstance(aRef);
        ArrayList<PyInteger> bList = new ArrayList<PyInteger>(L);
        this.interp = new PythonInterpreter();
        int[] posStart = new int[]{0, 9, 22, L - 11, L - 1};
        for (int step = 1; step < 4; ++step) {
            PyInteger pyStep = new PyInteger(step);
            for (int start : posStart) {
                PyInteger pyStart = new PyInteger(start);
                PyObject pyStart_L = start > 0 ? new PyInteger(start - L) : Py.None;
                for (int stop = start; stop <= L; ++stop) {
                    bList.clear();
                    for (int i = start; i < stop; i += step) {
                        if (verbose2 >= 5) {
                            System.out.printf("    (%d,%d,%d) i=%d\n", start, stop, step, i);
                        }
                        bList.add(new PyInteger(aRef[i]));
                    }
                    PyObject pyStop_L = stop < L ? new PyInteger(stop - L) : Py.None;
                    PyInteger pyStop = new PyInteger(stop);
                    this.doTest__getslice__3(a, pyStart, pyStop, pyStep, bList, verbose2 + 2);
                    this.doTest__getslice__3(a, pyStart_L, pyStop, pyStep, bList, verbose2);
                    this.doTest__getslice__3(a, pyStart, pyStop_L, pyStep, bList, verbose2);
                    this.doTest__getslice__3(a, pyStart_L, pyStop_L, pyStep, bList, verbose2);
                }
            }
        }
        int[] negStart = new int[]{0, 5, 14, L - 10, L - 1};
        for (int step = -1; step > -4; --step) {
            PyInteger pyStep = new PyInteger(step);
            for (int start : negStart) {
                PyInteger pyStart = new PyInteger(start);
                PyObject pyStart_L = start < L - 1 ? new PyInteger(start - L) : Py.None;
                for (int stop = start; stop >= -1; --stop) {
                    PyObject pyStop_L;
                    bList.clear();
                    for (int i = start; i > stop; i += step) {
                        if (verbose2 >= 5) {
                            System.out.printf("    (%d,%d,%d) i=%d\n", start, stop, step, i);
                        }
                        bList.add(new PyInteger(aRef[i]));
                    }
                    if (stop >= 0) {
                        pyStop_L = new PyInteger(stop - L);
                    } else {
                        stop = -(L + 1);
                        pyStop_L = Py.None;
                    }
                    PyInteger pyStop = new PyInteger(stop);
                    this.doTest__getslice__3(a, pyStart, pyStop, pyStep, bList, verbose2 + 2);
                    this.doTest__getslice__3(a, pyStart_L, pyStop, pyStep, bList, verbose2);
                    this.doTest__getslice__3(a, pyStart, pyStop_L, pyStep, bList, verbose2);
                    this.doTest__getslice__3(a, pyStart_L, pyStop_L, pyStep, bList, verbose2);
                }
            }
        }
    }

    private void doTest__getslice__3(BaseBytes a, PyObject pyStart, PyObject pyStop, PyObject pyStep, List<PyInteger> bList, int verbose2) {
        if (verbose2 >= 4) {
            System.out.printf("    __getslice__(%s,%s,%s)\n", pyStart, pyStop, pyStep);
        }
        PyObject b = a.__getslice__(pyStart, pyStop, pyStep);
        if (verbose2 >= 3) {
            System.out.println(this.toString((BaseBytes)b));
        }
        PyByteArrayTest.checkInts(bList, b);
    }

    @Override
    public void testPyset() {
        int[] badValue;
        int verbose2 = 0;
        this.interp = new PythonInterpreter();
        int[] aRef = PyByteArrayTest.randomInts(this.random, 25);
        PyByteArray a = this.getInstance(aRef);
        for (int i = 0; i < 25; ++i) {
            int b = aRef[i] ^ 0x55;
            PyInteger pyb = new PyInteger(b);
            a.__setitem__(i, (PyObject)pyb);
            int ai = a.pyget(i).asInt();
            if (verbose2 >= 3) {
                System.out.printf("    __setitem__(%2d,%3d) : a[%2d]=%3d\n", i, b, i, ai);
            }
            PyByteArrayTest.assertEquals((int)b, (int)ai);
        }
        for (int i : badValue = new int[]{256, Integer.MAX_VALUE, -1, -2, -100, -65536, Integer.MIN_VALUE}) {
            PyInteger b = new PyInteger(i);
            try {
                a.__setitem__(0, (PyObject)b);
                PyByteArrayTest.fail((String)("Exception not thrown for __setitem__(0, " + b + ")"));
            }
            catch (PyException pye) {
                PyByteArrayTest.assertEquals((Object)Py.ValueError, (Object)pye.type);
                if (verbose2 < 2) continue;
                System.out.printf("    Exception: %s\n", pye);
            }
        }
        PyInteger x = new PyInteger(10);
        for (int i : new int[]{-26, -125, 25, 26}) {
            try {
                a.__setitem__(i, (PyObject)x);
                PyByteArrayTest.fail((String)("Exception not thrown for __setitem__(" + i + ", x)"));
            }
            catch (PyException pye) {
                PyByteArrayTest.assertEquals((Object)Py.IndexError, (Object)pye.type);
                if (verbose2 < 2) continue;
                System.out.printf("    Exception: %s\n", pye);
            }
        }
    }

    public void testSetslice2() {
        int[] neList;
        int verbose2 = 0;
        int[] naList = new int[]{2, 5, 0};
        int[] ndList = new int[]{5, 20, 0};
        int[] nbList = new int[]{4, 7, 0};
        for (int ne : neList = new int[]{4, 5, 6, 20, 0}) {
            int[] eInts = new int[ne];
            Arrays.fill(eInts, 69);
            PyByteArray e = new PyByteArray(eInts);
            for (int nd : ndList) {
                for (int na : naList) {
                    for (int nb : nbList) {
                        int[] aRef = PyByteArrayTest.adbInts(na, nd, nb);
                        int[] bRef = PyByteArrayTest.aebInts(na, ne, nb);
                        PyByteArray b = this.getInstance(aRef);
                        byte[] oldStorage = b.storage;
                        if (verbose2 >= 2) {
                            System.out.printf("setslice(%d,%d,%d,e[len=%d])\n", na, na + nd, 1, ne);
                            if (verbose2 >= 3) {
                                System.out.println(this.toString(b));
                            }
                        }
                        b.setslice(na, na + nd, 1, (PyObject)e);
                        if (verbose2 >= 2) {
                            boolean avAlloc;
                            boolean bl = avAlloc = b.storage != oldStorage && bRef.length <= oldStorage.length;
                            if (b.storage.length * 2 < oldStorage.length) {
                                avAlloc = false;
                            }
                            System.out.println(this.toString(b) + (avAlloc ? " avoidable new" : ""));
                        }
                        PyByteArrayTest.checkInts(bRef, (BaseBytes)b);
                    }
                }
            }
        }
        int AMAX = 7;
        int BMAX = 7;
        int DMAX = 25;
        int EMAX = 25;
        int[] xInts = PyByteArrayTest.randomInts(this.random, 39, 117, 122);
        int[] yInts = PyByteArrayTest.randomInts(this.random, 25, 65, 72);
        PyByteArray x = this.getInstance(xInts);
        PyByteArray y = this.getInstance(yInts);
        int[] nbList2 = new int[]{0, 1, 7};
        for (int na = 0; na <= 7; ++na) {
            for (int nb : nbList2) {
                for (int nd = 0; nd < 25; ++nd) {
                    for (int ne = 0; ne < 25; ++ne) {
                        PyByteArray u = x.getslice(0, na + nd + nb, 1);
                        PyByteArray e = y.getslice(0, ne, 1);
                        if (verbose2 >= 2) {
                            System.out.printf("setslice(start=%d, stop=%d, step=%d, e[len=%d])\n", na, na + nd, 1, ne);
                            if (verbose2 >= 3) {
                                System.out.println("u = " + this.toString(u));
                                System.out.println("e = " + this.toString(e));
                            }
                        }
                        u.setslice(na, na + nd, 1, (PyObject)e);
                        if (verbose2 >= 1) {
                            System.out.println("u'= " + this.toString(u));
                        }
                        PyByteArrayTest.checkSlice(na, nd, nb, ne, xInts, yInts, u);
                    }
                }
            }
        }
    }

    public void test__setslice__2() {
        int verbose2 = 0;
        String ver = "Cet autre affecte tes langueurs";
        int L = ver.length();
        int[] uRef = PyByteArrayTest.toInts(ver);
        this.interp = new PythonInterpreter();
        int[] eRef = PyByteArrayTest.randomInts(this.random, 14, 86, 90);
        BaseBytesTest.MyBytes eFull = new BaseBytesTest.MyBytes(eRef);
        int[] posStart = new int[]{0, 4, 10, 18, L - 9};
        int[] posStop = new int[]{0, 3, 9, 17, L - 10, L};
        for (int start : posStart) {
            PyInteger pyStart = new PyInteger(start);
            PyObject pyStart_L = start > 0 ? new PyInteger(start - L) : Py.None;
            for (int stop : posStop) {
                if (stop < start) continue;
                PyObject pyStop_L = stop < L ? new PyInteger(stop - L) : Py.None;
                PyInteger pyStop = new PyInteger(stop);
                for (int n = 0; n <= eRef.length; ++n) {
                    this.doTest__setslice__2(uRef, pyStart, pyStop, eFull, n, eRef, start, stop, verbose2 + 2);
                    this.doTest__setslice__2(uRef, pyStart_L, pyStop, eFull, n, eRef, start, stop, verbose2);
                    this.doTest__setslice__2(uRef, pyStart, pyStop_L, eFull, n, eRef, start, stop, verbose2);
                    this.doTest__setslice__2(uRef, pyStart_L, pyStop_L, eFull, n, eRef, start, stop, verbose2);
                }
            }
        }
    }

    private void doTest__setslice__2(int[] uRef, PyObject pyStart, PyObject pyStop, BaseBytes eFull, int n, int[] eRef, int start, int stop, int verbose2) {
        PyByteArray u = this.getInstance(uRef);
        BaseBytes e = eFull.getslice(0, n, 1);
        if (verbose2 >= 4) {
            System.out.printf("    __setslice__(%s,%s,e[0:%d])\n", pyStart, pyStop, n);
            System.out.println("u = " + this.toString(u));
            System.out.println("e = " + this.toString(e));
        }
        u.__setslice__(pyStart, pyStop, e);
        if (verbose2 >= 3) {
            System.out.println("u'= " + this.toString(u));
        }
        int nd = stop - start;
        int nb = uRef.length - stop;
        PyByteArrayTest.checkSlice(start, nd, nb, n, uRef, eRef, u);
    }

    @Override
    public void testSetslice3() {
        int verbose2 = 0;
        this.interp = new PythonInterpreter();
        int[] eRef = PyByteArrayTest.randomInts(this.random, 25, 65, 72);
        BaseBytesTest.MyBytes eFull = new BaseBytesTest.MyBytes(eRef);
        int[] uRef = PyByteArrayTest.randomInts(this.random, 25, 109, 115);
        int[] posStep = new int[]{2, 3, 5, 8, 25, 100};
        for (int start = 0; start < uRef.length; ++start) {
            int len = uRef.length - start;
            for (int step : posStep) {
                int nmax = (len + step - 1) / step;
                for (int n = 1; n <= nmax; ++n) {
                    int last = start + step * (n - 1) + 1;
                    for (int stop = last + 1; stop < last + step; ++stop) {
                        PyByteArray u = this.getInstance(uRef);
                        BaseBytes e = ((BaseBytes)eFull).getslice(0, n, 1);
                        if (verbose2 >= 2) {
                            System.out.printf("setslice(start=%d, stop=%d, step=%d, e[len=%d])\n", start, stop, step, n);
                            if (verbose2 >= 3) {
                                System.out.println("u = " + this.toString(u));
                                System.out.println("e = " + this.toString(e));
                            }
                        }
                        u.setslice(start, stop, step, (PyObject)e);
                        if (verbose2 >= 1) {
                            System.out.println("u'= " + this.toString(u));
                        }
                        PyByteArrayTest.checkSlice(start, step, n, uRef, eRef, u);
                    }
                }
            }
        }
        int[] negStep = new int[]{-1, -2, -5, -8, -25, -100};
        for (int start = uRef.length - 1; start >= 0; --start) {
            int len = start + 1;
            for (int step : negStep) {
                int nmax = (len + -step - 1) / -step;
                for (int n = 1; n <= nmax; ++n) {
                    int last;
                    for (int stop = last = start + step * (n - 1) - 1; stop > last - -step && stop >= 0; --stop) {
                        PyByteArray u = this.getInstance(uRef);
                        BaseBytes e = ((BaseBytes)eFull).getslice(0, n, 1);
                        if (verbose2 >= 2) {
                            System.out.printf("setslice(start=%d, stop=%d, step=%d, e[len=%d])\n", start, stop, step, n);
                            if (verbose2 >= 3) {
                                System.out.println("u = " + this.toString(u));
                                System.out.println("e = " + this.toString(e));
                            }
                        }
                        u.setslice(start, stop, step, (PyObject)e);
                        if (verbose2 >= 1) {
                            System.out.println("u'= " + this.toString(u));
                        }
                        PyByteArrayTest.checkSlice(start, step, n, uRef, eRef, u);
                    }
                }
            }
        }
    }

    public void test__setslice__3() {
        int verbose2 = 0;
        this.interp = new PythonInterpreter();
        int[] eRef = PyByteArrayTest.randomInts(this.random, 25, 65, 72);
        BaseBytesTest.MyBytes eFull = new BaseBytesTest.MyBytes(eRef);
        int[] uRef = PyByteArrayTest.randomInts(this.random, 25, 109, 115);
        int[] posStep = new int[]{2, 3, 5, 8, 25, 100};
        for (int start = 0; start < uRef.length; ++start) {
            PyInteger pyStart = new PyInteger(start);
            int len = uRef.length - start;
            for (int step : posStep) {
                PyInteger pyStep = new PyInteger(step);
                int nmax = (len + step - 1) / step;
                for (int n = 1; n <= nmax; ++n) {
                    int last = start + step * (n - 1) + 1;
                    for (int stop = last + 1; stop < last + step; ++stop) {
                        PyInteger pyStop = new PyInteger(stop);
                        PyByteArray u = this.getInstance(uRef);
                        BaseBytes e = ((BaseBytes)eFull).getslice(0, n, 1);
                        if (verbose2 >= 2) {
                            System.out.printf("setslice(%d,%d,%d, e[len=%d])\n", start, stop, step, n);
                            if (verbose2 >= 3) {
                                System.out.println("u = " + this.toString(u));
                                System.out.println("e = " + this.toString(e));
                            }
                        }
                        u.__setslice__(pyStart, pyStop, pyStep, e);
                        if (verbose2 >= 1) {
                            System.out.println("u'= " + this.toString(u));
                        }
                        PyByteArrayTest.checkSlice(start, step, n, uRef, eRef, u);
                    }
                }
            }
        }
        int[] negStep = new int[]{-1, -2, -5, -8, -25, -100};
        for (int start = uRef.length - 1; start >= 0; --start) {
            PyInteger pyStart = new PyInteger(start);
            int len = start + 1;
            for (int step : negStep) {
                PyInteger pyStep = new PyInteger(step);
                int nmax = (len + -step - 1) / -step;
                for (int n = 1; n <= nmax; ++n) {
                    int last;
                    for (int stop = last = start + step * (n - 1) - 1; stop > last - -step && stop >= 0; --stop) {
                        PyInteger pyStop = new PyInteger(stop);
                        PyByteArray u = this.getInstance(uRef);
                        BaseBytes e = ((BaseBytes)eFull).getslice(0, n, 1);
                        if (verbose2 >= 2) {
                            System.out.printf("setslice(%d,%d,%d, e[len=%d])\n", start, stop, step, n);
                            if (verbose2 >= 3) {
                                System.out.println("u = " + this.toString(u));
                                System.out.println("e = " + this.toString(e));
                            }
                        }
                        u.__setslice__(pyStart, pyStop, pyStep, e);
                        if (verbose2 >= 1) {
                            System.out.println("u'= " + this.toString(u));
                        }
                        PyByteArrayTest.checkSlice(start, step, n, uRef, eRef, u);
                    }
                }
            }
        }
    }

    public void testSetsliceTime() {
        int verbose2 = 1;
        this.timeSetslice(50, 100, 7, 14, verbose2);
        this.timeSetslice(50, 100, 25, 25, verbose2);
        this.timeSetslice(500, 20, 2000, 400, verbose2);
    }

    private void timeSetslice(int trials, int repeats, int N, int M, int verbose2) {
        int[] startList = new int[11];
        for (int i = 0; i < startList.length; ++i) {
            startList[i] = N * i / (startList.length - 1);
        }
        int[] changeList = new int[11];
        for (int i = 0; i < changeList.length; ++i) {
            changeList[i] = M * i / (changeList.length - 1);
        }
        long[][] elapsed = new long[startList.length][changeList.length];
        for (int row = 0; row < startList.length; ++row) {
            for (int col = 0; col < changeList.length; ++col) {
                elapsed[row][col] = Long.MAX_VALUE;
            }
        }
        int[] xRef = PyByteArrayTest.randomInts(this.random, N, 117, 122);
        PyByteArray x = this.getInstance(xRef);
        int[] yRef = PyByteArrayTest.randomInts(this.random, M, 65, 72);
        PyByteArray y = this.getInstance(yRef);
        PyByteArray[] u = new PyByteArray[repeats];
        for (int trial = 0; trial < trials; ++trial) {
            for (int irow = 0; irow < startList.length; ++irow) {
                int row = (irow + 5 * trial) % startList.length;
                int na = startList[row];
                int nd = 0;
                for (int icol = 0; icol < changeList.length; ++icol) {
                    long t;
                    int col = (icol + trial) % changeList.length;
                    int ne = changeList[col];
                    int start = na;
                    int stop = na + nd;
                    PyByteArray e = y.getslice(0, ne, 1);
                    if (trial == 0) {
                        this.doTimeSetslice(u, start, stop, e, x, verbose2);
                        PyByteArrayTest.checkSlice(na, nd, N - (na + nd), ne, xRef, yRef, u[0]);
                    }
                    if ((t = this.doTimeSetslice(u, start, stop, e, x, -1)) >= elapsed[row][col]) continue;
                    elapsed[row][col] = t;
                }
            }
        }
        if (verbose2 >= 1) {
            System.out.print("     N  ,     na  ");
            for (int col = 0; col < changeList.length; ++col) {
                System.out.printf(", ne=%7d", changeList[col]);
            }
            System.out.println(", elements inserted: time in microseconds.");
            for (int row = 0; row < startList.length; ++row) {
                System.out.printf("%8d, %8d", N, startList[row]);
                for (int col = 0; col < changeList.length; ++col) {
                    double usPerCall = 0.001 * (double)elapsed[row][col] / (double)repeats;
                    System.out.printf(", %10.3f", usPerCall);
                }
                System.out.println();
            }
        }
    }

    private long doTimeSetslice(PyByteArray[] u, int start, int stop, BaseBytes e, BaseBytes x, int verbose2) {
        int repeats = 1;
        if (verbose2 < 0) {
            repeats = u.length;
        }
        for (int i = 0; i < repeats; ++i) {
            u[i] = new PyByteArray(x);
        }
        PyByteArray v = u[0];
        byte[] oldStorage = v.storage;
        if (verbose2 >= 3) {
            System.out.printf("setslice(%d,%d,%d,e[%d])\n", start, stop, 1, e.size());
            System.out.println("u = " + this.toString(v));
            System.out.println("e = " + this.toString(e));
        }
        long beginTime = System.nanoTime();
        for (int i = 0; i < repeats; ++i) {
            u[i].setslice(start, stop, 1, (PyObject)e);
        }
        long t = System.nanoTime() - beginTime;
        if (verbose2 >= 2) {
            boolean avAlloc;
            boolean bl = avAlloc = v.storage != oldStorage;
            if (v.size * 2 <= oldStorage.length) {
                avAlloc = false;
            }
            if (v.size > oldStorage.length) {
                avAlloc = false;
            }
            System.out.println("u'= " + this.toString(v) + (avAlloc ? " new" : ""));
        }
        return t;
    }

    public void testDelslice2() {
        int verbose2 = 0;
        int[] naList = new int[]{2, 5, 0};
        int[] ndList = new int[]{5, 20, 0};
        int[] nbList = new int[]{4, 7, 0};
        for (int nd : ndList) {
            for (int na : naList) {
                for (int nb : nbList) {
                    int[] aRef = PyByteArrayTest.adbInts(na, nd, nb);
                    int[] bRef = PyByteArrayTest.aebInts(na, 0, nb);
                    PyByteArray b = this.getInstance(aRef);
                    byte[] oldStorage = b.storage;
                    if (verbose2 >= 2) {
                        System.out.printf("delslice(%d,%d,%d,%d)\n", na, na + nd, 1, nd);
                        if (verbose2 >= 3) {
                            System.out.println(this.toString(b));
                        }
                    }
                    b.delslice(na, na + nd, 1, nd);
                    if (verbose2 >= 2) {
                        boolean avAlloc;
                        boolean bl = avAlloc = b.storage != oldStorage;
                        if (bRef.length * 2 <= oldStorage.length) {
                            avAlloc = false;
                        }
                        System.out.println(this.toString(b) + (avAlloc ? " avoidable new" : ""));
                    }
                    PyByteArrayTest.checkInts(bRef, (BaseBytes)b);
                }
            }
        }
        int AMAX = 7;
        int BMAX = 7;
        int DMAX = 25;
        int[] xInts = PyByteArrayTest.randomInts(this.random, 39, 117, 122);
        PyByteArray x = this.getInstance(xInts);
        int[] nbList2 = new int[]{0, 1, 7};
        for (int na = 0; na <= 7; ++na) {
            for (int nb : nbList2) {
                for (int nd = 0; nd < 25; ++nd) {
                    PyByteArray u = x.getslice(0, na + nd + nb, 1);
                    if (verbose2 >= 2) {
                        System.out.printf("delslice(start=%d, stop=%d, step=%d, n=%d)\n", na, na + nd, 1, nd);
                        if (verbose2 >= 3) {
                            System.out.println("u = " + this.toString(u));
                        }
                    }
                    u.delslice(na, na + nd, 1, nd);
                    if (verbose2 >= 1) {
                        System.out.println("u'= " + this.toString(u));
                    }
                    PyByteArrayTest.checkSlice(na, nd, nb, 0, xInts, null, u);
                }
            }
        }
    }

    public void test__delslice__2() {
        int verbose2 = 0;
        String ver = "Et tes p\u00e2leurs, alors que lasse,";
        int L = ver.length();
        int[] uRef = PyByteArrayTest.toInts(ver);
        this.interp = new PythonInterpreter();
        int[] posStart = new int[]{0, 3, 7, 16, L - 1};
        int[] posStop = new int[]{0, 3, 7, 16, L - 6, L};
        for (int start : posStart) {
            PyInteger pyStart = new PyInteger(start);
            PyObject pyStart_L = start > 0 ? new PyInteger(start - L) : Py.None;
            for (int stop : posStop) {
                if (stop < start) continue;
                PyObject pyStop_L = stop < L ? new PyInteger(stop - L) : Py.None;
                PyInteger pyStop = new PyInteger(stop);
                this.doTest__delslice__2(uRef, pyStart, pyStop, start, stop, verbose2 + 2);
                this.doTest__delslice__2(uRef, pyStart_L, pyStop, start, stop, verbose2);
                this.doTest__delslice__2(uRef, pyStart, pyStop_L, start, stop, verbose2);
                this.doTest__delslice__2(uRef, pyStart_L, pyStop_L, start, stop, verbose2);
            }
        }
    }

    private void doTest__delslice__2(int[] uRef, PyObject pyStart, PyObject pyStop, int start, int stop, int verbose2) {
        PyByteArray u = this.getInstance(uRef);
        if (verbose2 >= 4) {
            System.out.printf("    __delslice__(%s,%s,1)\n", pyStart, pyStop);
            System.out.println("u = " + this.toString(u));
        }
        u.__delslice__(pyStart, pyStop);
        if (verbose2 >= 3) {
            System.out.println("u'= " + this.toString(u));
        }
        int nd = stop - start;
        int nb = uRef.length - stop;
        PyByteArrayTest.checkSlice(start, nd, nb, 0, uRef, null, u);
    }

    public void test__delslice__3() {
        int verbose2 = 0;
        this.interp = new PythonInterpreter();
        int[] uRef = PyByteArrayTest.randomInts(this.random, 25, 109, 115);
        int[] posStep = new int[]{2, 3, 5, 8, 25, 100};
        for (int start = 0; start < uRef.length; ++start) {
            PyInteger pyStart = new PyInteger(start);
            int len = uRef.length - start;
            for (int step : posStep) {
                PyInteger pyStep = new PyInteger(step);
                int nmax = (len + step - 1) / step;
                for (int n = 1; n <= nmax; ++n) {
                    int last = start + step * (n - 1) + 1;
                    for (int stop = last + 1; stop < last + step; ++stop) {
                        PyInteger pyStop = new PyInteger(stop);
                        PyByteArray u = this.getInstance(uRef);
                        if (verbose2 >= 2) {
                            System.out.printf("__delslice__(%d,%d,%d) (%d deletions)\n", start, stop, step, n);
                            if (verbose2 >= 3) {
                                System.out.println("u = " + this.toString(u));
                            }
                        }
                        u.__delslice__(pyStart, pyStop, pyStep);
                        if (verbose2 >= 1) {
                            System.out.println("u'= " + this.toString(u));
                        }
                        PyByteArrayTest.checkDelSlice(start, step, n, uRef, u);
                    }
                }
            }
        }
        int[] negStep = new int[]{-1, -2, -5, -8, -25, -100};
        for (int start = uRef.length - 1; start >= 0; --start) {
            PyInteger pyStart = new PyInteger(start);
            int len = start + 1;
            for (int step : negStep) {
                PyInteger pyStep = new PyInteger(step);
                int nmax = (len + -step - 1) / -step;
                for (int n = 1; n <= nmax; ++n) {
                    int last;
                    for (int stop = last = start + step * (n - 1) - 1; stop > last - -step && stop >= 0; --stop) {
                        PyInteger pyStop = new PyInteger(stop);
                        PyByteArray u = this.getInstance(uRef);
                        if (verbose2 >= 2) {
                            System.out.printf("__delslice__(%d,%d,%d) (%d deletions)\n", start, stop, step, n);
                            if (verbose2 >= 3) {
                                System.out.println("u = " + this.toString(u));
                            }
                        }
                        u.__delslice__(pyStart, pyStop, pyStep);
                        if (verbose2 >= 1) {
                            System.out.println("u'= " + this.toString(u));
                        }
                        PyByteArrayTest.checkDelSlice(start, step, n, uRef, u);
                    }
                }
            }
        }
    }

    public void testDelsliceTime3() {
        int verbose2 = 1;
        this.timeDelslice3(50, 100, 7, verbose2);
        this.timeDelslice3(50, 100, 25, verbose2);
        this.timeDelslice3(20, 4, 2000, verbose2);
    }

    private void timeDelslice3(int trials, int repeats, int N, int verbose2) {
        int[] startList = new int[10];
        for (int i = 0; i < startList.length; ++i) {
            startList[i] = N * i / startList.length;
        }
        int[] posStep = new int[]{1, 2, 3, 5, 10};
        int[] stepList = new int[2 * posStep.length];
        for (int i = 0; i < posStep.length; ++i) {
            stepList[posStep.length - i - 1] = posStep[i];
            stepList[posStep.length + i] = -posStep[i];
        }
        long[][] elapsed = new long[startList.length][stepList.length];
        for (int row = 0; row < startList.length; ++row) {
            for (int col = 0; col < stepList.length; ++col) {
                elapsed[row][col] = Long.MAX_VALUE;
            }
        }
        int[] xRef = PyByteArrayTest.randomInts(this.random, N, 117, 122);
        PyByteArray x = this.getInstance(xRef);
        PyByteArray[] u = new PyByteArray[repeats];
        for (int trial = 0; trial < trials; ++trial) {
            for (int irow = 0; irow < startList.length; ++irow) {
                int row = (irow + 5 * trial) % startList.length;
                int start = startList[row];
                for (int icol = 0; icol < stepList.length; ++icol) {
                    long t;
                    int col = (icol + trial) % stepList.length;
                    int step = stepList[col];
                    int n = step > 0 ? (xRef.length - start + step - 1) / step : (start + -step) / -step;
                    PyInteger pyStart = new PyInteger(start);
                    PyObject pyStop = Py.None;
                    PyInteger pyStep = new PyInteger(step);
                    if (trial == 0) {
                        this.doTimeDelslice3(u, pyStart, pyStop, pyStep, x, verbose2);
                        PyByteArrayTest.checkDelSlice(start, step, n, xRef, u[0]);
                    }
                    if ((t = this.doTimeDelslice3(u, pyStart, pyStop, pyStep, x, -1)) >= elapsed[row][col]) continue;
                    elapsed[row][col] = t;
                }
            }
        }
        System.out.print("     N  ,    start");
        for (int col = 0; col < stepList.length; ++col) {
            System.out.printf(", step=%5d", stepList[col]);
        }
        System.out.println(", deletion time in microseconds.");
        for (int row = 0; row < startList.length; ++row) {
            System.out.printf("%8d, %8d", N, startList[row]);
            for (int col = 0; col < stepList.length; ++col) {
                double usPerCall = 0.001 * (double)elapsed[row][col] / (double)repeats;
                System.out.printf(", %10.3f", usPerCall);
            }
            System.out.println();
        }
    }

    private long doTimeDelslice3(PyByteArray[] u, PyObject pyStart, PyObject pyStop, PyObject pyStep, BaseBytes x, int verbose2) {
        int repeats = 1;
        if (verbose2 < 0) {
            repeats = u.length;
        }
        for (int i = 0; i < repeats; ++i) {
            u[i] = new PyByteArray(x);
        }
        PyByteArray v = u[0];
        byte[] oldStorage = v.storage;
        if (verbose2 >= 3) {
            System.out.printf("__delslice__(%s,%s,%s)\n", pyStart, pyStop, pyStep);
            System.out.println("u = " + this.toString(v));
        }
        long beginTime = System.nanoTime();
        for (int i = 0; i < repeats; ++i) {
            u[i].__delslice__(pyStart, pyStop, pyStep);
        }
        long t = System.nanoTime() - beginTime;
        if (verbose2 >= 2) {
            boolean avAlloc;
            boolean bl = avAlloc = v.storage != oldStorage;
            if (v.size * 2 <= oldStorage.length) {
                avAlloc = false;
            }
            if (v.size > oldStorage.length) {
                avAlloc = false;
            }
            System.out.println("u'= " + this.toString(v) + (avAlloc ? " new" : ""));
        }
        return t;
    }

    @Override
    public PyByteArray getInstance(PyType type) {
        return new PyByteArray(type);
    }

    @Override
    public PyByteArray getInstance() {
        return new PyByteArray();
    }

    @Override
    public PyByteArray getInstance(int size) {
        return new PyByteArray(size);
    }

    @Override
    public PyByteArray getInstance(int[] value) {
        return new PyByteArray(value);
    }

    @Override
    public PyByteArray getInstance(BaseBytes source) {
        return new PyByteArray(source);
    }

    @Override
    public PyByteArray getInstance(Iterable<? extends PyObject> source) {
        return new PyByteArray(source);
    }

    @Override
    public PyByteArray getInstance(PyString arg, PyObject encoding2, PyObject errors2) {
        return new PyByteArray(arg, encoding2, errors2);
    }

    @Override
    public PyByteArray getInstance(PyString arg, String encoding2, String errors2) {
        return new PyByteArray(arg, encoding2, errors2);
    }

    @Override
    public PyByteArray getInstance(PyObject arg) throws PyException {
        return new PyByteArray(arg);
    }
}

