/*
 * Decompiled with CFR 0.152.
 */
package org.python.icu.impl;

import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import org.python.icu.impl.ICUBinary;
import org.python.icu.impl.ICUData;
import org.python.icu.impl.SoftCache;
import org.python.icu.util.ICUException;
import org.python.icu.util.ICUUncheckedIOException;
import org.python.icu.util.ULocale;
import org.python.icu.util.VersionInfo;

public final class ICUResourceBundleReader {
    private static final int DATA_FORMAT = 1382380354;
    private static final IsAcceptable IS_ACCEPTABLE = new IsAcceptable();
    private static final int URES_INDEX_LENGTH = 0;
    private static final int URES_INDEX_KEYS_TOP = 1;
    private static final int URES_INDEX_BUNDLE_TOP = 3;
    private static final int URES_INDEX_MAX_TABLE_LENGTH = 4;
    private static final int URES_INDEX_ATTRIBUTES = 5;
    private static final int URES_INDEX_16BIT_TOP = 6;
    private static final int URES_INDEX_POOL_CHECKSUM = 7;
    private static final int URES_ATT_NO_FALLBACK = 1;
    private static final int URES_ATT_IS_POOL_BUNDLE = 2;
    private static final int URES_ATT_USES_POOL_BUNDLE = 4;
    private static final CharBuffer EMPTY_16_BIT_UNITS = CharBuffer.wrap("\u0000");
    static final int LARGE_SIZE = 24;
    private static final boolean DEBUG = false;
    private int dataVersion;
    private ByteBuffer bytes;
    private CharBuffer b16BitUnits;
    private ByteBuffer poolBundleKeys;
    private int rootRes;
    private int localKeyLimit;
    private boolean noFallback;
    private boolean isPoolBundle;
    private boolean usesPoolBundle;
    private int poolCheckSum;
    private ResourceCache resourceCache;
    private static ReaderCache CACHE = new ReaderCache();
    private static final ICUResourceBundleReader NULL_READER = new ICUResourceBundleReader();
    private static final byte[] emptyBytes = new byte[0];
    private static final ByteBuffer emptyByteBuffer = ByteBuffer.allocate(0).asReadOnlyBuffer();
    private static final char[] emptyChars = new char[0];
    private static final int[] emptyInts = new int[0];
    private static final String emptyString = "";
    private static final Container EMPTY_ARRAY = new Container();
    private static final Table EMPTY_TABLE = new Table();
    private static final String ICU_RESOURCE_SUFFIX = ".res";

    private ICUResourceBundleReader() {
    }

    private ICUResourceBundleReader(ByteBuffer inBytes, String baseName, String localeID, ClassLoader loader2) throws IOException {
        this.init(inBytes);
        if (this.usesPoolBundle) {
            ICUResourceBundleReader poolBundleReader = ICUResourceBundleReader.getReader(baseName, "pool", loader2);
            if (!poolBundleReader.isPoolBundle) {
                throw new IllegalStateException("pool.res is not a pool bundle");
            }
            if (poolBundleReader.poolCheckSum != this.poolCheckSum) {
                throw new IllegalStateException("pool.res has a different checksum than this bundle");
            }
            this.poolBundleKeys = poolBundleReader.bytes;
        }
    }

    static ICUResourceBundleReader getReader(String baseName, String localeID, ClassLoader root) {
        ReaderInfo info = new ReaderInfo(baseName, localeID, root);
        ICUResourceBundleReader reader2 = (ICUResourceBundleReader)CACHE.getInstance(info, info);
        if (reader2 == NULL_READER) {
            return null;
        }
        return reader2;
    }

    private void init(ByteBuffer inBytes) throws IOException {
        int bundleTop;
        this.dataVersion = ICUBinary.readHeader(inBytes, 1382380354, IS_ACCEPTABLE);
        boolean isFormatVersion10 = inBytes.get(16) == 1 && inBytes.get(17) == 0;
        this.bytes = ICUBinary.sliceWithOrder(inBytes);
        int dataLength = this.bytes.remaining();
        this.rootRes = this.bytes.getInt(0);
        if (isFormatVersion10) {
            this.localKeyLimit = 65536;
            this.resourceCache = new ResourceCache(dataLength / 4 - 1);
            return;
        }
        int indexes0 = this.getIndexesInt(0);
        int indexLength = indexes0 & 0xFF;
        if (indexLength <= 4) {
            throw new ICUException("not enough indexes");
        }
        if (dataLength < 1 + indexLength << 2 || dataLength < (bundleTop = this.getIndexesInt(3)) << 2) {
            throw new ICUException("not enough bytes");
        }
        int maxOffset = bundleTop - 1;
        if (indexLength > 5) {
            int att = this.getIndexesInt(5);
            this.noFallback = (att & 1) != 0;
            this.isPoolBundle = (att & 2) != 0;
            boolean bl = this.usesPoolBundle = (att & 4) != 0;
        }
        if (indexLength > 6) {
            int keysTop = this.getIndexesInt(1);
            int _16BitTop = this.getIndexesInt(6);
            if (_16BitTop > keysTop) {
                int num16BitUnits = (_16BitTop - keysTop) * 2;
                this.bytes.position(keysTop << 2);
                this.b16BitUnits = this.bytes.asCharBuffer();
                this.b16BitUnits.limit(num16BitUnits);
                maxOffset |= num16BitUnits - 1;
            } else {
                this.b16BitUnits = EMPTY_16_BIT_UNITS;
            }
        } else {
            this.b16BitUnits = EMPTY_16_BIT_UNITS;
        }
        if (indexLength > 7) {
            this.poolCheckSum = this.getIndexesInt(7);
        }
        if (this.getIndexesInt(1) > 1 + indexLength) {
            if (this.isPoolBundle) {
                this.bytes.position(1 + indexLength << 2);
                this.bytes = ICUBinary.sliceWithOrder(this.bytes);
            } else {
                this.localKeyLimit = this.getIndexesInt(1) << 2;
            }
        }
        if (!this.isPoolBundle) {
            this.resourceCache = new ResourceCache(maxOffset);
        }
    }

    private int getIndexesInt(int i) {
        return this.bytes.getInt(1 + i << 2);
    }

    VersionInfo getVersion() {
        return ICUBinary.getVersionInfoFromCompactInt(this.dataVersion);
    }

    int getRootResource() {
        return this.rootRes;
    }

    boolean getNoFallback() {
        return this.noFallback;
    }

    boolean getUsesPoolBundle() {
        return this.usesPoolBundle;
    }

    static int RES_GET_TYPE(int res) {
        return res >>> 28;
    }

    private static int RES_GET_OFFSET(int res) {
        return res & 0xFFFFFFF;
    }

    private int getResourceByteOffset(int offset) {
        return offset << 2;
    }

    static int RES_GET_INT(int res) {
        return res << 4 >> 4;
    }

    static int RES_GET_UINT(int res) {
        return res & 0xFFFFFFF;
    }

    static boolean URES_IS_ARRAY(int type) {
        return type == 8 || type == 9;
    }

    static boolean URES_IS_TABLE(int type) {
        return type == 2 || type == 5 || type == 4;
    }

    private char getChar(int offset) {
        return this.bytes.getChar(offset);
    }

    private char[] getChars(int offset, int count2) {
        char[] chars = new char[count2];
        for (int i = 0; i < count2; ++i) {
            chars[i] = this.bytes.getChar(offset);
            offset += 2;
        }
        return chars;
    }

    private int getInt(int offset) {
        return this.bytes.getInt(offset);
    }

    private int[] getInts(int offset, int count2) {
        int[] ints = new int[count2];
        for (int i = 0; i < count2; ++i) {
            ints[i] = this.bytes.getInt(offset);
            offset += 4;
        }
        return ints;
    }

    private char[] getTable16KeyOffsets(int offset) {
        int length;
        if ((length = this.b16BitUnits.charAt(offset++)) > 0) {
            char[] result2 = new char[length];
            if (length <= 16) {
                for (int i = 0; i < length; ++i) {
                    result2[i] = this.b16BitUnits.charAt(offset++);
                }
            } else {
                CharBuffer temp = this.b16BitUnits.duplicate();
                temp.position(offset);
                temp.get(result2);
            }
            return result2;
        }
        return emptyChars;
    }

    private char[] getTableKeyOffsets(int offset) {
        char length = this.getChar(offset);
        if (length > '\u0000') {
            return this.getChars(offset + 2, length);
        }
        return emptyChars;
    }

    private int[] getTable32KeyOffsets(int offset) {
        int length = this.getInt(offset);
        if (length > 0) {
            return this.getInts(offset + 4, length);
        }
        return emptyInts;
    }

    private static String makeKeyStringFromBytes(ByteBuffer keyBytes, int keyOffset) {
        byte b;
        StringBuilder sb = new StringBuilder();
        while ((b = keyBytes.get(keyOffset)) != 0) {
            ++keyOffset;
            sb.append((char)b);
        }
        return sb.toString();
    }

    private String getKey16String(int keyOffset) {
        if (keyOffset < this.localKeyLimit) {
            return ICUResourceBundleReader.makeKeyStringFromBytes(this.bytes, keyOffset);
        }
        return ICUResourceBundleReader.makeKeyStringFromBytes(this.poolBundleKeys, keyOffset - this.localKeyLimit);
    }

    private String getKey32String(int keyOffset) {
        if (keyOffset >= 0) {
            return ICUResourceBundleReader.makeKeyStringFromBytes(this.bytes, keyOffset);
        }
        return ICUResourceBundleReader.makeKeyStringFromBytes(this.poolBundleKeys, keyOffset & Integer.MAX_VALUE);
    }

    private int compareKeys(CharSequence key, char keyOffset) {
        if (keyOffset < this.localKeyLimit) {
            return ICUBinary.compareKeys(key, this.bytes, keyOffset);
        }
        return ICUBinary.compareKeys(key, this.poolBundleKeys, keyOffset - this.localKeyLimit);
    }

    private int compareKeys32(CharSequence key, int keyOffset) {
        if (keyOffset >= 0) {
            return ICUBinary.compareKeys(key, this.bytes, keyOffset);
        }
        return ICUBinary.compareKeys(key, this.poolBundleKeys, keyOffset & Integer.MAX_VALUE);
    }

    String getString(int res) {
        String s;
        int offset = ICUResourceBundleReader.RES_GET_OFFSET(res);
        if (res != offset && ICUResourceBundleReader.RES_GET_TYPE(res) != 6) {
            return null;
        }
        if (offset == 0) {
            return emptyString;
        }
        Object value = this.resourceCache.get(res);
        if (value != null) {
            return (String)value;
        }
        if (res != offset) {
            char first = this.b16BitUnits.charAt(offset);
            if ((first & 0xFFFFFC00) != 56320) {
                char c;
                if (first == '\u0000') {
                    return emptyString;
                }
                StringBuilder sb = new StringBuilder();
                sb.append(first);
                while ((c = this.b16BitUnits.charAt(++offset)) != '\u0000') {
                    sb.append(c);
                }
                s = sb.toString();
            } else {
                int length;
                if (first < '\udfef') {
                    length = first & 0x3FF;
                    ++offset;
                } else if (first < '\udfff') {
                    length = first - 57327 << 16 | this.b16BitUnits.charAt(offset + 1);
                    offset += 2;
                } else {
                    length = this.b16BitUnits.charAt(offset + 1) << 16 | this.b16BitUnits.charAt(offset + 2);
                    offset += 3;
                }
                s = this.b16BitUnits.subSequence(offset, offset + length).toString();
            }
        } else {
            offset = this.getResourceByteOffset(offset);
            int length = this.getInt(offset);
            s = new String(this.getChars(offset + 4, length));
        }
        return (String)this.resourceCache.putIfAbsent(res, s, s.length() * 2);
    }

    String getAlias(int res) {
        int offset = ICUResourceBundleReader.RES_GET_OFFSET(res);
        if (ICUResourceBundleReader.RES_GET_TYPE(res) == 3) {
            if (offset == 0) {
                return emptyString;
            }
            Object value = this.resourceCache.get(res);
            if (value != null) {
                return (String)value;
            }
            offset = this.getResourceByteOffset(offset);
            int length = this.getInt(offset);
            String s = new String(this.getChars(offset + 4, length));
            return (String)this.resourceCache.putIfAbsent(res, s, length * 2);
        }
        return null;
    }

    byte[] getBinary(int res, byte[] ba) {
        int offset = ICUResourceBundleReader.RES_GET_OFFSET(res);
        if (ICUResourceBundleReader.RES_GET_TYPE(res) == 1) {
            if (offset == 0) {
                return emptyBytes;
            }
            int length = this.getInt(offset = this.getResourceByteOffset(offset));
            if (length == 0) {
                return emptyBytes;
            }
            if (ba == null || ba.length != length) {
                ba = new byte[length];
            }
            offset += 4;
            if (length <= 16) {
                for (int i = 0; i < length; ++i) {
                    ba[i] = this.bytes.get(offset++);
                }
            } else {
                ByteBuffer temp = this.bytes.duplicate();
                temp.position(offset);
                temp.get(ba);
            }
            return ba;
        }
        return null;
    }

    ByteBuffer getBinary(int res) {
        int offset = ICUResourceBundleReader.RES_GET_OFFSET(res);
        if (ICUResourceBundleReader.RES_GET_TYPE(res) == 1) {
            if (offset == 0) {
                return emptyByteBuffer.duplicate();
            }
            int length = this.getInt(offset = this.getResourceByteOffset(offset));
            if (length == 0) {
                return emptyByteBuffer.duplicate();
            }
            ByteBuffer result2 = this.bytes.duplicate();
            result2.position(offset += 4).limit(offset + length);
            result2 = ICUBinary.sliceWithOrder(result2);
            if (!result2.isReadOnly()) {
                result2 = result2.asReadOnlyBuffer();
            }
            return result2;
        }
        return null;
    }

    int[] getIntVector(int res) {
        int offset = ICUResourceBundleReader.RES_GET_OFFSET(res);
        if (ICUResourceBundleReader.RES_GET_TYPE(res) == 14) {
            if (offset == 0) {
                return emptyInts;
            }
            offset = this.getResourceByteOffset(offset);
            int length = this.getInt(offset);
            return this.getInts(offset + 4, length);
        }
        return null;
    }

    Container getArray(int res) {
        int type = ICUResourceBundleReader.RES_GET_TYPE(res);
        if (!ICUResourceBundleReader.URES_IS_ARRAY(type)) {
            return null;
        }
        int offset = ICUResourceBundleReader.RES_GET_OFFSET(res);
        if (offset == 0) {
            return EMPTY_ARRAY;
        }
        Object value = this.resourceCache.get(res);
        if (value != null) {
            return (Container)value;
        }
        Container array = type == 8 ? new Array(this, offset) : new Array16(this, offset);
        return (Container)this.resourceCache.putIfAbsent(res, array, 0);
    }

    Table getTable(int res) {
        int size;
        Table table;
        int type = ICUResourceBundleReader.RES_GET_TYPE(res);
        if (!ICUResourceBundleReader.URES_IS_TABLE(type)) {
            return null;
        }
        int offset = ICUResourceBundleReader.RES_GET_OFFSET(res);
        if (offset == 0) {
            return EMPTY_TABLE;
        }
        Object value = this.resourceCache.get(res);
        if (value != null) {
            return (Table)value;
        }
        if (type == 2) {
            table = new Table1632(this, offset);
            size = table.getSize() * 2;
        } else if (type == 5) {
            table = new Table16(this, offset);
            size = table.getSize() * 2;
        } else {
            table = new Table32(this, offset);
            size = table.getSize() * 4;
        }
        return (Table)this.resourceCache.putIfAbsent(res, table, size);
    }

    public static String getFullName(String baseName, String localeName) {
        if (baseName == null || baseName.length() == 0) {
            if (localeName.length() == 0) {
                localeName = ULocale.getDefault().toString();
                return localeName;
            }
            return localeName + ICU_RESOURCE_SUFFIX;
        }
        if (baseName.indexOf(46) == -1) {
            if (baseName.charAt(baseName.length() - 1) != '/') {
                return baseName + "/" + localeName + ICU_RESOURCE_SUFFIX;
            }
            return baseName + localeName + ICU_RESOURCE_SUFFIX;
        }
        baseName = baseName.replace('.', '/');
        if (localeName.length() == 0) {
            return baseName + ICU_RESOURCE_SUFFIX;
        }
        return baseName + "_" + localeName + ICU_RESOURCE_SUFFIX;
    }

    private static final class ResourceCache {
        private static final int SIMPLE_LENGTH = 32;
        private static final int ROOT_BITS = 7;
        private static final int NEXT_BITS = 6;
        private int[] keys = new int[32];
        private Object[] values = new Object[32];
        private int length;
        private int maxOffsetBits;
        private int levelBitsList;
        private Level rootLevel;

        private static final Object putIfCleared(Object[] values, int index, Object item, int size) {
            Object value = values[index];
            if (!(value instanceof SoftReference)) {
                assert (size < 24);
                return value;
            }
            assert (size >= 24);
            if ((value = ((SoftReference)value).get()) != null) {
                return value;
            }
            values[index] = new SoftReference<Object>(item);
            return item;
        }

        ResourceCache(int maxOffset) {
            assert (maxOffset != 0);
            this.maxOffsetBits = 28;
            while (maxOffset <= 0x7FFFFFF) {
                maxOffset <<= 1;
                --this.maxOffsetBits;
            }
            int keyBits = this.maxOffsetBits + 2;
            if (keyBits <= 7) {
                this.levelBitsList = keyBits;
            } else if (keyBits < 10) {
                this.levelBitsList = 0x30 | keyBits - 3;
            } else {
                this.levelBitsList = 7;
                keyBits -= 7;
                int shift = 4;
                while (true) {
                    if (keyBits <= 6) {
                        this.levelBitsList |= keyBits << shift;
                        break;
                    }
                    if (keyBits < 9) {
                        this.levelBitsList |= (0x30 | keyBits - 3) << shift;
                        break;
                    }
                    this.levelBitsList |= 6 << shift;
                    keyBits -= 6;
                    shift += 4;
                }
            }
        }

        private int makeKey(int res) {
            int type = ICUResourceBundleReader.RES_GET_TYPE(res);
            int miniType = type == 6 ? 1 : (type == 5 ? 3 : (type == 9 ? 2 : 0));
            return ICUResourceBundleReader.RES_GET_OFFSET(res) | miniType << this.maxOffsetBits;
        }

        private int findSimple(int key) {
            int start = 0;
            int limit = this.length;
            while (limit - start > 8) {
                int mid = (start + limit) / 2;
                if (key < this.keys[mid]) {
                    limit = mid;
                    continue;
                }
                start = mid;
            }
            while (start < limit) {
                int k = this.keys[start];
                if (key < k) {
                    return ~start;
                }
                if (key == k) {
                    return start;
                }
                ++start;
            }
            return ~start;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        synchronized Object get(int res) {
            Object value;
            assert (ICUResourceBundleReader.RES_GET_OFFSET(res) != 0);
            if (this.length >= 0) {
                int index = this.findSimple(res);
                if (index < 0) return null;
                value = this.values[index];
            } else {
                value = this.rootLevel.get(this.makeKey(res));
                if (value == null) {
                    return null;
                }
            }
            if (!(value instanceof SoftReference)) return value;
            return ((SoftReference)value).get();
        }

        synchronized Object putIfAbsent(int res, Object item, int size) {
            if (this.length >= 0) {
                int index = this.findSimple(res);
                if (index >= 0) {
                    return ResourceCache.putIfCleared(this.values, index, item, size);
                }
                if (this.length < 32) {
                    if ((index ^= 0xFFFFFFFF) < this.length) {
                        System.arraycopy(this.keys, index, this.keys, index + 1, this.length - index);
                        System.arraycopy(this.values, index, this.values, index + 1, this.length - index);
                    }
                    ++this.length;
                    this.keys[index] = res;
                    this.values[index] = size >= 24 ? new SoftReference<Object>(item) : item;
                    return item;
                }
                this.rootLevel = new Level(this.levelBitsList, 0);
                for (int i = 0; i < 32; ++i) {
                    this.rootLevel.putIfAbsent(this.makeKey(this.keys[i]), this.values[i], 0);
                }
                this.keys = null;
                this.values = null;
                this.length = -1;
            }
            return this.rootLevel.putIfAbsent(this.makeKey(res), item, size);
        }

        private static final class Level {
            int levelBitsList;
            int shift;
            int mask;
            int[] keys;
            Object[] values;

            Level(int levelBitsList, int shift) {
                this.levelBitsList = levelBitsList;
                this.shift = shift;
                int bits = levelBitsList & 0xF;
                assert (bits != 0);
                int length = 1 << bits;
                this.mask = length - 1;
                this.keys = new int[length];
                this.values = new Object[length];
            }

            Object get(int key) {
                Level level;
                int index = key >> this.shift & this.mask;
                int k = this.keys[index];
                if (k == key) {
                    return this.values[index];
                }
                if (k == 0 && (level = (Level)this.values[index]) != null) {
                    return level.get(key);
                }
                return null;
            }

            Object putIfAbsent(int key, Object item, int size) {
                int index = key >> this.shift & this.mask;
                int k = this.keys[index];
                if (k == key) {
                    return ResourceCache.putIfCleared(this.values, index, item, size);
                }
                if (k == 0) {
                    Level level = (Level)this.values[index];
                    if (level != null) {
                        return level.putIfAbsent(key, item, size);
                    }
                    this.keys[index] = key;
                    this.values[index] = size >= 24 ? new SoftReference<Object>(item) : item;
                    return item;
                }
                Level level = new Level(this.levelBitsList >> 4, this.shift + (this.levelBitsList & 0xF));
                int i = k >> level.shift & level.mask;
                level.keys[i] = k;
                level.values[i] = this.values[index];
                this.keys[index] = 0;
                this.values[index] = level;
                return level.putIfAbsent(key, item, size);
            }
        }
    }

    private static final class Table32
    extends Table {
        int getContainerResource(ICUResourceBundleReader reader2, int index) {
            return this.getContainer32Resource(reader2, index);
        }

        Table32(ICUResourceBundleReader reader2, int offset) {
            offset = reader2.getResourceByteOffset(offset);
            this.key32Offsets = reader2.getTable32KeyOffsets(offset);
            this.size = this.key32Offsets.length;
            this.itemsOffset = offset + 4 * (1 + this.size);
        }
    }

    private static final class Table16
    extends Table {
        int getContainerResource(ICUResourceBundleReader reader2, int index) {
            return this.getContainer16Resource(reader2, index);
        }

        Table16(ICUResourceBundleReader reader2, int offset) {
            this.keyOffsets = reader2.getTable16KeyOffsets(offset);
            this.size = this.keyOffsets.length;
            this.itemsOffset = offset + 1 + this.size;
        }
    }

    private static final class Table1632
    extends Table {
        int getContainerResource(ICUResourceBundleReader reader2, int index) {
            return this.getContainer32Resource(reader2, index);
        }

        Table1632(ICUResourceBundleReader reader2, int offset) {
            offset = reader2.getResourceByteOffset(offset);
            this.keyOffsets = reader2.getTableKeyOffsets(offset);
            this.size = this.keyOffsets.length;
            this.itemsOffset = offset + 2 * (this.size + 2 & 0xFFFFFFFE);
        }
    }

    static class Table
    extends Container {
        protected char[] keyOffsets;
        protected int[] key32Offsets;
        private static final int URESDATA_ITEM_NOT_FOUND = -1;

        String getKey(ICUResourceBundleReader reader2, int index) {
            if (index < 0 || this.size <= index) {
                return null;
            }
            return this.keyOffsets != null ? reader2.getKey16String(this.keyOffsets[index]) : reader2.getKey32String(this.key32Offsets[index]);
        }

        int findTableItem(ICUResourceBundleReader reader2, CharSequence key) {
            int start = 0;
            int limit = this.size;
            while (start < limit) {
                int mid = start + limit >>> 1;
                int result2 = this.keyOffsets != null ? reader2.compareKeys(key, this.keyOffsets[mid]) : reader2.compareKeys32(key, this.key32Offsets[mid]);
                if (result2 < 0) {
                    limit = mid;
                    continue;
                }
                if (result2 > 0) {
                    start = mid + 1;
                    continue;
                }
                return mid;
            }
            return -1;
        }

        int getResource(ICUResourceBundleReader reader2, String resKey) {
            return this.getContainerResource(reader2, this.findTableItem(reader2, resKey));
        }

        Table() {
        }
    }

    private static final class Array16
    extends Container {
        int getContainerResource(ICUResourceBundleReader reader2, int index) {
            return this.getContainer16Resource(reader2, index);
        }

        Array16(ICUResourceBundleReader reader2, int offset) {
            this.size = reader2.b16BitUnits.charAt(offset);
            this.itemsOffset = offset + 1;
        }
    }

    private static final class Array
    extends Container {
        int getContainerResource(ICUResourceBundleReader reader2, int index) {
            return this.getContainer32Resource(reader2, index);
        }

        Array(ICUResourceBundleReader reader2, int offset) {
            offset = reader2.getResourceByteOffset(offset);
            this.size = reader2.getInt(offset);
            this.itemsOffset = offset + 4;
        }
    }

    static class Container {
        protected int size;
        protected int itemsOffset;

        int getSize() {
            return this.size;
        }

        int getContainerResource(ICUResourceBundleReader reader2, int index) {
            return -1;
        }

        protected int getContainer16Resource(ICUResourceBundleReader reader2, int index) {
            if (index < 0 || this.size <= index) {
                return -1;
            }
            return 0x60000000 | reader2.b16BitUnits.charAt(this.itemsOffset + index);
        }

        protected int getContainer32Resource(ICUResourceBundleReader reader2, int index) {
            if (index < 0 || this.size <= index) {
                return -1;
            }
            return reader2.getInt(this.itemsOffset + 4 * index);
        }

        int getResource(ICUResourceBundleReader reader2, String resKey) {
            return this.getContainerResource(reader2, Integer.parseInt(resKey));
        }

        Container() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ReaderCache
    extends SoftCache<ReaderInfo, ICUResourceBundleReader, ReaderInfo> {
        private ReaderCache() {
        }

        @Override
        protected ICUResourceBundleReader createInstance(ReaderInfo key, ReaderInfo data) {
            String fullName = ICUResourceBundleReader.getFullName(data.baseName, data.localeID);
            try {
                ByteBuffer inBytes;
                if (data.baseName != null && data.baseName.startsWith("org/python/icu/impl/data/icudt54b")) {
                    String itemPath = fullName.substring("org/python/icu/impl/data/icudt54b".length() + 1);
                    inBytes = ICUBinary.getData(data.loader, fullName, itemPath);
                    if (inBytes == null) {
                        return NULL_READER;
                    }
                } else {
                    InputStream stream = ICUData.getStream(data.loader, fullName);
                    if (stream == null) {
                        return NULL_READER;
                    }
                    inBytes = ICUBinary.getByteBufferFromInputStream(stream);
                }
                return new ICUResourceBundleReader(inBytes, data.baseName, data.localeID, data.loader);
            }
            catch (IOException ex) {
                throw new ICUUncheckedIOException("Data file " + fullName + " is corrupt - " + ex.getMessage(), ex);
            }
        }
    }

    private static class ReaderInfo {
        final String baseName;
        final String localeID;
        final ClassLoader loader;

        ReaderInfo(String baseName, String localeID, ClassLoader loader2) {
            this.baseName = baseName == null ? ICUResourceBundleReader.emptyString : baseName;
            this.localeID = localeID == null ? ICUResourceBundleReader.emptyString : localeID;
            this.loader = loader2;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ReaderInfo)) {
                return false;
            }
            ReaderInfo info = (ReaderInfo)obj;
            return this.baseName.equals(info.baseName) && this.localeID.equals(info.localeID) && this.loader.equals(info.loader);
        }

        public int hashCode() {
            return this.baseName.hashCode() ^ this.localeID.hashCode() ^ this.loader.hashCode();
        }
    }

    private static final class IsAcceptable
    implements ICUBinary.Authenticate {
        private IsAcceptable() {
        }

        public boolean isDataVersionAcceptable(byte[] formatVersion) {
            return formatVersion[0] == 1 || formatVersion[0] == 2;
        }
    }
}

