/*
 * Decompiled with CFR 0.152.
 */
package org.python.icu.impl.duration;

import org.python.icu.impl.duration.BasicPeriodBuilderFactory;
import org.python.icu.impl.duration.Period;
import org.python.icu.impl.duration.PeriodBuilder;
import org.python.icu.impl.duration.PeriodBuilderImpl;
import org.python.icu.impl.duration.TimeUnit;

class MultiUnitBuilder
extends PeriodBuilderImpl {
    private int nPeriods;

    MultiUnitBuilder(int nPeriods, BasicPeriodBuilderFactory.Settings settings2) {
        super(settings2);
        this.nPeriods = nPeriods;
    }

    public static MultiUnitBuilder get(int nPeriods, BasicPeriodBuilderFactory.Settings settings2) {
        if (nPeriods > 0 && settings2 != null) {
            return new MultiUnitBuilder(nPeriods, settings2);
        }
        return null;
    }

    protected PeriodBuilder withSettings(BasicPeriodBuilderFactory.Settings settingsToUse) {
        return MultiUnitBuilder.get(this.nPeriods, settingsToUse);
    }

    protected Period handleCreate(long duration, long referenceDate, boolean inPast) {
        Period period = null;
        int n = 0;
        short uset = this.settings.effectiveSet();
        for (int i = 0; i < TimeUnit.units.length; ++i) {
            if (0 == (uset & 1 << i)) continue;
            TimeUnit unit = TimeUnit.units[i];
            if (n == this.nPeriods) break;
            long unitDuration = this.approximateDurationOf(unit);
            if (duration < unitDuration && n <= 0) continue;
            double count2 = (double)duration / (double)unitDuration;
            if (++n < this.nPeriods) {
                count2 = Math.floor(count2);
                duration -= (long)(count2 * (double)unitDuration);
            }
            period = period == null ? Period.at((float)count2, unit).inPast(inPast) : period.and((float)count2, unit);
        }
        return period;
    }
}

