/*
 * Decompiled with CFR 0.152.
 */
package org.python.icu.impl.duration;

import java.util.TimeZone;
import org.python.icu.impl.duration.BasicPeriodBuilderFactory;
import org.python.icu.impl.duration.Period;
import org.python.icu.impl.duration.PeriodBuilder;
import org.python.icu.impl.duration.TimeUnit;

abstract class PeriodBuilderImpl
implements PeriodBuilder {
    protected BasicPeriodBuilderFactory.Settings settings;

    public Period create(long duration) {
        return this.createWithReferenceDate(duration, System.currentTimeMillis());
    }

    public long approximateDurationOf(TimeUnit unit) {
        return BasicPeriodBuilderFactory.approximateDurationOf(unit);
    }

    public Period createWithReferenceDate(long duration, long referenceDate) {
        Period ts;
        boolean inPast;
        boolean bl = inPast = duration < 0L;
        if (inPast) {
            duration = -duration;
        }
        if ((ts = this.settings.createLimited(duration, inPast)) == null && (ts = this.handleCreate(duration, referenceDate, inPast)) == null) {
            ts = Period.lessThan(1.0f, this.settings.effectiveMinUnit()).inPast(inPast);
        }
        return ts;
    }

    public PeriodBuilder withTimeZone(TimeZone timeZone) {
        return this;
    }

    public PeriodBuilder withLocale(String localeName) {
        BasicPeriodBuilderFactory.Settings newSettings = this.settings.setLocale(localeName);
        if (newSettings != this.settings) {
            return this.withSettings(newSettings);
        }
        return this;
    }

    protected abstract PeriodBuilder withSettings(BasicPeriodBuilderFactory.Settings var1);

    protected abstract Period handleCreate(long var1, long var3, boolean var5);

    protected PeriodBuilderImpl(BasicPeriodBuilderFactory.Settings settings2) {
        this.settings = settings2;
    }
}

