/*
 * Decompiled with CFR 0.152.
 */
package org.python.icu.text;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import org.python.icu.impl.ICUConfig;
import org.python.icu.lang.UScript;
import org.python.icu.text.DisplayContext;
import org.python.icu.util.ULocale;

public abstract class LocaleDisplayNames {
    private static final Method FACTORY_DIALECTHANDLING;
    private static final Method FACTORY_DISPLAYCONTEXT;

    public static LocaleDisplayNames getInstance(ULocale locale2) {
        return LocaleDisplayNames.getInstance(locale2, DialectHandling.STANDARD_NAMES);
    }

    public static LocaleDisplayNames getInstance(Locale locale2) {
        return LocaleDisplayNames.getInstance(ULocale.forLocale(locale2));
    }

    public static LocaleDisplayNames getInstance(ULocale locale2, DialectHandling dialectHandling) {
        LocaleDisplayNames result2 = null;
        if (FACTORY_DIALECTHANDLING != null) {
            try {
                result2 = (LocaleDisplayNames)FACTORY_DIALECTHANDLING.invoke(null, new Object[]{locale2, dialectHandling});
            }
            catch (InvocationTargetException e) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        if (result2 == null) {
            result2 = new LastResortLocaleDisplayNames(locale2, dialectHandling);
        }
        return result2;
    }

    public static LocaleDisplayNames getInstance(ULocale locale2, DisplayContext ... contexts) {
        LocaleDisplayNames result2 = null;
        if (FACTORY_DISPLAYCONTEXT != null) {
            try {
                result2 = (LocaleDisplayNames)FACTORY_DISPLAYCONTEXT.invoke(null, locale2, (Object[])contexts);
            }
            catch (InvocationTargetException e) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        if (result2 == null) {
            result2 = new LastResortLocaleDisplayNames(locale2, contexts);
        }
        return result2;
    }

    public static LocaleDisplayNames getInstance(Locale locale2, DisplayContext ... contexts) {
        return LocaleDisplayNames.getInstance(ULocale.forLocale(locale2), contexts);
    }

    public abstract ULocale getLocale();

    public abstract DialectHandling getDialectHandling();

    public abstract DisplayContext getContext(DisplayContext.Type var1);

    public abstract String localeDisplayName(ULocale var1);

    public abstract String localeDisplayName(Locale var1);

    public abstract String localeDisplayName(String var1);

    public abstract String languageDisplayName(String var1);

    public abstract String scriptDisplayName(String var1);

    @Deprecated
    public String scriptDisplayNameInContext(String script) {
        return this.scriptDisplayName(script);
    }

    public abstract String scriptDisplayName(int var1);

    public abstract String regionDisplayName(String var1);

    public abstract String variantDisplayName(String var1);

    public abstract String keyDisplayName(String var1);

    public abstract String keyValueDisplayName(String var1, String var2);

    @Deprecated
    protected LocaleDisplayNames() {
    }

    static {
        String implClassName = ICUConfig.get("org.python.icu.text.LocaleDisplayNames.impl", "org.python.icu.impl.LocaleDisplayNamesImpl");
        Method factoryDialectHandling = null;
        Method factoryDisplayContext = null;
        try {
            Class<?> implClass = Class.forName(implClassName);
            try {
                factoryDialectHandling = implClass.getMethod("getInstance", ULocale.class, DialectHandling.class);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            try {
                factoryDisplayContext = implClass.getMethod("getInstance", ULocale.class, DisplayContext[].class);
            }
            catch (NoSuchMethodException e) {}
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        FACTORY_DIALECTHANDLING = factoryDialectHandling;
        FACTORY_DISPLAYCONTEXT = factoryDisplayContext;
    }

    private static class LastResortLocaleDisplayNames
    extends LocaleDisplayNames {
        private ULocale locale;
        private DisplayContext[] contexts;

        private LastResortLocaleDisplayNames(ULocale locale2, DialectHandling dialectHandling) {
            this.locale = locale2;
            DisplayContext context2 = dialectHandling == DialectHandling.DIALECT_NAMES ? DisplayContext.DIALECT_NAMES : DisplayContext.STANDARD_NAMES;
            this.contexts = new DisplayContext[]{context2};
        }

        private LastResortLocaleDisplayNames(ULocale locale2, DisplayContext ... contexts) {
            this.locale = locale2;
            this.contexts = new DisplayContext[contexts.length];
            System.arraycopy(contexts, 0, this.contexts, 0, contexts.length);
        }

        public ULocale getLocale() {
            return this.locale;
        }

        public DialectHandling getDialectHandling() {
            DialectHandling result2 = DialectHandling.STANDARD_NAMES;
            for (DisplayContext context2 : this.contexts) {
                if (context2.type() != DisplayContext.Type.DIALECT_HANDLING || context2.value() != DisplayContext.DIALECT_NAMES.ordinal()) continue;
                result2 = DialectHandling.DIALECT_NAMES;
                break;
            }
            return result2;
        }

        public DisplayContext getContext(DisplayContext.Type type) {
            DisplayContext result2 = DisplayContext.STANDARD_NAMES;
            for (DisplayContext context2 : this.contexts) {
                if (context2.type() != type) continue;
                result2 = context2;
                break;
            }
            return result2;
        }

        public String localeDisplayName(ULocale locale2) {
            return locale2.getName();
        }

        public String localeDisplayName(Locale locale2) {
            return ULocale.forLocale(locale2).getName();
        }

        public String localeDisplayName(String localeId) {
            return new ULocale(localeId).getName();
        }

        public String languageDisplayName(String lang) {
            return lang;
        }

        public String scriptDisplayName(String script) {
            return script;
        }

        public String scriptDisplayName(int scriptCode) {
            return UScript.getShortName(scriptCode);
        }

        public String regionDisplayName(String region) {
            return region;
        }

        public String variantDisplayName(String variant) {
            return variant;
        }

        public String keyDisplayName(String key) {
            return key;
        }

        public String keyValueDisplayName(String key, String value) {
            return value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DialectHandling {
        STANDARD_NAMES,
        DIALECT_NAMES;

    }
}

