/*
 * Decompiled with CFR 0.152.
 */
package org.python.icu.text;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.util.Locale;
import java.util.Map;
import org.python.icu.impl.Utility;
import org.python.icu.text.DecimalFormat;
import org.python.icu.text.MessagePattern;
import org.python.icu.text.NumberFormat;
import org.python.icu.text.PluralRules;
import org.python.icu.text.RbnfLenientScanner;
import org.python.icu.text.UFormat;
import org.python.icu.util.ULocale;

public class PluralFormat
extends UFormat {
    private static final long serialVersionUID = 1L;
    private ULocale ulocale = null;
    private PluralRules pluralRules = null;
    private String pattern = null;
    private transient MessagePattern msgPattern;
    private Map<String, String> parsedValues = null;
    private NumberFormat numberFormat = null;
    private transient double offset = 0.0;
    private transient PluralSelectorAdapter pluralRulesWrapper = new PluralSelectorAdapter();

    public PluralFormat() {
        this.init(null, PluralRules.PluralType.CARDINAL, ULocale.getDefault(ULocale.Category.FORMAT), null);
    }

    public PluralFormat(ULocale ulocale) {
        this.init(null, PluralRules.PluralType.CARDINAL, ulocale, null);
    }

    public PluralFormat(Locale locale2) {
        this(ULocale.forLocale(locale2));
    }

    public PluralFormat(PluralRules rules) {
        this.init(rules, PluralRules.PluralType.CARDINAL, ULocale.getDefault(ULocale.Category.FORMAT), null);
    }

    public PluralFormat(ULocale ulocale, PluralRules rules) {
        this.init(rules, PluralRules.PluralType.CARDINAL, ulocale, null);
    }

    public PluralFormat(Locale locale2, PluralRules rules) {
        this(ULocale.forLocale(locale2), rules);
    }

    public PluralFormat(ULocale ulocale, PluralRules.PluralType type) {
        this.init(null, type, ulocale, null);
    }

    public PluralFormat(Locale locale2, PluralRules.PluralType type) {
        this(ULocale.forLocale(locale2), type);
    }

    public PluralFormat(String pattern) {
        this.init(null, PluralRules.PluralType.CARDINAL, ULocale.getDefault(ULocale.Category.FORMAT), null);
        this.applyPattern(pattern);
    }

    public PluralFormat(ULocale ulocale, String pattern) {
        this.init(null, PluralRules.PluralType.CARDINAL, ulocale, null);
        this.applyPattern(pattern);
    }

    public PluralFormat(PluralRules rules, String pattern) {
        this.init(rules, PluralRules.PluralType.CARDINAL, ULocale.getDefault(ULocale.Category.FORMAT), null);
        this.applyPattern(pattern);
    }

    public PluralFormat(ULocale ulocale, PluralRules rules, String pattern) {
        this.init(rules, PluralRules.PluralType.CARDINAL, ulocale, null);
        this.applyPattern(pattern);
    }

    public PluralFormat(ULocale ulocale, PluralRules.PluralType type, String pattern) {
        this.init(null, type, ulocale, null);
        this.applyPattern(pattern);
    }

    PluralFormat(ULocale ulocale, PluralRules.PluralType type, String pattern, NumberFormat numberFormat) {
        this.init(null, type, ulocale, numberFormat);
        this.applyPattern(pattern);
    }

    private void init(PluralRules rules, PluralRules.PluralType type, ULocale locale2, NumberFormat numberFormat) {
        this.ulocale = locale2;
        this.pluralRules = rules == null ? PluralRules.forLocale(this.ulocale, type) : rules;
        this.resetPattern();
        this.numberFormat = numberFormat == null ? NumberFormat.getInstance(this.ulocale) : numberFormat;
    }

    private void resetPattern() {
        this.pattern = null;
        if (this.msgPattern != null) {
            this.msgPattern.clear();
        }
        this.offset = 0.0;
    }

    public void applyPattern(String pattern) {
        this.pattern = pattern;
        if (this.msgPattern == null) {
            this.msgPattern = new MessagePattern();
        }
        try {
            this.msgPattern.parsePluralStyle(pattern);
            this.offset = this.msgPattern.getPluralOffset(0);
        }
        catch (RuntimeException e) {
            this.resetPattern();
            throw e;
        }
    }

    public String toPattern() {
        return this.pattern;
    }

    static int findSubMessage(MessagePattern pattern, int partIndex, PluralSelector selector, Object context2, double number) {
        int count2 = pattern.countParts();
        MessagePattern.Part part = pattern.getPart(partIndex);
        double offset = part.getType().hasNumericValue() ? pattern.getNumericValue(part) : 0.0;
        String keyword2 = null;
        boolean haveKeywordMatch = false;
        int msgStart = 0;
        do {
            int n = ++partIndex;
            ++partIndex;
            part = pattern.getPart(n);
            MessagePattern.Part.Type type = part.getType();
            if (type == MessagePattern.Part.Type.ARG_LIMIT) break;
            assert (type == MessagePattern.Part.Type.ARG_SELECTOR);
            if (pattern.getPartType(partIndex).hasNumericValue()) {
                if (number == pattern.getNumericValue(part = pattern.getPart(partIndex++))) {
                    return partIndex;
                }
            } else if (!haveKeywordMatch) {
                if (pattern.partSubstringMatches(part, "other")) {
                    if (msgStart == 0) {
                        msgStart = partIndex;
                        if (keyword2 != null && keyword2.equals("other")) {
                            haveKeywordMatch = true;
                        }
                    }
                } else {
                    if (keyword2 == null) {
                        keyword2 = selector.select(context2, number - offset);
                        if (msgStart != 0 && keyword2.equals("other")) {
                            haveKeywordMatch = true;
                        }
                    }
                    if (!haveKeywordMatch && pattern.partSubstringMatches(part, keyword2)) {
                        msgStart = partIndex;
                        haveKeywordMatch = true;
                    }
                }
            }
            partIndex = pattern.getLimitPartIndex(partIndex);
        } while (++partIndex < count2);
        return msgStart;
    }

    public final String format(double number) {
        return this.format(number, number);
    }

    public StringBuffer format(Object number, StringBuffer toAppendTo, FieldPosition pos) {
        if (!(number instanceof Number)) {
            throw new IllegalArgumentException("'" + number + "' is not a Number");
        }
        Number numberObject = (Number)number;
        toAppendTo.append(this.format(numberObject, numberObject.doubleValue()));
        return toAppendTo;
    }

    private String format(Number numberObject, double number) {
        if (this.msgPattern == null || this.msgPattern.countParts() == 0) {
            return this.numberFormat.format(numberObject);
        }
        double numberMinusOffset = number - this.offset;
        String numberString = this.offset == 0.0 ? this.numberFormat.format(numberObject) : this.numberFormat.format(numberMinusOffset);
        PluralRules.FixedDecimal dec = this.numberFormat instanceof DecimalFormat ? ((DecimalFormat)this.numberFormat).getFixedDecimal(numberMinusOffset) : new PluralRules.FixedDecimal(numberMinusOffset);
        int partIndex = PluralFormat.findSubMessage(this.msgPattern, 0, this.pluralRulesWrapper, dec, number);
        StringBuilder result2 = null;
        int prevIndex = this.msgPattern.getPart(partIndex).getLimit();
        while (true) {
            MessagePattern.Part part = this.msgPattern.getPart(++partIndex);
            MessagePattern.Part.Type type = part.getType();
            int index = part.getIndex();
            if (type == MessagePattern.Part.Type.MSG_LIMIT) {
                if (result2 == null) {
                    return this.pattern.substring(prevIndex, index);
                }
                return result2.append(this.pattern, prevIndex, index).toString();
            }
            if (type == MessagePattern.Part.Type.REPLACE_NUMBER || type == MessagePattern.Part.Type.SKIP_SYNTAX && this.msgPattern.jdkAposMode()) {
                if (result2 == null) {
                    result2 = new StringBuilder();
                }
                result2.append(this.pattern, prevIndex, index);
                if (type == MessagePattern.Part.Type.REPLACE_NUMBER) {
                    result2.append(numberString);
                }
                prevIndex = part.getLimit();
                continue;
            }
            if (type != MessagePattern.Part.Type.ARG_START) continue;
            if (result2 == null) {
                result2 = new StringBuilder();
            }
            result2.append(this.pattern, prevIndex, index);
            prevIndex = index;
            partIndex = this.msgPattern.getLimitPartIndex(partIndex);
            index = this.msgPattern.getPart(partIndex).getLimit();
            MessagePattern.appendReducedApostrophes(this.pattern, prevIndex, index, result2);
            prevIndex = index;
        }
    }

    public Number parse(String text2, ParsePosition parsePosition) {
        throw new UnsupportedOperationException();
    }

    public Object parseObject(String source, ParsePosition pos) {
        throw new UnsupportedOperationException();
    }

    String parseType(String source, RbnfLenientScanner scanner2, FieldPosition pos) {
        if (this.msgPattern == null || this.msgPattern.countParts() == 0) {
            pos.setBeginIndex(-1);
            pos.setEndIndex(-1);
            return null;
        }
        int partIndex = 0;
        int count2 = this.msgPattern.countParts();
        int startingAt = pos.getBeginIndex();
        if (startingAt < 0) {
            startingAt = 0;
        }
        String keyword2 = null;
        String matchedWord = null;
        int matchedIndex = -1;
        while (partIndex < count2) {
            int currMatchIndex;
            MessagePattern.Part partLimit;
            MessagePattern.Part partStart;
            MessagePattern.Part partSelector;
            if ((partSelector = this.msgPattern.getPart(partIndex++)).getType() != MessagePattern.Part.Type.ARG_SELECTOR || (partStart = this.msgPattern.getPart(partIndex++)).getType() != MessagePattern.Part.Type.MSG_START || (partLimit = this.msgPattern.getPart(partIndex++)).getType() != MessagePattern.Part.Type.MSG_LIMIT) continue;
            String currArg = this.pattern.substring(partStart.getLimit(), partLimit.getIndex());
            if (scanner2 != null) {
                int[] scannerMatchResult = scanner2.findText(source, currArg, startingAt);
                currMatchIndex = scannerMatchResult[0];
            } else {
                currMatchIndex = source.indexOf(currArg);
            }
            if (currMatchIndex < 0 || currMatchIndex < matchedIndex || matchedWord != null && currArg.length() <= matchedWord.length()) continue;
            matchedIndex = currMatchIndex;
            matchedWord = currArg;
            keyword2 = this.pattern.substring(partStart.getLimit(), partLimit.getIndex());
        }
        if (keyword2 != null) {
            pos.setBeginIndex(matchedIndex);
            pos.setEndIndex(matchedIndex + matchedWord.length());
            return keyword2;
        }
        pos.setBeginIndex(-1);
        pos.setEndIndex(-1);
        return null;
    }

    @Deprecated
    public void setLocale(ULocale ulocale) {
        if (ulocale == null) {
            ulocale = ULocale.getDefault(ULocale.Category.FORMAT);
        }
        this.init(null, PluralRules.PluralType.CARDINAL, ulocale, null);
    }

    public void setNumberFormat(NumberFormat format) {
        this.numberFormat = format;
    }

    public boolean equals(Object rhs) {
        if (this == rhs) {
            return true;
        }
        if (rhs == null || this.getClass() != rhs.getClass()) {
            return false;
        }
        PluralFormat pf = (PluralFormat)rhs;
        return Utility.objectEquals(this.ulocale, pf.ulocale) && Utility.objectEquals(this.pluralRules, pf.pluralRules) && Utility.objectEquals(this.msgPattern, pf.msgPattern) && Utility.objectEquals(this.numberFormat, pf.numberFormat);
    }

    public boolean equals(PluralFormat rhs) {
        return this.equals((Object)rhs);
    }

    public int hashCode() {
        return this.pluralRules.hashCode() ^ this.parsedValues.hashCode();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("locale=" + this.ulocale);
        buf.append(", rules='" + this.pluralRules + "'");
        buf.append(", pattern='" + this.pattern + "'");
        buf.append(", format='" + this.numberFormat + "'");
        return buf.toString();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.pluralRulesWrapper = new PluralSelectorAdapter();
        this.parsedValues = null;
        if (this.pattern != null) {
            this.applyPattern(this.pattern);
        }
    }

    private final class PluralSelectorAdapter
    implements PluralSelector {
        private PluralSelectorAdapter() {
        }

        public String select(Object context2, double number) {
            PluralRules.FixedDecimal dec = (PluralRules.FixedDecimal)context2;
            assert (dec.source == number);
            return PluralFormat.this.pluralRules.select(dec);
        }
    }

    static interface PluralSelector {
        public String select(Object var1, double var2);
    }
}

