/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import java.util.List;
import org.python.indexer.Indexer;
import org.python.indexer.NBinding;
import org.python.indexer.Scope;
import org.python.indexer.ast.BindingFinder;
import org.python.indexer.ast.NBlock;
import org.python.indexer.ast.NBody;
import org.python.indexer.ast.NFunctionDef;
import org.python.indexer.ast.NName;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNodeVisitor;
import org.python.indexer.ast.NameBinder;
import org.python.indexer.types.NTupleType;
import org.python.indexer.types.NType;
import org.python.indexer.types.NUnknownType;

public class NLambda
extends NFunctionDef {
    static final long serialVersionUID = 7737836525970653522L;
    private NName fname;

    public NLambda(List<NNode> args, NNode body, List<NNode> defaults2, NName varargs, NName kwargs) {
        this(args, body, defaults2, varargs, kwargs, 0, 1);
    }

    public NLambda(List<NNode> args, NNode body, List<NNode> defaults2, NName varargs, NName kwargs, int start, int end) {
        super(null, args, null, defaults2, varargs, kwargs, start, end);
        this.body = body instanceof NBlock ? new NBody((NBlock)body) : body;
        this.addChildren(this.body);
    }

    @Override
    public boolean isLambda() {
        return true;
    }

    @Override
    protected String getBindingName(Scope s) {
        if (this.fname != null) {
            return this.fname.id;
        }
        String fn = s.newLambdaName();
        this.fname = new NName(fn, this.start(), this.start() + "lambda".length());
        this.fname.setParent(this);
        return fn;
    }

    @Override
    protected void bindFunctionName(Scope owner) throws Exception {
        NameBinder.make(NBinding.Kind.FUNCTION).bindName(owner, this.fname, this.getType());
    }

    @Override
    protected void bindMethodAttrs(Scope owner) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NType resolve(Scope s) throws Exception {
        NUnknownType u;
        if (!this.getType().isFuncType()) {
            Indexer.idx.reportFailedAssertion("Bad type on " + this + ": type=" + this.getType() + " in file " + this.getFile() + " at " + this.start());
        }
        NTupleType fromType = new NTupleType();
        NameBinder param = NameBinder.make(NBinding.Kind.PARAMETER);
        this.resolveList(this.defaults, s);
        Scope funcTable = this.getTable();
        int argnum = 0;
        for (NNode a : this.args) {
            NType argtype = NFunctionDef.getArgType(this.args, this.defaults, argnum++);
            param.bind(funcTable, a, argtype);
            fromType.add(argtype);
        }
        if (this.varargs != null) {
            u = new NUnknownType();
            param.bind(funcTable, this.varargs, (NType)u);
            fromType.add(u);
        }
        if (this.kwargs != null) {
            u = new NUnknownType();
            param.bind(funcTable, this.kwargs, (NType)u);
            fromType.add(u);
        }
        try {
            funcTable.setNameBindingPhase(true);
            this.body.visit(new BindingFinder(funcTable));
        }
        finally {
            funcTable.setNameBindingPhase(false);
        }
        NType toType = NLambda.resolveExpr(this.body, funcTable);
        if (this.getType().isFuncType()) {
            this.getType().asFuncType().setReturnType(toType);
        }
        return this.getType();
    }

    @Override
    public String toString() {
        return "<Lambda:" + this.start() + ":" + this.args + ":" + this.body + ">";
    }

    @Override
    public void visit(NNodeVisitor v) {
        if (v.visit(this)) {
            this.visitNodeList(this.args, v);
            this.visitNodeList(this.defaults, v);
            this.visitNode(this.varargs, v);
            this.visitNode(this.kwargs, v);
            this.visitNode(this.body, v);
        }
    }
}

