/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.api;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.ProxySelector;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.entity.ContentProducer;
import org.apache.http.entity.EntityTemplate;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.ProxySelectorRoutePlanner;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.dom4j.Node;
import org.rundeck.api.ApiPathBuilder;
import org.rundeck.api.RundeckApiException;
import org.rundeck.api.RundeckClient;
import org.rundeck.api.parser.ParserHelper;
import org.rundeck.api.parser.XmlNodeParser;
import org.rundeck.api.util.AssertUtil;
import org.rundeck.api.util.DocumentContentProducer;

class ApiCall {
    private static final transient String AUTH_TOKEN_HEADER = "X-RunDeck-Auth-Token";
    private static final transient String COOKIE_HEADER = "Cookie";
    private final RundeckClient client;

    public ApiCall(RundeckClient client) throws IllegalArgumentException {
        this.client = client;
        AssertUtil.notNull(client, "The RunDeck Client must not be null !");
    }

    public void ping() throws RundeckApiException {
        HttpClient httpClient = this.instantiateHttpClient();
        try {
            HttpResponse response = httpClient.execute((HttpUriRequest)new HttpGet(this.client.getUrl()));
            if (response.getStatusLine().getStatusCode() / 100 != 2) {
                throw new RundeckApiException("Invalid HTTP response '" + response.getStatusLine() + "' when pinging " + this.client.getUrl());
            }
        }
        catch (IOException e) {
            throw new RundeckApiException("Failed to ping RunDeck instance at " + this.client.getUrl(), e);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    public String testAuth() throws RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException {
        String sessionID = null;
        if (this.client.getToken() != null || this.client.getSessionID() != null) {
            this.testTokenAuth();
        } else {
            sessionID = this.testLoginAuth();
        }
        return sessionID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String testLoginAuth() throws RundeckApiException.RundeckApiLoginException {
        String sessionID = null;
        HttpClient httpClient = this.instantiateHttpClient();
        try {
            sessionID = this.login(httpClient);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
        return sessionID;
    }

    public void testTokenAuth() throws RundeckApiException.RundeckApiTokenException {
        try {
            this.execute((HttpUriRequest)new HttpGet(this.client.getUrl() + this.client.getApiEndpoint() + "/system/info"));
        }
        catch (RundeckApiException.RundeckApiTokenException e) {
            throw e;
        }
        catch (RundeckApiException e) {
            throw new RundeckApiException.RundeckApiTokenException("Failed to verify token", e);
        }
    }

    public <T> T get(ApiPathBuilder apiPath, XmlNodeParser<T> parser) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException {
        HttpGet request = new HttpGet(this.client.getUrl() + this.client.getApiEndpoint() + apiPath);
        if (null != apiPath.getAccept()) {
            request.setHeader("Accept", apiPath.getAccept());
        }
        return this.execute((HttpRequestBase)request, parser);
    }

    public InputStream get(ApiPathBuilder apiPath) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException {
        HttpGet request = new HttpGet(this.client.getUrl() + this.client.getApiEndpoint() + apiPath);
        if (null != apiPath.getAccept()) {
            request.setHeader("Accept", apiPath.getAccept());
        }
        ByteArrayInputStream response = this.execute((HttpUriRequest)request);
        ParserHelper.loadDocument(response);
        response.reset();
        return response;
    }

    public InputStream getNonApi(ApiPathBuilder apiPath) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException {
        HttpGet request = new HttpGet(this.client.getUrl() + apiPath);
        if (null != apiPath.getAccept()) {
            request.setHeader("Accept", apiPath.getAccept());
        }
        ByteArrayInputStream response = this.execute((HttpUriRequest)request);
        response.reset();
        return response;
    }

    public <T> T postOrGet(ApiPathBuilder apiPath, XmlNodeParser<T> parser) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException {
        if (apiPath.hasPostContent()) {
            return this.post(apiPath, parser);
        }
        return this.get(apiPath, parser);
    }

    public <T> T post(ApiPathBuilder apiPath, XmlNodeParser<T> parser) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException {
        HttpPost httpPost = new HttpPost(this.client.getUrl() + this.client.getApiEndpoint() + apiPath);
        return this.requestWithEntity(apiPath, parser, (HttpEntityEnclosingRequestBase)httpPost);
    }

    public <T> T put(ApiPathBuilder apiPath, XmlNodeParser<T> parser) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException {
        HttpPut httpPut = new HttpPut(this.client.getUrl() + this.client.getApiEndpoint() + apiPath);
        return this.requestWithEntity(apiPath, parser, (HttpEntityEnclosingRequestBase)httpPut);
    }

    private <T> T requestWithEntity(ApiPathBuilder apiPath, XmlNodeParser<T> parser, HttpEntityEnclosingRequestBase httpPost) {
        if (null != apiPath.getAccept()) {
            httpPost.setHeader("Accept", apiPath.getAccept());
        }
        if (apiPath.getAttachments().size() > 0) {
            MultipartEntity entity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
            for (Map.Entry<String, InputStream> attachment : apiPath.getAttachments().entrySet()) {
                entity.addPart(attachment.getKey(), (ContentBody)new InputStreamBody(attachment.getValue(), attachment.getKey()));
            }
            httpPost.setEntity((HttpEntity)entity);
        } else if (apiPath.getForm().size() > 0) {
            try {
                httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(apiPath.getForm(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RundeckApiException("Unsupported encoding: " + e.getMessage(), e);
            }
        } else if (apiPath.getContentStream() != null && apiPath.getContentType() != null) {
            BasicHttpEntity entity = new BasicHttpEntity();
            entity.setContent(apiPath.getContentStream());
            entity.setContentType(apiPath.getContentType());
            httpPost.setEntity((HttpEntity)entity);
        } else if (apiPath.getContentFile() != null && apiPath.getContentType() != null) {
            httpPost.setEntity((HttpEntity)new FileEntity(apiPath.getContentFile(), apiPath.getContentType()));
        } else if (apiPath.getXmlDocument() != null) {
            httpPost.setHeader("Content-Type", "application/xml");
            httpPost.setEntity((HttpEntity)new EntityTemplate((ContentProducer)new DocumentContentProducer(apiPath.getXmlDocument())));
        } else if (!apiPath.isEmptyContent()) {
            throw new IllegalArgumentException("No Form or Multipart entity for POST content-body");
        }
        return this.execute((HttpRequestBase)httpPost, parser);
    }

    public <T> T delete(ApiPathBuilder apiPath, XmlNodeParser<T> parser) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException {
        return this.execute((HttpRequestBase)new HttpDelete(this.client.getUrl() + this.client.getApiEndpoint() + apiPath), parser);
    }

    public void delete(ApiPathBuilder apiPath) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException {
        ByteArrayInputStream response = this.execute((HttpUriRequest)new HttpDelete(this.client.getUrl() + this.client.getApiEndpoint() + apiPath));
        if (null != response) {
            throw new RundeckApiException("Unexpected Rundeck response content, expected no content!");
        }
    }

    private <T> T execute(HttpRequestBase request, XmlNodeParser<T> parser) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException {
        return (T)new ParserHandler(parser).handle(this.execute((HttpUriRequest)request, new ResultHandler()));
    }

    public int get(ApiPathBuilder apiPath, OutputStream outputStream) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IOException {
        WriteOutHandler writeOutHandler;
        HttpGet request = new HttpGet(this.client.getUrl() + this.client.getApiEndpoint() + apiPath);
        if (null != apiPath.getAccept()) {
            request.setHeader("Accept", apiPath.getAccept());
        }
        Handler<HttpResponse, Integer> handler = writeOutHandler = new WriteOutHandler(outputStream);
        if (null != apiPath.getRequiredContentType()) {
            handler = new RequireContentTypeHandler(apiPath.getRequiredContentType(), handler);
        }
        int wrote = this.execute((HttpUriRequest)request, handler);
        if (writeOutHandler.thrown != null) {
            throw writeOutHandler.thrown;
        }
        return wrote;
    }

    private ByteArrayInputStream execute(HttpUriRequest request) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException {
        return this.execute(request, new ResultHandler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T execute(HttpUriRequest request, Handler<HttpResponse, T> handler) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException {
        HttpClient httpClient = this.instantiateHttpClient();
        try {
            T t;
            if (this.client.getToken() == null && this.client.getSessionID() == null) {
                this.login(httpClient);
            }
            HttpResponse response = null;
            try {
                response = httpClient.execute(request);
            }
            catch (IOException e) {
                throw new RundeckApiException("Failed to execute an HTTP " + request.getMethod() + " on url : " + request.getURI(), e);
            }
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode / 100 == 3) {
                String newLocation = response.getFirstHeader("Location").getValue();
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                catch (IOException e) {
                    throw new RundeckApiException("Failed to consume entity (release connection)", e);
                }
                request = new HttpGet(newLocation);
                try {
                    response = httpClient.execute(request);
                    statusCode = response.getStatusLine().getStatusCode();
                }
                catch (IOException e) {
                    throw new RundeckApiException("Failed to execute an HTTP GET on url : " + request.getURI(), e);
                }
            }
            if (statusCode / 100 != 2) {
                if (statusCode == 403 && (this.client.getToken() != null || this.client.getSessionID() != null)) {
                    throw new RundeckApiException.RundeckApiTokenException("Invalid Token or sessionID ! Got HTTP response '" + response.getStatusLine() + "' for " + request.getURI());
                }
                throw new RundeckApiException.RundeckApiHttpStatusException("Invalid HTTP response '" + response.getStatusLine() + "' for " + request.getURI(), statusCode);
            }
            if (statusCode == 204) {
                t = null;
                return t;
            }
            if (response.getEntity() == null) {
                throw new RundeckApiException("Empty RunDeck response ! HTTP status line is : " + response.getStatusLine());
            }
            t = handler.handle(response);
            return t;
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    private String login(HttpClient httpClient) throws RundeckApiException.RundeckApiLoginException {
        String sessionID = null;
        String location = this.client.getUrl();
        try {
            int i2;
            int i1;
            String cookieStr;
            HttpGet getRequest = new HttpGet(location);
            HttpResponse response = httpClient.execute((HttpUriRequest)getRequest);
            Header cookieHeader = response.getFirstHeader("Set-Cookie");
            if (cookieHeader != null && (cookieStr = cookieHeader.getValue()) != null && (i1 = cookieStr.indexOf("JSESSIONID=")) >= 0 && (i2 = (cookieStr = cookieStr.substring(i1 + "JSESSIONID=".length())).indexOf(";")) >= 0) {
                sessionID = cookieStr.substring(0, i2);
            }
            try {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
            catch (IOException e) {
                throw new RundeckApiException.RundeckApiLoginException("Failed to consume entity (release connection)", e);
            }
        }
        catch (IOException e) {
            throw new RundeckApiException.RundeckApiLoginException("Failed to get request on " + location, e);
        }
        location = location + "/j_security_check";
        try {
            HttpResponse response;
            while (true) {
                HttpPost postLogin = new HttpPost(location);
                ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
                params.add(new BasicNameValuePair("j_username", this.client.getLogin()));
                params.add(new BasicNameValuePair("j_password", this.client.getPassword()));
                params.add(new BasicNameValuePair("action", "login"));
                postLogin.setEntity((HttpEntity)new UrlEncodedFormEntity(params, Consts.UTF_8));
                response = httpClient.execute((HttpUriRequest)postLogin);
                if (response.getStatusLine().getStatusCode() / 100 != 3) break;
                location = response.getFirstHeader("Location").getValue();
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                catch (IOException e) {
                    throw new RundeckApiException.RundeckApiLoginException("Failed to consume entity (release connection)", e);
                }
            }
            if (response.getStatusLine().getStatusCode() / 100 != 2) {
                throw new RundeckApiException.RundeckApiLoginException("Invalid HTTP response '" + response.getStatusLine() + "' for " + location);
            }
            try {
                String content = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Consts.UTF_8);
                if (StringUtils.contains((String)content, (String)"j_security_check")) {
                    throw new RundeckApiException.RundeckApiLoginException("Login failed for user " + this.client.getLogin());
                }
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                catch (IOException e) {
                    throw new RundeckApiException.RundeckApiLoginException("Failed to consume entity (release connection)", e);
                }
            }
            catch (IOException io) {
                throw new RundeckApiException.RundeckApiLoginException("Failed to read RunDeck result", io);
            }
            catch (ParseException p) {
                throw new RundeckApiException.RundeckApiLoginException("Failed to parse RunDeck response", p);
            }
        }
        catch (IOException e) {
            throw new RundeckApiException.RundeckApiLoginException("Failed to post login form on " + location, e);
        }
        return sessionID;
    }

    private HttpClient instantiateHttpClient() {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        HttpProtocolParams.setUserAgent((HttpParams)httpClient.getParams(), (String)("RunDeck API Java Client " + this.client.getApiVersion()));
        SSLSocketFactory socketFactory = null;
        try {
            socketFactory = new SSLSocketFactory(new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            }, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        }
        catch (KeyManagementException e) {
            throw new RuntimeException(e);
        }
        catch (UnrecoverableKeyException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (KeyStoreException e) {
            throw new RuntimeException(e);
        }
        httpClient.getConnectionManager().getSchemeRegistry().register(new Scheme("https", 443, (SchemeSocketFactory)socketFactory));
        System.setProperty("java.net.useSystemProxies", "true");
        httpClient.setRoutePlanner((HttpRoutePlanner)new ProxySelectorRoutePlanner(httpClient.getConnectionManager().getSchemeRegistry(), ProxySelector.getDefault()));
        httpClient.addRequestInterceptor(new HttpRequestInterceptor(){

            public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
                if (ApiCall.this.client.getToken() != null) {
                    request.addHeader(ApiCall.AUTH_TOKEN_HEADER, ApiCall.this.client.getToken());
                } else if (ApiCall.this.client.getSessionID() != null) {
                    request.addHeader(ApiCall.COOKIE_HEADER, "JSESSIONID=" + ApiCall.this.client.getSessionID());
                }
            }
        });
        return httpClient;
    }

    private static class ResultHandler
    implements Handler<HttpResponse, ByteArrayInputStream> {
        private ResultHandler() {
        }

        @Override
        public ByteArrayInputStream handle(HttpResponse response) {
            try {
                return new ByteArrayInputStream(EntityUtils.toByteArray((HttpEntity)response.getEntity()));
            }
            catch (IOException e) {
                throw new RundeckApiException("Failed to consume entity and convert the inputStream", e);
            }
        }
    }

    private static class WriteOutHandler
    implements Handler<HttpResponse, Integer> {
        OutputStream writeOut;
        IOException thrown;

        private WriteOutHandler(OutputStream writeOut) {
            this.writeOut = writeOut;
        }

        @Override
        public Integer handle(HttpResponse response) {
            try {
                return IOUtils.copy((InputStream)response.getEntity().getContent(), (OutputStream)this.writeOut);
            }
            catch (IOException e) {
                this.thrown = e;
                return -1;
            }
        }
    }

    private static class RequireContentTypeHandler<T>
    extends ChainHandler<T> {
        String contentType;

        private RequireContentTypeHandler(String contentType, Handler<HttpResponse, T> chain) {
            super(chain);
            this.contentType = contentType;
        }

        @Override
        public T handle(HttpResponse response) {
            Header firstHeader = response.getFirstHeader("Content-Type");
            String[] split = firstHeader.getValue().split(";");
            boolean matched = false;
            for (int i = 0; i < split.length; ++i) {
                String s = split[i];
                if (!this.contentType.equalsIgnoreCase(s.trim())) continue;
                matched = true;
                break;
            }
            if (!matched) {
                throw new RundeckApiException.RundeckApiHttpContentTypeException(firstHeader.getValue(), this.contentType);
            }
            return super.handle(response);
        }
    }

    private static class ChainHandler<T>
    implements Handler<HttpResponse, T> {
        Handler<HttpResponse, T> chain;

        private ChainHandler(Handler<HttpResponse, T> chain) {
            this.chain = chain;
        }

        @Override
        public T handle(HttpResponse response) {
            return this.chain.handle(response);
        }
    }

    private static class ParserHandler<S>
    implements Handler<InputStream, S> {
        XmlNodeParser<S> parser;

        private ParserHandler(XmlNodeParser<S> parser) {
            this.parser = parser;
        }

        @Override
        public S handle(InputStream response) {
            return this.parser.parseXmlNode((Node)ParserHelper.loadDocument(response));
        }
    }

    private static interface Handler<T, V> {
        public V handle(T var1);
    }
}

