/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.api;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.TimeZone;
import org.rundeck.api.ApiPathBuilder;

abstract class QueryParameterBuilder
implements ApiPathBuilder.BuildsParameters {
    public static final String W3C_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    static final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");

    QueryParameterBuilder() {
    }

    protected boolean visit(String key, Object value, boolean doPost, ApiPathBuilder builder) {
        if (null != value) {
            if (doPost) {
                if (value instanceof Collection) {
                    builder.field(key, (Collection)value);
                } else {
                    builder.field(key, this.stringVal(value));
                }
                return true;
            }
            if (value instanceof Collection) {
                builder.param(key, (Collection)value);
            } else {
                builder.param(key, this.stringVal(value));
            }
            return true;
        }
        return false;
    }

    private String stringVal(Object value) {
        return value instanceof String ? (String)value : (value instanceof Boolean ? Boolean.toString((Boolean)value) : (value instanceof Date ? this.formatDate((Date)value) : value.toString()));
    }

    private String formatDate(Date value) {
        return format.format(value);
    }

    static {
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

