/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.api;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.rundeck.api.ApiCall;
import org.rundeck.api.ApiPathBuilder;
import org.rundeck.api.ExecutionQueryParameters;
import org.rundeck.api.FileType;
import org.rundeck.api.RunAdhocCommand;
import org.rundeck.api.RunAdhocScript;
import org.rundeck.api.RunAdhocScriptBuilder;
import org.rundeck.api.RunJob;
import org.rundeck.api.RundeckApiException;
import org.rundeck.api.RundeckClientBuilder;
import org.rundeck.api.RundeckJobsImport;
import org.rundeck.api.RundeckJobsImportBuilder;
import org.rundeck.api.domain.ArchiveImport;
import org.rundeck.api.domain.ConfigProperty;
import org.rundeck.api.domain.DeleteExecutionsResponse;
import org.rundeck.api.domain.KeyResource;
import org.rundeck.api.domain.ProjectConfig;
import org.rundeck.api.domain.RundeckAbort;
import org.rundeck.api.domain.RundeckExecution;
import org.rundeck.api.domain.RundeckExecutionState;
import org.rundeck.api.domain.RundeckHistory;
import org.rundeck.api.domain.RundeckJob;
import org.rundeck.api.domain.RundeckJobDeleteBulk;
import org.rundeck.api.domain.RundeckJobsImportResult;
import org.rundeck.api.domain.RundeckNode;
import org.rundeck.api.domain.RundeckOutput;
import org.rundeck.api.domain.RundeckProject;
import org.rundeck.api.domain.RundeckSystemInfo;
import org.rundeck.api.domain.RundeckToken;
import org.rundeck.api.generator.DeleteExecutionsGenerator;
import org.rundeck.api.generator.ProjectConfigGenerator;
import org.rundeck.api.generator.ProjectConfigPropertyGenerator;
import org.rundeck.api.generator.ProjectGenerator;
import org.rundeck.api.parser.APIV11Helper;
import org.rundeck.api.parser.AbortParser;
import org.rundeck.api.parser.ArchiveImportParser;
import org.rundeck.api.parser.BulkDeleteParser;
import org.rundeck.api.parser.DeleteExecutionsResponseParser;
import org.rundeck.api.parser.ExecutionParser;
import org.rundeck.api.parser.ExecutionStateParser;
import org.rundeck.api.parser.HistoryParser;
import org.rundeck.api.parser.JobParser;
import org.rundeck.api.parser.JobsImportResultParser;
import org.rundeck.api.parser.ListParser;
import org.rundeck.api.parser.NodeParser;
import org.rundeck.api.parser.OutputEntryParser;
import org.rundeck.api.parser.OutputEntryParserV5;
import org.rundeck.api.parser.OutputParser;
import org.rundeck.api.parser.PagedResultParser;
import org.rundeck.api.parser.ProjectConfigParser;
import org.rundeck.api.parser.ProjectConfigPropertyParser;
import org.rundeck.api.parser.ProjectParser;
import org.rundeck.api.parser.ProjectParserV11;
import org.rundeck.api.parser.RundeckTokenParser;
import org.rundeck.api.parser.SSHKeyResourceParser;
import org.rundeck.api.parser.SystemInfoParser;
import org.rundeck.api.query.ExecutionQuery;
import org.rundeck.api.util.AssertUtil;
import org.rundeck.api.util.PagedResults;
import org.rundeck.api.util.ParametersUtil;

public class RundeckClient
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JOBS_IMPORT = "/jobs/import";
    public static final String STORAGE_ROOT_PATH = "/storage/";
    public static final String STORAGE_KEYS_PATH = "keys/";
    public static final transient int API_VERSION = Version.V12.getVersionNumber();
    private static final String API = "/api/";
    public static final transient String API_ENDPOINT = "/api/" + API_VERSION;
    public static final transient long DEFAULT_POOLING_INTERVAL = 5L;
    public static final TimeUnit DEFAULT_POOLING_UNIT = TimeUnit.SECONDS;
    private final String url;
    private int apiVersion = API_VERSION;
    private String token;
    private String login;
    private String password;
    private String sessionID;

    void setToken(String token) {
        this.token = token;
    }

    void setLogin(String login) {
        this.login = login;
    }

    void setPassword(String password) {
        this.password = password;
    }

    void setSessionID(String sessionID) {
        this.sessionID = sessionID;
    }

    int getApiVersion() {
        return this.apiVersion > 0 ? this.apiVersion : API_VERSION;
    }

    void setApiVersion(int apiVersion) {
        this.apiVersion = apiVersion > 0 ? apiVersion : API_VERSION;
    }

    void setApiVersion(Version apiVersion) {
        this.setApiVersion(apiVersion.getVersionNumber());
    }

    String getApiEndpoint() {
        return API + this.getApiVersion();
    }

    public RundeckClient(String url, String login, String password) throws IllegalArgumentException {
        this(url);
        AssertUtil.notBlank(login, "The RunDeck login is mandatory !");
        AssertUtil.notBlank(password, "The RunDeck password is mandatory !");
        this.login = login;
        this.password = password;
        this.token = null;
    }

    private RundeckClient(String url, String token, String sessionID, boolean useToken) throws IllegalArgumentException {
        this(url);
        if (useToken) {
            AssertUtil.notBlank(token, "Token is mandatory!");
            this.token = token;
            this.sessionID = null;
        } else {
            AssertUtil.notBlank(sessionID, "sessionID is mandatory!");
            this.sessionID = sessionID;
            this.token = null;
        }
        this.login = null;
        this.password = null;
    }

    public RundeckClient(String url, String token) throws IllegalArgumentException {
        this(url, token, null, true);
    }

    RundeckClient(String url) throws IllegalArgumentException {
        AssertUtil.notBlank(url, "The RunDeck URL is mandatory !");
        this.url = url;
    }

    public static RundeckClientBuilder builder() {
        return new RundeckClientBuilder();
    }

    public void ping() throws RundeckApiException {
        new ApiCall(this).ping();
    }

    public String testAuth() throws RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException {
        return new ApiCall(this).testAuth();
    }

    @Deprecated
    public void testCredentials() throws RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException {
        this.testAuth();
    }

    private String rootXpath() {
        return this.getApiVersion() < Version.V11.getVersionNumber() ? "result" : "";
    }

    private ProjectParser createProjectParser() {
        return this.createProjectParser(null);
    }

    private ProjectParser createProjectParser(String xpath) {
        return new ProjectParserV11(xpath);
    }

    public List<RundeckProject> getProjects() throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException {
        return (List)((Object)new ApiCall(this).get(new ApiPathBuilder("/projects"), new ListParser<RundeckProject>(this.createProjectParser(), this.rootXpath() + "/projects/project")));
    }

    public RundeckProject getProject(String projectName) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException {
        AssertUtil.notBlank(projectName, "projectName is mandatory to get the details of a project !");
        return new ApiCall(this).get(new ApiPathBuilder("/project/", projectName), this.createProjectParser(this.rootXpath() + (this.getApiVersion() < Version.V11.getVersionNumber() ? "/projects/project" : "/project")));
    }

    public RundeckProject createProject(String projectName, Map<String, String> configuration) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException {
        AssertUtil.notBlank(projectName, "projectName is mandatory to create a project !");
        return new ApiCall(this).post(new ApiPathBuilder("/projects").xml(this.projectDocument(projectName, configuration)), this.createProjectParser(this.rootXpath() + (this.getApiVersion() < Version.V11.getVersionNumber() ? "/projects/project" : "/project")));
    }

    public void deleteProject(String projectName) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException {
        AssertUtil.notBlank(projectName, "projectName is mandatory to create a project !");
        new ApiCall(this).delete(new ApiPathBuilder("/project/", projectName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int exportProject(String projectName, File out) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException, IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(out);
        try {
            int n = this.exportProject(projectName, fileOutputStream);
            return n;
        }
        finally {
            fileOutputStream.close();
        }
    }

    public int exportProject(String projectName, OutputStream out) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException, IOException {
        AssertUtil.notBlank(projectName, "projectName is mandatory to export a project archive!");
        return new ApiCall(this).get(new ApiPathBuilder("/project/", projectName, "/export").accept("application/zip"), out);
    }

    public ArchiveImport importArchive(String projectName, File archiveFile, boolean includeExecutions, boolean preserveJobUuids) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException, IOException {
        AssertUtil.notBlank(projectName, "projectName is mandatory to import a project archive!");
        AssertUtil.notNull(archiveFile, "archiveFile is mandatory to import a project archive!");
        return this.callImportProject(projectName, includeExecutions, preserveJobUuids, new ApiPathBuilder(new String[0]).content("application/zip", archiveFile));
    }

    private ArchiveImport callImportProject(String projectName, boolean includeExecutions, boolean preserveJobUuids, ApiPathBuilder param) {
        param.paths("/project/", projectName, "/import").param("importExecutions", includeExecutions).param("jobUuidOption", preserveJobUuids ? "preserve" : "remove");
        return new ApiCall(this).put(param, new ArchiveImportParser());
    }

    public ProjectConfig getProjectConfig(String projectName) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException {
        AssertUtil.notBlank(projectName, "projectName is mandatory to get the config of a project !");
        return new ApiCall(this).get(new ApiPathBuilder("/project/", projectName, "/config"), new ProjectConfigParser("/config"));
    }

    public String getProjectConfig(String projectName, String key) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException {
        AssertUtil.notBlank(projectName, "projectName is mandatory to get the config of a project !");
        AssertUtil.notBlank(key, "key is mandatory to get the config key value!");
        ConfigProperty configProperty = null;
        try {
            configProperty = new ApiCall(this).get(new ApiPathBuilder("/project/", projectName, "/config/", key), new ProjectConfigPropertyParser("/property"));
        }
        catch (RundeckApiException.RundeckApiHttpStatusException e) {
            if (404 == e.getStatusCode()) {
                return null;
            }
            throw e;
        }
        return configProperty.getValue();
    }

    public String setProjectConfig(String projectName, String key, String value) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException {
        AssertUtil.notBlank(projectName, "projectName is mandatory to set the config of a project !");
        AssertUtil.notBlank(key, "key is mandatory to set the config key value!");
        AssertUtil.notBlank(value, "value is mandatory to set the config key value!");
        ConfigProperty configProperty = new ApiCall(this).put(new ApiPathBuilder("/project/", projectName, "/config/", key).xml(new ProjectConfigPropertyGenerator(new ConfigProperty(key, value))), new ProjectConfigPropertyParser("/property"));
        return configProperty.getValue();
    }

    public void deleteProjectConfig(String projectName, String key) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException {
        AssertUtil.notBlank(projectName, "projectName is mandatory to set the config of a project !");
        AssertUtil.notBlank(key, "key is mandatory to set the config key value!");
        new ApiCall(this).delete(new ApiPathBuilder("/project/", projectName, "/config/", key).accept("application/xml"));
    }

    public ProjectConfig setProjectConfig(String projectName, Map<String, String> configuration) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException {
        AssertUtil.notBlank(projectName, "projectName is mandatory to get the config of a project !");
        return new ApiCall(this).put(new ApiPathBuilder("/project/", projectName, "/config").xml(new ProjectConfigGenerator(new ProjectConfig(configuration))), new ProjectConfigParser("/config"));
    }

    private Document projectDocument(String projectName, Map<String, String> configuration) {
        RundeckProject project = new RundeckProject();
        project.setName(projectName);
        if (null != configuration) {
            project.setProjectConfig(new ProjectConfig(configuration));
        }
        return new ProjectGenerator(project).generateXmlDocument();
    }

    public List<RundeckJob> getJobs() throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException {
        ArrayList<RundeckJob> jobs = new ArrayList<RundeckJob>();
        for (RundeckProject project : this.getProjects()) {
            jobs.addAll(this.getJobs(project.getName()));
        }
        return jobs;
    }

    public List<RundeckJob> getJobs(String project) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException {
        return this.getJobs(project, null, null, new String[0]);
    }

    public List<RundeckJob> getJobs(String project, String jobFilter, String groupPath, String ... jobIds) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException {
        AssertUtil.notBlank(project, "project is mandatory to get all jobs !");
        return (List)((Object)new ApiCall(this).get(new ApiPathBuilder("/jobs").param("project", project).param("jobFilter", jobFilter).param("groupPath", groupPath).param("idlist", StringUtils.join((Object[])jobIds, (String)",")), new ListParser<RundeckJob>(new JobParser(), this.rootXpath() + "/jobs/job")));
    }

    public void exportJobsToFile(String filename, String format, String project) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException, IOException {
        AssertUtil.notBlank(format, "format is mandatory to export jobs !");
        this.exportJobsToFile(filename, FileType.valueOf(StringUtils.upperCase((String)format)), project);
    }

    public void exportJobsToFile(String filename, FileType format, String project) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException, IOException {
        this.exportJobsToFile(filename, format, project, null, null, new String[0]);
    }

    public void exportJobsToFile(String filename, String format, String project, String jobFilter, String groupPath, String ... jobIds) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException, IOException {
        AssertUtil.notBlank(format, "format is mandatory to export jobs !");
        this.exportJobsToFile(filename, FileType.valueOf(StringUtils.upperCase((String)format)), project, jobFilter, groupPath, jobIds);
    }

    public void exportJobsToFile(String filename, FileType format, String project, String jobFilter, String groupPath, String ... jobIds) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException, IOException {
        AssertUtil.notBlank(filename, "filename is mandatory to export a job !");
        InputStream inputStream = this.exportJobs(format, project, jobFilter, groupPath, jobIds);
        FileUtils.writeByteArrayToFile((File)new File(filename), (byte[])IOUtils.toByteArray((InputStream)inputStream));
    }

    public InputStream exportJobs(String format, String project) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException {
        AssertUtil.notBlank(format, "format is mandatory to export jobs !");
        return this.exportJobs(FileType.valueOf(StringUtils.upperCase((String)format)), project);
    }

    public InputStream exportJobs(FileType format, String project) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException {
        return this.exportJobs(format, project, null, null, new String[0]);
    }

    public InputStream exportJobs(String format, String project, String jobFilter, String groupPath, String ... jobIds) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException {
        AssertUtil.notBlank(format, "format is mandatory to export jobs !");
        return this.exportJobs(FileType.valueOf(StringUtils.upperCase((String)format)), project, jobFilter, groupPath, jobIds);
    }

    public InputStream exportJobs(FileType format, String project, String jobFilter, String groupPath, String ... jobIds) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException {
        AssertUtil.notNull((Object)format, "format is mandatory to export jobs !");
        AssertUtil.notBlank(project, "project is mandatory to export jobs !");
        return new ApiCall(this).get(new ApiPathBuilder("/jobs/export").accept(format == FileType.XML ? "text/xml" : "text/yaml").param("format", format).param("project", project).param("jobFilter", jobFilter).param("groupPath", groupPath).param("idlist", StringUtils.join((Object[])jobIds, (String)",")));
    }

    public void exportJobToFile(String filename, String format, String jobId) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException, IOException {
        AssertUtil.notBlank(format, "format is mandatory to export a job !");
        this.exportJobToFile(filename, FileType.valueOf(StringUtils.upperCase((String)format)), jobId);
    }

    public void exportJobToFile(String filename, FileType format, String jobId) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException, IOException {
        AssertUtil.notBlank(filename, "filename is mandatory to export a job !");
        InputStream inputStream = this.exportJob(format, jobId);
        FileUtils.writeByteArrayToFile((File)new File(filename), (byte[])IOUtils.toByteArray((InputStream)inputStream));
    }

    public InputStream exportJob(String format, String jobId) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException {
        AssertUtil.notBlank(format, "format is mandatory to export a job !");
        return this.exportJob(FileType.valueOf(StringUtils.upperCase((String)format)), jobId);
    }

    public InputStream exportJob(FileType format, String jobId) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException {
        AssertUtil.notNull((Object)format, "format is mandatory to export a job !");
        AssertUtil.notBlank(jobId, "jobId is mandatory to export a job !");
        return new ApiCall(this).get(new ApiPathBuilder("/job/", jobId).param("format", format));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RundeckJobsImportResult importJobs(String filename, RundeckJobsImport rundeckJobsImport) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException, IOException {
        RundeckJobsImportResult rundeckJobsImportResult;
        AssertUtil.notBlank(filename, "filename (of jobs file) is mandatory to import jobs !");
        FileInputStream stream = null;
        try {
            stream = FileUtils.openInputStream((File)new File(filename));
            rundeckJobsImportResult = this.importJobs(RundeckJobsImportBuilder.builder(rundeckJobsImport).setStream(stream).build());
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(stream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)stream);
        return rundeckJobsImportResult;
    }

    public RundeckJobsImportResult importJobs(RundeckJobsImport rundeckJobsImport) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException {
        AssertUtil.notNull(rundeckJobsImport.getStream(), "inputStream of jobs is mandatory to import jobs !");
        AssertUtil.notNull((Object)rundeckJobsImport.getFileType(), "fileType is mandatory to import jobs !");
        ApiPathBuilder request = new ApiPathBuilder(JOBS_IMPORT).param("format", rundeckJobsImport.getFileType()).param("dupeOption", rundeckJobsImport.getImportMethod()).attach("xmlBatch", rundeckJobsImport.getStream());
        if (null != rundeckJobsImport.getUuidImportBehavior()) {
            request.param("uuidOption", rundeckJobsImport.getUuidImportBehavior());
        }
        if (null != rundeckJobsImport.getProject()) {
            request.param("project", rundeckJobsImport.getProject());
        }
        return new ApiCall(this).post(request, new JobsImportResultParser(this.rootXpath()));
    }

    public RundeckJob findJob(String project, String groupPath, String name) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException {
        AssertUtil.notBlank(project, "project is mandatory to find a job !");
        AssertUtil.notBlank(name, "job name is mandatory to find a job !");
        List<RundeckJob> jobs = this.getJobs(project, name, groupPath, new String[0]);
        return jobs.isEmpty() ? null : jobs.get(0);
    }

    public RundeckJob getJob(String jobId) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException {
        AssertUtil.notBlank(jobId, "jobId is mandatory to get the details of a job !");
        return new ApiCall(this).get(new ApiPathBuilder("/job/", jobId), new JobParser("joblist/job"));
    }

    public String deleteJob(String jobId) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException {
        AssertUtil.notBlank(jobId, "jobId is mandatory to delete a job !");
        new ApiCall(this).delete(new ApiPathBuilder("/job/", jobId));
        return "Job " + jobId + " was deleted successfully";
    }

    public RundeckJobDeleteBulk deleteJobs(List<String> jobIds) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException {
        if (null == jobIds || 0 == jobIds.size()) {
            throw new IllegalArgumentException("jobIds are mandatory to delete a job");
        }
        return new ApiCall(this).post(new ApiPathBuilder("/jobs/delete").field("ids", jobIds), new BulkDeleteParser(this.rootXpath() + "/deleteJobs"));
    }

    public RundeckExecution triggerJob(RunJob jobRun) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException {
        AssertUtil.notBlank(jobRun.getJobId(), "jobId is mandatory to trigger a job !");
        ApiPathBuilder apiPath = new ApiPathBuilder("/job/", jobRun.getJobId(), "/run").param("argString", ParametersUtil.generateArgString(jobRun.getOptions())).nodeFilters(jobRun.getNodeFilters());
        if (null != jobRun.getAsUser()) {
            apiPath.param("asUser", jobRun.getAsUser());
        }
        return new ApiCall(this).get(apiPath, APIV11Helper.unwrapIfNeeded(new ExecutionParser(this.rootXpath() + "/executions/execution"), this.rootXpath() + "/executions/execution"));
    }

    public RundeckExecution runJob(RunJob runJob) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException {
        return this.runJob(runJob, 5L, DEFAULT_POOLING_UNIT);
    }

    public RundeckExecution runJob(RunJob jobRun, long poolingInterval, TimeUnit poolingUnit) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException {
        if (poolingInterval <= 0L) {
            poolingInterval = 5L;
            poolingUnit = DEFAULT_POOLING_UNIT;
        }
        if (poolingUnit == null) {
            poolingUnit = DEFAULT_POOLING_UNIT;
        }
        RundeckExecution execution = this.triggerJob(jobRun);
        while (RundeckExecution.ExecutionStatus.RUNNING.equals((Object)execution.getStatus())) {
            try {
                Thread.sleep(poolingUnit.toMillis(poolingInterval));
            }
            catch (InterruptedException e) {
                break;
            }
            execution = this.getExecution(execution.getId());
        }
        return execution;
    }

    public RundeckExecution triggerAdhocCommand(RunAdhocCommand command) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException {
        AssertUtil.notBlank(command.getProject(), "project is mandatory to trigger an ad-hoc command !");
        AssertUtil.notBlank(command.getCommand(), "command is mandatory to trigger an ad-hoc command !");
        ApiPathBuilder apiPath = new ApiPathBuilder("/run/command").param("project", command.getProject()).param("exec", command.getCommand()).param("nodeThreadcount", command.getNodeThreadcount()).param("nodeKeepgoing", command.getNodeKeepgoing()).nodeFilters(command.getNodeFilters());
        if (null != command.getAsUser()) {
            apiPath.param("asUser", command.getAsUser());
        }
        RundeckExecution execution = new ApiCall(this).get(apiPath, new ExecutionParser(this.rootXpath() + "/execution"));
        return this.getExecution(execution.getId());
    }

    public RundeckExecution runAdhocCommand(RunAdhocCommand command) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException {
        return this.runAdhocCommand(command, 5L, DEFAULT_POOLING_UNIT);
    }

    public RundeckExecution runAdhocCommand(RunAdhocCommand command, long poolingInterval, TimeUnit poolingUnit) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException {
        if (poolingInterval <= 0L) {
            poolingInterval = 5L;
            poolingUnit = DEFAULT_POOLING_UNIT;
        }
        if (poolingUnit == null) {
            poolingUnit = DEFAULT_POOLING_UNIT;
        }
        RundeckExecution execution = this.triggerAdhocCommand(command);
        while (RundeckExecution.ExecutionStatus.RUNNING.equals((Object)execution.getStatus())) {
            try {
                Thread.sleep(poolingUnit.toMillis(poolingInterval));
            }
            catch (InterruptedException e) {
                break;
            }
            execution = this.getExecution(execution.getId());
        }
        return execution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RundeckExecution triggerAdhocScript(RunAdhocScript script, String scriptFilename) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException, IOException {
        RundeckExecution rundeckExecution;
        AssertUtil.notBlank(scriptFilename, "scriptFilename is mandatory to trigger an ad-hoc script !");
        FileInputStream stream = null;
        try {
            stream = FileUtils.openInputStream((File)new File(scriptFilename));
            rundeckExecution = this.triggerAdhocScript(RunAdhocScriptBuilder.builder(script).setScript(stream).build());
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(stream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)stream);
        return rundeckExecution;
    }

    public RundeckExecution triggerAdhocScript(RunAdhocScript script) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException {
        AssertUtil.notBlank(script.getProject(), "project is mandatory to trigger an ad-hoc script !");
        AssertUtil.notNull(script.getScript(), "script is mandatory to trigger an ad-hoc script !");
        ApiPathBuilder apiPath = new ApiPathBuilder("/run/script").param("project", script.getProject()).attach("scriptFile", script.getScript()).param("argString", script.getArgString()).param("nodeThreadcount", script.getNodeThreadcount()).param("nodeKeepgoing", script.getNodeKeepgoing()).param("scriptInterpreter", script.getScriptInterpreter()).param("interpreterArgsQuoted", script.getInterpreterArgsQuoted()).nodeFilters(script.getNodeFilters());
        if (null != script.getAsUser()) {
            apiPath.param("asUser", script.getAsUser());
        }
        RundeckExecution execution = new ApiCall(this).post(apiPath, new ExecutionParser(this.rootXpath() + "/execution"));
        return this.getExecution(execution.getId());
    }

    public RundeckExecution runAdhocScript(RunAdhocScript script) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException, IOException {
        return this.runAdhocScript(script, 5L, DEFAULT_POOLING_UNIT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RundeckExecution runAdhocScript(RunAdhocScript script, String scriptFilename, long poolingInterval, TimeUnit poolingUnit) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException, IOException {
        RundeckExecution rundeckExecution;
        FileInputStream stream = null;
        try {
            stream = FileUtils.openInputStream((File)new File(scriptFilename));
            rundeckExecution = this.runAdhocScript(RunAdhocScriptBuilder.builder(script).setScript(stream).build(), poolingInterval, poolingUnit);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(stream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)stream);
        return rundeckExecution;
    }

    public RundeckExecution runAdhocScript(RunAdhocScript script, long poolingInterval, TimeUnit poolingUnit) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException {
        if (poolingInterval <= 0L) {
            poolingInterval = 5L;
            poolingUnit = DEFAULT_POOLING_UNIT;
        }
        if (poolingUnit == null) {
            poolingUnit = DEFAULT_POOLING_UNIT;
        }
        RundeckExecution execution = this.triggerAdhocScript(script);
        while (RundeckExecution.ExecutionStatus.RUNNING.equals((Object)execution.getStatus())) {
            try {
                Thread.sleep(poolingUnit.toMillis(poolingInterval));
            }
            catch (InterruptedException e) {
                break;
            }
            execution = this.getExecution(execution.getId());
        }
        return execution;
    }

    public List<RundeckExecution> getRunningExecutions() throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException {
        if (this.getApiVersion() >= Version.V9.getVersionNumber()) {
            return this.getRunningExecutions("*");
        }
        ArrayList<RundeckExecution> executions = new ArrayList<RundeckExecution>();
        for (RundeckProject project : this.getProjects()) {
            executions.addAll(this.getRunningExecutions(project.getName()));
        }
        return executions;
    }

    public List<RundeckExecution> getRunningExecutions(String project) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException {
        AssertUtil.notBlank(project, "project is mandatory get all running executions !");
        return (List)((Object)new ApiCall(this).get(new ApiPathBuilder("/executions/running").param("project", project), new ListParser<RundeckExecution>(new ExecutionParser(), this.rootXpath() + "/executions/execution")));
    }

    public List<RundeckExecution> getJobExecutions(String jobId) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException {
        return this.getJobExecutions(jobId, (RundeckExecution.ExecutionStatus)null);
    }

    public List<RundeckExecution> getJobExecutions(String jobId, String status) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException {
        return this.getJobExecutions(jobId, StringUtils.isBlank((String)status) ? null : RundeckExecution.ExecutionStatus.valueOf(StringUtils.upperCase((String)status)));
    }

    public List<RundeckExecution> getJobExecutions(String jobId, RundeckExecution.ExecutionStatus status) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException {
        return this.getJobExecutions(jobId, status, null, null);
    }

    public List<RundeckExecution> getJobExecutions(String jobId, String status, Long max, Long offset) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException {
        return this.getJobExecutions(jobId, StringUtils.isBlank((String)status) ? null : RundeckExecution.ExecutionStatus.valueOf(StringUtils.upperCase((String)status)), max, offset);
    }

    public List<RundeckExecution> getJobExecutions(String jobId, RundeckExecution.ExecutionStatus status, Long max, Long offset) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException {
        AssertUtil.notBlank(jobId, "jobId is mandatory to get the executions of a job !");
        return (List)((Object)new ApiCall(this).get(new ApiPathBuilder("/job/", jobId, "/executions").param("status", status).param("max", max).param("offset", offset), new ListParser<RundeckExecution>(new ExecutionParser(), this.rootXpath() + "/executions/execution")));
    }

    public PagedResults<RundeckExecution> getExecutions(ExecutionQuery query, Long max, Long offset) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException {
        if (!query.notBlank()) {
            throw new IllegalArgumentException("Some execution query parameter must be set");
        }
        AssertUtil.notBlank(query.getProject(), "project is required for execution query");
        return (PagedResults)((Object)new ApiCall(this).get(new ApiPathBuilder("/executions").param(new ExecutionQueryParameters(query)).param("max", max).param("offset", offset), APIV11Helper.unwrapIfNeeded(new PagedResultParser<RundeckExecution>(new ListParser<RundeckExecution>(new ExecutionParser(), "execution"), this.rootXpath() + "/executions"), this.rootXpath() + "/executions")));
    }

    public RundeckExecution getExecution(Long executionId) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException {
        AssertUtil.notNull(executionId, "executionId is mandatory to get the details of an execution !");
        return new ApiCall(this).get(new ApiPathBuilder("/execution/", executionId.toString()), APIV11Helper.unwrapIfNeeded(new ExecutionParser(this.rootXpath() + "/executions/execution"), this.rootXpath() + "/executions/execution"));
    }

    public RundeckAbort abortExecution(Long executionId) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException {
        return this.abortExecution(executionId, null);
    }

    public RundeckAbort abortExecution(Long executionId, String asUser) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException {
        AssertUtil.notNull(executionId, "executionId is mandatory to abort an execution !");
        ApiPathBuilder apiPath = new ApiPathBuilder("/execution/", executionId.toString(), "/abort");
        if (null != asUser) {
            apiPath.param("asUser", asUser);
        }
        return new ApiCall(this).get(apiPath, new AbortParser(this.rootXpath() + "/abort"));
    }

    public DeleteExecutionsResponse deleteAllJobExecutions(String jobId) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException {
        AssertUtil.notNull(jobId, "jobId is mandatory to delete executions!");
        return new ApiCall(this).delete(new ApiPathBuilder("/job/", jobId, "/executions"), new DeleteExecutionsResponseParser(this.rootXpath() + "/deleteExecutions"));
    }

    public DeleteExecutionsResponse deleteExecutions(Set<Long> executionIds) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException {
        AssertUtil.notNull(executionIds, "executionIds is mandatory to delete executions!");
        if (executionIds.size() < 1) {
            throw new IllegalArgumentException("executionIds cannot be empty");
        }
        ApiPathBuilder apiPath = new ApiPathBuilder("/executions/delete").xml(new DeleteExecutionsGenerator(executionIds));
        return new ApiCall(this).post(apiPath, new DeleteExecutionsResponseParser(this.rootXpath() + "/deleteExecutions"));
    }

    public void deleteExecution(Long executionId) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException {
        AssertUtil.notNull(executionId, "executionId is mandatory to delete an execution!");
        new ApiCall(this).delete(new ApiPathBuilder("/execution/", executionId.toString()));
    }

    public RundeckHistory getHistory(String project) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException {
        return this.getHistory(project, null, null, (String)null, (String)null, null, null, null, null);
    }

    public RundeckHistory getHistory(String project, Long max, Long offset) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException {
        return this.getHistory(project, null, null, (String)null, (String)null, null, null, max, offset);
    }

    public RundeckHistory getHistory(String project, String jobId, String reportId, String user) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException {
        return this.getHistory(project, jobId, reportId, user, null, null, null, null, null);
    }

    public RundeckHistory getHistory(String project, String jobId, String reportId, String user, Long max, Long offset) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException {
        return this.getHistory(project, jobId, reportId, user, null, null, null, max, offset);
    }

    public RundeckHistory getHistory(String project, String recent) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException {
        return this.getHistory(project, null, null, null, recent, null, null, null, null);
    }

    public RundeckHistory getHistory(String project, String recent, Long max, Long offset) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException {
        return this.getHistory(project, null, null, null, recent, null, null, max, offset);
    }

    public RundeckHistory getHistory(String project, Date begin, Date end) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException {
        return this.getHistory(project, null, null, (String)null, (String)null, begin, end, null, null);
    }

    public RundeckHistory getHistory(String project, Date begin, Date end, Long max, Long offset) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException {
        return this.getHistory(project, null, null, (String)null, (String)null, begin, end, max, offset);
    }

    public RundeckHistory getHistory(String project, String jobId, String reportId, String user, String recent, Date begin, Date end, Long max, Long offset) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException {
        AssertUtil.notBlank(project, "project is mandatory to get the history !");
        return new ApiCall(this).get(new ApiPathBuilder("/history").param("project", project).param("jobIdFilter", jobId).param("reportIdFilter", reportId).param("userFilter", user).param("recentFilter", recent).param("begin", begin).param("end", end).param("max", max).param("offset", offset), new HistoryParser(this.rootXpath() + "/events"));
    }

    public RundeckHistory getHistory(String project, String user, String recent, List<String> includeJobNames, List<String> excludeJobNames, Date begin, Date end, Long max, Long offset) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException {
        AssertUtil.notBlank(project, "project is mandatory to get the history !");
        ApiPathBuilder builder = new ApiPathBuilder("/history").param("project", project).field("jobListFilter", includeJobNames).field("excludeJobListFilter", excludeJobNames).param("userFilter", user).param("recentFilter", recent).param("begin", begin).param("end", end).param("max", max).param("offset", offset);
        return new ApiCall(this).postOrGet(builder, new HistoryParser(this.rootXpath() + "/events"));
    }

    public List<RundeckNode> getNodes() throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException {
        ArrayList<RundeckNode> nodes = new ArrayList<RundeckNode>();
        for (RundeckProject project : this.getProjects()) {
            nodes.addAll(this.getNodes(project.getName()));
        }
        return nodes;
    }

    public List<RundeckNode> getNodes(String project) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException {
        return this.getNodes(project, null);
    }

    public List<RundeckNode> getNodes(String project, Properties nodeFilters) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException {
        AssertUtil.notBlank(project, "project is mandatory to get all nodes !");
        return (List)((Object)new ApiCall(this).get(new ApiPathBuilder("/resources").param("project", project).nodeFilters(nodeFilters), new ListParser<RundeckNode>(new NodeParser(), "project/node")));
    }

    public RundeckNode getNode(String name, String project) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException {
        AssertUtil.notBlank(name, "the name of the node is mandatory to get a node !");
        AssertUtil.notBlank(project, "project is mandatory to get a node !");
        return new ApiCall(this).get(new ApiPathBuilder("/resource/", name).param("project", project), new NodeParser("project/node"));
    }

    public InputStream getOutput(String executionId) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException {
        AssertUtil.notBlank(executionId, "the execution id is mandatory to get execution output !");
        return new ApiCall(this).getNonApi(new ApiPathBuilder("/execution/downloadOutput/", executionId));
    }

    public InputStream getProfilePage(String username) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException {
        AssertUtil.notBlank(username, "the username is mandatory to get profile page !");
        return new ApiCall(this).getNonApi(new ApiPathBuilder("/user/profile?login=", username));
    }

    public InputStream generateToken(String username) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException {
        AssertUtil.notBlank(username, "the username is mandatory to generate the token");
        return new ApiCall(this).getNonApi(new ApiPathBuilder("/user/generateApiToken?login=", username));
    }

    public RundeckOutput getJobExecutionOutput(Long executionId, int offset, int lastlines, long lastmod, int maxlines) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException {
        return this.getExecutionOutput(executionId, offset, lastlines, lastmod, maxlines);
    }

    public RundeckOutput getExecutionOutput(Long executionId, int offset, int lastlines, long lastmod, int maxlines) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException {
        AssertUtil.notNull(executionId, "executionId is mandatory to get the output of a job execution!");
        ApiPathBuilder param = new ApiPathBuilder("/execution/", executionId.toString(), "/output").param("offset", offset);
        if (lastlines > 0) {
            param.param("lastlines", lastlines);
        }
        if (lastmod >= 0L) {
            param.param("lastmod", lastmod);
        }
        if (maxlines > 0) {
            param.param("maxlines", maxlines);
        }
        return new ApiCall(this).get(param, new OutputParser(this.rootXpath() + "/output", this.createOutputEntryParser()));
    }

    public RundeckExecutionState getExecutionState(Long executionId) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException {
        AssertUtil.notNull(executionId, "executionId is mandatory to get the state of an execution!");
        ApiPathBuilder param = new ApiPathBuilder("/execution/", executionId.toString(), "/state");
        return new ApiCall(this).get(param, new ExecutionStateParser(this.rootXpath() + "/executionState"));
    }

    public RundeckOutput getExecutionOutputForNode(Long executionId, String nodeName, int offset, int lastlines, long lastmod, int maxlines) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException {
        AssertUtil.notNull(executionId, "executionId is mandatory to get the output of a job execution!");
        AssertUtil.notNull(nodeName, "nodeName is mandatory to get the output of a job execution!");
        ApiPathBuilder param = new ApiPathBuilder("/execution/", executionId.toString(), "/output/node/", nodeName).param("offset", offset);
        if (lastlines > 0) {
            param.param("lastlines", lastlines);
        }
        if (lastmod >= 0L) {
            param.param("lastmod", lastmod);
        }
        if (maxlines > 0) {
            param.param("maxlines", maxlines);
        }
        return new ApiCall(this).get(param, new OutputParser(this.rootXpath() + "/output", this.createOutputEntryParser()));
    }

    public RundeckOutput getExecutionOutputForStep(Long executionId, String stepCtx, int offset, int lastlines, long lastmod, int maxlines) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException {
        AssertUtil.notNull(executionId, "executionId is mandatory to get the output of a job execution!");
        AssertUtil.notNull(stepCtx, "stepCtx is mandatory to get the output of a job execution!");
        ApiPathBuilder param = new ApiPathBuilder("/execution/", executionId.toString(), "/output/step/", stepCtx).param("offset", offset);
        if (lastlines > 0) {
            param.param("lastlines", lastlines);
        }
        if (lastmod >= 0L) {
            param.param("lastmod", lastmod);
        }
        if (maxlines > 0) {
            param.param("maxlines", maxlines);
        }
        return new ApiCall(this).get(param, new OutputParser(this.rootXpath() + "/output", this.createOutputEntryParser()));
    }

    public RundeckOutput getExecutionOutputForNodeAndStep(Long executionId, String nodeName, String stepCtx, int offset, int lastlines, long lastmod, int maxlines) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException {
        AssertUtil.notNull(executionId, "executionId is mandatory to get the output of a job execution!");
        AssertUtil.notNull(nodeName, "nodeName is mandatory to get the output of a job execution!");
        AssertUtil.notNull(stepCtx, "stepCtx is mandatory to get the output of a job execution!");
        ApiPathBuilder param = new ApiPathBuilder("/execution/", executionId.toString(), "/output/node/", nodeName, "/step/", stepCtx).param("offset", offset);
        if (lastlines > 0) {
            param.param("lastlines", lastlines);
        }
        if (lastmod >= 0L) {
            param.param("lastmod", lastmod);
        }
        if (maxlines > 0) {
            param.param("maxlines", maxlines);
        }
        return new ApiCall(this).get(param, new OutputParser(this.rootXpath() + "/output", this.createOutputEntryParser()));
    }

    public RundeckOutput getJobExecutionOutput(Long executionId, int offset, long lastmod, int maxlines) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException {
        return this.getExecutionOutput(executionId, offset, lastmod, maxlines);
    }

    public RundeckOutput getExecutionOutput(Long executionId, int offset, long lastmod, int maxlines) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException {
        AssertUtil.notNull(executionId, "executionId is mandatory to get the output of a job execution!");
        ApiPathBuilder param = new ApiPathBuilder("/execution/", executionId.toString(), "/output").param("offset", offset);
        if (lastmod >= 0L) {
            param.param("lastmod", lastmod);
        }
        if (maxlines > 0) {
            param.param("maxlines", maxlines);
        }
        return new ApiCall(this).get(param, new OutputParser(this.rootXpath() + "/output", this.createOutputEntryParser()));
    }

    public RundeckOutput getExecutionOutputState(Long executionId, boolean stateOnly, int offset, long lastmod, int maxlines) throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException, IllegalArgumentException {
        AssertUtil.notNull(executionId, "executionId is mandatory to get the output of a job execution!");
        ApiPathBuilder param = new ApiPathBuilder("/execution/", executionId.toString(), "/output/state").param("offset", offset);
        if (lastmod >= 0L) {
            param.param("lastmod", lastmod);
        }
        if (maxlines > 0) {
            param.param("maxlines", maxlines);
        }
        if (stateOnly) {
            param.param("stateOnly", true);
        }
        return new ApiCall(this).get(param, new OutputParser(this.rootXpath() + "/output", this.createOutputEntryParser()));
    }

    private OutputEntryParser createOutputEntryParser() {
        if (this.getApiVersion() <= Version.V5.versionNumber) {
            return new OutputEntryParserV5();
        }
        return new OutputEntryParser();
    }

    public RundeckSystemInfo getSystemInfo() throws RundeckApiException, RundeckApiException.RundeckApiLoginException, RundeckApiException.RundeckApiTokenException {
        return new ApiCall(this).get(new ApiPathBuilder("/system/info"), new SystemInfoParser(this.rootXpath() + "/system"));
    }

    public List<RundeckToken> listApiTokens(String user) throws RundeckApiException {
        AssertUtil.notNull(user, "user is mandatory to list API tokens for a user.");
        return (List)((Object)new ApiCall(this).get(new ApiPathBuilder("/tokens/", user), new ListParser<RundeckToken>(new RundeckTokenParser(), "/tokens/token")));
    }

    public List<RundeckToken> listApiTokens() throws RundeckApiException {
        return (List)((Object)new ApiCall(this).get(new ApiPathBuilder("/tokens"), new ListParser<RundeckToken>(new RundeckTokenParser(), "/tokens/token")));
    }

    public String generateApiToken(String user) throws RundeckApiException {
        AssertUtil.notNull(user, "user is mandatory to generate an API token for a user.");
        RundeckToken result = new ApiCall(this).post(new ApiPathBuilder("/tokens/", user).emptyContent(), new RundeckTokenParser("/token"));
        return result.getToken();
    }

    public boolean deleteApiToken(String token) throws RundeckApiException {
        AssertUtil.notNull(token, "token is mandatory to delete an API token.");
        new ApiCall(this).delete(new ApiPathBuilder("/token/", token));
        return true;
    }

    public RundeckToken getApiToken(String token) throws RundeckApiException {
        AssertUtil.notNull(token, "token is mandatory to get an API token.");
        return new ApiCall(this).get(new ApiPathBuilder("/token/", token), new RundeckTokenParser("/token"));
    }

    public KeyResource storeKey(String path, File keyfile, boolean privateKey) throws RundeckApiException {
        AssertUtil.notNull(path, "path is mandatory to store an key.");
        AssertUtil.notNull(keyfile, "keyfile is mandatory to store an key.");
        if (!path.startsWith(STORAGE_KEYS_PATH)) {
            throw new IllegalArgumentException("key storage path must start with: keys/");
        }
        return new ApiCall(this).post(new ApiPathBuilder(STORAGE_ROOT_PATH, path).content(privateKey ? "application/octet-stream" : "application/pgp-keys", keyfile), new SSHKeyResourceParser("/resource"));
    }

    public KeyResource getKey(String path) throws RundeckApiException {
        AssertUtil.notNull(path, "path is mandatory to get an key.");
        if (!path.startsWith(STORAGE_KEYS_PATH)) {
            throw new IllegalArgumentException("key storage path must start with: keys/");
        }
        KeyResource storageResource = new ApiCall(this).get(new ApiPathBuilder(STORAGE_ROOT_PATH, path), new SSHKeyResourceParser("/resource"));
        if (storageResource.isDirectory()) {
            throw new RundeckApiException("Key Path is a directory: " + path);
        }
        return storageResource;
    }

    public int getPublicKeyContent(String path, OutputStream out) throws RundeckApiException, IOException {
        AssertUtil.notNull(path, "path is mandatory to get an key.");
        if (!path.startsWith(STORAGE_KEYS_PATH)) {
            throw new IllegalArgumentException("key storage path must start with: keys/");
        }
        try {
            return new ApiCall(this).get(new ApiPathBuilder(STORAGE_ROOT_PATH, path).accept("application/pgp-keys").requireContentType("application/pgp-keys"), out);
        }
        catch (RundeckApiException.RundeckApiHttpContentTypeException e) {
            throw new RundeckApiException("Requested Key path was not a Public key: " + path, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPublicKeyContent(String path, File out) throws RundeckApiException, IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(out);
        try {
            int n = this.getPublicKeyContent(path, fileOutputStream);
            return n;
        }
        finally {
            fileOutputStream.close();
        }
    }

    public List<KeyResource> listKeyDirectoryRoot() throws RundeckApiException {
        return this.listKeyDirectory(STORAGE_KEYS_PATH);
    }

    public List<KeyResource> listKeyDirectory(String path) throws RundeckApiException {
        AssertUtil.notNull(path, "path is mandatory to get an key.");
        if (!path.startsWith(STORAGE_KEYS_PATH)) {
            throw new IllegalArgumentException("key storage path must start with: keys/");
        }
        KeyResource storageResource = new ApiCall(this).get(new ApiPathBuilder(STORAGE_ROOT_PATH, path), new SSHKeyResourceParser("/resource"));
        if (!storageResource.isDirectory()) {
            throw new RundeckApiException("key path is not a directory path: " + path);
        }
        return storageResource.getDirectoryContents();
    }

    public void deleteKey(String path) {
        AssertUtil.notNull(path, "path is mandatory to delete an key.");
        if (!path.startsWith(STORAGE_KEYS_PATH)) {
            throw new IllegalArgumentException("key storage path must start with: keys/");
        }
        new ApiCall(this).delete(new ApiPathBuilder(STORAGE_ROOT_PATH, path));
    }

    public String getUrl() {
        return this.url;
    }

    public String getToken() {
        return this.token;
    }

    public String getLogin() {
        return this.login;
    }

    public String getPassword() {
        return this.password;
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("RundeckClient ").append(API_VERSION);
        str.append(" [").append(this.url).append("] ");
        if (this.token != null) {
            str.append("(token=").append(this.token).append(")");
        } else {
            str.append("(credentials=").append(this.login).append("|").append(this.password).append(")");
        }
        return str.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.login == null ? 0 : this.login.hashCode());
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        result = 31 * result + (this.token == null ? 0 : this.token.hashCode());
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RundeckClient other = (RundeckClient)obj;
        if (this.login == null ? other.login != null : !this.login.equals(other.login)) {
            return false;
        }
        if (this.password == null ? other.password != null : !this.password.equals(other.password)) {
            return false;
        }
        if (this.token == null ? other.token != null : !this.token.equals(other.token)) {
            return false;
        }
        return !(this.url == null ? other.url != null : !this.url.equals(other.url));
    }

    public static enum Version {
        V5(5),
        V6(6),
        V7(7),
        V8(8),
        V9(9),
        V10(10),
        V11(11),
        V12(12);

        private int versionNumber;

        private Version(int i) {
            this.versionNumber = i;
        }

        public int getVersionNumber() {
            return this.versionNumber;
        }
    }
}

