/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.api;

import org.rundeck.api.RundeckClient;
import org.rundeck.api.util.AssertUtil;

public class RundeckClientBuilder {
    private String url;
    private String login;
    private String password;
    private String token = null;
    private String id = null;
    private int version = -1;

    RundeckClientBuilder() {
    }

    public RundeckClientBuilder url(String url) {
        this.url = url;
        return this;
    }

    public RundeckClientBuilder login(String login) {
        this.login = login;
        return this;
    }

    public RundeckClientBuilder login(String login, String password) {
        this.login = login;
        this.password = password;
        return this;
    }

    public RundeckClientBuilder password(String password) {
        this.password = password;
        return this;
    }

    public RundeckClientBuilder token(String token) {
        this.token = token;
        return this;
    }

    public RundeckClientBuilder sessionId(String id) {
        this.id = id;
        return this;
    }

    public RundeckClientBuilder version(RundeckClient.Version version) {
        this.version = version.getVersionNumber();
        return this;
    }

    public RundeckClientBuilder version(int version) {
        this.version = version;
        return this;
    }

    public RundeckClient build() {
        if (null == this.url) {
            AssertUtil.notBlank(this.url, "The Rundeck URL is required");
        }
        RundeckClient client = new RundeckClient(this.url);
        if (null != this.login && null != this.password) {
            AssertUtil.notBlank(this.login, "login cannot be blank");
            AssertUtil.notBlank(this.password, "password cannot be blank");
            client.setLogin(this.login);
            client.setPassword(this.password);
        } else if (null != this.token) {
            AssertUtil.notBlank(this.token, "token cannot be blank");
            client.setToken(this.token);
        } else if (null != this.id) {
            AssertUtil.notBlank(this.token, "sessionId cannot be blank");
            client.setSessionID(this.id);
        } else {
            throw new IllegalStateException("login/password, token, or sessionID must be specified");
        }
        if (this.version > 0) {
            client.setApiVersion(this.version);
        }
        return client;
    }
}

