/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.api.parser;

import org.apache.commons.lang.StringUtils;
import org.dom4j.Node;
import org.rundeck.api.domain.BaseState;
import org.rundeck.api.domain.RundeckWFExecState;
import org.rundeck.api.parser.WorkflowStateParser;
import org.rundeck.api.parser.XmlNodeParser;

public class BaseStateParser
implements XmlNodeParser<BaseState> {
    private String xpath;

    public static void parseBaseState(Node targetNode, BaseState state) {
        state.setEndTime(WorkflowStateParser.parseDate(StringUtils.trimToNull((String)targetNode.valueOf("endTime"))));
        state.setStartTime(WorkflowStateParser.parseDate(StringUtils.trimToNull((String)targetNode.valueOf("startTime"))));
        state.setUpdateTime(WorkflowStateParser.parseDate(StringUtils.trimToNull((String)targetNode.valueOf("updateTime"))));
        try {
            state.setExecutionState(RundeckWFExecState.valueOf(StringUtils.upperCase((String)targetNode.valueOf("executionState"))));
        }
        catch (IllegalArgumentException e) {
            state.setExecutionState(null);
        }
    }

    public BaseStateParser() {
    }

    public BaseStateParser(String xpath) {
        this.xpath = xpath;
    }

    @Override
    public BaseState parseXmlNode(Node node) {
        Node targetNode = this.xpath != null ? node.selectSingleNode(this.xpath) : node;
        BaseState baseState = new BaseState();
        BaseStateParser.parseBaseState(targetNode, baseState);
        return baseState;
    }
}

