/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.api.parser;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Node;
import org.rundeck.api.domain.RundeckExecutionState;
import org.rundeck.api.domain.RundeckNode;
import org.rundeck.api.domain.RundeckNodeIdentity;
import org.rundeck.api.domain.WorkflowStepContextState;
import org.rundeck.api.parser.IndexedWorkflowStepStateParser;
import org.rundeck.api.parser.ListParser;
import org.rundeck.api.parser.NodeParser;
import org.rundeck.api.parser.WorkflowStateParser;
import org.rundeck.api.parser.XmlNodeParser;

public class ExecutionStateParser
implements XmlNodeParser<RundeckExecutionState> {
    private String xpath;

    public ExecutionStateParser() {
    }

    public ExecutionStateParser(String xpath) {
        this();
        this.xpath = xpath;
    }

    @Override
    public RundeckExecutionState parseXmlNode(Node node) {
        Node targetNode = this.xpath != null ? node.selectSingleNode(this.xpath) : node;
        RundeckExecutionState rundeckExecutionState = new RundeckExecutionState();
        rundeckExecutionState.setExecutionId(Long.valueOf(targetNode.valueOf("@id")));
        WorkflowStateParser.parseWorkflowState(targetNode, rundeckExecutionState);
        Object rundeckNodes = new ListParser<RundeckNode>(new NodeParser(), "allNodes/nodes/node").parseXmlNode(targetNode);
        rundeckExecutionState.setAllNodes(new HashSet<RundeckNodeIdentity>((Collection<RundeckNodeIdentity>)rundeckNodes));
        HashMap<String, List<WorkflowStepContextState>> nodeStates = new HashMap<String, List<WorkflowStepContextState>>();
        for (Object o : targetNode.selectNodes("nodes/node")) {
            Node nodeStateNode = (Node)o;
            String nodeName = StringUtils.trimToNull((String)nodeStateNode.valueOf("@name"));
            if (null == nodeName) continue;
            ListParser<WorkflowStepContextState> workflowStepStateListParser = new ListParser<WorkflowStepContextState>(new IndexedWorkflowStepStateParser(rundeckExecutionState, nodeName), "steps/step");
            nodeStates.put(nodeName, (List<WorkflowStepContextState>)workflowStepStateListParser.parseXmlNode(nodeStateNode));
        }
        rundeckExecutionState.setNodeStates(nodeStates);
        return rundeckExecutionState;
    }
}

