/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.api.parser;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Node;
import org.rundeck.api.domain.RundeckOutputEntry;
import org.rundeck.api.parser.XmlNodeParser;

public class OutputEntryParser
implements XmlNodeParser<RundeckOutputEntry> {
    private String xpath;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
    static HashSet<String> nonMetaAttributes = new HashSet();

    public OutputEntryParser() {
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public OutputEntryParser(String xpath) {
        this();
        this.xpath = xpath;
    }

    @Override
    public RundeckOutputEntry parseXmlNode(Node node) {
        Node entryNode = this.xpath != null ? node.selectSingleNode(this.xpath) : node;
        RundeckOutputEntry outputEntry = new RundeckOutputEntry();
        outputEntry.setTime(StringUtils.trimToNull((String)entryNode.valueOf("@time")));
        try {
            outputEntry.setLevel(RundeckOutputEntry.RundeckLogLevel.valueOf(StringUtils.upperCase((String)entryNode.valueOf("@level"))));
        }
        catch (IllegalArgumentException e) {
            outputEntry.setLevel(null);
        }
        if (null != entryNode.valueOf("@absolute_time")) {
            outputEntry.setAbsoluteTime(this.parseDate(StringUtils.trimToNull((String)entryNode.valueOf("@absolute_time"))));
        }
        outputEntry.setUser(StringUtils.trimToNull((String)entryNode.valueOf("@user")));
        outputEntry.setNode(StringUtils.trimToNull((String)entryNode.valueOf("@node")));
        outputEntry.setType(StringUtils.trimToNull((String)entryNode.valueOf("@type")));
        HashMap<String, String> meta = new HashMap<String, String>();
        List list = entryNode.selectNodes("@*");
        for (Object node1 : list) {
            Node child;
            if (!(node1 instanceof Node) || nonMetaAttributes.contains((child = (Node)node1).getName())) continue;
            meta.put(child.getName(), child.getText());
        }
        if (meta.size() > 0) {
            outputEntry.setMetadata(meta);
        }
        outputEntry.setMessage(this.parseMessage(entryNode));
        return outputEntry;
    }

    private Date parseDate(String s) {
        if (null == s) {
            return null;
        }
        try {
            Date parse = this.dateFormat.parse(s);
            return parse;
        }
        catch (ParseException e) {
            return null;
        }
    }

    protected String parseMessage(Node entryNode) {
        return StringUtils.trimToNull((String)entryNode.valueOf("@log"));
    }

    static {
        nonMetaAttributes.add("time");
        nonMetaAttributes.add("level");
        nonMetaAttributes.add("user");
        nonMetaAttributes.add("node");
        nonMetaAttributes.add("type");
        nonMetaAttributes.add("log");
        nonMetaAttributes.add("absolute_type");
    }
}

