/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.api.parser;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Node;
import org.rundeck.api.domain.RundeckExecution;
import org.rundeck.api.domain.RundeckOutput;
import org.rundeck.api.domain.RundeckOutputEntry;
import org.rundeck.api.parser.XmlNodeParser;

public class OutputParser
implements XmlNodeParser<RundeckOutput> {
    private String xpath;
    XmlNodeParser<RundeckOutputEntry> parser;

    public OutputParser(String xpath, XmlNodeParser<RundeckOutputEntry> parser) {
        this.xpath = xpath;
        if (null != parser) {
            this.parser = parser;
        }
    }

    @Override
    public RundeckOutput parseXmlNode(Node node) {
        Node entriesListNode;
        Node entryNode = this.xpath != null ? node.selectSingleNode(this.xpath) : node;
        RundeckOutput output = new RundeckOutput();
        try {
            output.setExecutionId(Long.valueOf(entryNode.valueOf("id")));
        }
        catch (NumberFormatException e) {
            output.setExecutionId(null);
        }
        try {
            output.setOffset(Integer.valueOf(entryNode.valueOf("offset")));
        }
        catch (NumberFormatException e) {
            output.setOffset(-1);
        }
        output.setCompleted(Boolean.valueOf(entryNode.valueOf("completed")));
        output.setExecCompleted(Boolean.valueOf(entryNode.valueOf("execCompleted")));
        output.setHasFailedNodes(Boolean.valueOf(entryNode.valueOf("hasFailedNodes")));
        output.setUnmodified(Boolean.valueOf(entryNode.valueOf("unmodified")));
        try {
            output.setStatus(RundeckExecution.ExecutionStatus.valueOf(StringUtils.upperCase((String)entryNode.valueOf("execState"))));
        }
        catch (IllegalArgumentException e) {
            output.setStatus(null);
        }
        try {
            output.setLastModified(Long.valueOf(entryNode.valueOf("lastModified")));
        }
        catch (NumberFormatException e) {
            output.setLastModified(null);
        }
        try {
            output.setExecDuration(Long.valueOf(entryNode.valueOf("execDuration")));
        }
        catch (NumberFormatException e) {
            output.setExecDuration(null);
        }
        try {
            output.setPercentLoaded(Float.valueOf(entryNode.valueOf("percentLoaded")));
        }
        catch (NumberFormatException e) {
            output.setPercentLoaded(null);
        }
        try {
            output.setTotalSize(Integer.valueOf(entryNode.valueOf("totalSize")));
        }
        catch (NumberFormatException e) {
            output.setTotalSize(-1);
        }
        if (entryNode.selectSingleNode("filter") != null) {
            output.setFilterNode(StringUtils.trimToNull((String)entryNode.valueOf("filter/@nodename")));
            output.setFilterStep(StringUtils.trimToNull((String)entryNode.valueOf("filter/@stepctx")));
        }
        if ((entriesListNode = entryNode.selectSingleNode("entries")) != null) {
            List entries = entriesListNode.selectNodes("entry");
            for (Node logEntryNode : entries) {
                RundeckOutputEntry outputEntry = this.parser.parseXmlNode(logEntryNode);
                output.addLogEntry(outputEntry);
            }
        }
        return output;
    }
}

