/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.api.parser;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Node;
import org.rundeck.api.domain.RundeckNode;
import org.rundeck.api.domain.RundeckNodeIdentity;
import org.rundeck.api.domain.WorkflowState;
import org.rundeck.api.domain.WorkflowStepState;
import org.rundeck.api.parser.BaseStateParser;
import org.rundeck.api.parser.ListParser;
import org.rundeck.api.parser.NodeParser;
import org.rundeck.api.parser.WorkflowStepStateParser;
import org.rundeck.api.parser.XmlNodeParser;

public class WorkflowStateParser
implements XmlNodeParser<WorkflowState> {
    private String xpath;
    private static final ThreadLocal<DateFormat> w3cDateFormat = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
            fmt.setTimeZone(TimeZone.getTimeZone("GMT"));
            return fmt;
        }
    };

    public WorkflowStateParser() {
    }

    public WorkflowStateParser(String xpath) {
        this();
        this.xpath = xpath;
    }

    public static Date parseDate(String s) {
        if (null == s) {
            return null;
        }
        try {
            Date parse = w3cDateFormat.get().parse(s);
            return parse;
        }
        catch (ParseException e) {
            return null;
        }
    }

    private static int integerValue(String value, int defValue) {
        int parseMax = defValue;
        try {
            parseMax = null != value ? Integer.parseInt(value) : defValue;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return parseMax;
    }

    @Override
    public WorkflowState parseXmlNode(Node node) {
        Node targetNode = this.xpath != null ? node.selectSingleNode(this.xpath) : node;
        WorkflowState state = new WorkflowState();
        WorkflowStateParser.parseWorkflowState(targetNode, state);
        return state;
    }

    public static void parseWorkflowState(Node targetNode, WorkflowState state) {
        BaseStateParser.parseBaseState(targetNode, state);
        state.setStepCount(WorkflowStateParser.integerValue(StringUtils.trimToNull((String)targetNode.valueOf("stepCount")), 0));
        Object rundeckNodes = new ListParser<RundeckNode>(new NodeParser(), "targetNodes/nodes/node").parseXmlNode(targetNode);
        state.setTargetNodes(new HashSet<RundeckNodeIdentity>((Collection<RundeckNodeIdentity>)rundeckNodes));
        state.setSteps((List<WorkflowStepState>)new ListParser<WorkflowStepState>(new WorkflowStepStateParser(), "steps/step").parseXmlNode(targetNode));
    }
}

