/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.api.parser;

import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Node;
import org.rundeck.api.domain.WorkflowStepContextState;
import org.rundeck.api.domain.WorkflowStepState;
import org.rundeck.api.parser.BaseStateParser;
import org.rundeck.api.parser.WorkflowStateParser;
import org.rundeck.api.parser.WorkflowStepContextStateParser;
import org.rundeck.api.parser.XmlNodeParser;

public class WorkflowStepStateParser
implements XmlNodeParser<WorkflowStepState> {
    private String xpath;

    public WorkflowStepStateParser(String xpath) {
        this.xpath = xpath;
    }

    public WorkflowStepStateParser() {
    }

    @Override
    public WorkflowStepState parseXmlNode(Node node) {
        Node targetNode = this.xpath != null ? node.selectSingleNode(this.xpath) : node;
        WorkflowStepState state = new WorkflowStepState();
        BaseStateParser.parseBaseState(targetNode, state);
        state.setStepContextId(StringUtils.trimToNull((String)targetNode.valueOf("@stepctx")));
        state.setStepNum(Integer.valueOf(targetNode.valueOf("@id")));
        state.setNodeStep(Boolean.valueOf(StringUtils.trimToNull((String)targetNode.valueOf("nodeStep"))));
        if (Boolean.valueOf(StringUtils.trimToNull((String)targetNode.valueOf("hasSubworkflow"))).booleanValue()) {
            state.setSubWorkflow(new WorkflowStateParser("workflow").parseXmlNode(targetNode));
        }
        if (Boolean.valueOf(StringUtils.trimToNull((String)targetNode.valueOf("nodeStep"))).booleanValue()) {
            HashMap<String, WorkflowStepContextState> nodeStates = new HashMap<String, WorkflowStepContextState>();
            for (Object o : targetNode.selectNodes("nodeStates/nodeState")) {
                Node nodeStateNode = (Node)o;
                String nodeName = StringUtils.trimToNull((String)nodeStateNode.valueOf("@name"));
                if (null == nodeName) continue;
                nodeStates.put(nodeName, new WorkflowStepContextStateParser(state).parseXmlNode(nodeStateNode));
            }
            state.setNodeStates(nodeStates);
        }
        return state;
    }
}

