/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.authorization.providers;

import com.dtolabs.rundeck.core.authorization.AclRule;
import com.dtolabs.rundeck.core.authorization.AclRuleSet;
import com.dtolabs.rundeck.core.authorization.AclRuleSetImpl;
import com.dtolabs.rundeck.core.authorization.AclRuleSetSource;
import com.dtolabs.rundeck.core.authorization.Attribute;
import com.dtolabs.rundeck.core.authorization.ValidationSet;
import com.dtolabs.rundeck.core.authorization.providers.PoliciesCache;
import com.dtolabs.rundeck.core.authorization.providers.PolicyCollection;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Policies
implements AclRuleSetSource {
    private Iterable<PolicyCollection> cache;
    private ValidationSet validation;

    public Policies(Iterable<PolicyCollection> cache, ValidationSet validationSet) {
        this.validation = validationSet;
        this.cache = cache;
    }

    public Policies(Iterable<PolicyCollection> cache) {
        this(cache, null);
    }

    public int count() {
        int count = 0;
        for (PolicyCollection f : this.cache) {
            count = (int)((long)count + f.countPolicies());
        }
        return count;
    }

    @Override
    public AclRuleSet getRuleSet() {
        HashSet<AclRule> set = new HashSet<AclRule>();
        for (PolicyCollection f : this.cache) {
            set.addAll(f.getRuleSet().getRules());
        }
        return new AclRuleSetImpl(set);
    }

    public static Policies load(File rootPath) {
        return new Policies(PoliciesCache.fromDir(rootPath));
    }

    public static Policies load(File rootPath, Set<Attribute> forcedContext) {
        return new Policies(PoliciesCache.fromDir(rootPath, forcedContext));
    }

    public static Policies loadFile(File singleFile) {
        return new Policies(PoliciesCache.fromFile(singleFile));
    }

    @Deprecated
    public List<String> listAllRoles() {
        ArrayList<String> results = new ArrayList<String>();
        for (PolicyCollection f : this.cache) {
            results.addAll(f.groupNames());
        }
        return results;
    }
}

