/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.plugins;

import com.dtolabs.rundeck.core.common.ProviderService;
import com.dtolabs.rundeck.core.execution.service.ExecutionServiceException;
import com.dtolabs.rundeck.core.plugins.CloseableProvider;
import com.dtolabs.rundeck.core.plugins.Closeables;
import com.dtolabs.rundeck.core.plugins.ProviderIdent;
import com.dtolabs.rundeck.core.utils.Converter;
import java.util.List;

public class AdapterService<S, T>
implements ProviderService<T> {
    private ProviderService<S> sourceService;
    private Converter<S, T> converter;

    public AdapterService(ProviderService<S> sourceService, Converter<S, T> converter) {
        this.sourceService = sourceService;
        this.converter = converter;
    }

    @Override
    public T providerOfType(String providerName) throws ExecutionServiceException {
        return this.converter.convert(this.sourceService.providerOfType(providerName));
    }

    @Override
    public CloseableProvider<T> closeableProviderOfType(String providerName) throws ExecutionServiceException {
        T t = this.providerOfType(providerName);
        if (null == t) {
            return null;
        }
        return Closeables.closeableProvider(t);
    }

    @Override
    public List<ProviderIdent> listProviders() {
        return this.sourceService.listProviders();
    }

    @Override
    public String getName() {
        return this.sourceService.getName();
    }

    public ProviderService<S> getSourceService() {
        return this.sourceService;
    }

    public Converter<S, T> getConverter() {
        return this.converter;
    }

    public static <X, Y> AdapterService<X, Y> adaptFor(ProviderService<X> sourceService, Converter<X, Y> converter) {
        return new AdapterService<X, Y>(sourceService, converter);
    }
}

