/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.common;

import com.dtolabs.rundeck.core.Constants;
import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.IFilesystemFramework;
import com.dtolabs.rundeck.core.common.IFramework;
import com.dtolabs.rundeck.core.common.PropertyRetriever;
import com.dtolabs.rundeck.core.utils.IPropertyLookup;
import com.dtolabs.rundeck.core.utils.PropertyLookup;
import java.io.File;

public class FilesystemFramework
implements IFilesystemFramework {
    public static final String FRAMEWORK_LIBEXT_DIR = "framework.libext.dir";
    public static final String FRAMEWORK_LIBEXT_CACHE_DIR = "framework.libext.cache.dir";
    public static final String DEFAULT_LIBEXT_DIR_NAME = "libext";
    public static final String DEFAULT_LIBEXT_CACHE_DIR_NAME = "cache";
    public static final String SYSTEM_PROP_LIBEXT = "rdeck.libext";
    public static final String SYSTEM_PROP_LIBEXT_CACHE = "rdeck.libext.cache";
    private File baseDir;
    private File projectsBase;
    private Framework framework;

    public FilesystemFramework(File baseDir, File projectsDir) {
        this.baseDir = baseDir;
        this.projectsBase = projectsDir;
    }

    public static String getProjectsBaseDir(File baseDir) {
        return baseDir + Constants.FILE_SEP + "projects";
    }

    @Override
    public File getConfigDir() {
        return new File(Constants.getFrameworkConfigDir(this.getBaseDir().getAbsolutePath()));
    }

    public static File getConfigDir(File baseDir) {
        return new File(Constants.getFrameworkConfigDir(baseDir.getAbsolutePath()));
    }

    public static FilesystemFramework getInstanceWithoutProjectsDir(String rdeck_base_dir) {
        File baseDir = new File(rdeck_base_dir);
        File propertyFile = FilesystemFramework.getPropertyFile(FilesystemFramework.getConfigDir(baseDir));
        String projectsDir = null;
        if (propertyFile.exists()) {
            PropertyRetriever propertyRetriever = FilesystemFramework.createPropertyRetriever(baseDir);
            projectsDir = propertyRetriever.getProperty("framework.projects.dir");
        }
        return new FilesystemFramework(new File(rdeck_base_dir), new File(projectsDir));
    }

    @Override
    public File getFrameworkProjectsBaseDir() {
        return this.projectsBase;
    }

    @Override
    public File getLibextDir(IFramework fwk) {
        if (null != System.getProperty(SYSTEM_PROP_LIBEXT)) {
            return new File(System.getProperty(SYSTEM_PROP_LIBEXT));
        }
        if (fwk.getPropertyLookup().hasProperty(FRAMEWORK_LIBEXT_DIR)) {
            return new File(fwk.getPropertyLookup().getProperty(FRAMEWORK_LIBEXT_DIR));
        }
        return new File(this.getBaseDir(), DEFAULT_LIBEXT_DIR_NAME);
    }

    @Override
    public File getLibextDir() {
        if (null != System.getProperty(SYSTEM_PROP_LIBEXT)) {
            return new File(System.getProperty(SYSTEM_PROP_LIBEXT));
        }
        return new File(this.getBaseDir(), DEFAULT_LIBEXT_DIR_NAME);
    }

    @Override
    public File getLibextCacheDir() {
        if (null != System.getProperty(SYSTEM_PROP_LIBEXT_CACHE)) {
            return new File(System.getProperty(SYSTEM_PROP_LIBEXT_CACHE));
        }
        return new File(this.getLibextDir(), DEFAULT_LIBEXT_CACHE_DIR_NAME);
    }

    @Override
    public File getLibextCacheDir(IFramework fwk) {
        if (null != System.getProperty(SYSTEM_PROP_LIBEXT_CACHE)) {
            return new File(System.getProperty(SYSTEM_PROP_LIBEXT_CACHE));
        }
        if (fwk.getPropertyLookup().hasProperty(FRAMEWORK_LIBEXT_CACHE_DIR)) {
            return new File(fwk.getPropertyLookup().getProperty(FRAMEWORK_LIBEXT_CACHE_DIR));
        }
        return new File(this.getLibextDir(fwk), DEFAULT_LIBEXT_CACHE_DIR_NAME);
    }

    public static File getPropertyFile(File configDir) {
        return new File(configDir, "framework.properties");
    }

    public static PropertyRetriever createPropertyRetriever(File baseDir) {
        return FilesystemFramework.createPropertyLookupFromBasedir(baseDir).expand().safe();
    }

    public static PropertyLookup createPropertyLookupFromBasedir(File baseDir) {
        return PropertyLookup.create(FilesystemFramework.getPropertyFile(FilesystemFramework.getConfigDir(baseDir)));
    }

    @Override
    public IPropertyLookup getPropertyLookup() {
        return FilesystemFramework.createPropertyLookupFromBasedir(this.baseDir);
    }

    @Override
    public File getBaseDir() {
        return this.baseDir;
    }

    public void setBaseDir(File baseDir) {
        this.baseDir = baseDir;
    }

    public Framework getFramework() {
        return this.framework;
    }

    public void setFramework(Framework framework) {
        this.framework = framework;
    }
}

