/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.common;

import com.dtolabs.rundeck.core.common.AdditiveListNodeSet;
import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.INodeSet;
import com.dtolabs.rundeck.core.common.IProjectNodes;
import com.dtolabs.rundeck.core.common.IRundeckProject;
import com.dtolabs.rundeck.core.common.IRundeckProjectConfig;
import com.dtolabs.rundeck.core.common.MergedAttributesNodeSet;
import com.dtolabs.rundeck.core.common.NodeSetMerge;
import com.dtolabs.rundeck.core.execution.service.ExecutionServiceException;
import com.dtolabs.rundeck.core.plugins.CloseableProvider;
import com.dtolabs.rundeck.core.plugins.Closeables;
import com.dtolabs.rundeck.core.resources.ExceptionCatchingResourceModelSource;
import com.dtolabs.rundeck.core.resources.FileResourceModelSource;
import com.dtolabs.rundeck.core.resources.FileResourceModelSourceCache;
import com.dtolabs.rundeck.core.resources.LoggingResourceModelSourceCache;
import com.dtolabs.rundeck.core.resources.ResourceModelSource;
import com.dtolabs.rundeck.core.resources.ResourceModelSourceCache;
import com.dtolabs.rundeck.core.resources.ResourceModelSourceErrors;
import com.dtolabs.rundeck.core.resources.ResourceModelSourceException;
import com.dtolabs.rundeck.core.resources.ResourceModelSourceService;
import com.dtolabs.rundeck.core.resources.SourceFactory;
import com.dtolabs.rundeck.core.resources.SourceType;
import com.dtolabs.rundeck.core.resources.WriteableModelSource;
import com.dtolabs.rundeck.core.resources.format.ResourceFormatGenerator;
import com.dtolabs.rundeck.core.resources.format.ResourceFormatGeneratorService;
import com.dtolabs.rundeck.core.resources.format.UnsupportedFormatException;
import com.dtolabs.rundeck.core.utils.TextUtils;
import java.beans.ConstructorProperties;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;

public class ProjectNodeSupport
implements IProjectNodes,
Closeable {
    private static final Logger logger = Logger.getLogger(ProjectNodeSupport.class);
    public static final String NODES_XML = "resources.xml";
    public static final String PROJECT_RESOURCES_URL_PROPERTY = "project.resources.url";
    public static final String PROJECT_RESOURCES_FILE_PROPERTY = "project.resources.file";
    public static final String PROJECT_RESOURCES_FILEFORMAT_PROPERTY = "project.resources.file.format";
    public static final String RESOURCES_SOURCE_PROP_PREFIX = "resources.source";
    public static final String PROJECT_RESOURCES_MERGE_NODE_ATTRIBUTES = "project.resources.mergeNodeAttributes";
    public static final String PROJECT_RESOURCES_ALLOWED_URL_PREFIX = "project.resources.allowedURL.";
    public static final String FRAMEWORK_RESOURCES_ALLOWED_URL_PREFIX = "framework.resources.allowedURL.";
    private IRundeckProjectConfig projectConfig;
    private Map<String, Exception> nodesSourceExceptions;
    private long nodesSourcesLastReload = -1L;
    private List<LoadedResourceModelSource> nodesSourceList;
    private Set<Closeable> nodeSourceReferences = new HashSet<Closeable>();
    private ResourceFormatGeneratorService resourceFormatGeneratorService;
    private ResourceModelSourceService resourceModelSourceService;
    private boolean sourcesOpened;
    static Set<String> uncachedResourceTypes = new HashSet<String>();

    public ProjectNodeSupport(IRundeckProjectConfig projectConfig, ResourceFormatGeneratorService resourceFormatGeneratorService, ResourceModelSourceService resourceModelSourceService) {
        this.projectConfig = projectConfig;
        this.resourceFormatGeneratorService = resourceFormatGeneratorService;
        this.resourceModelSourceService = resourceModelSourceService;
        this.nodesSourceExceptions = Collections.synchronizedMap(new HashMap());
    }

    private boolean shouldCacheForType(String type) {
        return !uncachedResourceTypes.contains(type);
    }

    private NodeSetMerge getNodeSetMerge() {
        if (this.projectConfig.hasProperty(PROJECT_RESOURCES_MERGE_NODE_ATTRIBUTES) && "false".equals(this.projectConfig.getProperty(PROJECT_RESOURCES_MERGE_NODE_ATTRIBUTES))) {
            return new AdditiveListNodeSet();
        }
        return new MergedAttributesNodeSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public INodeSet getNodeSet() {
        NodeSetMerge list = this.getNodeSetMerge();
        Map<String, ResourceModelSourceException> exceptions = Collections.synchronizedMap(new HashMap());
        int index = 1;
        HashSet<String> validSources = new HashSet<String>();
        for (ResourceModelSource resourceModelSource : this.getResourceModelSourcesInternal()) {
            try {
                ResourceModelSourceErrors nodeerrors;
                List<String> modelSourceErrors;
                INodeSet nodes = resourceModelSource.getNodes();
                if (null == nodes) {
                    logger.warn((Object)("Empty nodes result from [" + resourceModelSource.toString() + "]"));
                } else {
                    list.addNodeSet(nodes);
                }
                boolean hasErrors = false;
                if (resourceModelSource instanceof ResourceModelSourceErrors && (modelSourceErrors = (nodeerrors = (ResourceModelSourceErrors)((Object)resourceModelSource)).getModelSourceErrors()) != null && modelSourceErrors.size() > 0) {
                    hasErrors = true;
                    logger.error((Object)("Some errors getting nodes from [" + resourceModelSource.toString() + "]: " + modelSourceErrors));
                    exceptions.put(index + ".source", new ResourceModelSourceException(TextUtils.join(modelSourceErrors.toArray(new String[modelSourceErrors.size()]), ';')));
                }
                if (!hasErrors) {
                    validSources.add(index + ".source");
                }
            }
            catch (ResourceModelSourceException | RuntimeException e) {
                logger.error((Object)("Cannot get nodes from [" + resourceModelSource.toString() + "]: " + e.getMessage()));
                logger.debug((Object)("Cannot get nodes from [" + resourceModelSource.toString() + "]: " + e.getMessage()), (Throwable)e);
                exceptions.put(index + ".source", new ResourceModelSourceException(e.getMessage(), e));
            }
            catch (Throwable e) {
                logger.error((Object)("Cannot get nodes from [" + resourceModelSource.toString() + "]: " + e.getMessage()));
                logger.debug((Object)("Cannot get nodes from [" + resourceModelSource.toString() + "]: " + e.getMessage()), e);
                exceptions.put(index + ".source", new ResourceModelSourceException(e.getMessage()));
            }
            ++index;
        }
        Map<String, Exception> map = this.nodesSourceExceptions;
        synchronized (map) {
            this.nodesSourceExceptions.putAll(exceptions);
            for (String validSource : validSources) {
                this.nodesSourceExceptions.remove(validSource);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<Exception> getResourceModelSourceExceptions() {
        Map<String, Exception> map = this.nodesSourceExceptions;
        synchronized (map) {
            return new ArrayList<Exception>(this.nodesSourceExceptions.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Exception> getResourceModelSourceExceptionsMap() {
        Map<String, Exception> map = this.nodesSourceExceptions;
        synchronized (map) {
            return Collections.unmodifiableMap(this.nodesSourceExceptions);
        }
    }

    @Override
    public List<IProjectNodes.ReadableProjectNodes> getResourceModelSources() {
        List<LoadedResourceModelSource> resourceModelSources = this.getResourceModelSourcesInternal();
        return resourceModelSources.stream().map(i -> i).collect(Collectors.toList());
    }

    private synchronized List<LoadedResourceModelSource> getResourceModelSourcesInternal() {
        long lastMod;
        long l = lastMod = this.projectConfig.getConfigLastModifiedTime() != null ? this.projectConfig.getConfigLastModifiedTime().getTime() : 0L;
        if (lastMod > this.nodesSourcesLastReload) {
            this.unloadSources();
        }
        if (!this.sourcesOpened) {
            this.loadResourceModelSources();
            this.sourcesOpened = true;
        }
        return this.nodesSourceList;
    }

    @Override
    public Collection<IProjectNodes.WriteableProjectNodes> getWriteableResourceModelSources() {
        List<LoadedResourceModelSource> resourceModelSources = this.getResourceModelSourcesInternal();
        return resourceModelSources.stream().filter(i -> i.getSourceType() == SourceType.READ_WRITE).map(i -> new ProjectWriteableNodes(i.getWriteable(), i.getIndex(), i.getType())).collect(Collectors.toList());
    }

    @Override
    public void close() throws IOException {
        this.unloadSources();
    }

    private synchronized void unloadSources() {
        this.nodesSourceList = new ArrayList<LoadedResourceModelSource>();
        Closeables.closeQuietly(this.nodeSourceReferences);
        this.nodeSourceReferences = new HashSet<Closeable>();
        this.sourcesOpened = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadResourceModelSources() {
        Map<String, ExecutionServiceException> exceptions = Collections.synchronizedMap(new HashMap());
        HashSet<String> validSources = new HashSet<String>();
        if (this.projectConfig.hasProperty(PROJECT_RESOURCES_FILE_PROPERTY)) {
            logger.error((Object)"Project config: project.resources.file is no longer supported.");
        }
        if (this.projectConfig.hasProperty(PROJECT_RESOURCES_URL_PROPERTY)) {
            logger.error((Object)"Project config: project.resources.url is no longer supported.");
        }
        String name = this.projectConfig.getName();
        List<Map<String, Object>> list = this.listResourceModelConfigurations();
        int i = 1;
        for (Map<String, Object> map : list) {
            String providerType = (String)map.get("type");
            Properties props = (Properties)map.get("props");
            logger.info((Object)("Source #" + i + " (" + providerType + "): loading with properties: " + props));
            try {
                this.nodesSourceList.add(this.loadResourceModelSource(providerType, props, this.shouldCacheForType(providerType), i + ".source", i));
                validSources.add(i + ".source");
            }
            catch (ExecutionServiceException e) {
                logger.error((Object)String.format("Failed loading resource model source #%d in project %s, skipping: %s", i, name, e.getMessage()), (Throwable)e);
                exceptions.put(i + ".source", e);
            }
            ++i;
        }
        Map<String, Exception> map = this.nodesSourceExceptions;
        synchronized (map) {
            this.nodesSourceExceptions.putAll(exceptions);
            for (String validSource : validSources) {
                this.nodesSourceExceptions.remove(validSource);
            }
        }
        Date configLastModifiedTime = this.projectConfig.getConfigLastModifiedTime();
        this.nodesSourcesLastReload = configLastModifiedTime != null ? configLastModifiedTime.getTime() : -1L;
    }

    private File getResourceModelSourceFileCacheForType(String ident) {
        String varDir = this.projectConfig.getProperty("framework.var.dir");
        File file = new File(varDir, "resourceModelSourceCache/" + this.projectConfig.getName() + "/" + ident + ".xml");
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            logger.warn((Object)"Failed to create cache dirs for source file cache");
        }
        return file;
    }

    public static ResourceModelSource asModelSource(IProjectNodes nodes) {
        return new ProjectNodesSource(nodes);
    }

    private ResourceModelSource createCachingSource(ResourceModelSource origin, String ident, String descr) {
        return this.createCachingSource(origin, ident, descr, SourceFactory.CacheType.BOTH, true);
    }

    public ResourceModelSource createCachingSource(ResourceModelSource origin, String ident, String descr, SourceFactory.CacheType type, boolean logging) {
        File file = this.getResourceModelSourceFileCacheForType(ident);
        ResourceModelSourceService nodesSourceService = this.getResourceModelSourceService();
        ResourceFormatGeneratorService resourceFormatGeneratorService = this.getResourceFormatGeneratorService();
        Properties fileSourceConfig = this.generateFileSourceConfigurationProperties(file.getAbsolutePath(), "resourcexml", false, false);
        try {
            ResourceModelSource fileSource = nodesSourceService.getSourceForConfiguration("file", fileSourceConfig);
            ResourceFormatGenerator generatorForFormat = resourceFormatGeneratorService.getGeneratorForFormat("resourcexml");
            String ident1 = "[ResourceModelSource: " + descr + ", project: " + this.projectConfig.getName() + "]";
            StoreExceptionHandler handler = new StoreExceptionHandler(ident);
            ResourceModelSourceCache cache = new FileResourceModelSourceCache(file, generatorForFormat, fileSource);
            if (logging) {
                cache = new LoggingResourceModelSourceCache(cache, ident1);
            }
            return SourceFactory.cachedSource(origin, ident1, handler, cache, type);
        }
        catch (ExecutionServiceException | UnsupportedFormatException e) {
            e.printStackTrace();
            return null;
        }
    }

    private ResourceFormatGeneratorService getResourceFormatGeneratorService() {
        return this.resourceFormatGeneratorService;
    }

    private ResourceModelSourceService getResourceModelSourceService() {
        return this.resourceModelSourceService;
    }

    private LoadedResourceModelSource loadResourceModelSource(String type, Properties configuration, boolean useCache, String ident, int index) throws ExecutionServiceException {
        ResourceModelSourceService nodesSourceService = this.getResourceModelSourceService();
        configuration.put("project", this.projectConfig.getName());
        CloseableProvider<ResourceModelSource> sourceForConfiguration = nodesSourceService.getCloseableSourceForConfiguration(type, configuration);
        this.nodeSourceReferences.add(sourceForConfiguration);
        if (useCache) {
            return new LoadedSource(index, type, this.createCachingSource(sourceForConfiguration.getProvider(), ident, ident + " (" + type + ")"));
        }
        return new LoadedSource(index, type, sourceForConfiguration.getProvider());
    }

    private Properties generateFileSourceConfigurationProperties(String filepath, String format, boolean generate, boolean includeServerNode) {
        FileResourceModelSource.Configuration build = FileResourceModelSource.Configuration.build();
        build.file(filepath);
        if (null != format) {
            build.format(format);
        }
        build.project(this.projectConfig.getName());
        build.generateFileAutomatically(generate);
        build.includeServerNode(includeServerNode);
        return build.getProperties();
    }

    private Properties createFileSourceConfiguration() {
        String format = null;
        if (this.projectConfig.hasProperty(PROJECT_RESOURCES_FILEFORMAT_PROPERTY)) {
            format = this.projectConfig.getProperty(PROJECT_RESOURCES_FILEFORMAT_PROPERTY);
        }
        return this.generateFileSourceConfigurationProperties(this.projectConfig.getProperty(PROJECT_RESOURCES_FILE_PROPERTY), format, true, true);
    }

    @Override
    public synchronized List<Map<String, Object>> listResourceModelConfigurations() {
        Map<String, String> propertiesMap = this.projectConfig.getProperties();
        Properties properties = new Properties();
        properties.putAll(propertiesMap);
        return ProjectNodeSupport.listResourceModelConfigurations(properties);
    }

    public static Properties serializeResourceModelConfigurations(List<Map<String, Object>> configs) {
        Properties projProps = new Properties();
        int count = 1;
        for (Map<String, Object> config : configs) {
            String prefix = "resources.source." + count + ".";
            String type = config.get("type").toString();
            Properties props = (Properties)config.get("props");
            projProps.setProperty(prefix + "type", type);
            for (String k : props.stringPropertyNames()) {
                String v = props.getProperty(k);
                projProps.setProperty(prefix + "config." + k, v);
            }
            ++count;
        }
        return projProps;
    }

    public static List<Map<String, Object>> listResourceModelConfigurations(Properties props) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        int i = 1;
        boolean done = false;
        while (!done) {
            String prefix = "resources.source." + i;
            if (props.containsKey(prefix + ".type")) {
                String providerType = props.getProperty(prefix + ".type");
                Properties configProps = new Properties();
                int len = (prefix + ".config.").length();
                for (Object o : props.keySet()) {
                    String key = (String)o;
                    if (!key.startsWith(prefix + ".config.")) continue;
                    configProps.setProperty(key.substring(len), props.getProperty(key));
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("type", providerType);
                map.put("props", configProps);
                list.add(map);
            } else {
                done = true;
            }
            ++i;
        }
        return list;
    }

    public static String getNodesResourceFilePath(IRundeckProject project, Framework framework) {
        if (project.hasProperty(PROJECT_RESOURCES_FILE_PROPERTY)) {
            return new File(project.getProperty(PROJECT_RESOURCES_FILE_PROPERTY)).getAbsolutePath();
        }
        if (null != framework) {
            File etcDir = new File(framework.getFrameworkProjectsBaseDir(), project.getName() + "/etc/");
            if (framework.hasProperty("framework.nodes.file.name")) {
                return new File(etcDir, framework.getProperty("framework.nodes.file.name")).getAbsolutePath();
            }
            return new File(etcDir, NODES_XML).getAbsolutePath();
        }
        return null;
    }

    public IRundeckProjectConfig getProjectConfig() {
        return this.projectConfig;
    }

    static {
        uncachedResourceTypes.add("file");
        uncachedResourceTypes.add("directory");
    }

    static class LoadedSource
    implements LoadedResourceModelSource {
        final int index;
        final String type;
        final ResourceModelSource source;

        @ConstructorProperties(value={"index", "type", "source"})
        public LoadedSource(int index, String type, ResourceModelSource source) {
            this.index = index;
            this.type = type;
            this.source = source;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public ResourceModelSource getSource() {
            return this.source;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LoadedSource)) {
                return false;
            }
            LoadedSource other = (LoadedSource)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getIndex() != other.getIndex()) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            ResourceModelSource this$source = this.getSource();
            ResourceModelSource other$source = other.getSource();
            return !(this$source == null ? other$source != null : !this$source.equals(other$source));
        }

        protected boolean canEqual(Object other) {
            return other instanceof LoadedSource;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getIndex();
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            ResourceModelSource $source = this.getSource();
            result = result * 59 + ($source == null ? 43 : $source.hashCode());
            return result;
        }

        public String toString() {
            return "ProjectNodeSupport.LoadedSource(index=" + this.getIndex() + ", type=" + this.getType() + ", source=" + this.getSource() + ")";
        }

        @Override
        public INodeSet getNodes() throws ResourceModelSourceException {
            return this.getSource().getNodes();
        }

        @Override
        public SourceType getSourceType() {
            return this.getSource().getSourceType();
        }

        @Override
        public WriteableModelSource getWriteable() {
            return this.getSource().getWriteable();
        }
    }

    static interface LoadedResourceModelSource
    extends ResourceModelSource,
    IProjectNodes.ReadableProjectNodes {
        @Override
        public int getIndex();

        @Override
        public String getType();
    }

    private static class ProjectNodesSource
    implements ResourceModelSource {
        IProjectNodes nodes;

        public ProjectNodesSource(IProjectNodes nodes) {
            this.nodes = nodes;
        }

        @Override
        public INodeSet getNodes() throws ResourceModelSourceException {
            return this.nodes.getNodeSet();
        }
    }

    class StoreExceptionHandler
    implements ExceptionCatchingResourceModelSource.ExceptionHandler {
        String sourceIdent;

        public StoreExceptionHandler(String sourceIdent) {
            this.sourceIdent = sourceIdent;
        }

        @Override
        public void handleException(Exception t, ResourceModelSource origin) {
            ProjectNodeSupport.this.nodesSourceExceptions.put(this.sourceIdent, t);
        }
    }

    public static final class ProjectWriteableNodes
    implements IProjectNodes.WriteableProjectNodes {
        final WriteableModelSource writeableSource;
        final int index;
        final String type;

        @Override
        public WriteableModelSource getWriteableSource() {
            return this.writeableSource;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public String getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProjectWriteableNodes)) {
                return false;
            }
            ProjectWriteableNodes other = (ProjectWriteableNodes)o;
            WriteableModelSource this$writeableSource = this.getWriteableSource();
            WriteableModelSource other$writeableSource = other.getWriteableSource();
            if (this$writeableSource == null ? other$writeableSource != null : !this$writeableSource.equals(other$writeableSource)) {
                return false;
            }
            if (this.getIndex() != other.getIndex()) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WriteableModelSource $writeableSource = this.getWriteableSource();
            result = result * 59 + ($writeableSource == null ? 43 : $writeableSource.hashCode());
            result = result * 59 + this.getIndex();
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public String toString() {
            return "ProjectNodeSupport.ProjectWriteableNodes(writeableSource=" + this.getWriteableSource() + ", index=" + this.getIndex() + ", type=" + this.getType() + ")";
        }

        @ConstructorProperties(value={"writeableSource", "index", "type"})
        public ProjectWriteableNodes(WriteableModelSource writeableSource, int index, String type) {
            this.writeableSource = writeableSource;
            this.index = index;
            this.type = type;
        }
    }
}

