/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.rules;

import com.dtolabs.rundeck.core.rules.StateObj;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public interface WorkflowSystem {
    public <D, T extends OperationCompleted<D>, X extends Operation<D, T>> Set<OperationResult<D, T, X>> processOperations(Set<X> var1, SharedData<D> var2);

    public boolean isInterrupted();

    public static interface Operation<X, T extends OperationCompleted>
    extends Function<X, T> {
        public boolean shouldRun(StateObj var1);

        public boolean shouldSkip(StateObj var1);

        public StateObj getSkipState(StateObj var1);

        public StateObj getFailureState(Throwable var1);
    }

    public static interface OperationCompleted<T> {
        public StateObj getNewState();

        public T getResult();
    }

    public static interface SharedData<T> {
        public void addData(T var1);

        public T produceNext();

        public static <T> SharedData<T> with(final Consumer<T> adder, final Supplier<T> producer) {
            return new SharedData<T>(){

                @Override
                public void addData(T item) {
                    adder.accept(item);
                }

                @Override
                public T produceNext() {
                    return producer.get();
                }
            };
        }
    }

    public static interface OperationResult<D, T extends OperationCompleted<D>, X extends Operation<D, T>> {
        public Throwable getFailure();

        public T getSuccess();

        public X getOperation();
    }
}

