/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.rules;

import com.dtolabs.rundeck.core.data.DataContext;
import com.dtolabs.rundeck.core.dispatcher.ContextView;
import com.dtolabs.rundeck.core.execution.workflow.WFSharedContext;
import com.dtolabs.rundeck.core.rules.Rules;
import com.dtolabs.rundeck.core.rules.StateObj;
import com.dtolabs.rundeck.core.rules.WorkflowEngine;
import com.dtolabs.rundeck.core.rules.WorkflowSystem;
import com.dtolabs.rundeck.core.rules.WorkflowSystemEventType;
import com.dtolabs.rundeck.core.rules.Workflows;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Consumer;
import java.util.stream.Collectors;

class WorkflowEngineOperationsProcessor<DAT, RES extends WorkflowSystem.OperationCompleted<DAT>, OP extends WorkflowSystem.Operation<DAT, RES>> {
    private WorkflowEngine workflowEngine;
    private final Set<OP> operations;
    private final WorkflowSystem.SharedData<DAT> sharedData;
    private final Set<WorkflowSystem.Operation> inProcess = Collections.synchronizedSet(new HashSet());
    private final Set<WorkflowSystem.Operation> skipped = new HashSet<WorkflowSystem.Operation>();
    private final Set<OP> pending;
    private volatile boolean interrupted;
    private final ListeningExecutorService executorService;
    private final ListeningExecutorService manager;
    private final LinkedBlockingQueue<WorkflowSystem.OperationCompleted<DAT>> stateChangeQueue = new LinkedBlockingQueue();
    private final Set<WorkflowSystem.OperationResult<DAT, RES, OP>> results = Collections.synchronizedSet(new HashSet());
    private final List<ListenableFuture<RES>> futures = new ArrayList<ListenableFuture<RES>>();
    private WorkflowEngine.Sleeper sleeper = new WorkflowEngine.Sleeper();

    public WorkflowEngineOperationsProcessor(WorkflowEngine workflowEngine, Set<OP> operations, WorkflowSystem.SharedData<DAT> sharedData, ListeningExecutorService executorService, ListeningExecutorService manager) {
        this.workflowEngine = workflowEngine;
        this.operations = operations;
        this.sharedData = sharedData;
        this.pending = new HashSet<OP>(operations);
        this.executorService = executorService;
        this.manager = manager;
    }

    public void beginProcessing() {
        this.workflowEngine.event(WorkflowSystemEventType.Begin, "Workflow begin");
        this.initialize();
        this.continueProcessing();
    }

    private void continueProcessing() {
        try {
            while (!Thread.currentThread().isInterrupted()) {
                HashMap<String, String> changes = new HashMap<String, String>();
                this.getAvailableChanges(changes);
                if (changes.isEmpty()) {
                    if (this.inProcess.isEmpty()) {
                        this.workflowEngine.event(WorkflowSystemEventType.EndOfChanges, "No more state changes expected, finishing workflow.");
                        return;
                    }
                    if (Thread.currentThread().isInterrupted()) break;
                    this.waitForChanges(changes);
                }
                if (changes.isEmpty()) continue;
                this.getContextGlobalData(changes);
                this.processStateChanges(changes);
                if (this.workflowEngine.isWorkflowEndState(this.workflowEngine.getState())) {
                    this.workflowEngine.event(WorkflowSystemEventType.WorkflowEndState, "Workflow end state reached.");
                    return;
                }
                this.processOperations(this.results::add);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (Thread.currentThread().isInterrupted()) {
            this.workflowEngine.event(WorkflowSystemEventType.Interrupted, "Engine interrupted, stopping engine...");
            this.cancelFutures();
            this.interrupted = Thread.interrupted();
        }
        this.awaitFutures();
    }

    private void getAvailableChanges(Map<String, String> changes) {
        WorkflowSystem.OperationCompleted<DAT> task = this.stateChangeQueue.poll();
        while (task != null && task.getNewState() != null) {
            changes.putAll(task.getNewState().getState());
            DAT result = task.getResult();
            if (null != this.sharedData && null != result) {
                this.sharedData.addData(result);
            }
            task = this.stateChangeQueue.poll();
        }
    }

    private void getContextGlobalData(Map<String, String> changes) {
        DataContext globals;
        Object inputData;
        Object v0 = inputData = null != this.sharedData ? this.sharedData.produceNext() : null;
        if (inputData != null && inputData instanceof WFSharedContext && null != (globals = (DataContext)((WFSharedContext)inputData).getData().get(ContextView.global()))) {
            HashMap stringStringHashMap = new HashMap();
            for (String s : globals.keySet()) {
                Map map = (Map)globals.get(s);
                for (String key : map.keySet()) {
                    if (this.workflowEngine.getState().getState().containsKey(s + "." + key) && this.workflowEngine.getState().getState().get(s + "." + key).equals(map.get(key))) continue;
                    stringStringHashMap.put(s + "." + key, map.get(key));
                }
            }
            changes.putAll(stringStringHashMap);
        }
    }

    private void awaitFutures() {
        if (!this.inProcess.isEmpty()) {
            for (ListenableFuture<RES> future : this.futures) {
                try {
                    future.get();
                }
                catch (InterruptedException | CancellationException | ExecutionException exception) {}
            }
        }
    }

    private void cancelFutures() {
        this.futures.forEach(future -> future.cancel(true));
    }

    public void initialize() {
        this.stateChangeQueue.add(WorkflowEngine.dummyResult(Workflows.getWorkflowStartState()));
    }

    private void processRunnableOperations(final Consumer<WorkflowSystem.OperationResult<DAT, RES, OP>> resultConsumer, List<OP> shouldrun, List<OP> shouldskip, DAT inputData) {
        for (final WorkflowSystem.Operation operation : shouldrun) {
            if (shouldskip.contains(operation)) continue;
            this.pending.remove(operation);
            this.workflowEngine.event(WorkflowSystemEventType.WillRunOperation, String.format("operation starting: %s", operation), operation);
            ListenableFuture submit = this.executorService.submit(() -> (WorkflowSystem.OperationCompleted)operation.apply(inputData));
            this.inProcess.add(operation);
            this.futures.add(submit);
            FutureCallback callback = new FutureCallback<RES>(){

                public void onSuccess(RES successResult) {
                    WorkflowEngineOperationsProcessor.this.workflowEngine.event(WorkflowSystemEventType.OperationSuccess, String.format("operation succeeded: %s", successResult), successResult);
                    assert (successResult != null);
                    WorkflowSystem.OperationResult result = WorkflowEngineOperationsProcessor.this.result(successResult, operation);
                    resultConsumer.accept(result);
                    WorkflowEngineOperationsProcessor.this.stateChangeQueue.add(successResult);
                    WorkflowEngineOperationsProcessor.this.inProcess.remove(operation);
                }

                public void onFailure(Throwable t) {
                    WorkflowEngineOperationsProcessor.this.workflowEngine.event(WorkflowSystemEventType.OperationFailed, String.format("operation failed: %s", t), t);
                    WorkflowSystem.OperationResult result = WorkflowEngineOperationsProcessor.this.result((WorkflowSystem.OperationCompleted)((Object)t), (WorkflowSystem.Operation)operation);
                    resultConsumer.accept(result);
                    StateObj newFailureState = operation.getFailureState(t);
                    if (null != newFailureState && newFailureState.getState().size() > 0) {
                        WorkflowSystem.OperationCompleted objectOperationCompleted = WorkflowEngine.dummyResult(newFailureState);
                        WorkflowEngineOperationsProcessor.this.stateChangeQueue.add(objectOperationCompleted);
                    }
                    WorkflowEngineOperationsProcessor.this.inProcess.remove(operation);
                }
            };
            Futures.addCallback((ListenableFuture)submit, (FutureCallback)callback, (Executor)this.manager);
        }
    }

    private <D, T extends WorkflowSystem.OperationCompleted<D>, X extends WorkflowSystem.Operation<D, T>> WorkflowSystem.OperationResult<D, T, X> result(Throwable t, X operation) {
        return new WorkflowEngine.WResult(operation, t);
    }

    private <D, T extends WorkflowSystem.OperationCompleted<D>, X extends WorkflowSystem.Operation<D, T>> WorkflowSystem.OperationResult<D, T, X> result(T successResult, X operation) {
        return new WorkflowEngine.WResult(operation, successResult);
    }

    private void waitForChanges(Map<String, String> changes) throws InterruptedException {
        WorkflowSystem.OperationCompleted<DAT> take = this.stateChangeQueue.poll(this.sleeper.time(), this.sleeper.unit());
        if (null == take || take.getNewState().getState().isEmpty()) {
            this.sleeper.backoff();
            return;
        }
        this.sleeper.reset();
        changes.putAll(take.getNewState().getState());
        if (null != this.sharedData) {
            this.sharedData.addData(take.getResult());
        }
        this.getAvailableChanges(changes);
    }

    private void processStateChanges(Map<String, String> changes) {
        this.workflowEngine.event(WorkflowSystemEventType.WillProcessStateChange, String.format("saw state changes: %s", changes), changes);
        this.workflowEngine.getState().updateState(changes);
        boolean update = Rules.update(this.workflowEngine.getRuleEngine(), this.workflowEngine.getState());
        this.workflowEngine.event(WorkflowSystemEventType.DidProcessStateChange, String.format("applied state changes and rules (changed? %s): %s", update, this.workflowEngine.getState()), this.workflowEngine.getState());
    }

    private void processOperations(Consumer<WorkflowSystem.OperationResult<DAT, RES, OP>> resultConsumer) {
        int origPendingCount = this.pending.size();
        List shouldrun = this.pending.stream().filter(input -> input.shouldRun(this.workflowEngine.getState())).collect(Collectors.toList());
        List shouldskip = shouldrun.stream().filter(input -> input.shouldSkip(this.workflowEngine.getState())).collect(Collectors.toList());
        DAT inputData = null != this.sharedData ? (DAT)this.sharedData.produceNext() : null;
        this.processRunnableOperations(resultConsumer, shouldrun, shouldskip, inputData);
        this.processSkippedOperations(shouldskip);
        this.pending.removeAll(shouldskip);
        this.skipped.addAll(shouldskip);
        this.workflowEngine.eventLoopProgress(origPendingCount, shouldskip.size(), shouldrun.size(), this.pending.size());
    }

    private void processSkippedOperations(List<OP> shouldskip) {
        for (WorkflowSystem.Operation operation : shouldskip) {
            this.workflowEngine.event(WorkflowSystemEventType.WillSkipOperation, String.format("Skip condition statisfied for operation: %s, skipping", operation), operation);
            StateObj newstate = operation.getSkipState(this.workflowEngine.getState());
            WorkflowSystem.OperationCompleted objectOperationCompleted = WorkflowEngine.dummyResult(newstate);
            this.stateChangeQueue.add(objectOperationCompleted);
        }
    }

    public Set<OP> getOperations() {
        return this.operations;
    }

    public WorkflowSystem.SharedData<DAT> getSharedData() {
        return this.sharedData;
    }

    public Set<WorkflowSystem.Operation> getInProcess() {
        return this.inProcess;
    }

    public Set<WorkflowSystem.Operation> getSkipped() {
        return this.skipped;
    }

    public boolean isInterrupted() {
        return this.interrupted;
    }

    public void setInterrupted(boolean interrupted) {
        this.interrupted = interrupted;
    }

    public Set<OP> getPending() {
        return this.pending;
    }

    public Set<WorkflowSystem.OperationResult<DAT, RES, OP>> getResults() {
        return this.results;
    }
}

