/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.rules;

import com.dtolabs.rundeck.core.rules.MutableStateObj;
import com.dtolabs.rundeck.core.rules.RuleEngine;
import com.dtolabs.rundeck.core.rules.WorkflowEngine;
import com.dtolabs.rundeck.core.rules.WorkflowSystem;
import com.dtolabs.rundeck.core.rules.WorkflowSystemBuilder;
import com.dtolabs.rundeck.core.rules.WorkflowSystemEventListener;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;

public class WorkflowEngineBuilder
implements WorkflowSystemBuilder {
    RuleEngine engine;
    MutableStateObj state;
    Supplier<ExecutorService> executor;
    WorkflowSystemEventListener listener;

    public static WorkflowEngineBuilder builder(WorkflowEngineBuilder source) {
        WorkflowEngineBuilder workflowSystemBuilder = new WorkflowEngineBuilder();
        workflowSystemBuilder.engine = source.engine;
        workflowSystemBuilder.state = source.state;
        workflowSystemBuilder.executor = source.executor;
        workflowSystemBuilder.listener = source.listener;
        return workflowSystemBuilder;
    }

    public static WorkflowEngineBuilder builder() {
        return new WorkflowEngineBuilder();
    }

    @Override
    public WorkflowEngineBuilder ruleEngine(RuleEngine engine) {
        this.engine = engine;
        return this;
    }

    @Override
    public WorkflowEngineBuilder state(MutableStateObj state) {
        this.state = state;
        return this;
    }

    @Override
    public WorkflowEngineBuilder executor(Supplier<ExecutorService> executor) {
        this.executor = executor;
        return this;
    }

    @Override
    public WorkflowEngineBuilder listener(WorkflowSystemEventListener listener) {
        this.listener = listener;
        return this;
    }

    @Override
    public WorkflowSystem build() {
        if (null == this.engine || null == this.state || null == this.executor) {
            throw new IllegalArgumentException();
        }
        WorkflowEngine workflowEngine = new WorkflowEngine(this.engine, this.state, this.executor.get());
        workflowEngine.setListener(this.listener);
        return workflowEngine;
    }
}

