/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.utils;

import com.dtolabs.rundeck.core.plugins.configuration.PropertyValidator;
import com.dtolabs.rundeck.core.plugins.configuration.ValidationException;
import java.util.UUID;
import java.util.regex.Pattern;

public class UUIDPropertyValidator
implements PropertyValidator {
    private static final Pattern UUID_PAT = Pattern.compile("^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$");

    @Override
    public boolean isValid(String value) throws ValidationException {
        return UUIDPropertyValidator.validate(value);
    }

    public static boolean isValidUUID(String value) {
        try {
            return UUIDPropertyValidator.validate(value, false);
        }
        catch (ValidationException ignored) {
            return false;
        }
    }

    public static boolean validate(String value) throws ValidationException {
        return UUIDPropertyValidator.validate(value, true);
    }

    private static boolean validate(String value, boolean report) throws ValidationException {
        if (null == value || value.length() != 36) {
            if (!report) {
                return false;
            }
            throw new ValidationException("Input should be 36 characters in the form: 00000000-0000-0000-0000-000000000000");
        }
        if (!UUID_PAT.matcher(value).matches()) {
            if (!report) {
                return false;
            }
            throw new ValidationException("Input does not match UUID form: 01234567-89ab-cdef-0123-456789abcdef");
        }
        try {
            UUID uUID = UUID.fromString(value);
        }
        catch (IllegalArgumentException e) {
            if (!report) {
                return false;
            }
            throw new ValidationException(e.getMessage(), e);
        }
        return true;
    }
}

