/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.service;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.execution.impl.jsch.JschNodeExecutor;
import com.dtolabs.rundeck.core.execution.impl.local.LocalNodeExecutor;
import com.dtolabs.rundeck.core.execution.impl.local.NewLocalNodeExecutor;
import com.dtolabs.rundeck.core.execution.service.NodeExecutor;
import com.dtolabs.rundeck.core.execution.service.NodeSpecifiedService;
import com.dtolabs.rundeck.core.execution.service.ProviderCreationException;
import com.dtolabs.rundeck.core.execution.service.ScriptPluginNodeExecutor;
import com.dtolabs.rundeck.core.plugins.PluggableProviderService;
import com.dtolabs.rundeck.core.plugins.PluginException;
import com.dtolabs.rundeck.core.plugins.ProviderIdent;
import com.dtolabs.rundeck.core.plugins.ScriptPluginProvider;
import com.dtolabs.rundeck.core.plugins.configuration.DescribableService;
import com.dtolabs.rundeck.core.plugins.configuration.DescribableServiceUtil;
import com.dtolabs.rundeck.core.plugins.configuration.Description;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class NodeExecutorService
extends NodeSpecifiedService<NodeExecutor>
implements DescribableService,
PluggableProviderService<NodeExecutor> {
    private static final String SERVICE_NAME = "NodeExecutor";
    public static final String SERVICE_DEFAULT_PROVIDER_PROPERTY = "service.NodeExecutor.default.provider";
    private static final String SERVICE_DEFAULT_LOCAL_PROVIDER_PROPERTY = "service.NodeExecutor.default.local.provider";
    public static final String NODE_SERVICE_SPECIFIER_ATTRIBUTE = "node-executor";
    public static final String LOCAL_NODE_SERVICE_SPECIFIER_ATTRIBUTE = "local-node-executor";
    public static final String DEFAULT_LOCAL_PROVIDER = "local";
    public static final String DEFAULT_REMOTE_PROVIDER = "jsch-ssh";

    @Override
    public String getName() {
        return SERVICE_NAME;
    }

    public List<String> getBundledProviderNames() {
        return Collections.unmodifiableList(new ArrayList(this.registry.keySet()));
    }

    NodeExecutorService(Framework framework) {
        super(framework);
        this.registry.put(DEFAULT_REMOTE_PROVIDER, JschNodeExecutor.class);
        this.registry.put(DEFAULT_LOCAL_PROVIDER, LocalNodeExecutor.class);
        this.registry.put("newlocal", NewLocalNodeExecutor.class);
    }

    @Override
    protected String getDefaultProviderNameForNodeAndProject(INodeEntry node, String project) {
        if (this.framework.isLocalNode(node)) {
            String value = this.framework.getProjectProperty(project, SERVICE_DEFAULT_LOCAL_PROVIDER_PROPERTY);
            return null != value ? value : DEFAULT_LOCAL_PROVIDER;
        }
        String value = this.framework.getProjectProperty(project, SERVICE_DEFAULT_PROVIDER_PROPERTY);
        return null != value ? value : DEFAULT_REMOTE_PROVIDER;
    }

    public static NodeExecutorService getInstanceForFramework(Framework framework) {
        if (null == framework.getService(SERVICE_NAME)) {
            NodeExecutorService service = new NodeExecutorService(framework);
            framework.setService(SERVICE_NAME, service);
            return service;
        }
        return (NodeExecutorService)framework.getService(SERVICE_NAME);
    }

    @Override
    protected String getServiceProviderNodeAttributeForNode(INodeEntry node) {
        if (this.framework.isLocalNode(node)) {
            return LOCAL_NODE_SERVICE_SPECIFIER_ATTRIBUTE;
        }
        return NODE_SERVICE_SPECIFIER_ATTRIBUTE;
    }

    @Override
    public boolean isValidProviderClass(Class clazz) {
        return NodeExecutor.class.isAssignableFrom(clazz) && this.hasValidProviderSignature(clazz);
    }

    @Override
    public <X extends NodeExecutor> NodeExecutor createProviderInstance(Class<X> clazz, String name) throws PluginException, ProviderCreationException {
        return (NodeExecutor)this.createProviderInstanceFromType(clazz, name);
    }

    @Override
    public boolean isScriptPluggable() {
        return true;
    }

    @Override
    public NodeExecutor createScriptProviderInstance(ScriptPluginProvider provider) throws PluginException {
        ScriptPluginNodeExecutor.validateScriptPlugin(provider);
        return new ScriptPluginNodeExecutor(provider, this.framework);
    }

    @Override
    public List<Description> listDescriptions() {
        return DescribableServiceUtil.listDescriptions(this, false);
    }

    @Override
    public List<ProviderIdent> listDescribableProviders() {
        return DescribableServiceUtil.listDescribableProviders(this);
    }
}

