/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.resources;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.INodeSet;
import com.dtolabs.rundeck.core.common.NodeEntryImpl;
import com.dtolabs.rundeck.core.common.NodeSetImpl;
import com.dtolabs.rundeck.core.plugins.configuration.Configurable;
import com.dtolabs.rundeck.core.plugins.configuration.ConfigurationException;
import com.dtolabs.rundeck.core.plugins.configuration.Description;
import com.dtolabs.rundeck.core.resources.BaseFileResourceModelSource;
import com.dtolabs.rundeck.core.resources.ResourceModelSourceException;
import com.dtolabs.rundeck.core.resources.format.ResourceFormatGenerator;
import com.dtolabs.rundeck.core.resources.format.ResourceFormatGeneratorException;
import com.dtolabs.rundeck.core.resources.format.ResourceFormatParserService;
import com.dtolabs.rundeck.core.resources.format.UnsupportedFormatException;
import com.dtolabs.rundeck.plugins.util.DescriptionBuilder;
import com.dtolabs.utils.Streams;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;

public class FileResourceModelSource
extends BaseFileResourceModelSource
implements Configurable {
    private Configuration configuration;

    FileResourceModelSource(Framework framework) {
        super(framework);
    }

    static Description createDescription(List<String> formats) {
        return DescriptionBuilder.buildDescriptionWith(d -> d.name("file").title("File").description("Reads a file containing node definitions in a supported format").property(p -> p.freeSelect("format").title("Format").description("Format of the file").values(formats)).property(p -> p.string("file").title("File Path").description("Path of the file").required(true)).property(p -> p.booleanType("generateFileAutomatically").title("Generate").description("Automatically generate the file if it is missing?\n\nAlso creates missing directories.").required(true).defaultValue("false")).property(p -> p.booleanType("includeServerNode").title("Include Server Node").description("Automatically include the server node in the generated file?").required(true).defaultValue("false")).property(p -> p.booleanType("requireFileExists").title("Require File Exists").description("Require that the file exists").required(true).defaultValue("false")).property(p -> p.booleanType("writeable").title("Writeable").description("Allow this file to be editable.").required(false).defaultValue("false")));
    }

    @Override
    public void configure(Properties configs) throws ConfigurationException {
        Configuration configuration1 = Configuration.fromProperties(configs);
        this.configure(configuration1);
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.configuration = new Configuration(configuration);
        this.configuration.validate();
    }

    @Override
    public long writeFileData(InputStream dataStream) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(this.configuration.nodesFile);){
            long l = Streams.copyStream(dataStream, fos);
            return l;
        }
    }

    @Override
    public InputStream openFileDataInputStream() throws IOException, ResourceModelSourceException {
        if (!this.configuration.nodesFile.exists() && this.configuration.generateFileAutomatically) {
            this.generateResourcesFile(this.configuration.nodesFile, this.configuration.format);
        }
        if (this.configuration.nodesFile.isFile()) {
            return new FileInputStream(this.configuration.nodesFile);
        }
        if (this.configuration.requireFileExists) {
            throw new ResourceModelSourceException("File does not exist: " + this.configuration.nodesFile);
        }
        return null;
    }

    @Override
    public boolean hasData() {
        return this.configuration.requireFileExists || this.configuration.generateFileAutomatically || this.configuration.nodesFile.exists();
    }

    @Override
    protected boolean isSupportsLastModified() {
        return true;
    }

    @Override
    protected long getLastModified() {
        return this.configuration.nodesFile.exists() ? this.configuration.nodesFile.lastModified() : 0L;
    }

    @Override
    protected String getResourceFormat() {
        return this.configuration.format;
    }

    @Override
    protected String getDocumentFileExtension() {
        return ResourceFormatParserService.getFileExtension(this.configuration.nodesFile.getName());
    }

    @Override
    public String getSourceDescription() {
        return this.configuration.nodesFile.getAbsolutePath();
    }

    @Override
    public boolean isDataWritable() {
        return this.configuration.writeable;
    }

    @Override
    protected boolean shouldGenerateServerNode() {
        return this.configuration.includeServerNode;
    }

    public static INodeSet parseFile(File file, Framework framework, String project) throws ResourceModelSourceException, ConfigurationException {
        FileResourceModelSource prov = new FileResourceModelSource(framework);
        prov.configure(Configuration.build().file(file).includeServerNode(false).generateFileAutomatically(false).project(project).requireFileExists(true));
        return prov.getNodes();
    }

    public static INodeSet parseFile(File file, String format, Framework framework, String project) throws ResourceModelSourceException, ConfigurationException {
        FileResourceModelSource prov = new FileResourceModelSource(framework);
        prov.configure(Configuration.build().file(file).includeServerNode(false).generateFileAutomatically(false).project(project).format(format).requireFileExists(true));
        return prov.getNodes();
    }

    private void generateResourcesFile(File resfile, String format) throws ResourceModelSourceException {
        ResourceFormatGenerator generator;
        NodeEntryImpl node = this.framework.createFrameworkNode();
        node.setFrameworkProject(this.configuration.project);
        if (null != format) {
            try {
                generator = this.framework.getResourceFormatGeneratorService().getGeneratorForFormat(format);
            }
            catch (UnsupportedFormatException e) {
                throw new ResourceModelSourceException(e);
            }
        }
        try {
            generator = this.framework.getResourceFormatGeneratorService().getGeneratorForFileExtension(resfile);
        }
        catch (UnsupportedFormatException e) {
            throw new ResourceModelSourceException(e);
        }
        NodeSetImpl nodes = new NodeSetImpl();
        if (this.configuration.includeServerNode) {
            nodes.putNode(node);
        }
        if (!resfile.getParentFile().exists() && !resfile.getParentFile().mkdirs()) {
            throw new ResourceModelSourceException("Parent dir for resource file does not exists, and could not be created: " + resfile);
        }
        try (FileOutputStream stream = new FileOutputStream(resfile);){
            generator.generateDocument(nodes, stream);
        }
        catch (ResourceFormatGeneratorException | IOException e) {
            throw new ResourceModelSourceException(e);
        }
    }

    public String toString() {
        return "FileResourceModelSource{file=" + this.configuration.nodesFile + ", format=" + this.configuration.format + '}';
    }

    public static class Configuration {
        public static final String GENERATE_FILE_AUTOMATICALLY = "generateFileAutomatically";
        public static final String INCLUDE_SERVER_NODE = "includeServerNode";
        public static final String FILE = "file";
        public static final String PROJECT = "project";
        public static final String FORMAT = "format";
        public static final String REQUIRE_FILE_EXISTS = "requireFileExists";
        public static final String WRITEABLE = "writeable";
        String format;
        File nodesFile;
        String project;
        boolean generateFileAutomatically;
        boolean includeServerNode;
        boolean requireFileExists;
        final Properties configuration;
        boolean writeable;

        Configuration() {
            this.configuration = new Properties();
        }

        Configuration(Properties configuration) {
            if (null == configuration) {
                throw new NullPointerException("configuration");
            }
            this.configuration = configuration;
            this.configure();
        }

        Configuration(Configuration configuration) {
            this(configuration.getProperties());
        }

        public static Configuration fromProperties(Properties configuration) {
            return new Configuration(configuration);
        }

        public static Configuration clone(Configuration configuration) {
            return Configuration.fromProperties(configuration.getProperties());
        }

        public static Configuration build() {
            return new Configuration();
        }

        public Configuration format(String format) {
            this.format = format;
            this.configuration.put(FORMAT, format);
            return this;
        }

        public Configuration file(File file) {
            this.nodesFile = file;
            this.configuration.put(FILE, file.getAbsolutePath());
            return this;
        }

        public Configuration file(String file) {
            this.nodesFile = new File(file);
            this.configuration.put(FILE, file);
            return this;
        }

        public Configuration project(String project) {
            this.project = project;
            this.configuration.put(PROJECT, project);
            return this;
        }

        public Configuration includeServerNode(boolean include) {
            this.includeServerNode = include;
            this.configuration.put(INCLUDE_SERVER_NODE, Boolean.toString(include));
            return this;
        }

        public Configuration generateFileAutomatically(boolean generate) {
            this.generateFileAutomatically = generate;
            this.configuration.put(GENERATE_FILE_AUTOMATICALLY, Boolean.toString(generate));
            return this;
        }

        public Configuration requireFileExists(boolean require) {
            this.requireFileExists = require;
            this.configuration.put(REQUIRE_FILE_EXISTS, Boolean.toString(this.requireFileExists));
            return this;
        }

        public Configuration writeable(boolean writeable) {
            this.writeable = writeable;
            this.configuration.put(WRITEABLE, Boolean.toString(writeable));
            return this;
        }

        public Properties getProperties() {
            return this.configuration;
        }

        void configure() {
            if (this.configuration.containsKey(PROJECT)) {
                this.project = this.configuration.getProperty(PROJECT);
            }
            if (this.configuration.containsKey(FILE)) {
                this.nodesFile = new File(this.configuration.getProperty(FILE));
            }
            if (this.configuration.containsKey(FORMAT)) {
                this.format = this.configuration.getProperty(FORMAT);
            }
            if (this.configuration.containsKey(GENERATE_FILE_AUTOMATICALLY)) {
                this.generateFileAutomatically = Boolean.parseBoolean(this.configuration.getProperty(GENERATE_FILE_AUTOMATICALLY));
            }
            if (this.configuration.containsKey(INCLUDE_SERVER_NODE)) {
                this.includeServerNode = Boolean.parseBoolean(this.configuration.getProperty(INCLUDE_SERVER_NODE));
            }
            if (this.configuration.containsKey(REQUIRE_FILE_EXISTS)) {
                this.requireFileExists = Boolean.parseBoolean(this.configuration.getProperty(REQUIRE_FILE_EXISTS));
            }
            if (this.configuration.containsKey(WRITEABLE)) {
                this.writeable = Boolean.parseBoolean(this.configuration.getProperty(WRITEABLE));
            }
        }

        void validate() throws ConfigurationException {
            if (null == this.project) {
                throw new ConfigurationException("project is required");
            }
            if (null == this.nodesFile) {
                throw new ConfigurationException("file is required");
            }
        }

        public String toString() {
            return "Configuration{format=" + this.format + ", nodesFile=" + this.nodesFile + ", project='" + this.project + '\'' + ", generateFileAutomatically=" + this.generateFileAutomatically + ", includeServerNode=" + this.includeServerNode + ", requireFileExists=" + this.requireFileExists + ", writeable=" + this.writeable + ", configuration=" + this.configuration + '}';
        }
    }
}

