/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.resources;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.INodeSet;
import com.dtolabs.rundeck.core.common.NodeEntryImpl;
import com.dtolabs.rundeck.core.common.NodeSetImpl;
import com.dtolabs.rundeck.core.plugins.configuration.ConfigurationException;
import com.dtolabs.rundeck.core.plugins.configuration.Description;
import com.dtolabs.rundeck.core.resources.ResourceModelSource;
import com.dtolabs.rundeck.core.resources.ResourceModelSourceException;
import com.dtolabs.rundeck.plugins.util.DescriptionBuilder;
import java.io.IOException;
import java.io.StringReader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;

public class LocalResourceModelSource
implements ResourceModelSource {
    final Framework framework;
    String description;
    String hostname;
    String osArch;
    String osName;
    String osVersion;
    String osFamily;
    Properties attributes;

    public LocalResourceModelSource(Framework framework) {
        this.framework = framework;
    }

    @Override
    public INodeSet getNodes() throws ResourceModelSourceException {
        NodeSetImpl newNodes = new NodeSetImpl();
        NodeEntryImpl node = this.createFrameworkNodeNew();
        newNodes.putNode(node);
        return newNodes;
    }

    private NodeEntryImpl createFrameworkNodeNew() {
        NodeEntryImpl node = new NodeEntryImpl(null != this.hostname ? this.hostname : this.framework.getFrameworkNodeHostname(), this.framework.getFrameworkNodeName());
        node.setDescription(this.description != null ? this.description : "Rundeck server node");
        node.setOsArch(this.osArch != null ? this.osArch : System.getProperty("os.arch"));
        node.setOsName(this.osName != null ? this.osName : System.getProperty("os.name"));
        node.setOsVersion(this.osVersion != null ? this.osVersion : System.getProperty("os.version"));
        if (this.osFamily != null) {
            node.setOsFamily(this.osFamily);
        } else {
            String s = System.getProperty("file.separator");
            node.setOsFamily("/".equals(s) ? "unix" : ("\\".equals(s) ? "windows" : ""));
        }
        if (null != this.attributes) {
            for (Object o : this.attributes.keySet()) {
                if (o.toString().equals("tags")) {
                    String[] split = this.attributes.getProperty(o.toString()).split("\\s*,\\s*");
                    node.setTags(new HashSet<String>(Arrays.asList(split)));
                    continue;
                }
                node.setAttribute(o.toString(), this.attributes.getProperty(o.toString()));
            }
        }
        return node;
    }

    private NodeEntryImpl createFrameworkNodeOrig() {
        return this.framework.createFrameworkNode();
    }

    static Description createDescription() {
        return DescriptionBuilder.buildDescriptionWith(d -> d.name("local").title("Local").description("Provides the local node as the single resource").property(p -> p.string("description").title("Description").description("Description of the local server node").defaultValue("Rundeck server node")).property(p -> p.string("hostname").title("Hostname").description("Server hostname (default: via host OS)")).property(p -> p.string("osFamily").title("OS Family").description("OS Family: unix, windows, ... (default: via host OS)")).property(p -> p.string("osName").title("OS Name").description("(default: via host OS)")).property(p -> p.string("osArch").title("OS Architecture").description("(default: via host OS)")).property(p -> p.string("osVersion").title("OS Version").description("(default: via host OS)")).property(p -> p.string("attributes").renderingOption("displayType", "CODE").renderingOption("codeSyntaxMode", "properties").title("Attributes").description("Custom attributes, in Java properties format")));
    }

    public void configure(Properties configuration) throws ConfigurationException {
        this.description = configuration.getProperty("description");
        this.hostname = configuration.getProperty("hostname");
        this.osFamily = configuration.getProperty("osFamily");
        this.osVersion = configuration.getProperty("osVersion");
        this.osName = configuration.getProperty("osName");
        this.osArch = configuration.getProperty("osArch");
        String attributes = configuration.getProperty("attributes");
        if (null != attributes && !"".equals(attributes.trim())) {
            Properties props = new Properties();
            try {
                props.load(new StringReader(attributes));
            }
            catch (IOException e) {
                throw new ConfigurationException("Cannot parse attributes text as Java Properties format: " + e.getMessage(), e);
            }
            this.attributes = props;
        }
    }
}

