/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.common;

import com.dtolabs.rundeck.core.authorization.Attribute;
import com.dtolabs.rundeck.core.authorization.AuthContext;
import com.dtolabs.rundeck.core.common.FilesystemFramework;
import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.FrameworkFactory;
import com.dtolabs.rundeck.core.common.FrameworkSupportService;
import com.dtolabs.rundeck.core.common.IFramework;
import com.dtolabs.rundeck.core.common.IFrameworkNodes;
import com.dtolabs.rundeck.core.common.IFrameworkServices;
import com.dtolabs.rundeck.core.common.INodeDesc;
import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.common.INodeSet;
import com.dtolabs.rundeck.core.common.IRundeckProject;
import com.dtolabs.rundeck.core.common.NodeEntryImpl;
import com.dtolabs.rundeck.core.common.ProjectManager;
import com.dtolabs.rundeck.core.common.PropertyRetriever;
import com.dtolabs.rundeck.core.execution.ExecutionContext;
import com.dtolabs.rundeck.core.execution.ExecutionService;
import com.dtolabs.rundeck.core.execution.dispatch.NodeDispatcher;
import com.dtolabs.rundeck.core.execution.orchestrator.OrchestratorService;
import com.dtolabs.rundeck.core.execution.service.ExecutionServiceException;
import com.dtolabs.rundeck.core.execution.service.FileCopier;
import com.dtolabs.rundeck.core.execution.service.FileCopierService;
import com.dtolabs.rundeck.core.execution.service.NodeExecutor;
import com.dtolabs.rundeck.core.execution.service.NodeExecutorService;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionService;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowStrategyService;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepExecutionService;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepExecutionItem;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepExecutionService;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepExecutor;
import com.dtolabs.rundeck.core.plugins.ServiceProviderLoader;
import com.dtolabs.rundeck.core.resources.ResourceModelSourceService;
import com.dtolabs.rundeck.core.resources.format.ResourceFormatGeneratorService;
import com.dtolabs.rundeck.core.resources.format.ResourceFormatParserService;
import com.dtolabs.rundeck.core.utils.IPropertyLookup;
import com.dtolabs.rundeck.core.utils.PropertyLookup;
import java.io.File;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class FrameworkBase
implements IFramework {
    public static final Logger logger = Logger.getLogger(FrameworkBase.class);
    public static final String NODES_RESOURCES_FILE_PROP = "framework.nodes.file.name";
    public static final String FRAMEWORK_GLOBALS_PROP = "framework.globals.";
    public static final String PROJECT_GLOBALS_PROP = "project.globals.";
    public static final Attribute RUNDECK_APP_CONTEXT = new Attribute(URI.create("rundeck:auth:env:application"), "rundeck");
    public static final Set<Attribute> RUNDECK_APP_ENV = Collections.singleton(RUNDECK_APP_CONTEXT);
    private final IPropertyLookup lookup;
    private ProjectManager projectManager;
    private IFrameworkServices frameworkServices;
    private IFrameworkNodes frameworkNodes;

    FrameworkBase(ProjectManager projectManager, IPropertyLookup lookup, IFrameworkServices services, IFrameworkNodes iFrameworkNodes) {
        this.setProjectManager(projectManager);
        this.lookup = lookup;
        this.frameworkServices = services;
        this.frameworkNodes = iFrameworkNodes;
    }

    @Override
    public ProjectManager getFrameworkProjectMgr() {
        return this.getProjectManager();
    }

    @Override
    public FrameworkSupportService getService(String name) {
        return this.frameworkServices.getService(name);
    }

    @Override
    public void setService(String name, FrameworkSupportService service) {
        this.frameworkServices.setService(name, service);
    }

    @Override
    public ExecutionService getExecutionService() {
        return this.frameworkServices.getExecutionService();
    }

    @Override
    public OrchestratorService getOrchestratorService() {
        return this.frameworkServices.getOrchestratorService();
    }

    @Override
    public WorkflowExecutionService getWorkflowExecutionService() {
        return this.frameworkServices.getWorkflowExecutionService();
    }

    @Override
    public WorkflowStrategyService getWorkflowStrategyService() {
        return this.frameworkServices.getWorkflowStrategyService();
    }

    @Override
    public StepExecutionService getStepExecutionService() {
        return this.frameworkServices.getStepExecutionService();
    }

    @Override
    public FileCopier getFileCopierForNodeAndProject(INodeEntry node, String project) throws ExecutionServiceException {
        return this.frameworkServices.getFileCopierForNodeAndProject(node, project);
    }

    @Override
    public FileCopierService getFileCopierService() {
        return this.frameworkServices.getFileCopierService();
    }

    @Override
    public NodeExecutor getNodeExecutorForNodeAndProject(INodeEntry node, String project) throws ExecutionServiceException {
        return this.frameworkServices.getNodeExecutorForNodeAndProject(node, project);
    }

    @Override
    public NodeExecutorService getNodeExecutorService() throws ExecutionServiceException {
        return this.frameworkServices.getNodeExecutorService();
    }

    @Override
    public NodeStepExecutionService getNodeStepExecutorService() throws ExecutionServiceException {
        return this.frameworkServices.getNodeStepExecutorService();
    }

    @Override
    public NodeStepExecutor getNodeStepExecutorForItem(NodeStepExecutionItem item) throws ExecutionServiceException {
        return this.frameworkServices.getNodeStepExecutorForItem(item);
    }

    @Override
    public NodeDispatcher getNodeDispatcherForContext(ExecutionContext context) throws ExecutionServiceException {
        return this.frameworkServices.getNodeDispatcherForContext(context);
    }

    @Override
    public ResourceModelSourceService getResourceModelSourceService() {
        return this.frameworkServices.getResourceModelSourceService();
    }

    @Override
    public ResourceFormatParserService getResourceFormatParserService() {
        return this.frameworkServices.getResourceFormatParserService();
    }

    @Override
    public ResourceFormatGeneratorService getResourceFormatGeneratorService() {
        return this.frameworkServices.getResourceFormatGeneratorService();
    }

    @Override
    public ServiceProviderLoader getPluginManager() {
        return this.frameworkServices.getPluginManager();
    }

    public static PropertyRetriever createPropertyRetriever(File basedir) {
        return FilesystemFramework.createPropertyRetriever(basedir);
    }

    public static Framework getInstance(String basedir, String projectsdir) {
        return FrameworkFactory.createForFilesystem(basedir);
    }

    public String getProperty(String name) {
        return this.lookup.getProperty(name);
    }

    public PropertyRetriever getPropertyRetriever() {
        return PropertyLookup.safePropertyRetriever(this.lookup);
    }

    public boolean hasProperty(String key) {
        return this.lookup.hasProperty(key);
    }

    public boolean hasProjectProperty(String key, String project) {
        IRundeckProject frameworkProject = this.getFrameworkProjectMgr().getFrameworkProject(project);
        return frameworkProject.hasProperty(key) || this.hasProperty(key);
    }

    public String getProjectProperty(String project, String key) {
        IRundeckProject frameworkProject = this.getFrameworkProjectMgr().getFrameworkProject(project);
        if (frameworkProject.hasProperty(key)) {
            return frameworkProject.getProperty(key);
        }
        if (this.hasProperty(key)) {
            return this.getProperty(key);
        }
        return null;
    }

    public Map<String, String> getProjectGlobals(String project) {
        HashMap<String, String> projectGlobalsMap = new HashMap<String, String>();
        HashMap projectGlobs = new HashMap();
        Map<String, String> projectFullProps = this.getFrameworkProjectMgr().getFrameworkProject(project).getProperties();
        for (Map.Entry<String, String> propEntry : projectFullProps.entrySet()) {
            String varName;
            HashMap<String, String> curMap;
            if (propEntry.getKey().startsWith(FRAMEWORK_GLOBALS_PROP)) {
                curMap = projectGlobalsMap;
                varName = propEntry.getKey().substring(FRAMEWORK_GLOBALS_PROP.length());
            } else {
                if (!propEntry.getKey().startsWith(PROJECT_GLOBALS_PROP)) continue;
                curMap = projectGlobs;
                varName = propEntry.getKey().substring(PROJECT_GLOBALS_PROP.length());
            }
            if ("".equals(varName)) continue;
            curMap.put(varName, propEntry.getValue());
        }
        projectGlobalsMap.putAll(projectGlobs);
        return projectGlobalsMap;
    }

    @Override
    public IPropertyLookup getPropertyLookup() {
        return this.lookup;
    }

    public String toString() {
        return "BaseFramework{}";
    }

    @Override
    public String getFrameworkNodeHostname() {
        return this.getFrameworkNodes().getFrameworkNodeHostname();
    }

    @Override
    public String getFrameworkNodeName() {
        return this.getFrameworkNodes().getFrameworkNodeName();
    }

    @Override
    public NodeEntryImpl createFrameworkNode() {
        return this.getFrameworkNodes().createFrameworkNode();
    }

    @Override
    public INodeSet filterAuthorizedNodes(String project, Set<String> actions, INodeSet unfiltered, AuthContext authContext) {
        return this.getFrameworkNodes().filterAuthorizedNodes(project, actions, unfiltered, authContext);
    }

    @Override
    public INodeDesc getNodeDesc() {
        return this.getFrameworkNodes().getNodeDesc();
    }

    @Override
    public boolean isLocalNode(INodeDesc node) {
        return this.getFrameworkNodes().isLocalNode(node);
    }

    public IFrameworkServices getFrameworkServices() {
        return this.frameworkServices;
    }

    public void setFrameworkServices(IFrameworkServices frameworkServices) {
        this.frameworkServices = frameworkServices;
    }

    public IFrameworkNodes getFrameworkNodes() {
        return this.frameworkNodes;
    }

    public void setFrameworkNodes(IFrameworkNodes frameworkNodes) {
        this.frameworkNodes = frameworkNodes;
    }

    public ProjectManager getProjectManager() {
        return this.projectManager;
    }

    public void setProjectManager(ProjectManager projectManager) {
        this.projectManager = projectManager;
    }
}

