/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.resources;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.execution.service.ExecutionServiceException;
import com.dtolabs.rundeck.core.execution.service.ProviderCreationException;
import com.dtolabs.rundeck.core.plugins.CloseableProvider;
import com.dtolabs.rundeck.core.plugins.PluggableProviderRegistryService;
import com.dtolabs.rundeck.core.plugins.PluggableProviderService;
import com.dtolabs.rundeck.core.plugins.PluginException;
import com.dtolabs.rundeck.core.plugins.ProviderIdent;
import com.dtolabs.rundeck.core.plugins.ScriptPluginProvider;
import com.dtolabs.rundeck.core.plugins.configuration.ConfigurableService;
import com.dtolabs.rundeck.core.plugins.configuration.ConfigurationException;
import com.dtolabs.rundeck.core.plugins.configuration.DescribableService;
import com.dtolabs.rundeck.core.plugins.configuration.DescribableServiceUtil;
import com.dtolabs.rundeck.core.plugins.configuration.Description;
import com.dtolabs.rundeck.core.resources.DirectoryResourceModelSourceFactory;
import com.dtolabs.rundeck.core.resources.FileResourceModelSourceFactory;
import com.dtolabs.rundeck.core.resources.LocalResourceModelSourceFactory;
import com.dtolabs.rundeck.core.resources.ResourceModelSource;
import com.dtolabs.rundeck.core.resources.ResourceModelSourceFactory;
import com.dtolabs.rundeck.core.resources.ResourceModelSourceServiceException;
import com.dtolabs.rundeck.core.resources.ScriptPluginResourceModelSourceFactory;
import com.dtolabs.rundeck.core.resources.ScriptResourceModelSourceFactory;
import com.dtolabs.rundeck.core.resources.URLResourceModelSourceFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.function.Function;

public class ResourceModelSourceService
extends PluggableProviderRegistryService<ResourceModelSourceFactory>
implements ConfigurableService<ResourceModelSource>,
DescribableService,
PluggableProviderService<ResourceModelSourceFactory> {
    public static final String SERVICE_NAME = "ResourceModelSource";

    public List<String> getBundledProviderNames() {
        return Collections.unmodifiableList(new ArrayList(this.registry.keySet()));
    }

    public ResourceModelSourceService(Framework framework) {
        super(framework);
        this.registry.put("local", LocalResourceModelSourceFactory.class);
        this.registry.put("file", FileResourceModelSourceFactory.class);
        this.registry.put("directory", DirectoryResourceModelSourceFactory.class);
        this.registry.put("url", URLResourceModelSourceFactory.class);
        this.registry.put("script", ScriptResourceModelSourceFactory.class);
    }

    @Override
    public String getName() {
        return SERVICE_NAME;
    }

    public static ResourceModelSourceService getInstanceForFramework(Framework framework) {
        if (null == framework.getService(SERVICE_NAME)) {
            ResourceModelSourceService service = new ResourceModelSourceService(framework);
            framework.setService(SERVICE_NAME, service);
            return service;
        }
        return (ResourceModelSourceService)framework.getService(SERVICE_NAME);
    }

    public ResourceModelSource getSourceForConfiguration(String type, Properties configuration) throws ExecutionServiceException {
        ResourceModelSourceFactory nodesSourceFactory = (ResourceModelSourceFactory)this.providerOfType(type);
        try {
            return nodesSourceFactory.createResourceModelSource(configuration);
        }
        catch (Throwable e) {
            throw new ResourceModelSourceServiceException(e);
        }
    }

    public CloseableProvider<ResourceModelSource> getCloseableSourceForConfiguration(String type, Properties configuration) throws ExecutionServiceException {
        return this.closeableProviderOfType(type).convert(ResourceModelSourceService.factoryConverter(configuration));
    }

    public static Function<ResourceModelSourceFactory, ResourceModelSource> factoryConverter(final Properties configuration) {
        return new Function<ResourceModelSourceFactory, ResourceModelSource>(){

            @Override
            public ResourceModelSource apply(ResourceModelSourceFactory resourceModelSourceFactory) {
                try {
                    return resourceModelSourceFactory.createResourceModelSource(configuration);
                }
                catch (ConfigurationException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    @Override
    public boolean isValidProviderClass(Class clazz) {
        return ResourceModelSourceFactory.class.isAssignableFrom(clazz) && this.hasValidProviderSignature(clazz);
    }

    @Override
    public <X extends ResourceModelSourceFactory> ResourceModelSourceFactory createProviderInstance(Class<X> clazz, String name) throws PluginException, ProviderCreationException {
        return (ResourceModelSourceFactory)this.createProviderInstanceFromType(clazz, name);
    }

    @Override
    public boolean isScriptPluggable() {
        return true;
    }

    @Override
    public ResourceModelSourceFactory createScriptProviderInstance(ScriptPluginProvider provider) throws PluginException {
        ScriptPluginResourceModelSourceFactory.validateScriptPlugin(provider);
        return new ScriptPluginResourceModelSourceFactory(provider, this.framework);
    }

    @Override
    public ResourceModelSource getProviderForConfiguration(String type, Properties configuration) throws ExecutionServiceException {
        return this.getSourceForConfiguration(type, configuration);
    }

    @Override
    public CloseableProvider<ResourceModelSource> getCloseableProviderForConfiguration(String type, Properties configuration) throws ExecutionServiceException {
        return this.getCloseableSourceForConfiguration(type, configuration);
    }

    @Override
    public List<Description> listDescriptions() {
        return DescribableServiceUtil.listDescriptions(this, false);
    }

    @Override
    public List<ProviderIdent> listDescribableProviders() {
        return DescribableServiceUtil.listDescribableProviders(this);
    }
}

