/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.plugins;

import com.dtolabs.rundeck.core.common.FrameworkSupportService;
import com.dtolabs.rundeck.core.execution.service.ProviderCreationException;
import com.dtolabs.rundeck.core.execution.service.ProviderLoaderException;
import com.dtolabs.rundeck.core.plugins.CloseableProvider;
import com.dtolabs.rundeck.core.plugins.Closeables;
import com.dtolabs.rundeck.core.plugins.JavaClassProviderLoadable;
import com.dtolabs.rundeck.core.plugins.LocalFirstClassLoader;
import com.dtolabs.rundeck.core.plugins.PluggableService;
import com.dtolabs.rundeck.core.plugins.Plugin;
import com.dtolabs.rundeck.core.plugins.PluginException;
import com.dtolabs.rundeck.core.plugins.PluginMetadata;
import com.dtolabs.rundeck.core.plugins.PluginMetadataValidator;
import com.dtolabs.rundeck.core.plugins.PluginResourceLoader;
import com.dtolabs.rundeck.core.plugins.PluginUtils;
import com.dtolabs.rundeck.core.plugins.PluginValidation;
import com.dtolabs.rundeck.core.plugins.ProviderIdent;
import com.dtolabs.rundeck.core.plugins.ProviderLoader;
import com.dtolabs.rundeck.core.plugins.VersionCompare;
import com.dtolabs.rundeck.core.plugins.ZipResourceLoader;
import com.dtolabs.rundeck.core.utils.FileUtils;
import com.dtolabs.rundeck.core.utils.ZipUtil;
import com.dtolabs.rundeck.core.utils.cache.FileCache;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.apache.log4j.Logger;

public class JarPluginProviderLoader
implements ProviderLoader,
FileCache.Expireable,
PluginResourceLoader,
PluginMetadata,
Closeable {
    public static final String RESOURCES_DIR_DEFAULT = "resources";
    private static Logger log = Logger.getLogger((String)JarPluginProviderLoader.class.getName());
    public static final String RUNDECK_PLUGIN_ARCHIVE = "Rundeck-Plugin-Archive";
    public static final String RUNDECK_PLUGIN_CLASSNAMES = "Rundeck-Plugin-Classnames";
    public static final String RUNDECK_PLUGIN_RESOURCES = "Rundeck-Plugin-Resources";
    public static final String RUNDECK_PLUGIN_RESOURCES_DIR = "Rundeck-Plugin-Resources-Dir";
    public static final String RUNDECK_PLUGIN_LIBS = "Rundeck-Plugin-Libs";
    public static final String JAR_PLUGIN_VERSION = "1.1";
    public static final String JAR_PLUGIN_VERSION_1_2 = "1.2";
    public static final String JAR_PLUGIN_VERSION_2_0 = "2.0";
    public static final VersionCompare SUPPORTS_RESOURCES_PLUGIN_VERSION = VersionCompare.forString("1.2");
    public static final VersionCompare LOWEST_JAR_PLUGIN_VERSION = VersionCompare.forString("1.1");
    public static final String RUNDECK_PLUGIN_NAME = "Rundeck-Plugin-Name";
    public static final String RUNDECK_PLUGIN_VERSION = "Rundeck-Plugin-Version";
    public static final String RUNDECK_PLUGIN_FILE_VERSION = "Rundeck-Plugin-File-Version";
    public static final String RUNDECK_PLUGIN_AUTHOR = "Rundeck-Plugin-Author";
    public static final String RUNDECK_PLUGIN_URL = "Rundeck-Plugin-URL";
    public static final String RUNDECK_PLUGIN_DATE = "Rundeck-Plugin-Date";
    public static final String RUNDECK_PLUGIN_LIBS_LOAD_FIRST = "Rundeck-Plugin-Libs-Load-First";
    public static final String CACHED_JAR_TIMESTAMP_FORMAT = "yyyyMMddHHmmssSSS";
    public static final String RUNDECK_PLUGIN_RUNDECK_COMPAT_VER = "Rundeck-Plugin-Rundeck-Compatibility-Version";
    public static final String RUNDECK_PLUGIN_DESCRIPTION = "Rundeck-Plugin-Description";
    public static final String RUNDECK_PLUGIN_LICENSE = "Rundeck-Plugin-License";
    public static final String RUNDECK_PLUGIN_TAGS = "Rundeck-Plugin-Tags";
    public static final String RUNDECK_PLUGIN_THIRD_PARTY_DEPS = "Rundeck-Plugin-Third-Party-Dependencies";
    public static final String RUNDECK_PLUGIN_SOURCE_LINK = "Rundeck-Plugin-Source-Link";
    public static final String RUNDECK_PLUGIN_TARGET_HOST_COMPAT = "Rundeck-Plugin-Target-Host-Compatibility";
    protected final File pluginJar;
    protected final File pluginJarCacheDirectory;
    protected final File cachedir;
    protected final boolean loadLibsFirst;
    private final DateFormat cachedJarTimestampFormatter = new SimpleDateFormat("yyyyMMddHHmmssSSS");
    private Map<ProviderIdent, Class> pluginProviderDefs = new HashMap<ProviderIdent, Class>();
    private AtomicInteger loadCount = new AtomicInteger();
    private final Closeable dereferencer = new Closeable(){

        @Override
        public void close() throws IOException {
            JarPluginProviderLoader.this.removeReference();
        }
    };
    Attributes mainAttributes;
    String pluginId;
    private Map<String, Class<?>> classCache = new HashMap();
    static final AtomicLong counter = new AtomicLong(0L);
    protected CachedJar cachedJar;
    protected Date loadedDate = null;
    private boolean closed = false;
    private boolean expired = false;

    public JarPluginProviderLoader(File pluginJar, File pluginJarCacheDirectory, File cachedir) {
        this(pluginJar, pluginJarCacheDirectory, cachedir, true);
    }

    public JarPluginProviderLoader(File pluginJar, File pluginJarCacheDirectory, File cachedir, boolean loadLibsFirst) {
        if (null == pluginJar) {
            throw new NullPointerException("Expected non-null plugin jar argument.");
        }
        if (!pluginJar.exists()) {
            throw new IllegalArgumentException("File does not exist: " + pluginJar);
        }
        if (!pluginJar.isFile()) {
            throw new IllegalArgumentException("Not a file: " + pluginJar);
        }
        this.pluginJar = pluginJar;
        this.pluginJarCacheDirectory = pluginJarCacheDirectory;
        this.cachedir = cachedir;
        this.loadLibsFirst = loadLibsFirst;
    }

    @Override
    public boolean canLoadForService(FrameworkSupportService service) {
        return service instanceof JavaClassProviderLoadable;
    }

    private boolean supportsResources(String pluginVersion) {
        return VersionCompare.forString(pluginVersion).atLeast(SUPPORTS_RESOURCES_PLUGIN_VERSION);
    }

    @Override
    public List<String> listResources() throws PluginException, IOException {
        if (this.supportsResources(this.getPluginVersion())) {
            return this.getCachedJar().resourcesLoader.listResources();
        }
        return null;
    }

    @Override
    public InputStream openResourceStreamFor(String path) throws PluginException, IOException {
        if (this.supportsResources(this.getPluginVersion())) {
            return this.getCachedJar().resourcesLoader.openResourceStreamFor(path);
        }
        return null;
    }

    @Override
    public <T> CloseableProvider<T> loadCloseable(PluggableService<T> service, String providerName) throws ProviderLoaderException {
        this.addReference();
        return Closeables.closeableProvider(this.load(service, providerName), Closeables.closeOnce(this.dereferencer));
    }

    @Override
    public synchronized <T> T load(PluggableService<T> service, String providerName) throws ProviderLoaderException {
        Class cls;
        ProviderIdent ident = new ProviderIdent(service.getName(), providerName);
        JarPluginProviderLoader.debug("loadInstance for " + ident + ": " + this.pluginJar);
        if (null == this.pluginProviderDefs.get(ident)) {
            String[] strings;
            for (String classname : strings = this.getClassnames()) {
                try {
                    Class<?> cls2 = this.loadClass(classname);
                    if (!JarPluginProviderLoader.matchesProviderDeclaration(ident, cls2)) continue;
                    this.pluginProviderDefs.put(ident, cls2);
                }
                catch (PluginException e) {
                    log.error((Object)("Failed to load class from " + this.pluginJar + ": classname: " + classname + ": " + e.getMessage()));
                }
            }
        }
        if (null != (cls = this.pluginProviderDefs.get(ident))) {
            try {
                return JarPluginProviderLoader.createProviderForClass(service, cls);
            }
            catch (PluginException e) {
                throw new ProviderLoaderException(e, service.getName(), providerName);
            }
        }
        return null;
    }

    static boolean matchesProviderDeclaration(ProviderIdent ident, Class<?> cls) throws PluginException {
        Plugin annotation = JarPluginProviderLoader.getPluginMetadata(cls);
        return ((String)ident.getFirst()).equals(annotation.service()) && ((String)ident.getSecond()).equals(annotation.name());
    }

    static ProviderIdent getProviderDeclaration(Class<?> cls) throws PluginException {
        Plugin annotation = JarPluginProviderLoader.getPluginMetadata(cls);
        return new ProviderIdent(annotation.service(), annotation.name());
    }

    public String[] getClassnames() {
        Attributes attributes = this.getMainAttributes();
        if (null == attributes) {
            return null;
        }
        String value = attributes.getValue(RUNDECK_PLUGIN_CLASSNAMES);
        if (null == value) {
            return null;
        }
        return value.split(",");
    }

    private String getResourcesBasePath() {
        String dir;
        Attributes attributes = this.getMainAttributes();
        if (null != attributes && null != (dir = attributes.getValue(RUNDECK_PLUGIN_RESOURCES_DIR))) {
            return dir;
        }
        return RESOURCES_DIR_DEFAULT;
    }

    private List<String> getPluginResourcesList() {
        String value;
        Attributes attributes = this.getMainAttributes();
        if (null != attributes && null != (value = attributes.getValue(RUNDECK_PLUGIN_RESOURCES))) {
            return Arrays.asList(value.split(" *, *"));
        }
        return null;
    }

    @Override
    public String getPluginVersion() {
        Attributes mainAttributes = this.getMainAttributes();
        return mainAttributes.getValue(RUNDECK_PLUGIN_VERSION);
    }

    private Attributes getMainAttributes() {
        if (null == this.mainAttributes) {
            this.mainAttributes = JarPluginProviderLoader.getJarMainAttributes(this.pluginJar);
            String pluginName = this.mainAttributes.getValue(RUNDECK_PLUGIN_NAME);
            if (pluginName == null) {
                pluginName = this.mainAttributes.getValue(RUNDECK_PLUGIN_CLASSNAMES);
            }
            this.pluginId = PluginUtils.generateShaIdFromName(pluginName);
        }
        return this.mainAttributes;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Attributes getJarMainAttributes(File file) {
        JarPluginProviderLoader.debug("getJarMainAttributes: " + file);
        try (JarInputStream jarInputStream = new JarInputStream(new FileInputStream(file));){
            Attributes attributes = jarInputStream.getManifest().getMainAttributes();
            return attributes;
        }
        catch (IOException e) {
            return null;
        }
    }

    static <T, X extends T> T createProviderForClass(PluggableService<T> service, Class<X> cls) throws PluginException, ProviderCreationException {
        JarPluginProviderLoader.debug("Try loading provider " + cls.getName());
        if (!(service instanceof JavaClassProviderLoadable)) {
            return null;
        }
        JavaClassProviderLoadable loadable = (JavaClassProviderLoadable)((Object)service);
        Plugin annotation = JarPluginProviderLoader.getPluginMetadata(cls);
        String pluginname = annotation.name();
        if (!loadable.isValidProviderClass(cls)) {
            throw new PluginException("Class " + cls.getName() + " was not a valid plugin class for service: " + service.getName() + ". Expected class " + cls.getName() + ", with a public constructor with no parameter");
        }
        JarPluginProviderLoader.debug("Succeeded loading plugin " + cls.getName() + " for service: " + service.getName());
        return loadable.createProviderInstance(cls, pluginname);
    }

    private static void debug(String s) {
        if (log.isDebugEnabled()) {
            log.debug((Object)s);
        }
    }

    static Plugin getPluginMetadata(Class<?> cls) throws PluginException {
        if (!cls.isAnnotationPresent(Plugin.class)) {
            throw new PluginException("No Plugin annotation was found for the class: " + cls.getName());
        }
        Plugin annotation = cls.getAnnotation(Plugin.class);
        String pluginname = annotation.name();
        if (null == pluginname || "".equals(pluginname)) {
            throw new PluginException("Plugin annotation 'name' cannot be empty for the class: " + cls.getName());
        }
        String servicename = annotation.service();
        if (null == servicename || "".equals(servicename)) {
            throw new PluginException("Plugin annotation 'service' cannot be empty for the class: " + cls.getName());
        }
        return annotation;
    }

    protected boolean isEquivalentPluginJar(File other) {
        return other.getName().replaceFirst("\\d+-\\d+-", "").equals(this.pluginJar.getName());
    }

    protected String generateCachedJarIdentity() {
        Date mtime = new Date(this.pluginJar.lastModified());
        return String.format("%s-%d", this.cachedJarTimestampFormatter.format(mtime), counter.getAndIncrement());
    }

    protected String generateCachedJarName(String ident) {
        return String.format("%s-%s", ident, this.pluginJar.getName());
    }

    protected File generateCachedJarDir(String ident) {
        File dir = new File(this.getFileCacheDir(), ident);
        if (!dir.mkdirs()) {
            JarPluginProviderLoader.debug("Could not create dir for cachedjar libs: " + dir);
        }
        return dir;
    }

    protected File createCachedJar(File dir, String jarName) throws PluginException {
        File cachedJar;
        try {
            cachedJar = new File(dir, jarName);
            cachedJar.deleteOnExit();
            FileUtils.fileCopy(this.pluginJar, cachedJar, true);
        }
        catch (IOException e) {
            throw new PluginException(e);
        }
        return cachedJar;
    }

    private Class<?> loadClass(String classname) throws PluginException {
        Class<?> cls;
        if (null == classname) {
            throw new IllegalArgumentException("A null java class name was specified.");
        }
        if (null != this.classCache.get(classname)) {
            return this.classCache.get(classname);
        }
        CachedJar cachedJar1 = this.getCachedJar();
        JarPluginProviderLoader.debug("loadClass! " + classname + ": " + cachedJar1.getCachedJar());
        URLClassLoader urlClassLoader = cachedJar1.getClassLoader();
        try {
            cls = Class.forName(classname, true, urlClassLoader);
            this.classCache.put(classname, cls);
        }
        catch (ClassNotFoundException e) {
            throw new PluginException("Class not found: " + classname, e);
        }
        catch (Throwable t) {
            throw new PluginException("Error loading class: " + classname, t);
        }
        return cls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized CachedJar getCachedJar() throws PluginException {
        if (null == this.cachedJar) {
            JarPluginProviderLoader jarPluginProviderLoader = this;
            synchronized (jarPluginProviderLoader) {
                if (null == this.cachedJar) {
                    this.loadedDate = new Date();
                    String itemIdent = this.generateCachedJarIdentity();
                    String jarName = this.generateCachedJarName(itemIdent);
                    File dir = this.generateCachedJarDir(itemIdent);
                    File cachedJar = this.createCachedJar(dir, jarName);
                    Collection<File> extlibs = null;
                    try {
                        extlibs = this.extractDependentLibs(dir);
                    }
                    catch (IOException e) {
                        throw new PluginException("Unable to expand plugin libs: " + e.getMessage(), e);
                    }
                    ZipResourceLoader loader = null;
                    if (this.supportsResources(this.getPluginVersion())) {
                        loader = new ZipResourceLoader(new File(dir, RESOURCES_DIR_DEFAULT), cachedJar, this.getPluginResourcesList(), this.getResourcesBasePath());
                        try {
                            loader.extractResources();
                        }
                        catch (IOException e) {
                            throw new PluginException("Unable to expand plugin resources: " + e.getMessage(), e);
                        }
                    }
                    this.cachedJar = new CachedJar(dir, cachedJar, extlibs, loader);
                }
            }
        }
        return this.cachedJar;
    }

    protected Collection<File> extractDependentLibs(File cachedir) throws IOException {
        Attributes attributes = this.getMainAttributes();
        if (null == attributes) {
            JarPluginProviderLoader.debug("no manifest attributes");
            return null;
        }
        ArrayList<File> files = new ArrayList<File>();
        String libs = attributes.getValue(RUNDECK_PLUGIN_LIBS);
        if (null != libs) {
            JarPluginProviderLoader.debug("jar libs listed: " + libs + " for file: " + this.pluginJar);
            if (!cachedir.isDirectory() && !cachedir.mkdirs()) {
                JarPluginProviderLoader.debug("Failed to create cachedJar dir for dependent libs: " + cachedir);
            }
            String[] libsarr = libs.split(" ");
            this.extractJarContents(libsarr, cachedir);
            for (String s : libsarr) {
                File libFile = new File(cachedir, s);
                libFile.deleteOnExit();
                files.add(libFile);
            }
        } else {
            JarPluginProviderLoader.debug("no jar libs listed in manifest: " + this.pluginJar);
        }
        return files;
    }

    private void extractJarContents(String[] entries, File destdir) throws IOException {
        if (!destdir.exists() && !destdir.mkdir()) {
            log.warn((Object)("Unable to create cache dir for plugin: " + destdir.getAbsolutePath()));
        }
        JarPluginProviderLoader.debug("extracting lib files from jar: " + this.pluginJar);
        for (String path : entries) {
            JarPluginProviderLoader.debug("Expand zip " + this.pluginJar.getAbsolutePath() + " to dir: " + destdir + ", file: " + path);
            ZipUtil.extractZipFile(this.pluginJar.getAbsolutePath(), destdir, path);
        }
    }

    String getFileBasename() {
        return JarPluginProviderLoader.basename(this.pluginJar);
    }

    private static String basename(File file) {
        String name = file.getName();
        if (name.contains(".")) {
            return name.substring(0, name.lastIndexOf("."));
        }
        return name;
    }

    File getFileCacheDir() {
        return new File(this.cachedir, this.getFileBasename());
    }

    @Override
    public synchronized boolean isLoaderFor(ProviderIdent ident) {
        String[] strings;
        for (String classname : strings = this.getClassnames()) {
            try {
                if (!JarPluginProviderLoader.matchesProviderDeclaration(ident, this.loadClass(classname))) continue;
                return true;
            }
            catch (PluginException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    @Override
    public synchronized List<ProviderIdent> listProviders() {
        String[] strings;
        ArrayList<ProviderIdent> providerIdents = new ArrayList<ProviderIdent>();
        for (String classname : strings = this.getClassnames()) {
            try {
                providerIdents.add(JarPluginProviderLoader.getProviderDeclaration(this.loadClass(classname)));
            }
            catch (PluginException e) {
                e.printStackTrace();
            }
        }
        return providerIdents;
    }

    private synchronized int addReference() {
        return this.loadCount.incrementAndGet();
    }

    private synchronized int removeReference() {
        int i = this.loadCount.decrementAndGet();
        JarPluginProviderLoader.debug(String.format("removeReference for: %s (loadCount: %d)", this.pluginJar, i));
        if (i <= 0 && this.isExpired()) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        JarPluginProviderLoader.debug(String.format("close jar provider loader for: %s", this.pluginJar));
        JarPluginProviderLoader jarPluginProviderLoader = this;
        synchronized (jarPluginProviderLoader) {
            this.closed = true;
        }
        if (null != this.cachedJar) {
            this.cachedJar.close();
            this.classCache.clear();
            this.cachedJar = null;
        }
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    public synchronized boolean isExpired() {
        return this.expired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void expire() {
        JarPluginProviderLoader jarPluginProviderLoader = this;
        synchronized (jarPluginProviderLoader) {
            this.expired = true;
        }
        int i = this.loadCount.get();
        JarPluginProviderLoader.debug(String.format("expire jar provider loader for: %s (loadCount: %d)", this.pluginJar, i));
        if (i <= 0) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JarPluginProviderLoader that = (JarPluginProviderLoader)o;
        if (this.classCache != null ? !this.classCache.equals(that.classCache) : that.classCache != null) {
            return false;
        }
        if (!this.pluginJar.equals(that.pluginJar)) {
            return false;
        }
        if (this.mainAttributes != null ? !this.mainAttributes.equals(that.mainAttributes) : that.mainAttributes != null) {
            return false;
        }
        return !(this.pluginProviderDefs != null ? !this.pluginProviderDefs.equals(that.pluginProviderDefs) : that.pluginProviderDefs != null);
    }

    public int hashCode() {
        int result = this.pluginJar.hashCode();
        result = 31 * result + (this.pluginProviderDefs != null ? this.pluginProviderDefs.hashCode() : 0);
        result = 31 * result + (this.mainAttributes != null ? this.mainAttributes.hashCode() : 0);
        result = 31 * result + (this.classCache != null ? this.classCache.hashCode() : 0);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isValidJarPlugin(File file) {
        try (JarInputStream jarInputStream = new JarInputStream(new FileInputStream(file));){
            Manifest manifest = jarInputStream.getManifest();
            if (null == manifest) {
                boolean bl = false;
                return bl;
            }
            Attributes mainAttributes = manifest.getMainAttributes();
            JarPluginProviderLoader.validateJarManifest(mainAttributes);
            return true;
        }
        catch (InvalidManifestException | IOException e) {
            log.error((Object)(file.getAbsolutePath() + ": " + e.getMessage()));
            return false;
        }
    }

    static void validateJarManifest(Attributes mainAttributes) throws InvalidManifestException {
        String value1 = mainAttributes.getValue(RUNDECK_PLUGIN_ARCHIVE);
        String plugvers = mainAttributes.getValue(RUNDECK_PLUGIN_VERSION);
        String plugclassnames = mainAttributes.getValue(RUNDECK_PLUGIN_CLASSNAMES);
        if (null == value1) {
            throw new InvalidManifestException("Jar plugin manifest attribute missing: Rundeck-Plugin-Archive");
        }
        if (!"true".equals(value1)) {
            throw new InvalidManifestException("Rundeck-Plugin-Archive was not 'true': " + value1);
        }
        if (null == plugvers) {
            throw new InvalidManifestException("Jar plugin manifest attribute missing: Rundeck-Plugin-Version");
        }
        VersionCompare pluginVersion = VersionCompare.forString(plugvers);
        if (!pluginVersion.atLeast(LOWEST_JAR_PLUGIN_VERSION)) {
            throw new InvalidManifestException("Unsupported plugin version: Rundeck-Plugin-Version: " + plugvers);
        }
        if (null == plugclassnames) {
            throw new InvalidManifestException("Jar plugin manifest attribute missing: Rundeck-Plugin-Classnames");
        }
        if (plugvers.equals(JAR_PLUGIN_VERSION_2_0)) {
            String pluginName = mainAttributes.getValue(RUNDECK_PLUGIN_NAME);
            if (pluginName == null) {
                throw new InvalidManifestException("Jar plugin manifest attribute missing: Rundeck-Plugin-Name");
            }
            String rundeckCompat = mainAttributes.getValue(RUNDECK_PLUGIN_RUNDECK_COMPAT_VER);
            if (rundeckCompat == null) {
                throw new InvalidManifestException("Jar plugin manifest attribute missing: Rundeck-Plugin-Rundeck-Compatibility-Version");
            }
            ArrayList<String> errors = new ArrayList<String>();
            PluginValidation.State state = PluginMetadataValidator.validateRundeckCompatibility(errors, rundeckCompat);
            if (!state.isValid()) {
                throw new InvalidManifestException(String.join((CharSequence)"\n", errors));
            }
        }
    }

    static String getVersionForFile(File file) {
        return JarPluginProviderLoader.loadManifestAttribute(file, RUNDECK_PLUGIN_FILE_VERSION);
    }

    static boolean getLoadLocalLibsFirstForFile(File file) {
        Attributes attributes = JarPluginProviderLoader.loadMainAttributes(file);
        if (null == attributes) {
            return false;
        }
        boolean loadFirstDefault = true;
        String loadFirst = attributes.getValue(RUNDECK_PLUGIN_LIBS_LOAD_FIRST);
        if (null != loadFirst) {
            return Boolean.valueOf(loadFirst);
        }
        return loadFirstDefault;
    }

    private static Attributes loadMainAttributes(File file) {
        Attributes mainAttributes = null;
        try (JarInputStream jarInputStream = new JarInputStream(new FileInputStream(file));){
            Manifest manifest = jarInputStream.getManifest();
            if (null != manifest) {
                mainAttributes = manifest.getMainAttributes();
            }
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            log.warn((Object)(e.getMessage() + ": " + file.getAbsolutePath()));
        }
        return mainAttributes;
    }

    private static String loadManifestAttribute(File file, String attribute) {
        String value = null;
        Attributes mainAttributes = JarPluginProviderLoader.loadMainAttributes(file);
        if (null != mainAttributes) {
            value = mainAttributes.getValue(attribute);
        }
        return value;
    }

    @Override
    public String getFilename() {
        return this.pluginJar.getName();
    }

    @Override
    public File getFile() {
        return this.pluginJar;
    }

    @Override
    public String getPluginArtifactName() {
        Attributes mainAttributes = this.getMainAttributes();
        String name = mainAttributes.getValue(RUNDECK_PLUGIN_NAME);
        return name != null ? name : this.pluginJar.getName();
    }

    @Override
    public String getPluginAuthor() {
        Attributes mainAttributes = this.getMainAttributes();
        return mainAttributes.getValue(RUNDECK_PLUGIN_AUTHOR);
    }

    @Override
    public String getPluginFileVersion() {
        Attributes mainAttributes = this.getMainAttributes();
        String version = mainAttributes.getValue(RUNDECK_PLUGIN_FILE_VERSION);
        return version != null ? version : "1.0.0";
    }

    @Override
    public String getPluginUrl() {
        Attributes mainAttributes = this.getMainAttributes();
        return mainAttributes.getValue(RUNDECK_PLUGIN_URL);
    }

    @Override
    public Date getPluginDate() {
        Attributes mainAttributes = this.getMainAttributes();
        String value = mainAttributes.getValue(RUNDECK_PLUGIN_DATE);
        if (null != value) {
            try {
                return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX").parse(value);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public Date getDateLoaded() {
        return this.loadedDate;
    }

    @Override
    public String getPluginName() {
        return this.getPluginArtifactName();
    }

    @Override
    public String getPluginDescription() {
        Attributes mainAttributes = this.getMainAttributes();
        return mainAttributes.getValue(RUNDECK_PLUGIN_DESCRIPTION);
    }

    @Override
    public String getPluginId() {
        this.getMainAttributes();
        return this.pluginId;
    }

    @Override
    public String getRundeckCompatibilityVersion() {
        Attributes mainAttributes = this.getMainAttributes();
        return mainAttributes.getValue(RUNDECK_PLUGIN_RUNDECK_COMPAT_VER);
    }

    @Override
    public String getTargetHostCompatibility() {
        Attributes mainAttributes = this.getMainAttributes();
        String hostCompat = mainAttributes.getValue(RUNDECK_PLUGIN_TARGET_HOST_COMPAT);
        if (hostCompat == null) {
            hostCompat = "all";
        }
        return hostCompat;
    }

    @Override
    public List<String> getTags() {
        Attributes mainAttributes = this.getMainAttributes();
        String tagString = mainAttributes.getValue(RUNDECK_PLUGIN_TAGS);
        List<String> tags = new ArrayList<String>();
        if (tagString != null) {
            tags = Arrays.asList(tagString.split(","));
        }
        return tags;
    }

    @Override
    public String getPluginLicense() {
        Attributes mainAttributes = this.getMainAttributes();
        return mainAttributes.getValue(RUNDECK_PLUGIN_LICENSE);
    }

    @Override
    public String getPluginThirdPartyDependencies() {
        Attributes mainAttributes = this.getMainAttributes();
        return mainAttributes.getValue(RUNDECK_PLUGIN_THIRD_PARTY_DEPS);
    }

    @Override
    public String getPluginSourceLink() {
        Attributes mainAttributes = this.getMainAttributes();
        return mainAttributes.getValue(RUNDECK_PLUGIN_SOURCE_LINK);
    }

    @Override
    public String getPluginType() {
        return "jar";
    }

    protected class CachedJar
    implements Closeable {
        private File dir;
        private File cachedJar;
        private Collection<File> depLibs;
        private URLClassLoader classLoader;
        private PluginResourceLoader resourcesLoader;

        public File getDir() {
            return this.dir;
        }

        public File getCachedJar() {
            return this.cachedJar;
        }

        public CachedJar(File dir, File cachedJar, Collection<File> depLibs, PluginResourceLoader resourcesLoader) throws PluginException {
            this.dir = dir;
            this.cachedJar = cachedJar;
            this.depLibs = depLibs;
            this.resourcesLoader = resourcesLoader;
        }

        public Collection<File> getDepLibs() {
            return this.depLibs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public URLClassLoader getClassLoader() throws PluginException {
            if (null == this.classLoader) {
                CachedJar cachedJar = this;
                synchronized (cachedJar) {
                    if (null == this.classLoader) {
                        this.classLoader = this.buildClassLoader();
                    }
                }
            }
            return this.classLoader;
        }

        private URLClassLoader buildClassLoader() throws PluginException {
            ClassLoader parent = JarPluginProviderLoader.class.getClassLoader();
            try {
                URL[] urlarray;
                URL url = this.getCachedJar().toURI().toURL();
                if (null != this.getDepLibs() && this.getDepLibs().size() > 0) {
                    ArrayList<URL> urls = new ArrayList<URL>();
                    urls.add(url);
                    for (File extlib : this.getDepLibs()) {
                        urls.add(extlib.toURI().toURL());
                    }
                    urlarray = urls.toArray(new URL[urls.size()]);
                } else {
                    urlarray = new URL[]{url};
                }
                URLClassLoader loaded = JarPluginProviderLoader.this.loadLibsFirst ? LocalFirstClassLoader.newInstance(urlarray, parent) : URLClassLoader.newInstance(urlarray, parent);
                return loaded;
            }
            catch (MalformedURLException e) {
                throw new PluginException("Error creating classloader for " + this.cachedJar, e);
            }
        }

        @Override
        public void close() throws IOException {
            JarPluginProviderLoader.debug(String.format("Jar plugin closing cached jar: %s", this.cachedJar));
            if (null != this.classLoader) {
                try {
                    JarPluginProviderLoader.debug("expire classLoaders for: " + this.cachedJar);
                    this.classLoader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            JarPluginProviderLoader.debug("remove cache dir on exit: " + this.dir);
            FileUtils.deleteDir(this.dir);
        }
    }

    static class InvalidManifestException
    extends Exception {
        public InvalidManifestException(String s) {
            super(s);
        }
    }
}

