/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.resources;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.INodeSet;
import com.dtolabs.rundeck.core.plugins.ScriptDataContextUtil;
import com.dtolabs.rundeck.core.plugins.configuration.Configurable;
import com.dtolabs.rundeck.core.plugins.configuration.ConfigurationException;
import com.dtolabs.rundeck.core.plugins.configuration.Description;
import com.dtolabs.rundeck.core.plugins.configuration.Property;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyValidator;
import com.dtolabs.rundeck.core.plugins.configuration.ValidationException;
import com.dtolabs.rundeck.core.resources.ResourceModelSource;
import com.dtolabs.rundeck.core.resources.ResourceModelSourceException;
import com.dtolabs.rundeck.core.resources.ScriptResourceUtil;
import com.dtolabs.rundeck.plugins.util.DescriptionBuilder;
import com.dtolabs.rundeck.plugins.util.PropertyBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ScriptResourceModelSource
implements Configurable,
ResourceModelSource {
    static Logger logger = Logger.getLogger((String)ScriptResourceModelSource.class.getName());
    static ArrayList<Property> scriptResourceProperties = new ArrayList();
    public static final String CONFIG_FILE = "file";
    public static final String CONFIG_INTERPRETER = "interpreter";
    public static final String CONFIG_ARGS = "args";
    public static final String CONFIG_INTERPRETER_ARGS_QUOTED = "argsQuoted";
    public static final String CONFIG_FORMAT = "format";
    public static final PropertyValidator FILE_VALIDATOR = new PropertyValidator(){

        @Override
        public boolean isValid(String value) throws ValidationException {
            return new File(value).isFile();
        }
    };
    private String format;
    private File scriptFile;
    private String interpreter;
    private String args;
    private boolean interpreterArgsQuoted;
    private String project;
    HashMap<String, Map<String, String>> configDataContext;
    Map<String, Map<String, String>> executionDataContext;
    private Framework framework;

    static Description createDescription(List<String> formats) {
        return DescriptionBuilder.builder().name("script").title("Script").description("Run a script to produce resource model data").property(PropertyBuilder.builder().freeSelect(CONFIG_FORMAT).title("Resource Format").description("Resources document format that the script will produce").required(true).values(formats).build()).property(PropertyBuilder.builder().string(CONFIG_FILE).title("Script File Path").description("Path to script file to execute").required(true).validator(FILE_VALIDATOR).build()).property(PropertyBuilder.builder().string(CONFIG_INTERPRETER).title("Interpreter").description("Command interpreter to use (optional)").build()).property(PropertyBuilder.builder().string(CONFIG_ARGS).title("Arguments").description("Arguments to pass to the script (optional)").build()).property(PropertyBuilder.builder().booleanType(CONFIG_INTERPRETER_ARGS_QUOTED).title("Quote Interpreter Args").description("If true, pass script file and args as a single argument to interpreter, otherwise, pass as multiple arguments").defaultValue("false").build()).metadata("faicon", "file-alt").build();
    }

    public ScriptResourceModelSource(Framework framework) {
        this.framework = framework;
    }

    @Override
    public void configure(Properties configuration) throws ConfigurationException {
        if (!configuration.containsKey("project")) {
            throw new ConfigurationException("project is required");
        }
        this.project = configuration.getProperty("project");
        if (!configuration.containsKey(CONFIG_FILE)) {
            throw new ConfigurationException("file is required");
        }
        this.scriptFile = new File(configuration.getProperty(CONFIG_FILE));
        if (!this.scriptFile.isFile()) {
            throw new ConfigurationException("file does not exist or is not a file: " + this.scriptFile.getAbsolutePath());
        }
        this.interpreter = configuration.getProperty(CONFIG_INTERPRETER);
        this.args = configuration.getProperty(CONFIG_ARGS);
        if (!configuration.containsKey(CONFIG_FORMAT)) {
            throw new ConfigurationException("format is required");
        }
        this.format = configuration.getProperty(CONFIG_FORMAT);
        this.interpreterArgsQuoted = Boolean.parseBoolean(configuration.getProperty(CONFIG_INTERPRETER_ARGS_QUOTED));
        this.configDataContext = new HashMap();
        HashMap<String, String> configdata = new HashMap<String, String>();
        configdata.put("project", this.project);
        this.configDataContext.put("context", configdata);
        this.executionDataContext = ScriptDataContextUtil.createScriptDataContextObjectForProject(this.framework, this.project);
        this.executionDataContext.putAll(this.configDataContext);
    }

    @Override
    public INodeSet getNodes() throws ResourceModelSourceException {
        try {
            return ScriptResourceUtil.executeScript(this.scriptFile, this.args, null, this.interpreter, "script", this.executionDataContext, this.format, this.framework, this.project, logger, this.interpreterArgsQuoted);
        }
        catch (ResourceModelSourceException e) {
            throw new ResourceModelSourceException("failed to execute: " + this.scriptFile + ": " + e.getMessage(), e);
        }
    }

    public String toString() {
        return "ScriptResourceModelSource{scriptFile=" + this.scriptFile + ", format='" + this.format + '\'' + '}';
    }
}

