/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.authorization;

import com.dtolabs.rundeck.core.authorization.Attribute;
import com.dtolabs.rundeck.core.authorization.providers.EnvironmentalContext;
import java.net.URI;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class BasicEnvironmentalContext
implements EnvironmentalContext {
    private String key;
    private String value;
    Pattern valuePattern;
    private URI keyUri;

    private BasicEnvironmentalContext(String key, String value, Pattern valuePattern) {
        this.key = key;
        this.value = value;
        this.valuePattern = valuePattern;
        this.keyUri = URI.create("rundeck:auth:env:" + key);
    }

    public static BasicEnvironmentalContext patternContextFor(String key, String value) {
        if (null == key) {
            throw new IllegalArgumentException("key cannot be null");
        }
        if (null == value) {
            throw new IllegalArgumentException("value cannot be null");
        }
        try {
            return new BasicEnvironmentalContext(key, value, Pattern.compile(value));
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return new BasicEnvironmentalContext(key, value, null);
        }
    }

    public static BasicEnvironmentalContext staticContextFor(String key, String value) {
        if (null == key) {
            throw new IllegalArgumentException("key cannot be null");
        }
        if (null == value) {
            throw new IllegalArgumentException("value cannot be null");
        }
        return new BasicEnvironmentalContext(key, value, null);
    }

    @Override
    public boolean matches(Set<Attribute> environment) {
        if (environment.size() != 1) {
            return false;
        }
        Attribute next = environment.iterator().next();
        if (next.getProperty().equals(this.getKeyUri())) {
            if (this.getValue().equals(next.getValue())) {
                return true;
            }
            if (null != this.valuePattern && this.valuePattern.matcher(next.getValue()).matches()) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "{" + this.getKey() + "='" + this.getValue() + "'}";
    }

    @Override
    public boolean isValid() {
        return true;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public URI getKeyUri() {
        return this.keyUri;
    }
}

