/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.common;

import com.dtolabs.rundeck.core.common.IFramework;
import com.dtolabs.rundeck.core.common.IRundeckProject;
import com.dtolabs.rundeck.core.common.PluginControlService;
import com.dtolabs.rundeck.core.common.PluginDisabledException;
import com.dtolabs.rundeck.core.plugins.configuration.Description;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class PluginControlServiceImpl
implements PluginControlService {
    public static final String DISABLED_PLUGINS = "disabled.plugins";
    private final IFramework framework;
    private final String projectName;

    private PluginControlServiceImpl(IFramework framework, String project) {
        this.framework = framework;
        this.projectName = project;
    }

    public static PluginControlService forProject(IFramework framework, String project) {
        return new PluginControlServiceImpl(framework, project);
    }

    @Override
    public List<String> listDisabledPlugins() {
        String disabledPlugins;
        IRundeckProject frameworkProject = this.framework.getFrameworkProjectMgr().getFrameworkProject(this.projectName);
        String string = disabledPlugins = frameworkProject.hasProperty(DISABLED_PLUGINS) ? frameworkProject.getProperty(DISABLED_PLUGINS) : null;
        if (disabledPlugins != null && !disabledPlugins.trim().isEmpty()) {
            return Arrays.asList(disabledPlugins.split("\\s*,\\s*"));
        }
        return new ArrayList<String>();
    }

    @Override
    public List<Description> filterEnabledPlugins(List<Description> plugins, String serviceName) {
        List<String> strings = this.listDisabledPlugins();
        return plugins.stream().filter(description -> !strings.contains(serviceName + ":" + description.getName())).collect(Collectors.toList());
    }

    @Override
    public Predicate<String> enabledPredicateForService(String serviceName) {
        List<String> strings = this.listDisabledPlugins();
        return name -> !strings.contains(serviceName + ":" + name);
    }

    @Override
    public Predicate<String> disabledPredicateForService(String serviceName) {
        return this.enabledPredicateForService(serviceName).negate();
    }

    @Override
    public boolean isDisabledPlugin(String pluginName, String serviceName) {
        List<String> disabledPluginsList = this.listDisabledPlugins();
        return disabledPluginsList.contains(serviceName + ":" + pluginName);
    }

    @Override
    public void checkDisabledPlugin(String pluginName, String serviceName) throws PluginDisabledException {
        if (this.isDisabledPlugin(pluginName, serviceName)) {
            throw new PluginDisabledException(String.format("%s Plugin '%s' is disabled", serviceName, pluginName));
        }
    }
}

