/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.rules;

import com.dtolabs.rundeck.core.data.DataContext;
import com.dtolabs.rundeck.core.dispatcher.ContextView;
import com.dtolabs.rundeck.core.execution.workflow.WFSharedContext;
import com.dtolabs.rundeck.core.rules.DataState;
import com.dtolabs.rundeck.core.rules.Rules;
import com.dtolabs.rundeck.core.rules.StateObj;
import com.dtolabs.rundeck.core.rules.StateWorkflowSystem;
import com.dtolabs.rundeck.core.rules.WorkflowEngine;
import com.dtolabs.rundeck.core.rules.WorkflowSystem;
import com.dtolabs.rundeck.core.rules.WorkflowSystemEventHandler;
import com.dtolabs.rundeck.core.rules.WorkflowSystemEventType;
import com.dtolabs.rundeck.core.rules.Workflows;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Consumer;
import java.util.stream.Collectors;

class WorkflowEngineOperationsProcessor<DAT, RES extends WorkflowSystem.OperationCompleted<DAT>, OP extends WorkflowSystem.Operation<DAT, RES>> {
    private StateWorkflowSystem workflowEngine;
    private WorkflowSystemEventHandler eventHandler;
    private final Set<OP> operations;
    private final WorkflowSystem.SharedData<DAT> sharedData;
    private final Set<WorkflowSystem.Operation> inProcess = Collections.synchronizedSet(new HashSet());
    private final Set<WorkflowSystem.Operation> skipped = new HashSet<WorkflowSystem.Operation>();
    private final Set<OP> pending;
    private volatile boolean interrupted;
    private final ListeningExecutorService executorService;
    private final ListeningExecutorService manager;
    private final LinkedBlockingQueue<WorkflowSystem.OperationCompleted<DAT>> stateChangeQueue = new LinkedBlockingQueue();
    private final Set<WorkflowSystem.OperationResult<DAT, RES, OP>> results = Collections.synchronizedSet(new HashSet());
    private final List<ListenableFuture<RES>> futures = new ArrayList<ListenableFuture<RES>>();
    private WorkflowEngine.Sleeper sleeper = new WorkflowEngine.Sleeper();
    private boolean endStateBreak = Boolean.parseBoolean(System.getProperty("WorkflowEngineOperationsProcessor.endStateBreak", "false"));
    private boolean endStateCancel = Boolean.parseBoolean(System.getProperty("WorkflowEngineOperationsProcessor.endStateCancel", "false"));
    private boolean endStateCancelInterrupt = Boolean.parseBoolean(System.getProperty("WorkflowEngineOperationsProcessor.endStateCancelInterrupt", "false"));

    public WorkflowEngineOperationsProcessor(StateWorkflowSystem workflowEngine, WorkflowSystemEventHandler eventHandler, Set<OP> operations, WorkflowSystem.SharedData<DAT> sharedData, ListeningExecutorService executorService, ListeningExecutorService manager) {
        this.workflowEngine = workflowEngine;
        this.eventHandler = eventHandler;
        this.operations = operations;
        this.sharedData = sharedData;
        this.pending = new HashSet<OP>(operations);
        this.executorService = executorService;
        this.manager = manager;
    }

    public void beginProcessing() {
        this.eventHandler.event(WorkflowSystemEventType.Begin, "Workflow begin");
        this.initialize();
        this.continueProcessing();
    }

    private void continueProcessing() {
        boolean cancel = false;
        boolean cancelInterrupt = false;
        try {
            while (!Thread.currentThread().isInterrupted()) {
                HashMap<String, String> changes = new HashMap<String, String>();
                this.getAvailableChanges(changes);
                if (changes.isEmpty()) {
                    if (this.detectNoMoreChanges()) {
                        this.eventHandler.event(WorkflowSystemEventType.EndOfChanges, "No more state changes expected, finishing workflow.");
                        return;
                    }
                    if (Thread.currentThread().isInterrupted()) break;
                    this.waitForChanges(changes);
                }
                if (changes.isEmpty()) continue;
                this.getContextGlobalData(changes);
                this.processStateChanges(changes);
                if (this.workflowEngine.isWorkflowEndState()) {
                    this.eventHandler.event(WorkflowSystemEventType.WorkflowEndState, "Workflow end state reached.");
                    if (this.endStateBreak) {
                        cancel = this.endStateCancel;
                        cancelInterrupt = this.endStateCancelInterrupt;
                        break;
                    }
                    return;
                }
                this.processOperations(this.results::add);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (Thread.currentThread().isInterrupted()) {
            this.eventHandler.event(WorkflowSystemEventType.Interrupted, "Engine interrupted, stopping engine...");
            this.cancelFutures(true);
            this.interrupted = Thread.interrupted();
        } else if (cancel) {
            this.cancelFutures(cancelInterrupt);
        }
        this.awaitFutures();
    }

    boolean detectNoMoreChanges() {
        return this.inProcess.isEmpty() && this.stateChangeQueue.isEmpty();
    }

    private void getAvailableChanges(Map<String, String> changes) {
        WorkflowSystem.OperationCompleted<DAT> task = this.stateChangeQueue.poll();
        while (task != null && task.getNewState() != null) {
            changes.putAll(task.getNewState().getState());
            DAT result = task.getResult();
            if (null != this.sharedData && null != result) {
                this.sharedData.addData(result);
            }
            task = this.stateChangeQueue.poll();
        }
    }

    private void getContextGlobalData(Map<String, String> changes) {
        DataContext globals;
        Object inputData;
        Object v0 = inputData = null != this.sharedData ? this.sharedData.produceNext() : null;
        if (inputData != null && inputData instanceof WFSharedContext && null != (globals = (DataContext)((WFSharedContext)inputData).getData().get(ContextView.global()))) {
            HashMap stringStringHashMap = new HashMap();
            for (String s : globals.keySet()) {
                Map map = (Map)globals.get(s);
                for (String key : map.keySet()) {
                    if (this.workflowEngine.getState().getState().containsKey(s + "." + key) && this.workflowEngine.getState().getState().get(s + "." + key).equals(map.get(key))) continue;
                    stringStringHashMap.put(s + "." + key, map.get(key));
                }
            }
            changes.putAll(stringStringHashMap);
        }
    }

    private void awaitFutures() {
        if (!this.inProcess.isEmpty()) {
            for (ListenableFuture<RES> future : this.futures) {
                try {
                    future.get();
                }
                catch (InterruptedException | CancellationException | ExecutionException exception) {}
            }
        }
    }

    private void cancelFutures(boolean mayInterruptIfRunning) {
        this.futures.forEach(future -> future.cancel(mayInterruptIfRunning));
    }

    public void initialize() {
        this.stateChangeQueue.add(WorkflowEngine.dummyResult(Workflows.getWorkflowStartState()));
    }

    private void processRunnableOperations(Consumer<WorkflowSystem.OperationResult<DAT, RES, OP>> resultConsumer, List<OP> shouldrun, List<OP> shouldskip, DAT inputData) {
        for (WorkflowSystem.Operation operation : shouldrun) {
            if (shouldskip.contains(operation)) continue;
            this.pending.remove(operation);
            this.eventHandler.event(WorkflowSystemEventType.WillRunOperation, String.format("operation starting: %s", operation), operation);
            ListenableFuture<RES> submit = this.beginOperation(inputData, operation);
            OperationFutureCallback callback = new OperationFutureCallback(this, this.eventHandler, operation, resultConsumer);
            Futures.addCallback(submit, (FutureCallback)callback, (Executor)this.manager);
        }
    }

    private ListenableFuture<RES> beginOperation(DAT inputData, OP operation) {
        ListenableFuture submit = this.executorService.submit(() -> (WorkflowSystem.OperationCompleted)operation.apply(inputData));
        this.inProcess.add((WorkflowSystem.Operation)operation);
        this.futures.add(submit);
        return submit;
    }

    private void finishedOperation(WorkflowSystem.OperationCompleted<DAT> e, OP operation) {
        this.stateChangeQueue.add(e);
        this.inProcess.remove(operation);
    }

    private <D, T extends WorkflowSystem.OperationCompleted<D>, X extends WorkflowSystem.Operation<D, T>> WorkflowSystem.OperationResult<D, T, X> result(Throwable t, X operation) {
        return new WorkflowEngine.WResult(operation, t);
    }

    private <D, T extends WorkflowSystem.OperationCompleted<D>, X extends WorkflowSystem.Operation<D, T>> WorkflowSystem.OperationResult<D, T, X> result(T successResult, X operation) {
        return new WorkflowEngine.WResult(operation, successResult);
    }

    private void waitForChanges(Map<String, String> changes) throws InterruptedException {
        WorkflowSystem.OperationCompleted<DAT> take = this.stateChangeQueue.poll(this.sleeper.time(), this.sleeper.unit());
        if (null == take || take.getNewState().getState().isEmpty()) {
            this.sleeper.backoff();
            return;
        }
        this.sleeper.reset();
        changes.putAll(take.getNewState().getState());
        if (null != this.sharedData) {
            this.sharedData.addData(take.getResult());
        }
        this.getAvailableChanges(changes);
    }

    private void processStateChanges(Map<String, String> changes) {
        this.eventHandler.event(WorkflowSystemEventType.WillProcessStateChange, String.format("saw state changes: %s", changes), changes);
        this.workflowEngine.getState().updateState(changes);
        boolean update = Rules.update(this.workflowEngine.getRuleEngine(), this.workflowEngine.getState());
        this.eventHandler.event(WorkflowSystemEventType.DidProcessStateChange, String.format("applied state changes and rules (changed? %s): %s", update, this.workflowEngine.getState()), this.workflowEngine.getState());
    }

    private void processOperations(Consumer<WorkflowSystem.OperationResult<DAT, RES, OP>> resultConsumer) {
        int origPendingCount = this.pending.size();
        List shouldrun = this.pending.stream().filter(input -> input.shouldRun(this.workflowEngine.getState())).collect(Collectors.toList());
        List shouldskip = shouldrun.stream().filter(input -> input.shouldSkip(this.workflowEngine.getState())).collect(Collectors.toList());
        DAT inputData = null != this.sharedData ? (DAT)this.sharedData.produceNext() : null;
        this.processRunnableOperations(resultConsumer, shouldrun, shouldskip, inputData);
        this.processSkippedOperations(shouldskip);
        this.pending.removeAll(shouldskip);
        this.skipped.addAll(shouldskip);
        this.eventHandler.event(WorkflowSystemEventType.LoopProgress, String.format("Pending(%d) => run(%d), skip(%d), remain(%d)", origPendingCount, shouldrun.size() - shouldskip.size(), shouldskip.size(), this.pending.size()));
    }

    private void processSkippedOperations(List<OP> shouldskip) {
        for (WorkflowSystem.Operation operation : shouldskip) {
            this.eventHandler.event(WorkflowSystemEventType.WillSkipOperation, String.format("Skip condition statisfied for operation: %s, skipping", operation), operation);
            StateObj newstate = operation.getSkipState(this.workflowEngine.getState());
            WorkflowSystem.OperationCompleted objectOperationCompleted = WorkflowEngine.dummyResult(newstate);
            this.stateChangeQueue.add(objectOperationCompleted);
        }
    }

    public Set<OP> getOperations() {
        return this.operations;
    }

    public WorkflowSystem.SharedData<DAT> getSharedData() {
        return this.sharedData;
    }

    public Set<WorkflowSystem.Operation> getInProcess() {
        return this.inProcess;
    }

    public Set<WorkflowSystem.Operation> getSkipped() {
        return this.skipped;
    }

    public boolean isInterrupted() {
        return this.interrupted;
    }

    public void setInterrupted(boolean interrupted) {
        this.interrupted = interrupted;
    }

    public Set<OP> getPending() {
        return this.pending;
    }

    public Set<WorkflowSystem.OperationResult<DAT, RES, OP>> getResults() {
        return this.results;
    }

    static class OperationFutureCallback
    implements FutureCallback<RES> {
        final WorkflowSystemEventHandler eventHandler;
        final OP operation;
        final Consumer<WorkflowSystem.OperationResult<DAT, RES, OP>> resultConsumer;
        final /* synthetic */ WorkflowEngineOperationsProcessor this$0;

        public void onSuccess(RES successResult) {
            this.eventHandler.event(WorkflowSystemEventType.OperationSuccess, String.format("operation succeeded: %s", successResult), successResult);
            assert (successResult != null);
            WorkflowSystem.OperationResult result = this.this$0.result(successResult, this.operation);
            this.resultConsumer.accept(result);
            this.this$0.finishedOperation(successResult, this.operation);
        }

        public void onFailure(Throwable t) {
            this.eventHandler.event(WorkflowSystemEventType.OperationFailed, String.format("operation failed: %s", t), t);
            WorkflowSystem.OperationResult result = this.this$0.result((WorkflowSystem.OperationCompleted)((Object)t), (WorkflowSystem.Operation)this.operation);
            this.resultConsumer.accept(result);
            StateObj newFailureState = this.operation.getFailureState(t);
            if (null == newFailureState) {
                newFailureState = new DataState();
            }
            this.this$0.finishedOperation(WorkflowEngine.dummyResult(newFailureState), this.operation);
        }

        @ConstructorProperties(value={"eventHandler", "operation", "resultConsumer"})
        public OperationFutureCallback(WorkflowSystemEventHandler eventHandler, OP operation, Consumer<WorkflowSystem.OperationResult<DAT, RES, OP>> resultConsumer) {
            this.this$0 = this$0;
            this.eventHandler = eventHandler;
            this.operation = operation;
            this.resultConsumer = resultConsumer;
        }
    }
}

