/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.workflow;

import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.execution.ExecutionContext;
import com.dtolabs.rundeck.core.execution.ExecutionListener;
import com.dtolabs.rundeck.core.execution.ExecutionListenerOverride;
import com.dtolabs.rundeck.core.execution.ExecutionLogger;
import com.dtolabs.rundeck.core.execution.FailedNodesListener;
import com.dtolabs.rundeck.core.execution.StepExecutionItem;
import com.dtolabs.rundeck.core.execution.workflow.ContextualExecutionListener;
import com.dtolabs.rundeck.core.execution.workflow.StepExecutionContext;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionItem;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionListener;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionResult;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepExecutionResult;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepExecutionItem;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepResult;

public class WorkflowExecutionListenerImpl
extends ContextualExecutionListener
implements WorkflowExecutionListener,
ExecutionListener {
    private WorkflowExecutionListenerImpl delegate;

    protected WorkflowExecutionListenerImpl(WorkflowExecutionListenerImpl delegate, ExecutionLogger logger) {
        super(delegate, logger);
        this.delegate = delegate;
    }

    public WorkflowExecutionListenerImpl(FailedNodesListener failedNodesListener, ExecutionLogger logger) {
        super(failedNodesListener, logger);
    }

    @Override
    public void ignoreErrors(boolean value) {
    }

    @Override
    public void beginExecuteNodeStep(ExecutionContext context, NodeStepExecutionItem item, INodeEntry node) {
        if (null != this.delegate) {
            this.delegate.beginExecuteNodeStep(context, item, node);
            return;
        }
        super.beginExecuteNodeStep(context, item, node);
        this.log(4, "[workflow] beginExecuteNodeStep(" + node.getNodename() + "): " + item.getType() + ": " + item);
    }

    @Override
    public void finishExecuteNodeStep(NodeStepResult result, ExecutionContext context, StepExecutionItem item, INodeEntry node) {
        if (null != this.delegate) {
            this.delegate.finishExecuteNodeStep(result, context, item, node);
            return;
        }
        super.finishExecuteNodeStep(result, context, item, node);
        this.log(4, "[workflow] finishExecuteNodeStep(" + node.getNodename() + "): " + item.getType() + ": " + result);
    }

    @Override
    public void beginWorkflowExecution(StepExecutionContext executionContext, WorkflowExecutionItem item) {
        if (null != this.delegate) {
            this.delegate.beginWorkflowExecution(executionContext, item);
            return;
        }
        this.log(4, "[workflow] Begin execution: " + item.getType());
    }

    @Override
    public void finishWorkflowExecution(WorkflowExecutionResult result, StepExecutionContext executionContext, WorkflowExecutionItem item) {
        if (null != this.delegate) {
            this.delegate.finishWorkflowExecution(result, executionContext, item);
            return;
        }
        this.log(4, "[workflow] Finish execution:  " + item.getType() + ": " + result);
    }

    @Override
    public void beginWorkflowItem(int step, StepExecutionItem item) {
        if (null != this.delegate) {
            this.delegate.beginWorkflowItem(step, item);
            return;
        }
        this.log(4, "[workflow] Begin step: " + step + "," + item.getType());
    }

    @Override
    public void beginWorkflowItemErrorHandler(int step, StepExecutionItem item) {
        if (null != this.delegate) {
            this.delegate.beginWorkflowItemErrorHandler(step, item);
            return;
        }
        this.log(4, "[workflow] Begin error handler: " + step + "," + item.getType());
    }

    @Override
    public void finishWorkflowItem(int step, StepExecutionItem item, StepExecutionResult result) {
        if (null != this.delegate) {
            this.delegate.finishWorkflowItem(step, item, result);
            return;
        }
        this.log(4, "[workflow] Finish step: " + step + "," + item.getType());
    }

    @Override
    public void finishWorkflowItemErrorHandler(int step, StepExecutionItem item, StepExecutionResult result) {
        if (null != this.delegate) {
            this.delegate.finishWorkflowItemErrorHandler(step, item, result);
            return;
        }
        this.log(4, "[workflow] Finish error handler: " + step + "," + item.getType());
    }

    @Override
    public ExecutionListenerOverride createOverride() {
        return new WorkflowExecutionListenerImpl(this, this.getLogger());
    }
}

